static char rcsid[] = "@(#)$Id: alias.c,v 1.19 2001/06/06 18:09:03 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.19 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains alias stuff

**/

#include "headers.h"
#include "s_elm.h"
#include <errno.h>
#include "s_aliases.h"
#include "ndbz.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"alias");

static char *us2s P_((unsigned char *str));
static char *us2s(str) 
     unsigned char *str;
{
    return (char *)str;
}

#define	ECHOIT	1 	/* echo on for prompting */

static int add_to_alias_text P_((char *aliasname, char *firstname, 
				 char *lastname, char *comment, 
				 char *address));

static int get_aliasname P_((char *aliasname, char *buffer,int *duplicate,
			     int size,int  buffer_size));
static int superceed_system P_((int this_alias, char *buffer, 
				int buffer_size));

static int open_system_aliases P_((void));
static int open_user_aliases P_((void));

/*
 * A simple macro to make it easier to remember how to do a simple
 * resync and not screw up whether or not to prompt on deletions.
 */

#define resync_aliases(newaliases)	delete_aliases(newaliases,TRUE)

extern char *alias_type();
char *error_description(), *get_parens();

static void get_realnames P_((char *, char *, char *, char *, char *,
			      int, int, int, int,int));
static int add_alias P_((int, int));
static int ask_accept P_((char *, char *, char *, char *, char *, char *,
			  int, int, int));
static int alias_help P_((void));
static void get_aliases P_((int are_in_aliases));
static int get_one_alias P_((DBZ *db, int current));


extern int  is_system;		/* system file updating?     */

extern int errno;

int current_mail_message;
int num_duplicates;
DBZ *system_hash = NULL, *user_hash = NULL;
char *a_rev_alias_pad, *a_rev_alias_abr, *a_rev_alias_name,
	*a_rev_full_pad, *a_full_abr, *a_rev_full_name,
	*a_rev_text_pad, *a_text_abr, *a_rev_text_file,
	*a_alias_pad, *a_alias_abr, *a_alias_name,
	*a_full_pad, *a_full_name,
	*a_text_pad, *a_text_file,
	*a_group_name, *a_person_name, *a_system_flag;
	

void open_alias_files(are_in_aliases)
     int are_in_aliases;
{
    static int first_time = TRUE;
    /*
     *	Close and re-open the system and user alias files, if present,
     *	and if they have changed since last we opened them.
     *
     *	Also, parse the data files into memory if needed
     */
    if (first_time) {
	a_group_name = catgets(elm_msg_cat, AliasesSet, AliasesGroup,
			       " Group");
	a_person_name = catgets(elm_msg_cat, AliasesSet, AliasesPerson,
				"Person");
	a_system_flag = catgets(elm_msg_cat, AliasesSet, AliasesSystemFlag,
				"(S)");
	a_rev_alias_pad = catgets(elm_msg_cat, AliasesSet, AliasesRevAliasPad,
				  "Reverse Alias Name      ");
	a_rev_alias_abr = catgets(elm_msg_cat, AliasesSet, AliasesRevAliasAbr,
				  "Reverse-Alias");
	a_rev_alias_name = catgets(elm_msg_cat, AliasesSet, AliasesRevAliasName,
				   "Reverse Alias Name");
	a_rev_full_pad = catgets(elm_msg_cat, AliasesSet, AliasesRevFullPad,
				 "Reverse Full (Real) Name");
	a_full_abr = catgets(elm_msg_cat, AliasesSet, AliasesRevFullAbr,
			     "Reverse-Name");
	a_rev_full_name = catgets(elm_msg_cat, AliasesSet, AliasesRevFullName,
				  "Reverse Full (Real) Name");
	a_rev_text_pad = catgets(elm_msg_cat, AliasesSet, AliasesRevTextPad,
				 "Reverse Text File       ");
	a_text_abr = catgets(elm_msg_cat, AliasesSet, AliasesRevTextAbr,
			     "Reverse-Text");
	a_rev_text_file = catgets(elm_msg_cat, AliasesSet, AliasesRevTextFile,
				  "Reverse Text File");
	a_alias_pad = catgets(elm_msg_cat, AliasesSet, AliasesAliasPad,
			      "Alias Name              ");
	a_alias_abr = catgets(elm_msg_cat, AliasesSet, AliasesAliasAbr,
			      "Alias");
	a_alias_name = catgets(elm_msg_cat, AliasesSet, AliasesAliasName,
			       "Alias Name");
	a_full_pad = catgets(elm_msg_cat, AliasesSet, AliasesFullPad,
			     "Full (Real) Name        ");
	a_full_abr = catgets(elm_msg_cat, AliasesSet, AliasesFullAbr,
			     "Name");
	a_full_name = catgets(elm_msg_cat, AliasesSet, AliasesFullName,
			      "Full (Real) Name");
	a_text_pad = catgets(elm_msg_cat, AliasesSet, AliasesTextPad,
			     "Text File               ");
	a_text_abr = catgets(elm_msg_cat, AliasesSet, AliasesTextAbr,
			     "Text");
	a_text_file = catgets(elm_msg_cat, AliasesSet, AliasesTextFile,
			      "Text File");
	first_time = FALSE;
    }
    
    if(open_system_aliases() || open_user_aliases()) {
	DPRINT(Debug,4,
	       (&Debug,
		"Reading alias data files...\n"));
	get_aliases(are_in_aliases);
    }
}

static int open_system_aliases()
{
/*
 *	Open the system alias file, if present,
 *	and if it has changed since last we read it.
 *
 *	Return 0 if hash file wasn't opened, otherwise 1
 */

	struct stat hst;
	static time_t system_ctime = 0, system_mtime = 0;

	/* If file hasn't changed, don't bother re-opening. */

	if (stat(system_data_file, &hst) == 0) {	/* File exists */
	    if (hst.st_ctime == system_ctime &&
	        hst.st_mtime == system_mtime) {		/* No changes */
	        return(0);
	    }

	   /*
	    * Re-open system hash table.  If we can't, just return.
	    */

	    if (system_hash != NULL)
	        dbz_close(system_hash);

	    if ((system_hash = dbz_open(system_data_file, O_RDONLY, 0)) == NULL)
	        return(0);

	    /* Remember hash file times. */

	    system_ctime = hst.st_ctime;
	    system_mtime = hst.st_mtime;

            return(1);
	}
	else {					/* File does not exist */
	    if (system_ctime == 0 && system_mtime == 0) {
	        return(0);			/* File never existed */
	    }
	    else {			/* Once existed, better re-read */

	       /*
	        * Since we no longer exist, we pretend we never existed.
	        */

	        system_ctime = 0;
	        system_mtime = 0;

	        return(1);
	    }
	}

}

static int open_user_aliases()
{
/*
 *	Open the user alias file, if present,
 *	and if it has changed since last we read it.
 *
 *	Return 0 if hash file wasn't opened, otherwise 1
 */

	struct stat hst;
	char fname[SLEN];
	static time_t user_ctime = 0, user_mtime = 0;

	/* If hash file hasn't changed, don't bother re-reading. */

	strfcpy(fname,user_data_file,sizeof fname);

	if (stat(fname, &hst) == 0) {			/* File exists */
	    if (hst.st_ctime == user_ctime &&
	        hst.st_mtime == user_mtime) {		/* No changes */
	        return(0);
	    }

	   /*
	    * Open user hash table.  If we can't, just return.
	    */

	    if (user_hash != NULL)
	        dbz_close(user_hash);

	    if ((user_hash = dbz_open(fname, O_RDONLY, 0)) == NULL)
	        return(0);

	    /* Remember hash file times. */

	    user_ctime = hst.st_ctime;
	    user_mtime = hst.st_mtime;

            return(1);
	}
	else {					/* File does not exist */
	    if (user_ctime == 0 && user_mtime == 0) {
	        return(0);			/* File never existed */
	    }
	    else {			/* Once existed, better re-read */

	       /*
	        * Since we no longer exist, we pretend we never existed.
	        */

	        user_ctime = 0;
	        user_mtime = 0;

	        return(1);
	    }
	}

}

static int add_alias(replace, to_replace)
     int replace, to_replace;
{
    /*
     *	Add an alias to the user alias text file.  If there
     *	are aliases tagged, the user is asked if he wants to
     *	create a group alias from the tagged files.
     *
     *	Return zero if alias not added in actuality.
     *
     *	If replace == FALSE, then we will ask for the new
     *	aliasname.
     *
     *	If replace == TRUE, then we are replacing the alias
     *	denoted by to_replace.
     *
     *	Note that even if replace == FALSE, if the user types
     *	in the name of a current alias then we can still do
     *	a replacement.
     */
    
    int i, leftoff = 0, tagged = 0;
    int is_group = 0;
    
    char aliasname[SLEN], firstname[SLEN], lastname[SLEN];
    char address1[LONG_STRING];
    char comment[LONG_STRING], ch = *def_ans_no;
    char *ch_ptr;

    char bufferA[100]; /* TODO: Can remove? */
    
    /*
     *	See if there are any tagged aliases.
     */
    for (i=0; i < message_count; i++) {
	if (ison(aliases[i]->status, TAGGED)) {
	    if (tagged == 0) leftoff = i;
	    tagged++;
	}
    }
    
    if (tagged == 1) {
	char * buffer = NULL;
	/*
	 * There is only on alias tagged.  Ask the question
	 * but the default response is NO.
	 */
	PutLineX(elm_LINES-2,0, CATGETS(elm_msg_cat,
					AliasesSet, AliasesOneTagged,
					"There is 1 alias tagged..."));
	CleartoEOLN();
	buffer = elm_message(CATGETS(elm_msg_cat,
				     AliasesSet, AliasesCreateGroup,
				     "Create group alias? (%c/%c) "),
			     *def_ans_yes, *def_ans_no);
	ch = want_to(buffer, *def_ans_no, elm_LINES-3, 0);
	free(buffer);
    }
    else if (tagged > 1) {
	char * buffer = NULL;
	/*
	 * If multiple tagged aliases then we assume the user
	 * wants to create a group alias.  The default response
	 * is YES.
	 */
	PutLineX(elm_LINES-2,0, CATGETS(elm_msg_cat,
					AliasesSet, AliasesManyTagged,
					"There are %d aliases tagged..."),
		 tagged);
	CleartoEOLN();
	buffer = elm_message(CATGETS(elm_msg_cat,
				     AliasesSet, AliasesCreateGroup,
				     "Create group alias? (%c/%c) "),
			     *def_ans_yes, *def_ans_no);
	ch = want_to(buffer, *def_ans_yes, elm_LINES-3, 0);
	free(buffer);
    }

    /*
     *	Create the group alias address.  This is only done
     *	if one of the above want_to() questions were
     *	answered YES (and thus there *were* tagged messages
     *	and the user responded correctly).
     */
    if (ch == *def_ans_yes) {
	strfcpy(address1, aliases[leftoff]->alias,
		sizeof address1);
	for (i=leftoff+1; i < message_count; i++) {
	    if (ison(aliases[i]->status, TAGGED)) {
		strfcat(address1, ",", sizeof address1);
		strfcat(address1, aliases[i]->alias, 
			sizeof address1);
	    }
	}
	is_group = 1;
    }
    else {
	tagged = 0;
    }

    /*
     *	Only ask for an aliasname if we are NOT replacing the
     *	current alias.
     */
    if (replace) {
	char buffer[100];    /* TODO: Fix this mess! */
	
	strfcpy(aliasname, aliases[to_replace]->alias,
		sizeof aliasname);
	/*
	 *  First, see if what we are replacing is a SYSTEM
	 *  alias.  If so, we need to ask a question.
	 */
	if(aliases[to_replace]->type & SYSTEM) {
	    DPRINT(Debug,3,
		   (&Debug, 
		    "Aliasname [%s] is SYSTEM in add_alias\n", aliasname));
	    /*
	     *  If they don't want to superceed the SYSTEM alias then
	     *  just return.
	     */
	    if( ! superceed_system(to_replace, buffer, sizeof buffer)) {
		ClearLine(elm_LINES-2);
		return(0);
	    }
	}
    }
    else {
	char buffer[100];    /* TODO: Fix this mess! */

	strfcpy(buffer, catgets(elm_msg_cat,
				AliasesSet, AliasesEnterAliasName, 
				"Enter alias name: "),
		sizeof buffer);
	PutLine0(elm_LINES-2,0, buffer);
	CleartoEOLN();
	*aliasname = '\0';

	replace = get_aliasname(aliasname, buffer, &to_replace,
				sizeof aliasname, sizeof buffer);
	while (REDRAW_MARK == replace) {
	    PutLine0(elm_LINES-2,0, buffer);
	    replace = get_aliasname(aliasname, buffer, &to_replace,
				    sizeof aliasname, sizeof buffer);
	}
	
	if (replace < 0) {
	    DPRINT(Debug,3,
		   (&Debug,
		    "Aliasname [%s] was rejected in add_alias\n", aliasname));
	    ClearLine(elm_LINES-2);
	    return(0);
	}
    }

    /*
     *	If we are replacing an existing alias, we will assume that
     *	they might want to be just editing most of what is already
     *	there.  So we copy some defaults from the existing alias.
     */

    if (replace) {
	strfcpy(lastname, aliases[to_replace]->last_name,
		sizeof lastname);
	strfcpy(firstname, aliases[to_replace]->name,
		sizeof firstname);
	ch_ptr = strstr(firstname, lastname);
	if (ch_ptr)
	    *(ch_ptr-1) = '\0';
	strfcpy(comment, aliases[to_replace]->comment, sizeof comment);
    }
    else {
	*lastname = '\0';
	*firstname = '\0';
	*comment = '\0';
    }
    
    /*
     *	Since there are no tagged aliases, we must ask for an
     *	address.  If we are replacing, a default address is
     *	presented.
     */
    if (tagged == 0) {
	char * buffer = elm_message(CATGETS(elm_msg_cat,
					    AliasesSet, AliasesEnterAddress,
					    "Enter address for %s: "), 
				    aliasname);
	PutLine0(elm_LINES-2,0, buffer);
	CleartoEOLN();
	if (replace) {
	    strfcpy(address1, aliases[to_replace]->address,
		    sizeof address1);
	}
	else {
	    *address1 = '\0';
	}
	
	do {
	    int status =
	        optionally_enter(address1, elm_LINES-2, strlen(buffer),
	                         OE_REDRAW_MARK, sizeof address1);
	    
	    while (REDRAW_MARK == status) {
		elm_sfprintf(buffer, sizeof buffer,
			     CATGETS(elm_msg_cat,
				     AliasesSet, AliasesEnterAddress,
				     "Enter address for %s: "), 
			     aliasname);
		PutLine0(elm_LINES-2,0, buffer);
		status =
		    optionally_enter(address1, elm_LINES-2, strlen(buffer),
				     OE_REDRAW_MARK|OE_APPEND_CURRENT,
				     sizeof address1);
	    }
	    
	    if (0 != status ||
		strlen(address1) == 0) {
		lib_error(CATGETS(elm_msg_cat, AliasesSet, 
				  AliasesNoAddressSpec,
				  "No address specified!"));
		free(buffer);
		return(0);
	    }
	} while (check_address(address1) == -1);
	
	clear_error();			/* Just in case */
	free(buffer);
    }
	
    if (!is_group && strchr(address1,',') != NULL)
	is_group = 1;
    
    get_realnames(aliasname, firstname, lastname, comment, bufferA,
		  sizeof firstname, sizeof lastname, sizeof comment,
		  sizeof bufferA, is_group);


    if(ask_accept(aliasname, firstname, lastname, comment, address1,
		  bufferA, replace, to_replace,
		  sizeof bufferA)) {
	/*
	 * We can only clear the tags after we know that the
	 * alias was added.  This allows the user to back out
	 * and rethink without losing the tags.
	 */
	if (tagged > 0) {
	    for (i=leftoff; i < message_count; i++) {
		if (ison(aliases[i]->status, TAGGED)) {
		    clearit(aliases[i]->status, TAGGED);
		    show_msg_tag(i);
		}
	    }
	}
	return(1);
    }
    else {
	return(0);
    }    
}

int
add_current_alias()
{
    /*
     *	Alias the current message to the specified name and
     *	add it to the alias text file, for processing as
     *	the user leaves the program.
     *
     *	Returns non-zero iff alias actually added to file.
     */
    
    char aliasname[SLEN], firstname[SLEN], lastname[SLEN];
    char comment[SLEN], address1[LONG_STRING], buffer[SLEN];
    char comment_buff[LONG_STRING];
    char *chspace, *bufptr;
    struct header_rec *current_header;
    
    static char bad_punc[] = ",.:;";
    char *punc_ptr;
    int i, match;
    int replace, to_replace;
    
    if (current_mail_message == 0) {
	DPRINT(Debug,3,
	       (&Debug,
		"Add current alias called without any current message!\n"));
	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesNoMessage,
			  "No message to alias to!"));
	return(0);
    }
    current_header = headers[current_mail_message - 1];
    if (!current_header->from || 
	!current_header->from[0].fullname ||
	!current_header->from[0].addr ||
	!current_header->from[0].comment)
	return 0;
    

    /* TODO: Fix this mess ... */
    strfcpy(buffer, catgets(elm_msg_cat, AliasesSet, AliasesCurrentMessage,
			    "Current message address aliased to: "),
	    sizeof buffer);
    PutLine0(elm_LINES-2,0, buffer);
    CleartoEOLN();
    *aliasname = '\0';
    replace = get_aliasname(aliasname, buffer, &to_replace,
			    sizeof aliasname, sizeof buffer);
    while (REDRAW_MARK == replace) {
	PutLine0(elm_LINES-2,0, buffer);
	replace = get_aliasname(aliasname, buffer, &to_replace,
				sizeof aliasname, sizeof buffer);
    }
    if (replace < 0) {
	DPRINT(Debug,3,
	       (&Debug,
		"Aliasname [%s] was rejected in add_current_alias\n",
		aliasname));
	ClearLine(elm_LINES-2);
	return(0);
    }
    
    {
	struct string * T = 
	    convert_string(display_charset,
			   current_header->from[0].fullname,
			   1);
	char * A = us2s(stream_from_string(T,1,NULL));
	strfcpy(comment_buff,A,sizeof comment_buff);
	free(A);
	free_string(&T);
    }
    
    /*
     *	Try to break up the From: comment into firstname, lastname, and
     *	any other text.  This is based on the fact that many address
     *	comments are pretty straightforward.  This will break on many
     *	situations.  Should handle:
     *		(Robert Howard)
     *		(Robert L. Howard)
     *		(Robert Howard, Georgia Tech)
     *	pretty well.  Will break on:
     *		(The Voice of Reason)
     *		and others....
     */

    *firstname = '\0';
    *lastname = '\0';
    *comment = '\0';
    if (strlen(comment_buff) != 0) {	/* There is something. */
	bufptr = comment_buff;
	while (*bufptr == SPACE) bufptr++;	/* Always strip leading WS */
	if ((chspace = index(bufptr, (int) SPACE)) != NULL) {
	    /*
	     *   A space means that there is at least (firstname lastname)
	     *   Get firstname and move bufptr.
	     */
	    *chspace = '\0';
	    strfcpy(firstname, bufptr, sizeof firstname);
	    bufptr = chspace + 1;			/* Move the pointer */
	    while (*bufptr == SPACE) bufptr++;
	}
	
    above:	    if ((chspace = index(bufptr, (int) SPACE)) != NULL) {
	/*
	 *   Another space means a third+ word.  We either have:
	 *       1. Word 3+ is a comment, or
	 *       2. Word 2 is a middle initial (word 3 is lastname).
	 *   Check and see.
	 */
	*chspace = '\0';
	if ((strlen(bufptr) == 1) ||
	    (strlen(bufptr) == 2  && *(bufptr+1) == '.')) {
	    /*
	     *   If the second word is either a single
	     *   character or a character followed by '.' it was
	     *   probably a middle initial.  Add it to firstname
	     *   and shift.
	     */
	    strfcat(firstname, " ", sizeof firstname);
	    strfcat(firstname, bufptr, sizeof firstname);
	    bufptr = chspace + 1;		/* Move the pointer */
	    while (*bufptr == SPACE) bufptr++;
	    goto above;
	}
	strfcpy(lastname, bufptr, sizeof lastname);
	bufptr = chspace + 1;			/* Move the pointer */
	while (*bufptr == SPACE) bufptr++;
	strfcpy(comment, bufptr, sizeof comment);
    }
    else {
	/*
	 *   Only a lastname left.
	 */
	strfcpy(lastname, bufptr, sizeof lastname);
    }
	
	if (!comment[0]) {
	    struct string * T = 
		convert_string(display_charset,
			       current_header->from[0].comment,
			       1);
	    char * A = us2s(stream_from_string(T,1,NULL));
	    strfcpy(comment, A, sizeof comment);
	    free(A);
	    free_string(&T);
	}
	
	/*
	 *  Finally, get any puctuation characters off the end of
	 *  lastname.
	 */
	match = TRUE;
	for (i = strlen(lastname) - 1; match && i>0; i--) {
	    match = FALSE;
	    for (punc_ptr = bad_punc; *punc_ptr != '\0'; punc_ptr++) {
		if (lastname[i] == *punc_ptr) {
		    lastname[i] = '\0';
		    match = TRUE;
		    break;
		}
	    }
	}
    }
    
    get_realnames(aliasname, firstname, lastname, comment, buffer,
		  sizeof firstname, sizeof lastname, sizeof comment,
		  sizeof buffer, 0);
    
    /* grab the return address of this message */
    strfcpy(address1,current_header->from[0].addr,sizeof address1);
    
    return(ask_accept(aliasname, firstname, lastname, comment, address1,
		      buffer, replace, to_replace, sizeof buffer));    
}

static int add_to_alias_text(aliasname, firstname, lastname, comment, address)
     char *aliasname, *firstname, *lastname, *comment, *address;
{
/*
 *	Add the data to the user alias text file.
 *
 *	Return zero if we succeeded, 1 if not.
 */
	
	FILE *file;
	char fname[SLEN];
	char buffer[SLEN];
	int  err;
	
	strfcpy(fname,user_text_file,sizeof fname);
	
	save_file_stats(fname);
	if ((file = fopen(fname, "a")) == NULL) {
	  err = errno;
	  DPRINT(Debug,2,
		 (&Debug, 
		  "Failure attempting to add alias to file %s within %s",
		  fname, "add_to_alias_text"));
	  DPRINT(Debug,2,
		 (&Debug, "** %s **\n", error_description(err)));
	  lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesCouldntOpenAdd,
			    "Couldn't open %s to add new alias!"), 
		    fname);
	  return(1);
	}

	if (strlen(firstname) == 0) {
	    strfcpy(buffer, lastname, sizeof buffer);  
	}
	else {
	  elm_sfprintf(buffer, sizeof buffer,
		       FRM("%s; %s"), lastname, firstname);
	}
	if (strlen(comment) != 0) {
	    strfcat(buffer, ", ", sizeof buffer);
	    strfcat(buffer, comment, sizeof buffer);
	}
	if (fprintf(file,"%s = %s = %s\n", aliasname, buffer, address) == EOF) {
	    err = errno;
	    DPRINT(Debug,2,
		   (&Debug,
		    "Failure attempting to write alias to file %s within %s",
		    fname, "add_to_alias_text"));
	    DPRINT(Debug,2,
		   (&Debug, "** %s **\n", error_description(err)));
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesCouldntWrite,
			      "Couldn't write alias to file %s!"), 
		      fname);
	    fclose(file);
	    return(1);
	}

	fclose(file);

	restore_file_stats(fname);

	return(0);
}

static int parse_aliases P_((char *, char *, int, int)); /* Prototype */


int delete_from_alias_text(name, num_to_delete)
     char **name;
     int num_to_delete;
{
/*
 *	Delete the data from the user alias text file.
 *
 *	Return zero if we succeeded, 1 if not.
 */
	
	FILE *file, *tmp_file;

	char fname[SLEN], tmpfname[SLEN];
	char line_in_file[LONG_STRING];
	char rest_of_line[LONG_STRING];
	char *s, *rest;

	register int i;
	int num_aliases;
	int delete_continues;
	int err;

	delete_continues = FALSE;

	strfcpy(fname,user_text_file,sizeof fname);
	elm_sfprintf(tmpfname,sizeof tmpfname,
		     FRM("%s.t"), user_text_file);
	
	save_file_stats(fname);

	if ((file = fopen(fname, "r")) == NULL) {
	  err = errno;
	  DPRINT(Debug,2,
		 (&Debug, 
		  "Failure attempting to delete alias from file %s within %s",
		  fname, "delete_from_alias_text"));
	  DPRINT(Debug,2,
		 (&Debug, "** %s **\n", error_description(err)));
	  lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesCouldntOpenDelete,
			    "Couldn't open %s to delete alias!"), 
		    fname);
	  return(1);
	}

	if ((tmp_file = fopen(tmpfname, "w")) == NULL) {
	  err = errno;
	  DPRINT(Debug,2,
		 (&Debug, 
		  "Failure attempting to open temp file %s within %s",
		  tmpfname, "delete_from_alias_text"));
	  DPRINT(Debug,2,
		 (&Debug, "** %s **\n", error_description(err)));
	  lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesCouldntOpenTemp,
			    "Couldn't open temp file %s to delete alias!"), 
		    tmpfname);
	  return(1);
	}

	while (mail_gets(line_in_file, sizeof(line_in_file), file) != 0)
	{
	  if (! whitespace(line_in_file[0])) {
	    delete_continues = FALSE;
	    if (line_in_file[0] != '#') {
	      if (0 != (num_aliases = 
			parse_aliases(line_in_file, rest_of_line,
				      sizeof line_in_file,
				      sizeof rest_of_line))) {
	        for (i=0; i < num_to_delete && num_aliases; i++) {
		  char buf[LONG_STRING];
		  strfcpy(buf,name[i], sizeof buf);
		  strfcat(buf,",", sizeof buf);

	          if ((s = strstr(line_in_file, buf)) != NULL) {
/*
 *	Collapse the to be deleted alias out of line_in_file
 */
	            rest = index(s, ',');
	            for (++rest; *rest; rest++)
	              *s++ = *rest;
	            *s = '\0';
	            num_aliases--;
	          }
	        }
	        if (num_aliases) {
	          *(line_in_file + strlen(line_in_file) - 1) = ' ';
	          strfcat(line_in_file, rest_of_line,
			  sizeof line_in_file);
	        }
	        else {
	          delete_continues = TRUE;
	        }
	      }
	    }
	  }
	  if (! delete_continues) {
	    if (fprintf(tmp_file,"%s", line_in_file) == EOF) {
	      err = errno;
	      DPRINT(Debug,2,
		     (&Debug,
		      "Failure attempting to write to temp file %s within %s",
		      tmpfname, "delete_from_alias_text"));
	      DPRINT(Debug,2,
		     (&Debug, "** %s **\n", error_description(err)));
	      lib_error(CATGETS(elm_msg_cat, AliasesSet, 
				AliasesCouldntWriteTemp,
				"Couldn't write to temp file %s!"), 
			tmpfname);
	      fclose(file);
	      fclose(tmp_file);
	      unlink(tmpfname);
	      return(1);
	    }
	  }
	}
	fclose(file);
	fclose(tmp_file);
	if (rename(tmpfname, fname) != 0)
	{
		lib_error(CATGETS(elm_msg_cat, AliasesSet, 
				  AliasesCouldntRenameTemp,
				  "Couldn't rename temp file %s after deleting alias!"), 
			  tmpfname);
		return(1);
	}

	restore_file_stats(fname);

	return(0);
}

void alias()
{
/*
 *	Work with alias commands...
 */

	char name[NLEN], buffer[SLEN];
	int ch;
	static int  newaliases = 0;
	int  i;
	int nutitle = 0;
	int too_long;

/*
 *	We're going to try to match the way elm does it at
 * 	he main menu.  I probably won't be able to use any
 *	main menu routines, but I will "borrow" from them. RLH
 */

	main_state();		/* Save globals for return to main menu */

	open_alias_files(FALSE);	/* First, read the alias files. RLH */

	alias_screen(newaliases);
	/* define_softkeys(ALIAS); */

	while (1) {

#ifdef SIGWINCH
	  if (resize_screen) {
	    int	newLINES, newCOLUMNS;

	    ScreenSize(&newLINES, &newCOLUMNS);
	    resize_screen = 0;
	    if (newLINES != elm_LINES || newCOLUMNS != elm_COLUMNS) {
	      elm_LINES = newLINES, elm_COLUMNS = newCOLUMNS;
#undef max
#define max(a,b)	       ((a) < (b) ? (b) : (a))
	      if (mini_menu)
		headers_per_page = max (elm_LINES - 13, 1);
	      else
		headers_per_page = max (elm_LINES -	 8, 1);	  /* 5 more headers! */
#undef max
	      redraw++;
	    }
	  }
	  else redraw = 0;
#else
    	  redraw = 0;
#endif
	  nucurr = 0;
	  nufoot = 0;

	  prompt(Prompt);
	  CleartoEOLN();
	  ch = ReadCh(REDRAW_MARK|READCH_CURSOR);
	  MoveCursor(elm_LINES-3,strlen(Prompt)); CleartoEOS();

	  if (isascii(ch) && isprint(ch)) {
	      DPRINT(Debug,4,
		     (&Debug, "-- Alias command: %c [%d]\n",ch,ch));
	  } else {
	      DPRINT(Debug,4,
		     (&Debug, "-- Alias command: [%d]\n",ch));
	  }

	  switch (ch) {
	  case HELP_MARK:
	  case '?': redraw += alias_help();			break;
	      
	  case REDRAW_MARK:
	    case 'L'&31: redraw++;                              break;


	    case '$': PutLineX(elm_LINES-3, strlen(Prompt),
			       CATGETS(elm_msg_cat, AliasesSet, AliasesResync,
				       "Resynchronize aliases..."));
	           /*
	            * Process deletions and then see if we need to
	            * re-run the "newalias" routine.
	            */
		      if (resync_aliases(newaliases)) {
		        install_aliases();
	                newaliases = 0;
		        redraw++;
		      }
		      break;

	    case 'a': PutLineX(elm_LINES-3, strlen(Prompt),
			       CATGETS(elm_msg_cat, AliasesSet, 
				       AliasesAddCurrent,
				       "Add address from current message..."));
		      clear_error();
		      if (add_current_alias()) {
		          newaliases++;
		          nutitle++;
		      }
		      break;

	    case 'c':
	              if (current > 0) {
	                  PutLineX(elm_LINES-3, strlen(Prompt),
				   CATGETS(elm_msg_cat,
					   AliasesSet, AliasesReplaceCurrent,
					   "Replace current alias in database..."));
		          clear_error();
		          if (add_alias(TRUE, current-1)) {
		              newaliases++;
		              nutitle++;
		          }
	              }
	              else {
		          lib_error(CATGETS(elm_msg_cat,
					    AliasesSet, AliasesNoneToReplace,
					    "Warning: no aliases to replace!"));
	              }
		      break;

	    case 'e': PutLineX(elm_LINES-3, strlen(Prompt),
			       CATGETS(elm_msg_cat, AliasesSet, AliasesEdit,
				       "Edit %s..."), USER_ALIAS_TEXT);
	           /*
	            * Process aliases.text for deletions, etc.  You
	            * have to do this *before* checking current because
	            * all aliases could be marked for deletion.
	            */
	              (void) resync_aliases(newaliases);
	              if (edit_aliases_text()) {
	                  newaliases = 0;
	              }
		      redraw++;
		      break;

	    case 'm':
	              if (current > 0) {
	                  PutLineX(elm_LINES-3, strlen(Prompt),
				   CATGETS(elm_msg_cat, AliasesSet, AliasesMail,
					   "Mail..."));
	                  redraw += a_sendmsg(TRUE,allow_forms);
	              }
	              else {
		          lib_error(CATGETS(elm_msg_cat,
					    AliasesSet, AliasesNoneToMail,
					    "Warning: no aliases to send mail to!"));
	              }
		      break;

	    case 'n': PutLineX(elm_LINES-3, strlen(Prompt),
			       CATGETS(elm_msg_cat, AliasesSet, AliasesAddNew,
				       "Add a new alias to database..."));
		      clear_error();
		      if (add_alias(FALSE, -1)) {
		          newaliases++;
		          nutitle++;
		      }
		      break;

	    case 'q':
	    case 'Q':
	    case 'i':
	    case 'I':
	    case 'r':
	    case 'R': PutLineX(elm_LINES-3, strlen(Prompt),
			       CATGETS(elm_msg_cat, AliasesSet, 
				       AliasesAddReturn,
				       "Return to main menu..."));
	           /*
	            * leaving the alias system.  Must check for
	            * pending deletes, etc.  prompt is set to FALSE
	            * on uppercase letters so that deletions are
	            * NOT queried.
	            */
	              if (delete_aliases(newaliases, islower(ch))) {
	                install_aliases();
	                newaliases = 0;
	              }
		      clear_error();
		      main_state();		/* Done with aliases. */
		      return;

	    case RETURN:
	    case LINE_FEED:
	    case SPACE:
	    case 'v':
		      if (newaliases) {		/* Need this ?? */
		          lib_error(CATGETS(elm_msg_cat,
					    AliasesSet, AliasesNotInstalled,
					    "Warning: new aliases not installed yet!"));
	              }

	              if (current > 0) {
	                  if (aliases[current-1]->type & GROUP) {
	                      PutLineX(elm_LINES-1, 0, 
				       CATGETS(elm_msg_cat,
					       AliasesSet, AliasesGroupAlias,
					       "Group alias: %-60.60s"),
	                          aliases[current-1]->address);
		          }
		          else {
	                      PutLineX(elm_LINES-1, 0, 
				       CATGETS(elm_msg_cat,
					       AliasesSet, AliasesAliasedAddress,
					       "Aliased address: %-60.60s"), 
				       aliases[current-1]->address);
		          }
		      }
	              else {
		          lib_error(CATGETS(elm_msg_cat,
					    AliasesSet, AliasesNoneToView,
					    "Warning: no aliases to view!"));
		      }
		      break;

	    case 'x':
	    case 'X': PutLineX(elm_LINES-3, strlen(Prompt),
			       CATGETS(elm_msg_cat, AliasesSet, 
				       AliasesAddReturn,
				       "Return to main menu..."));
	              exit_alias();
		      clear_error();
		      main_state();		/* Done with aliases. */
		      return;

	  case 'f':
	  case 'F':
	      if (current > 0) {
		  clear_error();
		  strfcpy(name, aliases[current-1]->alias,
			  sizeof name);
		  if (ch == 'F') {
		      int status;
		      /* TODO: Fix this mess... */
		      strfcpy(buffer, catgets(elm_msg_cat,
					      AliasesSet, 
					      AliasesFullyExpanded,
					      "Fully expand alias: "),
			      sizeof buffer);
		      PutLine0(elm_LINES-2,0, buffer);
		      CleartoEOS();
		      status = optionally_enter(name, elm_LINES-2, 
						strlen(buffer),
						OE_REDRAW_MARK, sizeof name);
		      while (REDRAW_MARK == status) {
			  PutLine0(elm_LINES-2,0, buffer);
			  status = optionally_enter(name, elm_LINES-2, 
						    strlen(buffer),
						    OE_REDRAW_MARK|
						    OE_APPEND_CURRENT,
						    sizeof name);
			  redraw++;
		      }
		      if (0 != status)
			  break;
		  }
		  {
		      struct addr_item * address;
		      too_long = FALSE;
		      address = get_alias_address_l(name, TRUE, 
						    &too_long);
		  redraw2:			
		      if (address != NULL) {
			  struct addr_item *walk =address;
			  while (TRUE) {
			      ClearScreen();
			      PutLineX(2,0, 
				       CATGETS(elm_msg_cat,
					       AliasesSet, AliasesAliasedFull,
					       "Aliased address for:\t%s\n\r"),
				       name);
			      i = 4;
			      
			      while (i < elm_LINES-2) {
				  if (walk->addr && walk->fullname) {
				      if (string_len(walk->fullname) ||
					  NULL != strchr(walk->addr,'@')) {
					  PutLineX(i++, 4, FRM("%S <%s>"),
						   walk->fullname,walk->addr);
				      } else
					  PutLine0(i++, 4, walk->addr);
				      walk++;
				  } else
				      break;
			      }
			      PutLineX(elm_LINES-1, 0, 
				       CATGETS(elm_msg_cat,
					       AliasesSet, AliasesPressReturn,
					       "Press <return> to continue."));
			      if (REDRAW_MARK == ReadCh(REDRAW_MARK)) {
				  redraw++;
				  goto redraw2;
			      }
			      if (walk->addr == NULL) {
				  redraw++;
				  break;
			      }
			  }
			  free_addr_items(address);
		      }
		      else if (! too_long) {
			  lib_error(CATGETS(elm_msg_cat,
					    AliasesSet, AliasesNotFound,
					    "Not found."));
		      }
		  }
	      }
	      else {
		  lib_error(CATGETS(elm_msg_cat,
				    AliasesSet, AliasesNoneToView,
				    "Warning: no aliases to view!"));
	      }
	      break;
	      
	 /*
	  * None of the menu specific commands were chosen, therefore
	  * it must be a "motion" command (or an error).
	  */
	    default	: motion(ch);

	  }

	  if (redraw) {			/* Redraw screen if necessary */
	      alias_screen(newaliases);
	      nutitle = 0;
	  }

	  if (nutitle) {		/* Redraw title if necessary */
	      alias_title(newaliases);
	      nutitle = 0;
	  }

	  check_range();

	  if (nucurr == NEW_PAGE)
	    show_headers();
	  else if (nucurr == SAME_PAGE)
	    show_current();
	  else if (nufoot) {
	    if (mini_menu) {
	      MoveCursor(elm_LINES-7, 0);  
              CleartoEOS();
	      show_alias_menu();
	    }
	    else {
	      MoveCursor(elm_LINES-4, 0);
	      CleartoEOS();
	    }
	    show_last_error();	/* for those operations that have to
				 * clear the footer except for a message.
				 */
	  }
	}			/* BIG while loop... */
}

void install_aliases()
{
/*
 *	Run the 'newalias' program and update the
 *	aliases before going back to the main program! 
 *
 *	No return value.....
 */

	int na;
	char itextfile[SLEN], odatafile[SLEN];

	lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesUpdating,
			  "Updating aliases..."));

	strfcpy(itextfile,user_text_file, sizeof itextfile);
	strfcpy(odatafile,user_data_file,sizeof odatafile);

/*
 *	We need to unlimit everything since aliases are 
 * 	eing read in from scratch.
 */
	selected = 0;

	na = do_newalias(itextfile, odatafile, TRUE, FALSE);
	if (na >= 0) {
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesReReading,
			      "Processed %d aliases.  Re-reading the database..."), 
		      na);
	    open_alias_files(TRUE);
	    lib_error(CATGETS(elm_msg_cat, AliasesSet, AliasesUpdatedOK,
			      "Aliases updated successfully."));
	}
}

static int alias_help()
{
    /*
     *	Help section for the alias menu...
     *
     *	Return non-0 if main part of screen overwritten, else 0
     */
	
    int  ch;
    int  redraw=0;
    char *alias_prompt;
    
    
    if (mini_menu)
	alias_prompt = catgets(elm_msg_cat, AliasesSet, AliasesShortKey,
			       "Key: ");
    else
	alias_prompt = catgets(elm_msg_cat, AliasesSet, AliasesLongKey,
			       "Key you want help for: ");
    
    MoveCursor(elm_LINES-3, 0);	CleartoEOS();
    
    if (mini_menu) {
	print_format_center(elm_LINES-3, 
			    CATGETS(elm_msg_cat, AliasesSet, 
				    AliasesKeyMenu,
				    "Press the key you want help for, '?' for a key list, or '.' to exit help"));
    }

    lower_prompt(alias_prompt);

    while ((ch = ReadCh(0|READCH_CURSOR)) != '.') {
	switch(ch) {
	case EOF : leave(0);
	    break;
	case HELP_MARK:
	case '?' : display_helpfile(ALIAS_HELP);	
	    redraw++;
	    return(redraw);
	    
	case '$': lib_transient(CATGETS(elm_msg_cat, AliasesSet, 
				    AliasesHelpDollar,
				    "$ = Force resynchronization of aliases, processing additions and deletions."));
	break;
	
	case FIND_MARK:
	case '/': lib_transient(CATGETS(elm_msg_cat, AliasesSet, 
				    AliasesHelpSlash,
				    "/ = Search for specified name or alias in list."));
	break;
	
	case RETURN:
	case LINE_FEED:
	case SPACE:
	case 'v': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpv,
				    "v = View the address for the currently selected alias."));
	break;
	
	case 'a':lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpa,
				       "a = Add (return) address of current message to alias database."));
	break;
	
	case 'c': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpc,
				    "c = Change current user alias, modifying alias database at next resync."));
	break;
	
	case 'd': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpd,
					"d = Mark the current alias for deletion from alias database."));
	break;
	
	case ctrl('D'): lib_transient(CATGETS(elm_msg_cat, AliasesSet, 
					  AliasesHelpCtrlD,
					  "^D = Mark for deletion user aliases matching specified pattern."));
	break;
	
	case 'e': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpe,
				    "e = Edit the alias text file directly (will run newalias)."));
	break;
	
	case 'f': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpf,
				    "f = Display fully expanded address of current alias."));
	break;
	
	case 'l': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpl,
				    "l = Limit displayed aliases on the specified criteria."));
	break;
	
	case ctrl('L'): lib_transient(CATGETS(elm_msg_cat, AliasesSet, 
					      AliasesHelpCtrlL,
					      "^L = Rewrite the screen."));
	break;
	
	case 'm': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpm,
					"m = Send mail to the current or tagged aliases."));
	break;
	
	case 'n': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpn,
					"n = Add a new user alias, adding to alias database at next resync."));
	break;
	
	case 'r':
	case 'q':
	case 'i': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpi,
					"r,q,i = Return from alias menu (with prompting)."));
	break;
	
	case 'R':
	case 'Q':
	case 'I': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpQ,
					"R,Q,I = Return from alias menu (no prompting)."));
	break;
	
	case 't': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpt,
					"t = Tag current alias for further operations."));
	break;
	
	case 'T': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpT,
					"T = Tag current alias and go to next alias."));
	break;
	
	case ctrl('T'): lib_transient(CATGETS(elm_msg_cat, AliasesSet, 
					      AliasesHelpCtrlT,
					      "^T = Tag aliases matching specified pattern."));
	break;
	
	case 'u': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpu,
					"u = Unmark the current alias for deletion from alias database."));
	break;
	
	case ctrl('U'): lib_transient(CATGETS(elm_msg_cat, AliasesSet, 
					      AliasesHelpCtrlU,
					      "^U = Mark for undeletion user aliases matching specified pattern."));
	break;
	
	case 'x':
	case 'X': lib_transient(CATGETS(elm_msg_cat, AliasesSet, AliasesHelpX,
				    "x = Exit from alias menu, abandoning any pending deletions."));
	break;
	
	default : lib_error(CATGETS(elm_msg_cat, AliasesSet, 
				    AliasesHelpNoHelp,
				    "That key isn't used in this section."));
	break;
	}
	lower_prompt(alias_prompt);
    }
    
    /* Remove help lines */
    MoveCursor(elm_LINES-3, 0);	CleartoEOS();
    return(redraw);
}

static void get_aliases(are_in_aliases)
     int are_in_aliases;
{
    /*
     *	Get all the system and user alias info
     *
     *	If we get this far, we must be needing to re-read from
     *	at least one data file.  Unfortunately that means we 
     *	really need to read both since the aliases may be sorted
     *	and all mixed up...  :-(
     */

    int dups = 0;
    
    current = 0;
    num_duplicates = 0;
    /*
     *	Read from user data file if it is open.
     */
    if (user_hash != NULL) {
	DPRINT(Debug,4,
	       (&Debug,
		"About to read user data file = %d.\n",
		user_hash->dbz_basef));
	fseek(user_hash->dbz_basef, 0L, 0);
	while (get_one_alias(user_hash, current)) {
	    DPRINT(Debug,6,
		   (&Debug, "%d\t%s\t%s\n", current+1,
		    aliases[current]->alias,
		    aliases[current]->address));
	    
	    current++;
	}
    }
    message_count = current;	/* Needed for find_alias() */
    
    /*
     *	Read from system data file if it is open.
     */
    if (system_hash != NULL) {
	DPRINT(Debug,4,
	       (&Debug,
		"About to read system data file = %d.\n",
		system_hash->dbz_basef));
	fseek(system_hash->dbz_basef, 0L, 0);
	while (get_one_alias(system_hash, current)) {
	    /*
	     *  If an identical user alias is found, we may
	     *  not want to display it, so we had better mark it.
	     */
	    if (find_alias(aliases[current]->alias, USER) >= 0) {
		setit(aliases[current]->type, DUPLICATE);
		dups++;
		setit(aliases[current]->status, URGENT);
		/* Not really, I want the U for User */
		DPRINT(Debug,4,
		       (&Debug,
			"System alias %s is same as user alias.\n",
			aliases[current]->alias));
	    }
	    DPRINT(Debug,6,
		   (&Debug, "%d\t%s\t%s\n", current+1,
		    aliases[current]->alias,
		    aliases[current]->address));
	    
	    current++;
	}
	num_duplicates = dups;
    }
    message_count = current - num_duplicates;
    
    if (!mail_only && !check_only && message_count) {
	current = 0;
	sort_aliases((message_count+num_duplicates), FALSE, are_in_aliases);
	current = 1;
	if (are_in_aliases) {
	    (void) get_page(current);
	}
    }
    
}

static int get_one_alias(db, current)
     DBZ *db;
     int current;
{
/*
 *	Get an alias (name, address, etc.) from the data file
 */

	int new_max;
	register struct alias_rec *a;
	extern struct alias_rec *fetch_alias();

	if ((a = fetch_alias(db, (char *)NULL)) == NULL)
	    return 0;

	if (current >= max_aliases) {
	    new_max = max_aliases + KLICK;
	    if (max_aliases == 0) {
		aliases = (struct alias_rec **)
		    safe_malloc(new_max * sizeof(struct alias_rec *));
	    } else {
		aliases = (struct alias_rec **) safe_realloc((malloc_t)aliases,
		    new_max * sizeof(struct alias_rec *));
	    }
	    while (max_aliases < new_max)
		aliases[max_aliases++] = NULL;
	}

	if (aliases[current] != NULL)
	    free((malloc_t)aliases[current]);
	aliases[current] = a;
	return 1;
}

void main_state()
{
/*	Save the globals that are shared for both menus
 *	so that we can return to the main menu without
 *	"tragedy".
 */

	static int alias_count = 0,    alias_current = 0, alias_last = -1,
	           alias_selected = 0, alias_page = 0;
	static int main_count = 0,     main_current = 0, main_last = -1,
	           main_selected = 0,  main_page = 0;

	if (inalias) {			/* Restore the settings */
	    alias_count = message_count;
	    alias_current = current;
	    alias_last = last_current;
	    alias_selected = selected;
	    alias_page = header_page;

	    message_count = main_count;
	    current = main_current;
	    last_current = main_last;
	    selected = main_selected;
	    header_page = main_page;

	    strfcpy(item, catgets(elm_msg_cat, ElmSet, Elmitem, "message"),
		    sizeof item);
	    strfcpy(items, catgets(elm_msg_cat, ElmSet, Elmitems, "messages"),
		    sizeof items);
	    strfcpy(Item, catgets(elm_msg_cat, ElmSet, ElmItem, "Message"),
		    sizeof Item);
	    strfcpy(Items, catgets(elm_msg_cat, ElmSet, ElmItems, "Messages"),
		    sizeof Items);
	    strfcpy(Prompt, catgets(elm_msg_cat, ElmSet, ElmPrompt, 
				    "Command: "),
		    sizeof Prompt);

	    DPRINT(Debug,2,
		   (&Debug, "Leaving alias mode\n"));
	    inalias = FALSE;
	}
	else {
	    main_count = message_count;
	    main_current = current;
	    current_mail_message = current;
	    main_last = last_current;
	    main_selected = selected;
	    main_page = header_page;

	    message_count = alias_count;
	    current = alias_current;
	    last_current = alias_last;
	    selected = alias_selected;
	    header_page = alias_page;

	    strfcpy(item, catgets(elm_msg_cat, AliasesSet, Aliasesitem, 
				  "alias"),
		    sizeof item);
	    strfcpy(items, catgets(elm_msg_cat, AliasesSet, Aliasesitems, 
				   "aliases"),
		    sizeof items);
	    strfcpy(Item, catgets(elm_msg_cat, AliasesSet, AliasesItem, 
				  "Alias"),
		    sizeof Item);
	    strfcpy(Items, catgets(elm_msg_cat, AliasesSet, AliasesItems, 
				   "Aliases"),
		    sizeof Items);
	    strfcpy(Prompt, catgets(elm_msg_cat, AliasesSet, AliasesPrompt, 
				    "Alias: "),
		    sizeof Prompt);

	    DPRINT(Debug,2,
		   (&Debug, "Entered alias mode\n"));
	    inalias = TRUE;
	}
}

static int parse_aliases(buffer, remainder, size_buffer, size_remainder)
     char *buffer, *remainder;
     int size_buffer, size_remainder;
{
/*
 *	This routine will parse out the individual aliases present
 *	on the line passed in buffer.  This involves:
 *
 *	1. Testing for an '=' to make sure this is an alias entry.
 *
 *	2. Setting remainder to point to the rest of the line starting
 *	   at the '=' (for later rewriting if needed).
 *
 *	3. Parsing the aliases into an string padded with ',' at 
 *	   the end.
 *
 *	4. Returning the number of aliases found (0 if test #1 fails).
 */

	char *s;
	int number;

/*	Check to see if an alias */

	if ((s = index(buffer, '=')) == NULL)
	  return (0);

	/* Save the remainder of the line */
	strfcpy(remainder, s, size_remainder);		

/*	Terminate the list of aliases with a ',' */

	while (--s >= buffer && whitespace(*s)) ;
	if (s < buffer + size_buffer -2) {
	  *++s = ',';
	  *++s = '\0';
	}

/*	Lowercase everything */

	s = shift_lower(buffer);
	strfcpy(buffer, s, size_buffer);

/*	Now, count the aliases */

	number = 0;
	for (s = buffer; *s; s++)
	  if (*s == ',')
	    number++;

	return (number);
}

static int get_aliasname(aliasname, buffer, duplicate, size, buffer_size)
     char *aliasname, *buffer;
     int *duplicate;
     int size, buffer_size;
{

/*
 *	Have the user enter an aliasname, check to see if it
 *	is legal, then check for duplicates.  If a duplicate
 *	is found offer to replace existing alias.
 *
 *	Return values:
 *
 *	-1	Either the aliasname was zero length, had bad
 *		characters and was a duplicate which the user
 *		chose not to replace.
 *
 *	0	A new alias was entered successfully.
 *
 *	1	The entered alias was an existing USER alias
 *		that the user has chosen to replace.  In this
 *		case the alias to replace is passed back in
 *		in the variable 'duplicate'.
 *
 *   REDRAW_MARK
 */

	int loc;

	do {
	  int status =
	    optionally_enter(aliasname, elm_LINES-2, strlen(buffer), 
			     OE_REDRAW_MARK, size);

	  if (REDRAW_MARK == status)
	    return REDRAW_MARK;

	/*
	 *  Return if nothing was entered.
	 */
	  if (0 != status || strlen(aliasname) == 0) 
	    return(-1);

	} while (check_alias(aliasname) == -1);

	clear_error();			/* Just in case */
/*
 *	Check to see if there is already a USER alias by this name.
 */
	if ((loc = find_alias(aliasname, USER)) >= 0) {
	    DPRINT(Debug,2,
		   (&Debug, 
		    "Attempt to add a duplicate alias [%s] in get_aliasname\n",
		    aliases[loc]->alias)); 
	    if (aliases[loc]->type & GROUP )
	        PutLineX(elm_LINES-2,0, 
			 CATGETS(elm_msg_cat,
				 AliasesSet, AliasesAlreadyGroup,
				 "Already a group with name %s."), 
			 aliases[loc]->alias);
	    else
	        PutLineX(elm_LINES-2,0, 
			 CATGETS(elm_msg_cat,
				 AliasesSet, AliasesAlreadyAlias,
				 "Already an alias for %s."), 
			 aliases[loc]->alias);
	    CleartoEOLN();
	    elm_sfprintf(buffer, buffer_size,
			 CATGETS(elm_msg_cat,
				 AliasesSet, AliasesReplaceExisting,
				 "Replace existing alias? (%c/%c) "),
			 *def_ans_yes, *def_ans_no);
	 /*
	  * If they don't want to replace the alias by that name
	  * then just return.
	  */
	    if (want_to(buffer, *def_ans_no, elm_LINES-3, 0) != *def_ans_yes)
	        return(-1);
	    *duplicate = loc;
	    return(1);
	}
/*
 *	If they have elected to replace an existing alias then
 *	we assume that they would also elect to superceed a
 *	system alias by that name (since they have already
 *	done so).  So we don't even bother to check or ask.
 *
 *	Of course we do check if there was no USER alias match.
 */
	if ((loc = find_alias(aliasname, SYSTEM)) >= 0) {
	    DPRINT(Debug,2,
		   (&Debug,
		    "Attempt to add a duplicate system alias [%s] in get_aliasname\n",
		    aliases[loc]->address)); 
	    
	    if( ! superceed_system(loc, buffer, buffer_size))
	        return(-1);
	}
	return(0);

}

static int
superceed_system(this_alias, buffer, buffer_size)
     int this_alias;
     char *buffer;
     int buffer_size;
{

	PutLineX(elm_LINES-2, 0, 
		 CATGETS(elm_msg_cat,
			 AliasesSet, AliasesSystemAlias, 
			 "System (%6s) alias for %s."),
		 alias_type(aliases[this_alias]->type), 
		 aliases[this_alias]->alias);

        elm_sfprintf(buffer, buffer_size,
		     CATGETS(elm_msg_cat, AliasesSet, AliasesSuperceed,
			     "Superceed? (%c/%c) "), *def_ans_yes, *def_ans_no);
/*
 *	If they don't want to superceed the SYSTEM alias then
 *	return a FALSE.
 */
	return(want_to(buffer, *def_ans_no, elm_LINES-3, 0) == *def_ans_yes);
}

static void get_realnames(aliasname, firstname, lastname, comment, buffer,
			  size_first, size_last, size_comment, size_buffer,
			  is_group)
     char *aliasname, *firstname, *lastname, *comment, *buffer;
     int size_first, size_last, size_comment, size_buffer;
     int is_group;
{
  int status;
	
  if (is_group) {
      lastname[0] = '\0';
      firstname[0] = '\0';
  } else {
      elm_sfprintf(buffer, size_buffer,
		   CATGETS(elm_msg_cat, AliasesSet, AliasesEnterLastName,
			   "Enter last name for %s: "), aliasname);
      PutLine0(elm_LINES-2,0, buffer);
      CleartoEOLN();
      status = optionally_enter(lastname, elm_LINES-2, strlen(buffer),
				  OE_REDRAW_MARK, size_last);
      while (REDRAW_MARK == status) {
	  PutLine0(elm_LINES-2,0, buffer);
	  status = optionally_enter(lastname, elm_LINES-2, strlen(buffer),
				    OE_REDRAW_MARK|OE_APPEND_CURRENT,
				    size_last);
      }
      
      elm_sfprintf(buffer, size_buffer,
		   CATGETS(elm_msg_cat, AliasesSet, AliasesEnterFirstName,
			   "Enter first name for %s: "), aliasname);
      PutLine0(elm_LINES-2,0, buffer);
      CleartoEOLN();
      status = optionally_enter(firstname, elm_LINES-2, strlen(buffer), 
				OE_REDRAW_MARK, size_first);
      while (REDRAW_MARK == status) {
	  PutLine0(elm_LINES-2,0, buffer);
	  status = optionally_enter(firstname, elm_LINES-2, strlen(buffer), 
				    OE_REDRAW_MARK|OE_APPEND_CURRENT,
				    size_first);
      }
      
      if (strlen(lastname) == 0) {
	  strfcpy(lastname, firstname, size_last);  
	  *firstname = '\0';
      }
  }       

  elm_sfprintf(buffer, size_buffer,
	       CATGETS(elm_msg_cat, AliasesSet, AliasesEnterComment,
		       "Enter optional comment for %s: "), aliasname);
  PutLine0(elm_LINES-2,0, buffer);
  status = optionally_enter(comment, elm_LINES-2, strlen(buffer), 
			    OE_REDRAW_MARK, size_comment);
  while (status == REDRAW_MARK) {
      PutLine0(elm_LINES-2,0, buffer);
      status = optionally_enter(comment, elm_LINES-2, strlen(buffer), 
				OE_REDRAW_MARK|OE_APPEND_CURRENT,
				size_comment);
  }  
}

static int ask_accept(aliasname, firstname, lastname, comment, address, buffer,
	       replace, replacement, size_buffer)
     char *aliasname, *firstname, *lastname, *comment, *address, *buffer;
     int replace, replacement;
     int size_buffer;
{

	char ch;
	char *(old_alias[1]);
/*
 *	If firstname == lastname, they probably just took all
 *	the deafaults.  We *assume* they don't want lastname
 *	entered twice, so we will truncate it.
 */
	if (strcmp(firstname, lastname) == 0) {
	    *firstname = '\0';
	}

	if (strlen(lastname) == 0) {
	  PutLineX(elm_LINES-1,0, CATGETS(elm_msg_cat, AliasesSet, 
					  AliasesAddressAs1,
					  "Messages addressed as: %s"), 
		   address);
	  strfcpy(buffer, aliasname, size_buffer);  
	} else {
	  if (strlen(firstname) == 0) {
	      strfcpy(buffer, lastname, size_buffer);  
	  }
	  else {
	      elm_sfprintf(buffer, size_buffer,
			   FRM("%s %s"), firstname, lastname);
	  }
	  PutLineX(elm_LINES-1,0, 
		   CATGETS(elm_msg_cat, AliasesSet, 
			   AliasesAddressAs,
			   "Messages addressed as: %s <%s>"), 
		   buffer,address);
	}
	if (strlen(comment) != 0) {
	    strfcat(buffer, ", ", size_buffer);
	    strfcat(buffer, comment, size_buffer);
	}

	PutLineX(elm_LINES-2,0, 
		 CATGETS(elm_msg_cat, AliasesSet, 
			 AliasesAddressTo,
			 "New alias: %s is '%s'."), 
		 aliasname, buffer);
	CleartoEOLN();
/*
 *	Kludge Alert:  Spaces are padded to the front of the prompt
 *	to write over the previous question.  Should probably record
 *	the end of the line, move to it, and CleartoEOLN() it.
 */
	elm_sfprintf(buffer, size_buffer,
		    CATGETS(elm_msg_cat, AliasesSet, AliasesAcceptNew,
			    "      Accept new alias? (%c/%c) "), 
		     *def_ans_yes, *def_ans_no);
	if((ch = want_to(buffer, *def_ans_yes, elm_LINES-3, 0)) == *def_ans_yes) {
	    if (replace) {
	        old_alias[0] = aliases[replacement]->alias;
	    /*
	     *  First, clear flag if this is marked to be deleted.
	     *  This prevents the problem where they marked it for
	     *  deletion and then figured out that it could be
	     *  c)hanged but didn't explicitly U)ndelete it.  Without
	     *  this test, the resync action would then delete
	     *  the new alias we just so carefully added to the
	     *  text file.
	     */
	        if (ison(aliases[replacement]->status, DELETED)) {
	            clearit(aliases[replacement]->status, DELETED);
	        }
	    /*
	     *  Changed aliases are given the NEW flag.
	     */
	        setit(aliases[replacement]->status, NEW);
	        show_msg_status(replacement);
	    /*
	     *  Now we can delete it...
	     */
	        delete_from_alias_text(old_alias, 1);
	    /*
	     *  Kludge Alert:  We need to get the trailing comma
	     *  (added in delete_from_alias_text()) off of the
	     *  alias since the display won't be re-sync'd right
	     *  away.
	     */
	        *((old_alias[0])+strlen(old_alias[0])-1) = '\0';
	    }
	    add_to_alias_text(aliasname, firstname, lastname, comment, address);
	}
	ClearLine(elm_LINES-2);
	ClearLine(elm_LINES-1);
	return(ch == *def_ans_yes ? 1 : 0);

}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
