static char rcsid[] = "@(#)$Id: file.c,v 1.24 2001/06/09 10:55:09 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.24 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** File I/O routines, mostly the save to file command...

**/

#include "headers.h"
#ifdef PWDINSYS
#  include <sys/pwd.h>
#else
#  include <pwd.h>
#endif

#include "s_elm.h"
#include <errno.h>
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"mbox");

extern int errno;

static int save_message P_((int number, 
			    struct folder_browser * XXX,
			    struct string         * name,
			    WRITE_STATE             ptr,
			    int pause, int appending, 
			    int silently, int delete, int text_only,
			    int *redraw));

struct string * prev_fold = NULL;           /* name of previous folder */

int save(redraw, silently, delete, text_only)
     int *redraw, silently, delete, text_only;
{
    /** Save all tagged messages + current in a folder.  If no messages
	are tagged, save the current message instead!  This routine
	will return ZERO if the operation failed.
	'redraw' is set to TRUE iff we use the '?' and mess up
	the screen.  Pretty reasonable, eh?  If "silently" is set,
	then don't output the "D" character upon marking for
	deletion...
	If delete is set, then delete the saved messages, else
	we are just copying the messages without deletion.
	If text_only is text, message is decoded.
    **/

    int	tagged = 0, i, oldstat, appending = 0,
	is_ordinary_file, scount = 0;
    int mesgnum = 0;	/* message whose address is used for save-by-name fn */
    char       
	answer;

    struct folder_browser * XXX = new_browser(selection_folder);
    struct string         * buffer = NULL;
    WRITE_STATE           write_ptr = NULL;
    int retval = 0;
    int fail = 0;


    oldstat = headers[current-1]->status;	/* remember */
    *redraw = FALSE;

    for (i=0; i < message_count; i++) {
	if (ison(headers[i]->status, TAGGED)) {
	    if(!tagged)
		mesgnum = i;	/* first tagged msg -  use this one for
				 * save-by-name folder name */
	    tagged++;
	}
    }

    if (tagged == 0) {
	mesgnum = current-1; /* use this one for save-by-name folder name */

	tagged = 1;
	setit(headers[current-1]->status, TAGGED);
	/* 2 == text_only -- Not envelope information */
	if (text_only)
	    text_only = 2;
    }
    
    DPRINT(Debug,4, (&Debug, 
		     "%d message%s tagged for saving (save)\n", tagged,
		     plural(tagged)));

    while (1) {
	int code;
	int X,Y;

	if (!buffer && save_by_name &&
		headers[mesgnum]->from &&
		headers[mesgnum]->from[0].addr) {
		char buffer1[1000];
		
		/** build default filename to save to **/
		
		get_return_name(headers[mesgnum]->from[0].addr, 
				buffer1, TRUE, sizeof buffer1);
		buffer = format_string(FRM("=%s"), buffer1);
	}

	/* 2 == text_only -- Not envelope information */
	if (text_only > 0) {
	    if (tagged == 1)
		gen_browser(XXX,&buffer,redraw,
			    delete ? word_save : word_copy,
			    prev_fold,
			    CATGETS(elm_msg_cat, ElmSet, ElmSaveTextMesTo,
				    "%s text of message to: "), 
			    (delete ? cap_save_word : cap_copy_word));
	    else
		gen_browser(XXX,&buffer,redraw,
			    delete ? word_save : word_copy,
			    prev_fold,
			    CATGETS(elm_msg_cat, ElmSet, ElmSaveTextMessagesTo,
				    "%s text messages to: "), 
			    (delete ? cap_save_word : cap_copy_word));
	  } else {
	      if (tagged == 1)
		  gen_browser(XXX,&buffer,redraw,
			      delete ? word_save : word_copy,
			      prev_fold,
			      CATGETS(elm_msg_cat, ElmSet, ElmSaveMessageTo,
				      "%s message to: "), 
			      (delete ? cap_save_word : cap_copy_word));
	      else
		  gen_browser(XXX,&buffer,redraw,
			      delete ? word_save : word_copy,
			      prev_fold,
			      CATGETS(elm_msg_cat, ElmSet, ElmSaveMessagesTo,
				      "%s messages to: "), 
			      (delete ? cap_save_word : cap_copy_word));
	  }
	GetXYLocation(&X,&Y);
	
	code = give_dir_flags(XXX);
	
	DPRINT(Debug,4,(&Debug, 			
			"*** %S have flags:%s%s%s%s%s%s%s\n",
			buffer,
			code & BROWSER_NODIR    ?   " NODIR":    "",
			code & BROWSER_NOFOLDER ?   " NOFOLDER": "",
			code & BROWSER_MARKED   ?   " MARKED":   "",
			
			code & BROWSER_MAILFILE ?   " MAILFILE": "",
			code & BROWSER_SELECTED ?   " SELECTED": "",
			code & BROWSER_EXIST    ?   " EXIST"   : "",
			!code                   ?   " none"    : ""));

	if (0 == code) {  /** <return> means 'cancel', right? **/
	    headers[current-1]->status = oldstat;	/* BACK! */
	    
	    retval = 0;
	    goto clean;
	}
	 
	/* Replace editing buffer with expanded version ... */
	if (buffer)
	    free_string(&buffer);
	buffer = selection_name_dir(XXX);

	is_ordinary_file = 0 == (code & BROWSER_MAILFILE);

	/* 2 == text_only -- Not envelope information */
	if (2 == text_only && !is_ordinary_file)
	    text_only = 1;

	if (0 != (code & BROWSER_EXIST)) {	/* already there!! */
	    appending = 1;
	    if (confirm_append || (confirm_files && is_ordinary_file)) {
		char * msg_buffer  = NULL;

	        if (is_ordinary_file)
		    msg_buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						     ElmConfirmFilesAppend,
						     "Append to an existing file `%S'? (%c/%c) "),
					     buffer, 
					     *def_ans_yes, 
					     *def_ans_no);
	        else
		    msg_buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						     ElmConfirmFolderAppend,
						     "Append to mail folder `%s'? (%c/%c) "),
					     buffer, 
					     *def_ans_yes, 
					     *def_ans_no);
		
	        answer = want_to(msg_buffer, *def_ans_no, elm_LINES-1, 1);

		free(msg_buffer);

		if (answer != *def_ans_yes) {
		    continue;   /* RETRY */
		}
	    }
	} else {
            if (confirm_create || (confirm_folders && !is_ordinary_file)) {
		char * msg_buffer  = NULL;

	        if (is_ordinary_file)
		    msg_buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						   ElmConfirmFilesCreate,
						   "Create a new file `%S'? (%c/%c) "),
					     buffer, 
					     *def_ans_yes, 
					     *def_ans_no);
	        else
	            msg_buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						     ElmConfirmFolderCreate,
						     "Create a new mail folder `%S'? (%c/%c) "),
					     buffer, 
					     *def_ans_yes, 
					     *def_ans_no);

	        answer = want_to(msg_buffer, *def_ans_no, elm_LINES-1, 1);

		free(msg_buffer);

		if (answer != *def_ans_yes) {
		    continue;    /* RETRY */
		}
	    }

	    /* Create it now ... */
            if (!create_selection_dir(XXX))
		continue;         /* RETRY */
	    
	}
	      
	if (prepare_write_folder(XXX,&write_ptr)) {
	    break; /* OK */
	}
	
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotSaveMessage,
			  "Cannot %s message to folder %S!"),
		  delete ? save_word:copy_word, buffer);
	headers[current-1]->status = oldstat; /* BACK! */
	/* RETRY */
    }  /* End loop */
   
    /* 2 == text_only -- Not envelope information */
    if (2 == text_only && appending)
	text_only = 1;

    /* save this filename for the next time */
    if (2 != text_only) {
	if (prev_fold)
	    free_string(&prev_fold);
	prev_fold = dup_string(buffer);
    }
   
    /* if we need a redraw that means index screen no longer present
     * so whatever silently was, now it's true - we can't show those
     * delete markings.
     */
    if(*redraw) silently = TRUE;

    for (i=0; i < message_count; i++) 	/* save each tagged msg */
	if (headers[i]->status & TAGGED) {
	    
	    if (!save_message(i, XXX, buffer, write_ptr, 
			      (tagged > 1), appending++, 
			      silently, delete, text_only, redraw))
		fail++;
	    if(*redraw) silently = TRUE;
	    scount++;
	    
	}


    if (!end_write_folder(XXX,&write_ptr) || fail) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedSaveMessage,
			  "Failed %s message to folder %S!"),
		  delete ? save_word:copy_word, buffer);	    
    } else {
	if (text_only) {
	    if (tagged == 1 && !appending)
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmTextMessageSaved,
				  "Text of message %s to %S."), 
			  delete ? saved_word: copied_word,
			  buffer);
	    else if (tagged > 1)
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmTextMessagesSaved,
				  "Text of %d messages %s to %S."), 
			  scount, 
			  delete ? saved_word: copied_word,
			  buffer);
	} else {
	    if (tagged == 1 && !appending)
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMessageSaved,
				  "Message %s to %S."), 
			  delete ? saved_word: copied_word,
			  buffer);
	    else if (tagged > 1)
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmMessagesSaved,
				  "%d messages %s to %S."), 
			  scount, 
			  delete ? saved_word: copied_word,
			  buffer);
	}
	retval = 1;
	goto clean;
    }
    
 clean:
    if (XXX)
	free_dir(&XXX);
    if (buffer)
	free_string(&buffer);
    
    DPRINT(Debug,8,(&Debug, 
		    "save=%d *redraw=%d\n",
		    retval,*redraw));
    return retval;
}

static int save_message(number, XXX, name,ptr,
			pause, appending, silently, 
			delete, text_only, redraw)
    int number, pause, appending, silently, delete;
    struct folder_browser * XXX;
    struct string         * name;
    WRITE_STATE             ptr;
    int text_only;
    int *redraw;
{
    int ret = 0;

    /** Save an actual message to a folder.  This is called by 
	"save()" only!  The parameters are the message number,
	and the name and file descriptor of the folder to save to.
	If 'pause' is true, a sleep(sleepmsg) will be done after the
	saved message appears on the screen...
	'appending' is only true if the folder already exists 
	If 'delete' is true, mark the message for deletion.
	If text_only is set then decode_message, if
	text_only == 2 no folder envelope will be saved
    **/

    int save_current, is_new;
    int is_tagged = 0;
	
    DPRINT(Debug,4,(&Debug, 
		    "\tSaving message %d to folder... (text_only=%d)\n", 
		    number,text_only));
    
    if (!current_folder)
	return 0;

    save_current = current;
    current = number+1;
    
    /* change status from NEW before copy and reset to what it was
     * so that copy doesn't look new, but we can preserve new status
     * of message in this mailfile. This is important because if
     * user does a resync, we don't want NEW status to be lost.
     * I.e. NEW becomes UNREAD when we "really" leave a mailfile.
     */
    if(0 != (is_new = 
	     ison(headers[number]->status, NEW)))
	clearit(headers[number]->status, NEW);

    /* Do not save TAGGED (\Flagged) flag ... */
    
    if(0 != (is_tagged = 
	     ison(headers[number]->status, TAGGED)))
	clearit(headers[number]->status, TAGGED);

    switch(text_only) {
    case 2:
	ret = copy_message_d(current_folder,headers[number],"",
			     XXX, ptr,
			     CM_DECODE | CM_FILT_HDR | CM_REMOVE_ENVELOPE);
	break;
    case 1:
	ret = copy_message_d(current_folder,headers[number],"",
			     XXX, ptr, CM_DECODE | CM_FILT_HDR);
	break;
    case 0: default:
	ret = copy_message_d(current_folder,headers[number],"",
			     XXX,ptr, CM_UPDATE_STATUS);
	break;
    }

    /* Need redraw -- PGP output ?*/
    if (raw_off_called()) {
	*redraw = TRUE;
	silently = TRUE;
    }
        
    if(is_new)
	setit(headers[number]->status, NEW);
    current = save_current;
    
    if (ret) {
	if (delete)
	    setit(headers[number]->status, DELETED); /* deleted, but ...   */
	
	if (text_only) {
	    if (appending)
		lib_transient(CATGETS(elm_msg_cat, ElmSet, 
				      ElmTextMessageAppendedFolder,
				      "Text of message %d appended to folder %S."), 
			      number+1, name);
	    else if (2 == text_only)
		lib_transient(CATGETS(elm_msg_cat, ElmSet, 
				      ElmTextMessageSavedFile,
				      "Text of message %d %s to file %S."),
			      number+1, delete ? saved_word : copied_word, 
			      name);
	    else
		lib_transient(CATGETS(elm_msg_cat, ElmSet, 
				      ElmTextMessageSavedFolder,
				      "Text of message %d %s to folder %S."),
			      number+1, delete ? saved_word : copied_word, 
			      name);
	} else {
	    if (appending)
		lib_transient(CATGETS(elm_msg_cat, ElmSet, 
				      ElmMessageAppendedFolder,
				      "Message %d appended to folder %S."), 
			      number+1, name);
	    else
		lib_transient(CATGETS(elm_msg_cat, ElmSet, 
				      ElmMessageSavedFolder,
				      "Message %d %s to folder %S."),
			      number+1, delete ? saved_word : copied_word, 
			      name);
	}	
    } else {
	/* save failed -- is still tagged */
	if(is_tagged)
	    setit(headers[number]->status, TAGGED);
    }

    if (! silently)
	show_new_status(number);	/* update screen, if needed */
    
    if (pause && (!silently) && (!appending)) 
	sleep_message();

    DPRINT(Debug,9,(&Debug,
		    "save_message=%d\n",ret));
    return ret;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

