static char rcsid[] = "@(#)$Id: leavembox.c,v 1.27 2001/06/09 12:34:57 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.27 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** leave current folder, updating etc. as needed...
  
**/

#include "headers.h"
#include "me.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"mbox");

#ifdef USE_FLOCK_LOCKING
#define SYSCALL_LOCKING
#endif
#ifdef USE_FCNTL_LOCKING
#define SYSCALL_LOCKING
#endif
#ifdef SYSCALL_LOCKING
#  if (defined(BSD_TYPE) || !defined(apollo))
#    include <sys/file.h>
#  endif
#endif
#include <errno.h>

extern int errno;

char *error_description();

static void block_signals P_((void));
static void unblock_signals P_((void));

static unsigned char * s2us P_((char *str));
static unsigned char * s2us(str)
     char *str;
{
    return (unsigned char *)str;
}

int leave_mbox(resyncing, quitting, prompt, new_folder)
     int resyncing, quitting, prompt;
     struct folder_info **new_folder;
{
    /** Close folder, deleting some messages, storing others in mbox,
	and keeping others, as directed by user input and elmrc options.
	
	Return	1	Folder altered
	        0	Folder not altered
		-1	New mail arrived during the process and
		        closing was aborted.
	        -2      Leaving of folder failed
			
        If "resyncing" we are just writing out folder to reopen it. We
	   therefore only consider deletes and keeps, not stores to mbox.
	   Also we don't remove NEW status so that it can be preserved
	   across the resync.

	If "quitting" and "prompt" is false, then no prompting is done.
	    Otherwise prompting is dependent upon the variable
	    question_me, as set by an elmrc option.  This behavior makes
	    the 'q' command prompt just like 'c' and '$', while
	    retaining the 'Q' command for a quick exit that never
	    prompts.
    **/

    int new_bytes;
    struct keep_folder_state * keep_state_ptr = NULL;

    int to_delete = 0, to_store = 0, to_keep = 0, i,
	marked_deleted, marked_read, marked_unread,
	last_sortby, ask_questions,  asked_storage_q,
	num_chgd_status;

    int return_value = -1;
    char answer = '\0';
    struct folder_browser * recv_browser = new_browser(selection_folder);
    struct string         * recv_name    = new_string(system_charset);
    int                     recv_flags   = 0;
    WRITE_STATE             recv_writeptr = NULL;

    int  can_store          = 0;
    int current_is_received = 0;
    int new_is_received     = 0;
    

    add_ascii_to_string(recv_name,s2us(">"));        /* Received folder */
    can_store = select_dir_item(recv_browser,&recv_name);
   
    if (resyncing) {
	DPRINT(Debug,1,
	       (&Debug, "\n\n-- syncing folder --\n\n"));
    } else {
	DPRINT(Debug,1,
	       (&Debug, "\n\n-- leaving folder --\n\n"));
    }

    if (can_store) {
	current_is_received = selection_is_folder(recv_browser,current_folder);
	if (new_folder && *new_folder)
	    new_is_received = selection_is_folder(recv_browser,*new_folder);
	recv_flags = give_dir_flags(recv_browser);

	/* Create it if not exists yet ... */
	if (0 == (recv_flags & BROWSER_EXIST)) {
	    if (!create_selection_dir(recv_browser))
		can_store = 0;
	    else {
		DPRINT(Debug,1,(&Debug,  
				"*** Creating received folder!\n"));
	    }
	}
    }

    if (current_is_received) {
	DPRINT(Debug,4,(&Debug,  "*** Current folder is received folder!\n"));
    }

    if (new_is_received) {
	DPRINT(Debug,4,(&Debug,  "*** New folder is received folder!\n"));
    }

    if (!can_store) {
	DPRINT(Debug,4,(&Debug,  "*** Received folder is not available!\n"));
    }

    if (0 != (get_folder_mode(current_folder) & FOLDER_RDONLY)) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFolderReadOnlyUnchanged,
			  "Folder is read-only and unchanged."));

	if (!resyncing) 
	    /* do not close folder in resyncing,
	     * because it will cause lost of session lock
	     */
	    close_folder(current_folder,CLOSE_NORMAL);
	return_value = 0;	/* nothing changed */
	goto cleanup;
    }

    if (message_count == 0) {
	/* consider_remove_folder closes folder if removed */
	if (!resyncing && consider_remove_folder(current_folder)) {

	    /* i.e. if no messages were and this is not a spool
	     * folder and we aren't keeping empty non-spool folders,
	     * simply remove the old original folder and that's it!
	     */
	    DPRINT(Debug,3,(&Debug,  "Removing folder!\n"));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFolderRemoved,
			      "Folder removed."));
	    
	    return_value = 1;
	    goto cleanup;
	}
	
	if (!resyncing) 
	    /* do not close folder in resyncing,
	     * because it will cause lost of session lock
	     */
	    close_folder(current_folder,CLOSE_NORMAL);
	return_value = 0;	/* nothing changed */
	goto cleanup;
    }
    ask_questions = ((quitting && !prompt) ? FALSE : question_me);

    /* YES or NO on softkeys */
    /*
      if (hp_softkeys && ask_questions) {
      define_softkeys(YESNO);
      softkeys_on();
      }
    */

    /* Clear the exit dispositions of all messages, just in case
     * they were left set by a previous call to this function
     * that was interrupted by the receipt of new mail.
     */
    for(i = 0; i < message_count; i++)
	headers[i]->exit_disposition = UNSET;
	  
    /* Determine if deleted messages are really to be deleted */

    /* we need to know if there are none, or one, or more to delete */
    for (marked_deleted=0, i=0; i<message_count && marked_deleted<2; i++)
	if (ison(headers[i]->status, DELETED))
	    marked_deleted++;

    if(marked_deleted) {
	answer = (always_del ? *def_ans_yes : *def_ans_no);	/* default answer */
	if(ask_questions) {
	    char * buffer = NULL;

	    if (marked_deleted == 1)
		buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
					     ElmLeaveDeleteMessage,
					     "Delete message? (%c/%c) "), 
				     *def_ans_yes, *def_ans_no);
	    else
		buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
					     ElmLeaveDeleteMessages,
					     "Delete messages? (%c/%c) "), 
				     *def_ans_yes, *def_ans_no);
	    answer = want_to(buffer, answer, elm_LINES-3, 0);
	    free(buffer);
	}

	if(answer == *def_ans_yes) {
	    for (i = 0; i < message_count; i++) {
		if (ison(headers[i]->status, DELETED)) {
		    headers[i]->exit_disposition = DELETE;
		    to_delete++;
		}
	    }
	}
    }
    DPRINT(Debug,3,(&Debug,  "Messages to delete: %d\n", to_delete));

    /* If this is a non spool file( or if received folder is treated
     * as mailbox because of protection mask of folder) , or if we are 
     * merely resyncing, all messages with an unset disposition (i.e. 
     * not slated for deletion) are to be kept.
     * Otherwise, we need to determine if read and unread messages
     * are to be stored or kept.
     */
    if(0 == (get_folder_mode(current_folder) & FOLDER_MBOX) ||
       current_is_received || resyncing) {
	to_store = 0;
	for (i = 0; i < message_count; i++) {
	    if(headers[i]->exit_disposition == UNSET) {
		headers[i]->exit_disposition = KEEP;
		to_keep++;
	    }
	}
    } else if (!can_store) {
	char * buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
					    ElmNoReceived,
					    "\"received\" folder not available, continue? (%c/%c) "),
				    *def_ans_yes, *def_ans_no);
		
	answer = want_to(buffer, *def_ans_no, elm_LINES-3, 0);
	
	if (answer != *def_ans_yes) {
	    return_value = -2;  /* failure */
	    goto cleanup;
	} 

	to_store = 0;
	for (i = 0; i < message_count; i++) {
	    if(headers[i]->exit_disposition == UNSET) {
		headers[i]->exit_disposition = KEEP;
		to_keep++;
	    }
	}

    } else {
	/* Let's first see if user wants to store read messages 
	 * that aren't slated for deletion */

	asked_storage_q = FALSE;

	/* we need to know if there are none, or one, or more marked read */
	for (marked_read=0, i=0; i < message_count && marked_read < 2; i++) {
	    if((isoff(headers[i]->status, UNREAD))
	       && (headers[i]->exit_disposition == UNSET))
		marked_read++;
	}

	if (marked_read) {
	   	
	    answer = (always_store ? *def_ans_yes : *def_ans_no);	/* default answer */
	    if(ask_questions) {
		char * buffer = NULL;
		
		if (marked_read == 1)
		    buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						 ElmLeaveMoveMessage,
						 "Move read message to \"received\" folder? (%c/%c) "),
					 *def_ans_yes, *def_ans_no);
		else
		    buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						 ElmLeaveMoveMessages,
						 "Move read messages to \"received\" folder? (%c/%c) "),
					 *def_ans_yes, *def_ans_no);
		answer = want_to(buffer, answer, elm_LINES-3, 0);
		asked_storage_q = TRUE;
		free(buffer);
	    }
	    
	    for (i = 0; i < message_count; i++) {
		if((isoff(headers[i]->status, UNREAD)) 
		   && (headers[i]->exit_disposition == UNSET)) {
		    
		    if(answer == *def_ans_yes) {
			headers[i]->exit_disposition = STORE;
			to_store++;
		    } else {
			headers[i]->exit_disposition = KEEP;
			to_keep++;
		    }
		}
	    } 	    
	}

	/* If we asked the user if read messages should be stored,
	 * and if the user wanted them kept instead, then certainly the
	 * user would want the unread messages kept as well.
	 */
	if(asked_storage_q && answer == *def_ans_no) {

	    for (i = 0; i < message_count; i++) {
		if((ison(headers[i]->status, UNREAD))
		   && (headers[i]->exit_disposition == UNSET)) {
		    headers[i]->exit_disposition = KEEP;
		    to_keep++;
		}
	    }	    
	} else {

	    /* Determine if unread messages are to be kept */
	    
	    /* we need to know if there are none, or one, or more unread */
	    for (marked_unread=0, i=0; i<message_count && marked_unread<2; i++)
		if((ison(headers[i]->status, UNREAD))
		   && (headers[i]->exit_disposition == UNSET))
		    marked_unread++;

	    if(marked_unread) {
		answer = (always_keep ? *def_ans_yes : *def_ans_no);	/* default answer */
		if(ask_questions) {
		    char * buffer = NULL;

		    if (marked_unread == 1)
			buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						     ElmLeaveKeepMessage,
						     "Keep unread message in incoming mailbox? (%c/%c) "),
					     *def_ans_yes, *def_ans_no);
		    else
			buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepMessages,
						     "Keep unread messages in incoming mailbox? (%c/%c) "),
					     *def_ans_yes, *def_ans_no);
		    answer = want_to(buffer, answer, elm_LINES-3, 0);
		    free(buffer);
		}
		
		for (i = 0; i < message_count; i++) {
		    if((ison(headers[i]->status, UNREAD))
		       && (headers[i]->exit_disposition == UNSET)) {
			if(answer == *def_ans_no) {
			    headers[i]->exit_disposition = STORE;
			    to_store++;
			} else {
			    headers[i]->exit_disposition = KEEP;
			    to_keep++;
			}	      
		    }
		}
	    }
	}
    }

    DPRINT(Debug,3,(&Debug,  "Messages to store: %d\n", to_store));
    DPRINT(Debug,3,(&Debug,  "Messages to keep: %d\n", to_keep));

    if(to_delete + to_store + to_keep != message_count) {
	MoveCursor(elm_LINES, 0);
	Raw(OFF);
	DPRINT(Debug,1,(&Debug, 
			"Error: %d to delete + %d to store + %d to keep != %d message cnt\n",
			to_delete, to_store, to_keep, message_count));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmSomethingWrongInCounts,
			  "Something wrong in message counts! Folder unchanged.\n"));
	panic("MBOX PANIC",__FILE__,__LINE__,"leave_mbox",
	      "Something wrong in message counts!",0);      
    }
	  
    /* If we are not resyncing, we are leaving the mailfile and
     * the new messages are new no longer. Note that this changes
     * their status.
     */
    if(!resyncing) {
	for (i = 0; i < message_count; i++) {
	    if (ison(headers[i]->status, NEW)) {
		clearit(headers[i]->status, NEW);
		headers[i]->status_chgd = TRUE;
	    }
	}
    }

    /* If all messages are to be kept and none have changed status
     * we don't need to do anything because the current folder won't
     * be changed by our writing it out - unless we are resyncing, in
     * which case we force the writing out of the mailfile.
     */

    for (num_chgd_status = 0, i = 0; i < message_count; i++)
	if(headers[i]->status_chgd == TRUE)
	    num_chgd_status++;
    
    if(!to_delete && !to_store && !num_chgd_status && !resyncing) {
	DPRINT(Debug,3,(&Debug,  "Folder keep as is!\n"));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFolderUnchanged,
			  "Folder unchanged."));
	return_value = 0;
	goto cleanup;
    }

    /** next, let's lock the file up and make one last size check **/
    
    if(!open_folder_lock(OUTGOING,current_folder)) {
	return_value = -2;  /* failure */
	goto cleanup;
    }

    /* 
     * lock routine will call clear_error so we print our action
     * message after it.
     */

    flush_folder(current_folder);

    if (new_mail_on_folder(current_folder,&new_bytes)) {
	unlock(0,current_folder);
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveNewMailArrived,
			  "New mail has just arrived. Resynchronizing..."));
	return_value = -1;
	goto cleanup;
    }

    if (to_store > 0) {

	if (new_is_received) {
	    int M = get_folder_mode(*new_folder);

	    if (0 != (M & FOLDER_FILE)) {
		DPRINT(Debug,3,(&Debug,  "--> Need close new folder...\n"));
		
		/* new_folder is same than =received, 
		   we need close new_folder so that locking does not
		   cause problems
		   
		   Two problems:
		   - Possible locking on prepare_write_folder()
	             may fail on some situations
		   
		   - Unlocking on end_write_folder() may cause
	             that lock of new_folder is lost!
		   
		     leave_old_folder frees data.
		*/
		
		leave_old_folder(*new_folder,CLOSE_NORMAL);
		*new_folder = NULL;
		
		/* change_file() on quit.c will reopen 
		   new_folder when needed
		*/
	    }
	}

	/* Permissons check for =received, and open of it ... */

	if (!prepare_write_folder(recv_browser,&recv_writeptr)) {
	    
#if POLL_METHOD	  
	    wait_for_timeout(5);
#else
	    sleep(5);
#endif

	    unlock(0,current_folder);
	    return_value = 0;
	    goto cleanup;
	}	
    }

    /** we have to check to see what the sorting order was...so that
	the order in which we write messages is the same as the order
	of the messages originally.
	We only need to do this if there are any messages to be
	written out (either to keep or to store). **/

    if ((to_keep || to_store ) && sortby != MAILBOX_ORDER) {
	last_sortby = sortby;
	sortby = MAILBOX_ORDER;
	sort_mailbox(message_count, FALSE);
	sortby = last_sortby;
    }

	
    /* Formulate message as to number of keeps, stores, and deletes.
     * This is only complex so that the message is good English.
     */
    if (to_keep > 0) {
	if (to_store > 0) {
	    if (to_delete > 0) {
		if (to_keep == 1)
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmLeaveKeepStoreDelete,
				      "[Keeping 1 message, storing %d, and deleting %d.]"), 
			      to_store, to_delete);
		else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmLeaveKeepStoreDeletePlural,
				      "[Keeping %d messages, storing %d, and deleting %d.]"), 
			      to_keep, to_store, to_delete);
	    } else {
		if (to_keep == 1)
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepStore,
				      "[Keeping 1 message and storing %d.]"), 
			      to_store);
		else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmLeaveKeepStorePlural,
				      "[Keeping %d messages and storing %d.]"), 
			      to_keep, to_store);
	    }
	} else {
	    if (to_delete > 0) {
		if (to_keep == 1)
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeepDelete,
				      "[Keeping 1 message and deleting %d.]"), 
			      to_delete);
		else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmLeaveKeepDeletePlural,
				      "[Keeping %d messages and deleting %d.]"), 
			      to_keep, to_delete);
	    } else {
		if (to_keep == 1)
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveKeep,
				      "[Keeping message.]"));
		else
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmLeaveKeepPlural,
				      "[Keeping all messages.]"));
	    }
	}
    } else if (to_store > 0) {
	if (to_delete > 0) {
	    if (to_store == 1)
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveStoreDelete,
				  "[Storing 1 message and deleting %d.]"), 
			  to_delete);
	    else
		lib_error(CATGETS(elm_msg_cat, ElmSet, 
				  ElmLeaveStoreDeletePlural,
				  "[Storing %d messages and deleting %d.]"), 
			  to_store, to_delete);
	} else {
	    if (to_store == 1)
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveStore,
				  "[Storing message.]"));
	    else
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveStorePlural,
				  "[Storing all messages.]"));
	}
    } else {
	if (to_delete > 0)
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmLeaveDelete,
			      "[Deleting all messages.]"));
    }
    
    block_signals();
	
    DPRINT(Debug,2,(&Debug,  "Action...\n"));

    /* Store messages slated for storage in received mail folder */
    if (to_store > 0) {
	/* Permissons check for and opening of =received done earlier */
       	DPRINT(Debug,10,(&Debug, 
			 "!! Copying from %s to %s\n",
			 current_folder->cur_folder_sys,recvd_mail));	    

	DPRINT(Debug,2,(&Debug,  "Storing message%s ", plural(to_store)));
	for (i = 0; i < message_count; i++) {
	    if(headers[i]->exit_disposition == STORE) {

		current = i+1;
		DPRINT(Debug,2,(&Debug,  "#%d, ", current));
		
		if (!copy_message_d(current_folder,headers[i],
				    "",recv_browser,recv_writeptr 
				    , CM_UPDATE_STATUS)) {
		    end_write_folder(recv_browser,&recv_writeptr);
		    goto write_received_failure;
		}
	    }
	}
	
	if (!end_write_folder(recv_browser,&recv_writeptr)) {
	write_received_failure:

	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmCopyMessageFailed,
			      "OOPS! Storing of mail failed!"));
	    	    
	    unlock(0,current_folder);
	    
	    unblock_signals();
	    return_value = -2;
	    goto cleanup;
	}

	DPRINT(Debug,2,(&Debug,  "\n\n"));
	
	if (ferror_folder(current_folder,TRUE)) {
	    unlock(0,current_folder);
	    
	    DPRINT(Debug,1,(&Debug,  "error when reading mailfile\n"));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmErrorReadMailfile,
			      "Error when reading mailfile %S"),
		      current_folder->cur_folder_disp);
	    sleep_message();
	    
	    unblock_signals();
	    return_value = -2;
	    goto cleanup;
	}
    }

    if (!prepare_keep_folder(current_folder,&keep_state_ptr)) {
	unlock(0,current_folder);
	
	unblock_signals();
	return_value = -2;
	goto cleanup;
    }

    for (i = 0; i < message_count; i++) {
	mark_keep_folder(current_folder,keep_state_ptr,
			 headers[i],
			 headers[i]->exit_disposition == KEEP);
    }

    if (!end_keep_folder(current_folder,&keep_state_ptr)) {
    panic_exit:
#if POLL_METHOD	  
	wait_for_timeout(5);
#else
	sleep(5);
#endif
	close_folder(current_folder,CLOSE_NORMAL);
	emergency_exit(0);
    }

    if (to_keep == 0) {
	/* consider_remove_folder closes folder if removed */
	if (!resyncing && consider_remove_folder(current_folder)) {
	    
	    /* i.e. if no messages were to be kept and this is not a spool
	     * folder and we aren't keeping empty non-spool folders,
	     * simply remove the old original folder and that's it!
	     */
	    
	    DPRINT(Debug,3,(&Debug,  "Removing folder!\n"));
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFolderRemoved,
			      "Folder removed."));
	    
	    unblock_signals();
	
#if POLL_METHOD	  
	    wait_for_timeout(5);
#else
	    sleep(5);
#endif
   
	    return_value = 1;
	    goto cleanup;
	}
    }

    if (resyncing) 
	/* do not close folder in resyncing,
	 * because it will cause lost of session lock
	 */
	unlock(0,current_folder);
    else
	close_folder(current_folder,CLOSE_NORMAL);
    unblock_signals();
    return_value = 1;

 cleanup:
    if (recv_writeptr)      /* If not done ealrier ...  */
	end_write_folder(recv_browser,&recv_writeptr);

    if (recv_browser)
	free_dir(&recv_browser);
    if (recv_name)
	free_string(&recv_name);


    DPRINT(Debug,11,(&Debug,  "leave_mbox=%d\n",return_value));

    return return_value;
}

#ifdef HASSIGPROCMASK
	sigset_t	toblock, oldset;
#else  /* HASSIGPROCMASK */
#  ifdef HASSIGBLOCK
	int		toblock, oldset;
#  else /* HASSIGBLOCK */
#    ifdef HASSIGHOLD
	/* Nothing required */
#    else /* HASSIGHOLD */
	SIGHAND_TYPE	(*oldhup)();
	SIGHAND_TYPE	(*oldint)();
	SIGHAND_TYPE	(*oldquit)();
	SIGHAND_TYPE	(*oldstop)();
#    endif /* HASSIGHOLD */
#  endif /* HASSIGBLOCK */
#endif /* HASSIGPROCMASK */

/*
 * Block all keyboard generated signals.  Need to do this while
 * rewriting mailboxes to avoid inadvertant corruption.  In
 * particular, a SIGHUP (from logging out under /bin/sh), can
 * corrupt a spool mailbox during an elm autosync.
 */

static void block_signals()
{
    DPRINT(Debug,1, (&Debug,  "block_signals\n"));
#ifdef HASSIGPROCMASK
	sigemptyset(&oldset);
	sigemptyset(&toblock);
	sigaddset(&toblock, SIGHUP);
	sigaddset(&toblock, SIGINT);
	sigaddset(&toblock, SIGQUIT);
#ifdef SIGTSTP
	sigaddset(&toblock, SIGTSTP);
#endif /* SIGTSTP */

	sigprocmask(SIG_BLOCK, &toblock, &oldset);

#else /* HASSIGPROCMASK */
#  ifdef HASSIGBLOCK
	toblock = sigmask(SIGHUP) | sigmask(SIGINT) | sigmask(SIGQUIT);
#ifdef SIGTSTP
	toblock |= sigmask(SIGTSTP);
#endif /* SIGTSTP */

	oldset = sigblock(toblock);

#  else /* HASSIGBLOCK */
#    ifdef HASSIGHOLD
	sighold(SIGHUP);
	sighold(SIGINT);
	sighold(SIGQUIT);
#ifdef SIGTSTP
	sighold(SIGTSTP);
#endif /* SIGTSTP */

#    else /* HASSIGHOLD */
	oldhup  = signal(SIGHUP, SIG_IGN);
	oldint  = signal(SIGINT, SIG_IGN);
	oldquit = signal(SIGQUIT, SIG_IGN);
#ifdef SIGTSTP
	oldstop = signal(SIGTSTP, SIG_IGN);
#endif /* SIGTSTP */
#    endif /* HASSIGHOLD */
#  endif /* HASSIGBLOCK */
#endif /* HASSIGPROCMASK */
}

/*
 * Inverse of the previous function.  Restore keyboard generated
 * signals.
 */
static void unblock_signals()
{
    DPRINT(Debug,1, (&Debug, "unblock_signals\n"));
#ifdef HASSIGPROCMASK
    sigprocmask(SIG_SETMASK, &oldset, (sigset_t *)0);

#else  /* HASSIGPROCMASK */
#  ifdef HASSIGBLOCK
    sigsetmask(oldset);

#  else /* HASSIGBLOCK */
#    ifdef HASSIGHOLD
	sigrelse(SIGHUP);
	sigrelse(SIGINT);
	sigrelse(SIGQUIT);
#ifdef SIGTSTP
	sigrelse(SIGTSTP);
#endif /* SIGTSTP */

#    else /* HASSIGHOLD */
	signal(SIGHUP, oldhup);
	signal(SIGINT, oldint);
	signal(SIGQUIT, oldquit);
#ifdef SIGTSTP
	signal(SIGTSTP, oldstop);
#endif /* SIGTSTP */

#    endif /* HASSIGHOLD */
#  endif /* HASSIGBLOCK */
#endif /* HASSIGPROCMASK */
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */


