static char rcsid[] = "@(#)$Id: quit.c,v 1.22 2001/06/09 13:37:25 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.22 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** quit: leave the current folder and quit the program.
  
**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"
#include <errno.h>

DEBUG_VAR(Debug,__FILE__,"ELM");

static char *us2s P_((unsigned char *str));
static char *us2s(str) 
     unsigned char *str;
{
    return (char *)str;
}

extern int errno;		/* system error number on failure */

long bytes();
char *error_description();

void quit(prompt)
     int prompt;
{

requit:
  if (current_folder) {
    int status;

    status = leave_mbox(FALSE, TRUE, prompt, NULL);
    if ( status == -1)
      /* new mail - leave not done - can't change to another file yet
       * check for change in mailfile_size in main() will do the work
       * of calling newmbox to add in the new messages to the current
       * file and fix the sorting sequence that leave_mbox may have
       * changed for its own purposes */
      return;
    
    if (status < 0) {
      int ans;
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedLeaveFolder,
			"Failed to leave folder!"));
      sleep_message();
    
      if (!prompt) 
	return;
    
    again1:
      PutLineX(elm_LINES,2,
	       CATGETS(elm_msg_cat, ElmSet, ElmFailedLeaveFolderQuit,
		       "Failed to leave folder: Try to quit again ? %c%c"),
	       *def_ans_no,BACKSPACE);
      CleartoEOLN();
      
      do {
	  ans = ReadCh(REDRAW_MARK);
	  if (ans == REDRAW_MARK)
	      goto again1;
	  if (ans == ('L'&31)) {
	      ClearScreen();      
	      goto again1;
	  }
	  ans = tolower(ans);
	  
	  if (ans == *def_ans_no || '\r' == ans || '\n' == ans) {
	      Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoWord, "No."));
	      return;
	  }
	  if (ans == *def_ans_yes) {
	      Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmYesWord, 
				      "Yes."));
	      clear_error();
	      goto requit;
	  } 
      } while(1);
    }
  }
  leave(0);
}

int resync()
{
  /** Resync on the current folder. Leave current and read it back in.
    Return indicates whether a redraw of the screen is needed.
    **/
  int  err;

  if (current_folder) {
    int result;

    result = leave_mbox(TRUE, FALSE, TRUE, NULL);
    if( result == -1)
      /* new mail - leave not done - can't change to another file yet
       * check for change in mailfile_size in main() will do the work
       * of calling newmbox to add in the new messages to the current
       * file and fix the sorting sequence that leave_mbox may have
       * changed for its own purposes */
      return(FALSE);

    if (result < 0) {
      lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedResyncFolder,
			"Failed to resync folder!"));
      sleep_message();
      return FALSE;
    }
  
    if (!sessionlock_folder(current_folder,SESSIONLOCK_CHECK)) {
	err = errno;
	MoveCursor(elm_LINES, 0);
	Raw(OFF);
	DPRINT(Debug,1,(&Debug, 
			 "Error: given file %s as folder - unreadable (%s)!\n", 
		   current_folder->cur_folder_sys, error_description(err)));
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCantOpenFolderRead,
			  "Can't open folder '%S' for reading: %s"), 
		  current_folder->cur_folder_disp,
		  error_description(err));
	leave(0);
    }
    
    newmbox_1(current_folder, FALSE);
  }
  return(TRUE);
}

int change_file()
{
    /* Prompt user for name of folder to change to.
     * If all okay with that folder, leave the current folder.
     * If leave goes okay (i.e. no new messages in current folder),
     * change to the folder that the user specified.
     *
     * Return value indicates whether a redraw is needed.
     */

    int redraw = FALSE;    
    struct folder_info *new_folder = NULL;
    struct folder_browser * XXX = new_browser(selection_folder);
    struct string         * buffer = NULL;

    int file_changed = 0;

    
    /* For some reason 0 is OK on input routine */

    while(1) {
	new_folder = folder_browser(XXX,&buffer,&redraw,
				    CATGETS(elm_msg_cat, ElmSet, 
					    ElmChangeToWhichFolder,
					    "Change to which folder: "));
	if (!new_folder)
	    break;
	
	/* don not accept the same file as the current */
	if (current_folder && selection_is_folder(XXX,current_folder)) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmAlreadyReadingThatFolder,
			      "Already reading that folder!"));
	    
	    /* Closing of IMAP folder may clear that error message
	     * se sleep on here ...
	     */

	    FlushBuffer();
	    if (sleepmsg) {
#if POLL_METHOD	  
		error_sleep(sleepmsg);
#else
		sleep(sleepmsg);
#endif
	    }

	    leave_old_folder(new_folder,CLOSE_NORMAL);
	    new_folder = NULL;
	    
	    continue;	/* prompt again */
	}
	
	/* Make sure this is a file the user can open, unless it is 
	 * the default mailfile, which is openable even if empty 
	 */
			       
	if (!sessionlock_folder(new_folder,SESSIONLOCK_CHECK)) {
	    leave_old_folder(new_folder,CLOSE_NORMAL);
	    new_folder = NULL;
		
	    continue; 	/* prompt again */
	}
	
	file_changed = 1;
	break;	/* exit loop - we got the name of a good file */
	
    }
	    
    if (file_changed) {
    rechange:
	/* All's clear with the new file to go ahead and leave the current. */
	MoveCursor(elm_LINES-3, 30);
	CleartoEOS();
	
	
	if (current_folder) {
	    int result;

	    if (redraw) {
		ClearScreen();      
		/* Show folder name which we are leaving ... */
		update_title();

	    }

	    result = leave_mbox(FALSE, FALSE, TRUE, &new_folder);
	    if(result ==-1) {
		/* new mail - leave not done - ca not change to another file 
		 * yet check for change in mailfile_size in main() will do the
		 * work of calling newmbox to add in the new messages to the 
		 * current file and fix the sorting sequence that leave_mbox 
		 * may have changed for its own purposes */
		
		if (new_folder) {
		    leave_old_folder(new_folder,CLOSE_NORMAL);
		    new_folder = NULL;
		}		

		goto fail;
	    }
	    
	    

	    if (result < 0) {
		int ans;
	    
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmFailedLeaveFolder,
				  "Failed to leave folder!"));
		sleep_message();
		
	    again1:
		/* TODO -- CATGETS */
		ans = want_to("Failed to leave folder: Try to change again ? [P]anic",
			      *def_ans_no,elm_LINES,1);
		if (ans == ('L'&31)) {
		    redraw = 1;
		    ClearScreen();      
		    goto again1;
		}
		if (ans == *def_ans_no) {
		    if (new_folder) {
			leave_old_folder(new_folder,CLOSE_NORMAL);
			new_folder = NULL;
		    }
		    goto fail;
		}
		if (ans == *def_ans_yes) {
		    clear_error();
		    goto rechange;
		}
		if (ans == 'P')
		    emergency_exit(0);
		
		if (new_folder) {
		    leave_old_folder(new_folder,CLOSE_NORMAL);
		    new_folder = NULL;
		}
		goto fail;
	    }
	
	    /* leave_mbox may have closed new_folder ... */
	    
	    if (!new_folder) {
		DPRINT(Debug,3,(&Debug,  
				"--> Need reopen new folder...\n"));

		new_folder = folder_from_dir_item(XXX);		

		if (!new_folder ||
		    !sessionlock_folder(new_folder,SESSIONLOCK_NORMAL)) {
		    emergency_exit(0);
		}
		    
	    }
	    


	}    
	redraw = TRUE;
	newmbox_1(new_folder, FALSE);
    }   

fail:

    if (buffer)
	free_string(&buffer);

    free_dir(&XXX);

    return redraw;
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
