static char rcsid[] = "@(#)$Id: read_rc.c,v 1.17 2001/06/14 18:25:44 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.17 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains programs to allow the user to have a .elm/elmrc file
    in their home directory containing any of the following: 

	fullname= <username string>
	maildir = <directory>
	tmpdir  = <directory>
	sentmail = <file>
	editor  = <editor>
	receviedmail= <file>
	calendar= <calendar file name>
	shell   = <shell>
	print   = <print command>
	weedout = <list of headers to weed out>
	prefix  = <copied message prefix string>
	pager   = <command to use for displaying messages>
	configoptions = <list of letters to use for options menu>
	precedences = <list of delivery precedences>
	
	escape  = <single character escape, default = '~' >

--
	signature = <.signature file for all outbound mail>
OR:
	localsignature = <.signature file for local mail>
	remotesignature = <.signature file for non-local mail>
--

	bounceback= <hop count threshold, or zero to disable>
	readmsginc = <new folder message count display increment>
	sleepmsg = time to 'sleep' while displaying transient messages
	timeout = <seconds for main menu timeout or zero to disable>
	userlevel = <0=amateur, 1=okay, 2 or greater = expert!>

	sortby  = <sent, thread, received, from, size, subject, mailbox, status>
	alias_sortby  = <alias, name>

	alternatives = <list of addresses that forward to us>

	builtinlines = <use builtin pager if message shorter than # lines>

    and/or the logical arguments:
	
	autocopy    [on|off]
	askcc	    [on|off]
	copy        [on|off]	
	resolve     [on|off]
	weed        [on|off]
	noheader    [on|off]
	titles      [on|off]
	savebyname  [on|off]
	forcename   [on|off]
	movepage    [on|off]
	pointnew    [on|off]
	hpkeypad    [on|off]
	hpsoftkeys  [on|off]
	alwayskeep  [on|off]
	alwaysstore [on|off]
	alwaysdel   [on|off]
	arrow	    [on|off]
	menus	    [on|off]
	metoo	    [on|off]
	forms	    [on|off]
	names	    [on|off]
	ask	    [on|off]
	keepempty   [on|off]
	promptafter [on|off]
	sigdashes   [on|off]
	usetite	    [on|off]


    Lines starting with '#' are considered comments and are not checked
    any further!

**/

#include "headers.h"
#include "rc_imp.h"
#include "save_opts.h"
#include "s_elm.h"
#include <errno.h>
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"config");

extern opts_menu *find_cfg_opts();
extern int errno;

char  *error_description(), *shift_lower(), *mode_to_str();

static void dump_rc_results P_((void));

void directory_check() {
    char  filename[SLEN];
    int ch;

#if DEBUG
    if (Debug.active > 10) 	/** only do this if we REALLY want debug! **/
	dump_rc_results();
#endif

    /* see if the user has a $HOME/.elm directory */
    elm_sfprintf(filename, sizeof filename,
		 FRM("%s/.elm"), 
		 home);
    if (access(filename, 00) == -1) {
	if(batch_only)  {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBatchDirNotice, 
			      "\nNotice:\
\nThis version of ELM requires the use of a .elm directory to store your\
\nelmrc and alias files. I'd like to create the directory .elm for you\
\nand set it up, but I can't in \"batch mode\".\
\nPlease run ELM in \"normal mode\" first.\n"));
	    exit(1);
	}
    
	Raw(ON | NO_TITE);
	MoveCursor(elm_LINES,0);

    redraw1:
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmDirNotice, 
				"\n\rNotice:\
\n\rThis version of ELM requires the use of a .elm directory in your home\
\n\rdirectory to store your elmrc and alias files. Shall I create the\
\n\rdirectory .elm for you and set it up (%c/%c/q)? %c%c"),
	     *def_ans_yes, *def_ans_no, *def_ans_no, BACKSPACE);
    
	FlushBuffer();
	ch=ReadCh(REDRAW_MARK);
	if (REDRAW_MARK == ch)
	    goto redraw1;
    
#ifdef ASCII_CTYPE
	if (isascii(ch))
#endif
	    ch = tolower(ch);

	/* they took the default by pressing cr */
	if (ch == '\n' || ch == '\r') 
	    ch = *def_ans_no;
	  
	if (ch == *def_ans_no) {
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeNo,
				    "No.\n\rVery well. I won't create it.\n\rBut, you may run into difficulties later.\n\r"));
	    if (sleepmsg > 0) {
#if POLL_METHOD
		error_sleep(sleepmsg *2);
#else
		sleep(sleepmsg *2);
#endif
	    }
	}
	else if (ch == *def_ans_yes) {
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeYes,
				    "Yes.\n\rGreat! I'll do it now.\n\r"));
	    create_new_elmdir();
	}
	else {
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeQuit,
				    "Quit.\n\rOK.  Bailing out of ELM.\n\r"));
	    Raw(OFF | NO_TITE);
	    exit(1);
	}
	Raw(OFF | NO_TITE);
    }	  

  /* see if the user has a folders directory */
    if (access(folders, 00) == -1) {
    if(batch_only)  {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmBatchNoticeFoldersDir, 
			  "\n\
Notice:\n\
ELM requires the use of a folders directory to store your mail folders in.\n\
I'd like to create the directory %s for you,\n\
but I can't in \"batch mode\". Please run ELM in \"normal mode\" first.\n"),
	     folders);
	exit(1);
    }

    Raw( ON | NO_TITE );
    MoveCursor(elm_LINES,0);

    redraw2:
    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmNoticeFoldersDir,
			    "\n\rNotice:\n\r\
ELM requires the use of a folders directory to store your mail folders in.\n\r\
Shall I create the directory %s for you (%c/%c/q)? %c%c"),
	     folders, *def_ans_yes, *def_ans_no, *def_ans_yes, BACKSPACE);
    
    FlushBuffer();
    ch=ReadCh(REDRAW_MARK);
    if (REDRAW_MARK == ch)
	goto redraw2;
    
#ifdef ASCII_CTYPE
    if (isascii(ch))
#endif
	ch = tolower(ch);

    if (ch == '\n' || ch == '\r') /* they took the default by pressing cr */
	ch = *def_ans_yes;

    if (ch == *def_ans_no) {
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeNo,
				"No.\n\rVery well. I won't create it.\n\rBut, you may run into difficulties later.\n\r"));
	if (sleepmsg > 0) {
#if POLL_METHOD
	    error_sleep(sleepmsg *2);
#else
	    sleep(sleepmsg *2);
#endif
	}
    }
    else if (ch == *def_ans_yes) {
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeYes,
				"Yes.\n\rGreat! I'll do it now.\n\r"));
	create_new_folders();
    }
    else {
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmDirNoticeQuit,
				"Quit.\n\rOK.  Bailing out of ELM.\n\r"));
	Raw(OFF | NO_TITE);
	exit(0);
    }
    Raw( OFF | NO_TITE );
  }

/* validate/correct config_options string */

  if (config_options[0]) {
    register char *s, *t;
    register opts_menu *o;
    s = shift_lower(config_options);
    for (t = config_options; *s; ++s) {
      if (*s == '_' || *s == '^') {
	*t++ = *s;
	continue;
      }
      o = find_cfg_opts(*s);
      if (o != NULL)
	*t++ = *s; /* silently remove invalid options */
    }
    *t = '\0';
  }
}

#if DEBUG
#define on_off(s)	(s == 1? "ON " : "OFF")
static void dump_rc_results()
{
     int i, j, len = 0;

     for (i = 0; i < NUMBER_OF_SAVEABLE_OPTIONS; i++) {
	 extern char *sort_name(), *alias_sort_name();

	 if (DT_SYN == save_info[i].dt_type ||
	     DT_MLT == save_info[i].dt_type ||
	     /* not dumping addresses to debug file */
	     DT_ALT == save_info[i].dt_type)
	     continue;

	 if (DT_WEE == save_info[i].dt_type) {

	     DPRINT(Debug,1,(&Debug, 
			     "\nAnd we're skipping the following headers:\n\t"));
	     
	     for (len = 8, j = 0; j < weedcount; j++) {
		 if (weedlist[j][0] == '*') continue;	/* skip '*end-of-defaults*' */
		 if (len + strlen(weedlist[j]) > 80) {
		     DPRINT(Debug,1,(&Debug,  " \n\t"));
		     len = 8;
		 }
		 DPRINT(Debug,1,(&Debug, "%s  ", weedlist[j]));
		 len += strlen(weedlist[j]) + 3;
	     }
	     DPRINT(Debug,1,(&Debug,  "\n\n"));
	     continue;	     
	 }
	 

	 {   /* Not very effective */
	     FILE * X = debug_to_FILE(&Debug);

	     if (X) {
		 save_info[i].dt_type->print_value(X,
						   & save_info[i],
						   0);
		 fclose(X);
	     }
	 }

     }
     DPRINT(Debug,1,(&Debug,  "\n\n"));
}
#endif

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
