static char rcsid[] = "@(#)$Id: savecopy.c,v 1.28 2001/06/09 14:29:42 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.28 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** Save a copy of the specified message in a folder.

**/

#include "headers.h"
#include "s_elm.h"

DEBUG_VAR(Debug,__FILE__,"mbox");

#include <errno.h>
#include "me.h"


char *error_description(), *ctime();

extern int errno;

static unsigned char * s2us P_((char *str));
static unsigned char * s2us(str)
     char *str;
{
    return (unsigned char *)str;
}

void zero_copy_file(cf)
     struct copy_file *cf;
{
    cf->copy_file = NULL;
    cf->dir       = NULL;
}

void clear_copy_file(cf)
     struct copy_file *cf;
{
    if (cf->copy_file)
	free_string(&(cf->copy_file));
    if (cf->dir)
	free_dir(&(cf->dir));
}

/*
 * save_copy() - Append a copy of the message contained in "filename" to
 * the file specified by "copy_file".  This routine simply gets all of
 * the filenames right, and then invokes "append_copy_to_file()" to do
 * the dirty work.
 */
int save_copy(headers, cf, form, mime_info, conv_file)
     struct mailing_headers * headers; 
     struct copy_file *cf;
     int form;
     mime_send_t *mime_info;
     FILE * conv_file;
{
    int
	is_ordinary_file;
    int flags = 0;
    int is_sent_mail = 0;
    int is_current_folder = 0;
    WRITE_STATE           write_ptr = NULL;
    int ra, rb;
    int reopen_current = 0;

    if (!cf->copy_file)
	return 0;                /* Selected NONE */

    if (cf->dir)
	flags = give_dir_flags(cf->dir);
    else
	cf->dir = new_browser(selection_folder);

    if (!flags) {
	int s_len=string_len(cf->copy_file);

	if (s_len < 1)
	    return 0;          /* Selected NONE */

	switch (give_unicode_from_string(cf->copy_file,0)) {
        case 0x003D:  /* '='  Handle save copy prompt! */
            if (1 == s_len /* "=" Unconditionally save by name */ 
		|| 
		/* Conditionally save by name name */
		(2 == s_len &&
		 give_unicode_from_string(cf->copy_file,1) 
		 == 0x003F /* '?' */)) {
		if (headers->to.addrs_len > 0) {
		    char buffer[LONG_STRING];
		    struct string *S1 = NULL;
		    int r;

		    /* determine 'to' login */
		    get_return_name(headers->to.addrs[0].addr, 
				    buffer, TRUE,  sizeof buffer);  	

		    if (!buffer[0])
			goto use_sent_mail;
		    
		    S1 = format_string(FRM("=%s"),buffer);
		
		    r = select_dir_item(cf->dir,&S1);
		    free_string(&S1);
		    
		    if (!r)
			goto use_sent_mail;      /* Selection failed! */


		    flags = give_dir_flags(cf->dir);

		    if (2 == s_len &&
			give_unicode_from_string(cf->copy_file,1) 
			== 0x003F /* '?' */ &&
			0 == (BROWSER_EXIST  & flags)) {

			DPRINT(Debug,5,(&Debug, 
					"Conditional save by name: file doesn't exist - using \"<\".\n"));
			goto use_sent_mail2;
		    }


		} else {
		use_sent_mail:
		    
		    lib_error(CATGETS(elm_msg_cat, ElmSet, 
				      ElmCannotDetermineToName,
				      "Cannot determine `to' name to save by! Saving to \"sent\" folder %s instead."),
			      sent_mail);

		    is_sent_mail++;
		}
	    }
	}
    }

    if (is_sent_mail) {
	int r;
    use_sent_mail2:
	/* If we come here via gtoto label, increment is_sent_mail */
	
	if (!is_sent_mail)
	    is_sent_mail++;
	
	
	if (cf->copy_file)
	    free_string(&(cf->copy_file));
	
	cf->copy_file = new_string(system_charset);
	add_ascii_to_string(cf->copy_file,s2us("<"));
	
	r = select_dir_item(cf->dir,&(cf->copy_file));
	    
	if (!r) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotSaveTo,
			      "Cannot save to %s!"), sent_mail);
	    sleep_message();
	    return 0;
	}		
    }

    flags = give_dir_flags(cf->dir);

    if (!flags) {   /* No selection so try it */	
	if (!select_dir_item(cf->dir,&(cf->copy_file))) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotSaveToSavingInstead,
			      "Cannot save to %S! Saving to \"sent\" folder %s instead."), 
		      cf->copy_file,sent_mail);
	    sleep_message();
	    if (is_sent_mail)
		panic("FILE PANIC",__FILE__,__LINE__,"save copy",
		      "sent mail panic",0);		    
	    goto use_sent_mail2;
	}
	flags = give_dir_flags(cf->dir);
    }

    if (cf->copy_file)
	DPRINT(Debug,8,(&Debug, 
			"*** %S have flags:%s%s%s%s%s%s%s\n",
			cf->copy_file,
			flags & BROWSER_NODIR    ?   " NODIR":    "",
			flags & BROWSER_NOFOLDER ?   " NOFOLDER": "",
			flags & BROWSER_MARKED   ?   " MARKED":   "",
			
			flags & BROWSER_MAILFILE ?   " MAILFILE": "",
			flags & BROWSER_SELECTED ?   " SELECTED": "",
			flags & BROWSER_EXIST    ?   " EXIST"   : "",
			!flags                   ?   " none"    : ""));
	       
    /*
     *  Allow options
     *  confirm_files, confirm_folders,
     *  confirm_append and confirm_create
     *  to control where the actual copy
     *  should be saved.
     */
    is_ordinary_file = 0 == (flags & BROWSER_MAILFILE);

    /* Replace editing buffer with expanded version ... */
    if (cf->copy_file)
	free_string(&(cf->copy_file));
    cf->copy_file = selection_name_dir(cf->dir);

    if (current_folder)
	is_current_folder = selection_is_folder(cf->dir,current_folder);

    if (is_sent_mail) {
	if ((flags & BROWSER_EXIST) == 0) {
	    /* Create it now ... */
            if (!create_selection_dir(cf->dir))
		return 0;
	}	    
    } else if ((flags & BROWSER_EXIST) != 0) {	/* already there!! */
	if (confirm_append || (confirm_files && is_ordinary_file)) {
	    /*
	     *  OK in batch mode it may be impossible
	     *  to ask the user to confirm. So we have
	     *  to use sent_mail anyway.
	     */
	    if (batch_only) 
		goto use_sent_mail2;
	    else {
		char * msg_buffer = NULL;
		char   answer;

		if (is_ordinary_file)
		    msg_buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						     ElmConfirmFilesAppend,
						     "Append to an existing file `%S'? (%c/%c) "),
					     cf->copy_file, 
					     *def_ans_yes, *def_ans_no);
		else
		    msg_buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						     ElmConfirmFolderAppend,
						     "Append to mail folder `%s'? (%c/%c) "),
					     cf->copy_file, 
					     *def_ans_yes, *def_ans_no);
		
		answer = want_to(msg_buffer, *def_ans_no, elm_LINES-2, 1);
		free(msg_buffer);

		if (answer != *def_ans_yes) {		   
		    PutLineX (elm_LINES-2, 0, CATGETS(elm_msg_cat, 
							ElmSet, 
						      ElmSavingToInstead,
						      "Alright - saving to `%s' instead"),
			      sent_mail);
		    if (sleepmsg > 0)
			sleep(sleepmsg);
		    ClearLine (elm_LINES-2);
		    goto use_sent_mail2;
		}
	    }
	}
    }
    else {
	if (confirm_create || (confirm_folders && !is_ordinary_file)) {
	    /*
	     *  OK in batch mode it may be impossible
	     *  to ask the user to confirm. So we have
	     *  to use sent_mail anyway.
	     */
	    if (batch_only) 
		goto use_sent_mail2;	    
	    else {
		char * msg_buffer = NULL;
		char   answer;
		    
		if (is_ordinary_file)
		    msg_buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						     ElmConfirmFilesCreate,
						     "Create a new file `%S'? (%c/%c) "),
					     cf->copy_file, 
					     *def_ans_yes, *def_ans_no);
		else
		    msg_buffer = elm_message(CATGETS(elm_msg_cat, ElmSet, 
						     ElmConfirmFolderCreate,
						     "Create a new mail folder `%S'? (%c/%c) "),
					     cf->copy_file, 
					     *def_ans_yes, *def_ans_no);
		
		answer = want_to(msg_buffer, *def_ans_no, elm_LINES-2, 1);
		free(msg_buffer);
	      
		if (answer != *def_ans_yes) {	       
		    PutLineX (elm_LINES-2, 0, 
			      CATGETS(elm_msg_cat, 
				      ElmSet, 
				      ElmSavingToInstead,
				      "Alright - saving to `%s' instead"),
			      sent_mail);
		    if (sleepmsg > 0)
			sleep(sleepmsg);
		    ClearLine (elm_LINES-2);
		    goto use_sent_mail2;
		}
	    }
	}
	/* Create it now ... */
	if (!create_selection_dir(cf->dir)) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmCannotSaveToSavingInstead,
			      "Cannot save to %S! Saving to \"sent\" folder %s instead."), 
		      cf->copy_file,sent_mail);
	    sleep_message();
	    goto use_sent_mail2;
	}
    }
    
    if (is_current_folder) {
	int M = get_folder_mode(current_folder);

	DPRINT(Debug,1,(&Debug,  "*** Current folder is save copy folder!\n"));

	if (0 != (M & FOLDER_FILE)) {
	    DPRINT(Debug,3,(&Debug,  "--> Need close current folder...\n"));
	
	    /* current_folder is same than save copy folder, 
	       we need close current_folder so that locking does not
	       cause problems
		   
	       Two problems:
	       - Possible locking on prepare_write_folder()
	         may fail on some situations
		   
	       - Unlocking on end_write_folder() may cause
	         that lock of new_folder is lost!
		   
	    */
		
	    close_folder(current_folder,CLOSE_NORMAL);
	    reopen_current = 1;
	}
    }

    if (!prepare_write_folder(cf->dir,&write_ptr)) {
	if (!is_sent_mail) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmCannotSaveToSavingInstead,
			      "Cannot save to %S! Saving to \"sent\" folder %s instead."), 
		      cf->copy_file,sent_mail);
	    sleep_message();
	    goto use_sent_mail2;
	}
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotSaveTo,
			  "Cannot save to %s!"), 
		  sent_mail);
	sleep_message();
	return 0;
    }
    
    ra = append_copy_to_file(headers, cf->dir, form,
			     mime_info,conv_file,write_ptr);

    rb = end_write_folder(cf->dir,&write_ptr);
    
    if (reopen_current) {
       	DPRINT(Debug,3,(&Debug,  "--> Reopeing current folder...\n"));

	if (!sessionlock_folder(current_folder,SESSIONLOCK_NORMAL)) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmFailedReopenFolder,
			      "Failed to reopen %S folder"),
		      current_folder->cur_folder_disp);
	}
    }

    if (!rb || ra < 0) {
	if (!is_sent_mail) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, 
			      ElmCannotSaveToSavingInstead,
			      "Cannot save to %S! Saving to \"sent\" folder %s instead."), 
		      cf->copy_file,sent_mail);
	    sleep_message();
	    goto use_sent_mail2;
	}
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotSaveTo,
			  "Cannot save to %s!"), 
		  sent_mail);
	return 0;
    }
    return 1;
}

int name_copy_file(cf)
     struct copy_file *cf;
{
    /** Prompt user for name of file for saving copy of outbound msg to.
	Return true if we need a redraw. **/

    int redraw = 0;	/* set when we ask for help = need redraw */

    if (!cf->dir)
	cf->dir = new_browser(selection_folder);

    gen_browser(cf->dir, &(cf->copy_file),
		&redraw,word_save_copy,NULL,
		CATGETS(elm_msg_cat, ElmSet, ElmSaveCopyInPrompt,
			"Save copy in (use '?' for help): "));
    
    return redraw;
}

int append_copy_to_file(headers, dir,  form, mime_info, conv_file,dest)
     struct mailing_headers * headers; 
     struct folder_browser *dir;
     int form;
     mime_send_t *mime_info;
     FILE * conv_file;
     WRITE_STATE dest; 

{
    int err = 0;
    struct header_rec  X;
    FILE *fp_copy;
    int env_flag;

    char * fname_copy = elm_message(FRM("%selmcopy-%d"),
                        temp_dir, getpid ());
    out_state_t buffer;
    charset_t charset_vector[2];
    
    /* Needed by STATE_out_dir */
    charset_vector[0] = RAW_BUFFER;
    charset_vector[1] = NULL;

    header_zero(&X);
    strfcpy(X.env_from,username,sizeof X.env_from);

    fp_copy = write_header_info(fname_copy, headers, (form == YES), TRUE,
				mime_info);
    if (fp_copy == NULL) {
	free (fname_copy);
	header_clear(&X);
	return -1;
    }
    unlink (fname_copy);
    X.mime_rec.offset = ftell(fp_copy);

    rewind(conv_file);
    /* dump the contents of the message to the end of the copy file */
    if (!copy_message_across(mime_info,fp_copy, TRUE, conv_file)) {
	fclose(fp_copy);
	free (fname_copy);
	header_clear(&X);
	return -1;	
    }
    X.content_length = ftell(fp_copy) - X.mime_rec.offset;

    rewind(fp_copy);

    out_state_clear(&buffer,STATE_out_dir);
    buffer.display_charset = charset_vector;
    set_out_state_dir(dir,dest,&buffer);

    if (!write_envelope_start(dir,dest,1,&X,&env_flag)) {
	err = -1;
	goto fail;
    }

    if (!copy_message_2(fp_copy,&X, "",&buffer,0,env_flag))
	err = -1;

    if (!write_envelope_end(dir,dest,1,&X)) 
	err = -1;
    
 fail:
    free (fname_copy);
    header_clear(&X);

    out_state_destroy(&buffer);

    if (EOF == fclose(fp_copy))
	err = -1;

    return err;
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
