static char rcsid[] = "@(#)$Id: showmsg.c,v 1.17 2001/06/09 14:29:42 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.17 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 * 			Copyright (c) 1988-1992 USENET Community Trust
 * 			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** This file contains all the routines needed to display the specified
    message.
**/

#include "headers.h"
#include <errno.h>
#include "s_elm.h"
#include "me.h"

DEBUG_VAR(Debug,__FILE__,"ui");

extern int errno;

int pipe_abort = FALSE; /* not used anymore, but won't compile without it */

static int need_meta (hdr)
     struct header_rec *hdr;
{
    /* Determine whether or not we need to call metamail to display the
     * message contents.
     */
    int result = 0;

    if ((hdr->status & (MIME_MESSAGE)) && (hdr->status & MIME_UNSUPPORTED))
	result = TRUE;
    /* Do not call metamail if Disposition is not inline */
    else if ((hdr->status & MIME_MESSAGE) && 
	     hdr->mime_rec.disposition != DISP_INLINE)
	result = FALSE;  
    else if (hdr->status & (MIME_MESSAGE | PRE_MIME_CONTENT))
	result = hdr->mime_rec.notplain;

    DPRINT(Debug,9,(&Debug, "need_meta=%d\n",result));
    return result;
}

int show_msg(number)
     int number;
{
	/*** Display number'th message.  Get starting and ending lines
	     of message from headers data structure, then fly through
	     the file, displaying only those lines that are between the
	     two!

	     Return 0 to return to the index screen or a character entered
	     by the user to initiate a command without returning to
	     the index screen (to be processed via process_showmsg_cmd()).
	***/

	struct header_rec *current_header = headers[number-1];
	DPRINT(Debug,4,(&Debug, 
			"displaying %d lines from message %d using %s\n", 
			current_header->lines, number, pager));

	if (!current_folder)
	  return 0;

	if (number > message_count || number < 1)
	  return(0);

	if(ison(current_header->status, NEW)) {
	  clearit(current_header->status, NEW);   /* it's been read now! */
	  current_header->status_chgd = TRUE;
	}
	if(ison(current_header->status, UNREAD)) {
	  clearit(current_header->status, UNREAD);   /* it's been read now! */
	  current_header->status_chgd = TRUE;
	}

	/* May need recheck: (Because now defination is recursive) */
	if ((current_header->status & MIME_MESSAGE) && 
	    current_header->mime_rec.notplain) {
	    FILE * ZZ = folder_to_fd(current_folder,-1L);
	    if (ZZ)
		attach_parse(current_header,ZZ);
	}

        if (need_meta(current_header) && have_metamail()) {
		char fname[STRING], Cmd[SLEN];
		int err;
		FILE *fpout;

		elm_sfprintf(fname, sizeof fname,
			     FRM("%semm.%d.%d"), temp_dir, getpid(), getuid());

		if ((fpout = safeopen_rdwr(fname)) == NULL) {
		    err = errno;
		    DPRINT(Debug,1,(&Debug, 
				    "Error: open of temporary file %s, errno %s (show_message)\n",
				    fname, error_description(err)));
		  lib_error(CATGETS(elm_msg_cat, ElmSet, 
				    ElmCantOpenAsOutputFile,
				    "Can't open \"%s\" as output file! (%s)."),
			    fname, error_description(err));
		  return(0);
		}
		/* Let metamail decode it! 
		 * (Now CM_DECODE also decodes MIME and PGP) -KEH
		 */
		if (!copy_message(current_folder,current_header,
				  "", fpout, 0)) {
		    /* FAIL */
		    fclose (fpout);
		    unlink (fname);
		    return 0;
		}
		(void) fclose (fpout);
		elm_sfprintf(Cmd, sizeof Cmd,
			     FRM("%s -p -z -m Elm %s"), 
			     metamail_path, fname);
		Raw(OFF);
		ClearScreen();
		printf ("Executing metamail...\n");
		system_call(Cmd, SY_ENAB_SIGINT|SY_ENV_METAMAIL);
		Raw(ON | NO_TITE);	/* Raw on but don't switch screen */
		(void) unlink (fname);
		PutLineX(elm_LINES,0, 
			 CATGETS(elm_msg_cat, ElmSet, 
				 ElmPressAnyKeyIndex,
				 "Press any key to return to index."));
		(void) ReadCh(0);
		printf("\r\n");
		Raw(OFF | NO_TITE); /* Raw off so raw on takes effect */
		Raw(ON); /* Finally raw on and switch screen */
		return(0);
	} else {
	    FILE * ZZ = folder_to_fd(current_folder,
				     current_header->offset);
	    
	    return (metapager (ZZ, current_header, TRUE));
	}
}


/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */

