static char rcsid[] = "@(#)$Id: syscall.c,v 1.18 2001/06/09 15:34:29 hurtta Exp $";

/******************************************************************************
 *  The Elm (ME+) Mail System  -  $Revision: 1.18 $   $State: Exp $
 *
 *  Modified by: Kari Hurtta <hurtta+elm@ozone.FMI.FI>
 ******************************************************************************
 *  The Elm Mail System 
 *
 *			Copyright (c) 1988-1992 USENET Community Trust
 *			Copyright (c) 1986,1987 Dave Taylor
 *****************************************************************************/

/** These routines are used for user-level system calls, including the
    '!' command and the '|' commands...

**/

#include "headers.h"
#include "s_elm.h"
#include "me.h"
#include "s_me.h"

DEBUG_VAR(Debug,__FILE__,"misc");

#include <errno.h>

#ifndef I_UNISTD
void _exit();
#endif

#ifdef ALLOW_SUBSHELL

int subshell()
{
	/** spawn a subshell with either the specified command
	    returns non-zero if screen rewrite needed
	**/

	char command[SLEN];
	int redraw = FALSE;
	int  old_raw, helpful, ret, status;

	helpful = (user_level == 0);

	if (helpful)
	  PutLineX(elm_LINES-3, elm_COLUMNS-40, 
		   CATGETS(elm_msg_cat, ElmSet, 
			   ElmUseShellName,
			   "(Use the shell name for a shell.)"));
	PutLineX(elm_LINES-2, 0, 
		 CATGETS(elm_msg_cat, ElmSet, ElmShellCommand,
			 "Shell command: "));
	CleartoEOS();
	command[0] = '\0';
	status = optionally_enter(command, elm_LINES-2, 15, OE_REDRAW_MARK,
				  sizeof command);

	while (REDRAW_MARK == status) {
	  redraw = TRUE;
	  PutLineX(elm_LINES-2, 0, 
		   CATGETS(elm_msg_cat, ElmSet, ElmShellCommand,
			   "Shell command: "));
	  status = optionally_enter(command, elm_LINES-2, 15, 
				    OE_REDRAW_MARK|OE_APPEND_CURRENT,
				    sizeof command);

	}
	if (0 != status && command[0] == 0) {
	  if (helpful)
	    MoveCursor(elm_LINES-3,elm_COLUMNS-40);
	  else
	    MoveCursor(elm_LINES-2,0);
	  CleartoEOS();
	  return redraw;
	}

	MoveCursor(elm_LINES,0);
	CleartoEOLN();

	if ((old_raw = RawState()) == ON)
	  Raw(OFF);
	/* softkeys_off(); */

	umask(original_umask);	/* restore original umask so users new files are ok */
	ret = system_call(command, SY_USER_SHELL|SY_ENAB_SIGINT|SY_DUMPSTATE);
	umask(077);		/* now put it back to private for mail files */

redraw2:

	PutLineX(elm_LINES, 0, CATGETS(elm_msg_cat, ElmSet, 
				       ElmPressAnyKeyToReturn,
				       "\n\nPress any key to return to ELM: "));
	Raw(ON | NO_TITE);
	if (ReadCh(REDRAW_MARK) == REDRAW_MARK) {
	    Raw(OFF | NO_TITE);
	    goto redraw2;
	}
	printf("\r\n");
	Raw(OFF | NO_TITE); /* Done even if old_raw == ON, to get ti/te right */
	if (old_raw == ON)
	  Raw(ON);

	/* softkeys_on(); */

	if (ret)
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmReturnCodeWas,
			    "Return code was %d."), 
		    ret);

	return 1;
}

#endif /* ALLOW_SUBSHELL */


	/** The following might be encoded into the "options" parameter:

	    SY_USER_SHELL	When set, we will use the user-defined
				"shell" instead of "/bin/sh" for the
				shell escape.

	    SY_ENV_SHELL	When set, put "SHELL=[name-of-shell]" in
				the child's environment.  This hack makes
				mail transport programs work right even
				for users with restricted shells.

	    SY_ENAB_SIGHUP	When set, we will set SIGHUP, SIGTSTP, and
				SIGCONT to their default behaviour during
				the shell escape rather than ignoring them.
				This is particularly important with stuff
				like `vi' so it can preserve the session on
				a SIGHUP and do its thing with job control.

	    SY_ENAB_SIGINT	This option implies SY_ENAB_SIGHUP.  In
				addition to the signals listed above, this
				option will also set SIGINT and SIGQUIT
				to their default behaviour rather than
				ignoring them.

	    SY_DUMPSTATE	Create a state file for use by the "readmsg"
				program.  This is so that if "readmsg" is
				invoked it can figure out what folder we are
				in and what message(s) are selected.

	    SY_ENV_METAMAIL	When set, put "MM_CHARSET=[display_charset]"
	                        to environ.

	**/


int system_call(string, options)
     char *string;
     VOLATILE int options;
{
    /** execute 'string', setting uid to userid... **/
    
    int pfd[2], stat, w;
    int pid = -1;
    VOLATILE int iteration;
    /* figure out what shell we are using here */
    S__ status;
    register SIGHAND_TYPE (*istat)(), (*qstat)(), (*wstat)();
#ifdef SIGTSTP
    register SIGHAND_TYPE (*oldstop)(), (*oldstart)();
#endif
    extern int errno;
    
    /* flush any pending output */
    FlushBuffer();
    
    DPRINT(Debug,2, (&Debug,  
		     "System Call: command=%s\n", string));
    if (options & SY_USER_SHELL) {
	DPRINT(Debug,2, (&Debug,  
			 "  Using user's shell=%s\n", shell));
    }
    
    /* if we aren't reading a folder then a state dump is meaningless */
    if (mail_only)
	options &= ~SY_DUMPSTATE;

  /* see if we need to dump out the folder state */
  if (options & SY_DUMPSTATE) {
      if (create_folder_state_file() != 0)
	  return -1;
  }

  /*
   * Note the neat trick with close-on-exec pipes.
   * If the child's exec() succeeds, then the pipe read returns zero.
   * Otherwise, it returns the zero byte written by the child
   * after the exec() is attempted.  This is the cleanest way I know
   * to discover whether an exec() failed.   --CHS
   */

  if (pipe(pfd) == -1) {
      perror("pipe");
      return -1;
  }
  fcntl(pfd[0], F_SETFD, 1);
  fcntl(pfd[1], F_SETFD, 1);
  
  istat = signal(SIGINT, SIG_IGN);
  qstat = signal(SIGQUIT, SIG_IGN);
#ifdef SIGWINCH
  wstat = signal(SIGWINCH, SIG_DFL);
#endif
#ifdef SIGTSTP
  oldstop = signal(SIGTSTP, SIG_DFL);
  oldstart = signal(SIGCONT, SIG_DFL);
#endif

	stat = -1;		/* Assume failure. */

	for (iteration = 0; iteration < 5; ++iteration) {
	  if (iteration > 0)
	    sleep(2);

#ifdef VFORK
	  if (options&SY_ENV_SHELL || options&SY_ENV_METAMAIL)
	    pid = fork();
	  else
	    pid = vfork();
#else
	  pid = fork();
#endif

	  if (pid != -1)
	    break;
	}

	if (pid == -1) {
	  perror("fork");
	  close(pfd[0]);
	  close(pfd[1]);
	}
	else if (pid == 0) {
	    CONST char *sh = ((options & SY_USER_SHELL) ? shell : "/bin/sh");

	    /*
	     * Set group and user back to their original values.
	     * Note that group must be set first.
	     */
	    if (-1 == setgid(groupid)) {
		int err = errno;
		fprintf(stderr,"system_call: setgid(%d) FAILED: %s\n",
			groupid,error_description(err));
		fflush(stderr);
		write(pfd[1], "", 1);
		_exit(127);
	    }
	    if (-1 == setuid(userid)) {
		int err = errno;
		fprintf(stderr,"system_call: setuid(%d) FAILED: %s\n",
			setuid,error_description(err));
		fflush(stderr);
		write(pfd[1], "", 1);
		_exit(127);
	    }
	    
	    set_child_signals(options);
	    
	    set_child_env(options);
	  
	    /* Go for it. */
	    if (string) execl(sh, argv_zero(sh), "-c", string, (char *) 0);
	    else execl(sh, argv_zero(sh), (char *) 0);

	    /* If exec fails, we write a byte to the pipe before exiting. */
	    perror(sh);
	    write(pfd[1], "", 1);
	    _exit(127);
	}
	else {
	  int rd;
	  char ch;

	  /* Try to read a byte from the pipe. */
	  close(pfd[1]);
	  rd = read(pfd[0], &ch, 1);
	  close(pfd[0]);

	  while ((w = my_wait(pid,&status)) != pid)
	      if (w == -1 && errno != EINTR)
		  break;

	  /* If we read a byte from the pipe, the exec failed. */
	  if (rd > 0)
	    stat = -1;
	  else if (w == pid) {
	    int sig = convert_status(status,&stat);
	    if (sig)
	      stat = -1;
	  }
  	}
  
	(void) signal(SIGINT, istat);
	(void) signal(SIGQUIT, qstat);
#ifdef SIGWINCH
	(void) signal(SIGWINCH, wstat);
#endif
#ifdef SIGTSTP
	(void) signal(SIGTSTP, oldstop);
	(void) signal(SIGCONT, oldstart);
#endif

	/* cleanup any folder state file we made */
	if (options & SY_DUMPSTATE)
	    (void) remove_folder_state_file();

	return(stat);
}

int do_pipe()
{
	/** pipe the current message or tagged messages to
	    the specified sequence.. **/

	char command[SLEN], buffer[SLEN], *prompt;
	register int  ret;
	int	old_raw;
	int redraw = FALSE;
	int status;

	/* TODO: Fix this mess ... */
	prompt = catgets(elm_msg_cat, ElmSet, ElmPipeTo, "Pipe to: ");
        PutLine0(elm_LINES-2, 0, prompt);
	command[0] = '\0';
	status = optionally_enter(command, elm_LINES-2, strlen(prompt), 
				  OE_REDRAW_MARK, sizeof command);
	while (status == REDRAW_MARK) {
	  redraw = TRUE;
	  PutLine0(elm_LINES-2, 0, prompt);
	  status = optionally_enter(command, elm_LINES-2, strlen(prompt), 
				    OE_REDRAW_MARK|OE_APPEND_CURRENT,
				    sizeof command);

	}
	if (0 != status || command[0] == '\0') {
	  MoveCursor(elm_LINES-2,0);
	  CleartoEOLN();
	  return(redraw);
	}

	MoveCursor(elm_LINES,0);
	CleartoEOLN();
	if (( old_raw = RawState()) == ON)
	  Raw(OFF);

	sprintf(buffer, "%s -Ih|%s", readmsg, command);
	ret = system_call(buffer, SY_USER_SHELL|SY_ENAB_SIGINT|SY_DUMPSTATE);

redraw2:
	SetXYLocation(0, 40);	/* a location not near the next request, so an absolute is used */
	PutLineX(elm_LINES, 0, 
		 CATGETS(elm_msg_cat, ElmSet, 
			 ElmPressAnyKeyToReturn,
			 "\n\nPress any key to return to ELM: "));

	Raw(ON | NO_TITE);
	if (ReadCh(REDRAW_MARK) == REDRAW_MARK) {
	  Raw(OFF | NO_TITE);
	  goto redraw2;
	}
	printf("\r\n");
	Raw(OFF | NO_TITE); /* Done even if old_raw == ON, to get ti/te right */
	if (old_raw == ON)
	  Raw(ON);

	if (ret != 0)
	  lib_error(CATGETS(elm_msg_cat, ElmSet, ElmReturnCodeWas,
			    "Return code was %d."), 
		    ret);
	return(1);
}

int have_printout() {
    int return_value = 1;
  
    if (strcmp(printout,"none") == 0 || 
	printout[0] == '\0') {
	return_value = 0;
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPrintDontKnowHow,
			  "Don't know how to print - option \"print\" undefined!"));
    }
    else if (printout[0] == '/') {
	char *test = safe_strdup(printout),*ptr;
	
	if (NULL != (ptr = strpbrk(test," \t;|")))
	    *ptr = '\0';
	
	DPRINT(Debug,5, (&Debug, 
			 "have_printout(%s) -- test=%s\n",
			 printout,test));
	
	if (-1 == access(test,EXECUTE_ACCESS)) {
	    int err = errno;
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPrintCantExecute,
			      "Can't execute \"print\": %.50s: %.30s"),
		      test, error_description(err));
	    
	    DPRINT(Debug,5, (&Debug, 
			     "have_printout: no access %s: %s\n",test,
			     error_description(err)));
	    sleep_message();
	    return_value = 0;
	}
	free(test);

    }

    DPRINT(Debug,5, (&Debug, 
		     "have_printout=%d\n",
		     return_value));
    return return_value;
}

int print_text(pause_on_scroll)
     int pause_on_scroll;
{
    int	tagged = 0, i, old_raw;
    int redraw_it = 0;
    char *fname = NULL;
    char * cmd = NULL;
    FILE * tmpfp = NULL;
    int nlines = 0;
    char buffer[STRING];
    int retcode = -1;
    int res = 0;
    struct run_state RS;
    char * argv[4];

    /*
     * Make sure we know how to print.
     */
    if (!have_printout())
	return 0;

    fname = elm_message(FRM("%sprintdecode-%d"),
                        temp_dir, getpid ());

    if (NULL == (tmpfp = safeopen_rdwr(fname))) {
	lib_error(CATGETS(elm_msg_cat, MeSet, MeDecodeFailedCreate,
			  "Failed to create file for decoding."));
	goto clean;
    }

    for (i=0; i < message_count; i++) {
	if (ison(headers[i]->status, TAGGED)) {
	    tagged++;
	}
    }

    if (tagged == 0) {
	tagged = 1;
	setit(headers[current-1]->status, TAGGED);	
    }

    for (i=0; i < message_count; i++) 	/* save each tagged msg */
	if (headers[i]->status & TAGGED) {	      
	    if (!copy_message(current_folder,headers[i],
			      "", tmpfp, 
			      CM_DECODE | CM_FILT_HDR | CM_REMOVE_ENVELOPE)) {
		/* FAIL */
		fclose(tmpfp);
		goto clean_1;
	    }
	    /* Need redraw -- PGP output ?*/
	    if (raw_off_called()) {
		redraw_it = TRUE;
	    }
	    clearit(headers[i]->status, TAGGED);  /* not tagged anymore */

	    if (!redraw_it && pause_on_scroll)
		show_new_status(i);	/* update screen, if needed */
	}
    if (EOF == fclose(tmpfp))
	goto clean_1;

    /*
     * Setup print command.  Select old or new behavior based
     * upon the presence of "%s" in the print command string.
     */
    if (in_string(printout, "%s")) {
	cmd = elm_message(FRM(printout), fname);
    } else {
	cmd = elm_message(FRM("(%s) < %s"),printout,fname);
    }
    
    argv[0] = "/bin/sh";
    argv[1] = "-c";
    argv[2] = cmd;
    argv[3] = NULL;

    /*
     * Put keyboard into normal state.
     */

    if ((old_raw = RawState()) == ON) {
	/* SY_NOTTY causes that run_state does not reposition cursor ... */
	MoveCursor(elm_LINES-2,0); CleartoEOS();
	Raw(OFF | NO_TITE);
    }
    /* softkeys_off(); */
    
    /*
     * Run the print command in a pipe and grab the output.
     */
    
    res = start_run(&RS,
		    SY_ENAB_SIGHUP|SY_ENAB_SIGINT|
		    SY_RUN_STATE_OPIPE|SY_RUN_STATE_EPIPE|
		    SY_NOTTY, 
		    argv,-1,-1);
    if (0 == res) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPrintPipeFailed,
			  "Cannot create pipe to print command."));
	goto clean_2;
    }
redraw:
    while (fgets(buffer, sizeof(buffer), RS.pfd) != NULL) {
	fputs(buffer, stdout);
	++nlines;
    }
    DPRINT(Debug,4, (&Debug, "print_msg: nlines=%d\n", nlines));

    
    /*
     * See if there were enough lines printed to trash the screen.
     */
    if (pause_on_scroll && nlines > 1) {
	Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmPrintPressAKey,
				"\nPress any key to continue:"));
	FlushBuffer();
	Raw(ON | NO_TITE);
	if (ReadCh(REDRAW_MARK) == REDRAW_MARK) {
	    Raw(OFF | NO_TITE);
	    redraw_it = TRUE;
	    goto redraw;
	}
    }

    if (0 != (res = wait_end(&RS,&retcode))) {
	/*
	 * Display a status message.
	 */
	Raw(old_raw | NO_TITE);
	if (res > 0) {                  /* ret < 0 is signal ... */
	    if (retcode == 0) {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPrintJobSpooled,
				  "Print job has been spooled."));
	    } else {
		lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPrintFailStatus,
				  "Printout failed with status 0x%04x."), 
			  (retcode));
	    }
	}
    } else
	Raw(old_raw | NO_TITE);

    /*
     * Hack alert:  The only place we use "pause_on_scroll" false is when
     * printing while reading a mail message.  This newline prevents the
     * above message from being wiped out by the command prompt.
     */
    if (!pause_on_scroll)
	putchar('\n');

    if (nlines> 1)
	redraw_it = 1;

 clean_2:
    free(cmd);

 clean_1:
    unlink(fname);

 clean:
    if (fname)
	free(fname);
    return redraw_it;
}



int print_msg(pause_on_scroll)
     int pause_on_scroll;
{
	/*
	 * Print the tagged messages, or the current message if none are
	 * tagged.  Message(s) are passed passed into the command specified
	 * by "printout".  An error is given if "printout" is undefined.
	 *
	 * Printing will be done through a pipe so we can print the number
	 * of lines output.  This is used to determine whether the screen
	 * got trashed by the print command.  One limitation is that only
	 * stdout lines are counted, not stderr output.  A nonzero result
	 * is returned if we think enough output was generated to trash
	 * the display, a zero result indicates the display is probably
	 * alright.  Further, if the display is trashed and "pause_on_scroll"
	 * is true then we'll give a "hit any key" prompt before returning.
	 *
	 * This routine has two modes of behavior, depending upon whether
	 * there is a "%s" embedded in the "printout" string.  If there,
	 * the old Elm behavior is used (a temp file is used, all output
	 * from the print command is chucked out).  If there isn't a "%s"
	 * then the new behavior is used (message(s) piped right into
	 * print command, output is left attached to the terminal).
	 *
	 * The old behaviour is bizarre.  I hope we can ditch it someday.
	 */

	char buffer[STRING];
	int  nlines, retcode, old_raw;
	char * filename = NULL;
	int res = 0;
	struct run_state RS;
	char * argv[4];

	DPRINT(Debug,4, (&Debug,  
			 "print_msg: pause_on_scroll=%d\n",
			 pause_on_scroll));

	argv[0] = "/bin/sh";
	argv[1] = "-c";
	argv[2] = buffer;
	argv[3] = NULL;

	/*
	 * Make sure we know how to print.
	 */
	if (!have_printout())
	  return 0;

	/*
	 * Setup print command.  Select old or new behavior based
	 * upon the presence of "%s" in the print command string.
	 */
	if (in_string(printout, "%s")) {
	    char * printbuffer;
	    /*
	     * Temp file name used by "old style" printing.
	     */
	    filename = elm_message(FRM("%s%s%d"), 
				   temp_dir, temp_print, getpid());
	    
	    printbuffer = elm_message(FRM(printout), filename);
	    elm_sfprintf(buffer,sizeof buffer,
			 FRM("%s -Ip > %s; %s"),
			 readmsg, filename, printbuffer);
	    free(printbuffer);
	} else {
	  elm_sfprintf(buffer,sizeof buffer,
		       FRM("%s -Ip | %s"), readmsg, printout);
	}

        /*
         * Create information for "readmsg" command.
	 * -- start_run() does not support SY_DUMPSTATE	
         */
        if (create_folder_state_file() != 0)
            goto free_it;

	/*
	 * Put keyboard into normal state.
	 */

	if ((old_raw = RawState()) == ON) {
	    /* SY_NOTTY causes that run_state does not reposition cursor ... */
	    MoveCursor(elm_LINES-2,0); CleartoEOS();
	    Raw(OFF | NO_TITE);
	}
	/* softkeys_off(); */

	/*
	 * Run the print command in a pipe and grab the output.
	 */
	nlines = 0;

	res = start_run(&RS,
			SY_ENAB_SIGHUP|SY_ENAB_SIGINT|
			SY_RUN_STATE_OPIPE|SY_RUN_STATE_EPIPE|
			SY_NOTTY, 
			argv,-1,-1);
	if (0 == res) {
	    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPrintPipeFailed,
			      "Cannot create pipe to print command."));
	    goto done;
	}
redraw:
	while (fgets(buffer, sizeof(buffer), RS.pfd) != NULL) {
	    fputs(buffer, stdout);
	    ++nlines;
	}
	DPRINT(Debug,4, (&Debug,  
			 "print_msg: nlines=%d\n", nlines));


	/*
	 * See if there were enough lines printed to trash the screen.
	 */
	if (pause_on_scroll && nlines > 1) {
	    Write_to_screen(CATGETS(elm_msg_cat, ElmSet, ElmPrintPressAKey,
				    "\nPress any key to continue:"));
	    FlushBuffer();
	    Raw(ON | NO_TITE);
	    if (ReadCh(REDRAW_MARK) == REDRAW_MARK) {
		Raw(OFF | NO_TITE);
		nlines = 2;
		goto redraw;
	    }
	}

	if (0 != (res = wait_end(&RS,&retcode))) {
	    /*
	     * Display a status message.
	     */
	    Raw(old_raw | NO_TITE);
	    if (res > 0) {                  /* ret < 0 is signal ... */
		if (retcode == 0) {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPrintJobSpooled,
				      "Print job has been spooled."));
		} else {
		    lib_error(CATGETS(elm_msg_cat, ElmSet, ElmPrintFailStatus,
				      "Printout failed with status 0x%04x."), 
			      (retcode));
		}
	    }
	} else
	    Raw(old_raw | NO_TITE);

	/*
	 * Hack alert:  The only place we use "pause_on_scroll" false is when
	 * printing while reading a mail message.  This newline prevents the
	 * above message from being wiped out by the command prompt.
	 */
	if (!pause_on_scroll)
		putchar('\n');

done:
	/* softkeys_on(); */
	if (filename) {
	    (void) unlink(filename);
	    free(filename);
	}
	(void) remove_folder_state_file();
	res = nlines > 1;

 free_it:
	return res;
}

static char folder_state_env_param[SLEN], *folder_state_fname;

/*
 * Setup a folder state file for external utilities (e.g. "readmsg").
 * Returns zero if the file was created, -1 if an error occurred.  A
 * diagnostic will have been printed on an error return.
 *
 * The state file contains the following:
 *
 * - An "F" record with the pathname to the current folder.
 *
 * - An "N" record with a count of the number of messages in the folder.
 *
 * - A set of "I" records indicating the seek index of the messages
 *   in the folder.  The first "I" record will contain the seek index
 *   of message number one, and so on.  The "I" records will be in
 *   sorting order and not necessarily mbox order.  The number of "I"
 *   records will match the value indicated in the "N" record.
 *
 * - A "C" record with a count of the total number of messages selected.
 *
 * - A set of "S" records indicating message number(s) which have been
 *   selected.  If messages have been tagged then there will be one
 *   "S" record for each selected message.  If no messages have been
 *   tagged then either:  there will be a single "S" record with the
 *   current message number, or there will be no "S" records if the
 *   folder is empty.  The number of "S" records will match the value
 *   indicated in the "C" record.
 */
int create_folder_state_file()
{
    int count, i;
    FILE *fp;

    /* format an environ param with the state file and pick out file name */
    sprintf(folder_state_env_param, "%s=%s%s%d",
	FOLDER_STATE_ENV, default_temp, temp_state, getpid());
    folder_state_fname = folder_state_env_param + strlen(FOLDER_STATE_ENV) +1;


    /* open up the folder state file for writing */
    if ((fp = safeopen(folder_state_fname)) == NULL) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotCreateFolderState,
			  "Cannot create folder state file \"%s\"."), 
		  folder_state_fname);
	return -1;
    }

    /* write out the pathname of the folder */
    if (current_folder)
	write_folder_info(fp,current_folder);

    /* write out the folder size and message indices */
    fprintf(fp, "N%d\n", message_count);
    for (i = 0 ; i < message_count ; ++i)
	fprintf(fp, "I%ld\n", headers[i]->offset);

    /* count up the number of tagged messages */
    count = 0;
    for (i = 0 ; i < message_count ; i++)  {
	if (headers[i]->status & TAGGED)
		++count;
    }

    /* write out selected messages */
    if (count > 0) {
	/* we found tagged messages - write them out */
	fprintf(fp, "C%d\n", count);
	for (i = 0 ; i < message_count ; i++) {
	    if (headers[i]->status & TAGGED)
		fprintf(fp, "S%d\n", i+1);
	}
    } else if (current > 0) {
	/* no tagged messages - write out the selected message */
	fprintf(fp, "C1\nS%d\n", current);
    } else {
	/* hmmm...must be an empty mailbox */
	fprintf(fp, "C0\n");
    }

    /* file is done */
    (void) fclose(fp);

    /* put pointer to the file in the environment */
    if (putenv(folder_state_env_param) != 0) {
	lib_error(CATGETS(elm_msg_cat, ElmSet, ElmCannotCreateEnvParam,
			  "Cannot create environment parameter \"%s\"."), 
		  FOLDER_STATE_ENV);
	return -1;
    }

    return 0;
}


int remove_folder_state_file()
{
    /*
     * We simply leave the FOLDER_STATE_ENV environment variable set.
     * It's too much work trying to pull it out of the environment, and
     * the load_folder_state_file() does not mind if the environment
     * variable points to a non-existent file.
     */
    return unlink(folder_state_fname);
}

/*
 * Local Variables:
 *  mode:c
 *  c-basic-offset:4
 * End:
 */
