case $CONFIG in
'')
    if test ! -f config.sh; then
	ln ../config.sh . || \
	ln ../../config.sh . || \
	ln ../../../config.sh . || \
	(echo "Can't find config.sh."; exit 1)
    fi
    . ./config.sh
    ;;
esac
case "$0" in
*/*) cd `expr X$0 : 'X\(.*\)/'` ;;
esac

echo "Extracting utils/Makefile (with variable substitutions)"
cat >Makefile <<!GROK!THIS!

# @(#)$Id: Makefile.SH,v 1.17 2001/06/14 18:25:45 hurtta Exp $
#
#  Makefile for the Elm system utilities
#
#         (C) Copyright 1986,1987, by Dave Taylor
#         (C) Copyright 1988-1992, USENET Community Trust
# 
#
# Variables
#	Variables established by Configure
CC		=	$cc
CCFLAGS		=	$ccflags $xencf
CHMOD		=	$chmod
CP		=	$cp
DEST		=	$bin
ECHO		=	$echo
LFLAGS		=	$ldflags $dynamic_opt $xenlf
LIB		=	$lib
LIB2		= 	$dlopen_lib $libs
LIBS		=	$termlib $dbm
LINT		=	$lint
LN		=	$ln
MAKE		=	$make
MV		=	$mv
OPTIMIZE	=	$optimize
RM		= 	$rm -f
TOUCH		=	$touch
!GROK!THIS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'
SHLIST          = 	$(BIN)/answer-shared		\
			$(BIN)/elmalias-shared		\
			$(BIN)/fastmail-shared		\
			$(BIN)/frm-shared		\
			$(BIN)/newalias-shared		\
			$(BIN)/newmail-shared		\
			$(BIN)/readmsg-shared		\
			$(BIN)/prlong-shared		\
			$(BIN)/elmcharset-shared	\
			$(BIN)/elmterminal-shared	\
			$(BIN)/elmunidata-shared

!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'
SHLIST          =

!NO!SUBS!

fi

cat >>Makefile <<'!NO!SUBS!'
#	Other general variables
BIN		=	../bin
CFLAGS		=	-I$(INCLDIR) $(CCFLAGS) $(OPTIMIZE)
INCLDIR		=	../hdrs
LINTFLAGS	=	-I$(INCLDIR)
SHELL		=	/bin/sh

#	Lists
#		List of installed programs - excludes wnewmail and nfrm,
#		which are handled separately
INSTALL_LIST	=	$(DEST)/answer		\
			$(DEST)/checkalias	\
			$(DEST)/elmalias	\
			$(DEST)/fastmail	\
			$(DEST)/frm		\
			$(DEST)/listalias	\
			$(DEST)/messages	\
			$(DEST)/newalias	\
			$(DEST)/newmail		\
			$(DEST)/printmail	\
			$(DEST)/readmsg		\
			$(LIB)/prlong		\
			$(LIB)/elmcharset       \
			$(LIB)/elmterminal	\
			$(LIB)/elmunidata


#		List of programs in bin directory
BINARY_LIST	=	$(BIN)/answer		\
			$(BIN)/checkalias	\
			$(BIN)/elmalias		\
			$(BIN)/fastmail		\
			$(BIN)/frm		\
			$(BIN)/listalias	\
			$(BIN)/messages		\
			$(BIN)/newalias		\
			$(BIN)/newmail		\
			$(BIN)/printmail	\
			$(BIN)/readmsg		\
			$(BIN)/prlong		\
			$(BIN)/elmcharset       \
			$(BIN)/elmterminal      \
			$(BIN)/elmunidata       \
                        $(SHLIST)

#		List of programs to $(LINT) - only C programs
LINT_LIST	=	answer_lint	\
			elmalias_lint	\
			fastmail_lint	\
			frm_lint	\
			newalias_lint	\
			newmail_lint	\
			readmsg_lint	\
			prlong_lint

#	List of all object files in all util programs (used in parallel makes)
UTIL_OBJ	=	answer.o		\
			elmalias.o		\
			fastmail.o		\
			from.o			\
			newalias.o		\
			newmail.o		\
			readmsg.o		\
			prlong.o		\
			elmcharset.o            \
			elmterminal.o		\
			elmunidata.o

#	Lists of source and object files for each C program
ANSWER_SRC	=	answer.c
ANSWER_OBJ	=	answer.o
ELMALIAS_SRC	=	elmalias.c
ELMALIAS_OBJ	=	elmalias.o
FASTMAIL_SRC	=	fastmail.c
FASTMAIL_OBJ	=	fastmail.o
FRM_SRC		=	from.c
FRM_OBJ		=	from.o
NEWALIAS_SRC	=	newalias.c
NEWALIAS_OBJ	=	newalias.o
NEWMAIL_SRC	=	newmail.c
NEWMAIL_OBJ	=	newmail.o
PRLONG_SRC	=	prlong.c
PRLONG_OBJ	=	prlong.o
READMSG_SRC	=	readmsg.c
READMSG_OBJ	=	readmsg.o
ELMCHARSET_SRC  =       elmcharset.c
ELMCHARSET_OBJ  =       elmcharset.o
ELMTERMINAL_SRC  =      elmterminal.c
ELMTERMINAL_OBJ  =      elmterminal.o
ELMUNIDATA_SRC  =      elmunidata.c
ELMUNIDATA_OBJ  =      elmunidata.o


# Standard targets
all:			objects $(BINARY_LIST)

#	This unusual target enables highly efficial compilation of object files
#	on systems that have the parallel make feature.
objects:		$& $(UTIL_OBJ)

install:		$(INSTALL_LIST) $(DEST)/wnewmail $(DEST)/nfrm

uninstall:		
			$(RM) $(INSTALL_LIST) $(DEST)/wnewmail $(DEST)/nfrm

#	This rule allows us to put lint output for each program on the
#	same file, but make sure we start off fresh each time.
lint:			
			$(RM) LINT.OUT; $(MAKE) -$(MAKEFLAGS) $(LINT_LIST)

clean:			
			$(RM) $(UTIL_OBJ) $(BINARY_LIST)

# Dependencies and rules
#	Dependencies and rules for compiling and linting C programs
.PRECIOUS:		$(INCLDIR)/defs.h $(INCLDIR)/elm.h \
			$(INCLDIR)/headers.h ../lib/libutil.a

answer.o: $(INCLDIR)/elmutil.h $(INCLDIR)/ndbz.h $(INCLDIR)/s_answer.h $(INCLDIR)/sysdefs.h 
elmalias.o: $(INCLDIR)/elmutil.h $(INCLDIR)/ndbz.h $(INCLDIR)/s_elmalias.h
fastmail.o: $(INCLDIR)/elmutil.h $(INCLDIR)/s_fastmail.h
from.o: $(INCLDIR)/elmutil.h $(INCLDIR)/s_from.h $(INCLDIR)/s_elm.h 
newalias.o: $(INCLDIR)/elmutil.h $(INCLDIR)/s_newalias.h
newmail.o: $(INCLDIR)/elmutil.h $(INCLDIR)/s_newmail.h
prlong.o: $(INCLDIR)/elmutil.h $(INCLDIR)/defs.h
readmsg.o: $(INCLDIR)/elmutil.h $(INCLDIR)/s_readmsg.h
elmcharset.o: $(INCLDIR)/elmutil.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h
elmterminal.o: $(INCLDIR)/elmutil.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h 
elmunidata.o: $(INCLDIR)/elmutil.h $(INCLDIR)/s_me.h $(INCLDIR)/s_elm.h $(INCLDIR)/unidata.h

checkalias:		checkalias.SH	; sh $?
listalias:		listalias.SH	; sh $?
messages:		messages.SH	; sh $?
printmail:		printmail.SH	; sh $?

$(BIN)/answer:		$(ANSWER_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(ANSWER_OBJ) ../lib/libutil.a $(LIB2)

answer_lint:		$(ANSWER_SRC)
			$(LINT) $(LINTFLAGS) $(ANSWER_SRC) >> LINT.OUT

$(BIN)/elmalias:	$(ELMALIAS_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(ELMALIAS_OBJ) ../lib/libutil.a $(LIB2)

elmalias_lint:		$(ELMALIAS_SRC)
			$(LINT) $(LINTFLAGS) $(ELMALIAS_SRC) >> LINT.OUT

$(BIN)/fastmail:	$(FASTMAIL_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(FASTMAIL_OBJ) ../lib/libutil.a $(LIB2)

fastmail_lint:		$(FASTMAIL_SRC)
			$(LINT) $(LINTFLAGS) $(FASTMAIL_SRC) >> LINT.OUT

$(BIN)/frm:		$(FRM_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(FRM_OBJ) ../lib/libutil.a $(LIB2)

frm_lint:		$(FRM_SRC)
			$(LINT) $(LINTFLAGS) $(FRM_SRC) >> LINT.OUT

$(BIN)/newalias:	$(NEWALIAS_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(NEWALIAS_OBJ) ../lib/libutil.a $(LIB2)

newalias_lint:		$(NEWALIAS_SRC)
			$(LINT) $(LINTFLAGS) $(NEWALIAS_SRC) >> LINT.OUT

$(BIN)/newmail:		$(NEWMAIL_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(NEWMAIL_OBJ) ../lib/libutil.a $(LIB2)

newmail_lint:		$(NEWMAIL_SRC)
			$(LINT) $(LINTFLAGS) $(NEWMAIL_SRC) >> LINT.OUT

$(BIN)/readmsg:		$(READMSG_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(READMSG_OBJ) ../lib/libutil.a $(LIB2)

readmsg_lint:		$(READMSG_SRC)
			$(LINT) $(LINTFLAGS) $(READMSG_SRC) >> LINT.OUT

$(BIN)/prlong:		$(PRLONG_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(PRLONG_OBJ) ../lib/libutil.a $(LIB2)

prlong_lint:		$(PRLONG_SRC)
			$(LINT) $(LINTFLAGS) $(PRLONG_SRC) >> LINT.OUT

$(BIN)/elmcharset:      $(ELMCHARSET_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(ELMCHARSET_OBJ) ../lib/libutil.a $(LIB2)

$(BIN)/elmterminal:     $(ELMTERMINAL_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(ELMTERMINAL_OBJ) ../lib/libutil.a $(LIB2)


$(BIN)/elmunidata:     $(ELMUNIDATA_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(ELMUNIDATA_OBJ) ../lib/libutil.a $(LIB2)

#	Rules to make shell scripts in bin directory
$(BIN)/checkalias:	checkalias
			$(CP) $? $@
			$(CHMOD) u+w,a+rx $@

$(BIN)/listalias:	listalias
			$(CP) $? $@
			$(CHMOD) u+w,a+rx $@

$(BIN)/messages:	messages
			$(CP) $? $@
			$(CHMOD) u+w,a+rx $@

$(BIN)/printmail:	printmail
			$(CP) $? $@
			$(CHMOD) u+w,a+rx $@

#	Dependencies of header files upon other header files they include
$(INCLDIR)/defs.h:	$(INCLDIR)/../config.h $(INCLDIR)/sysdefs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/elmutil.h:	$(INCLDIR)/elm_curses.h $(INCLDIR)/defs.h $(INCLDIR)/elmlib.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

$(INCLDIR)/headers.h:	$(INCLDIR)/elm_curses.h $(INCLDIR)/defs.h
			$(CHMOD) u+w $@
			$(TOUCH) $@

#	Dependencies of C object files
answer.o:	$(INCLDIR)/ndbz.h $(INCLDIR)/elmutil.h $(INCLDIR)/s_answer.h
elmalias.o:	$(INCLDIR)/elmutil.h $(INCLDIR)/s_elmalias.h
fastmail.o:	$(INCLDIR)/patchlevel.h $(INCLDIR)/elmutil.h $(INCLDIR)/s_fastmail.h
from.o:		$(INCLDIR)/elmutil.h $(INCLDIR)/s_from.h
newalias.o:	$(INCLDIR)/elmutil.h $(INCLDIR)/sysdefs.h $(INCLDIR)/s_newalias.h
newmail.o:	$(INCLDIR)/elmutil.h $(INCLDIR)/s_newmail.h
readmsg.o:	$(INCLDIR)/elmutil.h $(INCLDIR)/s_readmsg.h
prlong.o:	$(INCLDIR)/defs.h

#	Dependencies and rules for installing programs from bin directory

$(DEST)/checkalias:	$(BIN)/checkalias
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+rx $@

$(DEST)/listalias:	$(BIN)/listalias
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+rx $@

$(DEST)/messages:	$(BIN)/messages
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+rx $@


$(DEST)/printmail:	$(BIN)/printmail
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+rx $@


$(DEST)/wnewmail:	$(DEST)/newmail
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(RM) $@
			$(LN) $? $@


!NO!SUBS!

if $test "$d_shared" = "$define" ; then

cat >>Makefile <<'!NO!SUBS!'

$(BIN)/answer-shared:		$(ANSWER_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(ANSWER_OBJ) ../shlib/libelmme-base.so  $(LIB2)


$(BIN)/elmalias-shared:	$(ELMALIAS_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(ELMALIAS_OBJ) ../shlib/libelmme-base.so  $(LIB2)


$(BIN)/fastmail-shared:	$(FASTMAIL_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(FASTMAIL_OBJ) ../shlib/libelmme-base.so  $(LIB2)


$(BIN)/frm-shared:		$(FRM_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(FRM_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/newalias-shared:	$(NEWALIAS_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(NEWALIAS_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/newmail-shared:		$(NEWMAIL_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(NEWMAIL_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/readmsg-shared:		$(READMSG_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(READMSG_OBJ) ../shlib/libelmme-base.so  $(LIB2)


$(BIN)/prlong-shared:		$(PRLONG_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(PRLONG_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmcharset-shared:      $(ELMCHARSET_OBJ) ../lib/libutil.a
			$(CC) $(LFLAGS) -o $@ $(ELMCHARSET_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmterminal-shared:     $(ELMTERMINAL_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(ELMTERMINAL_OBJ) ../shlib/libelmme-base.so  $(LIB2)

$(BIN)/elmunidata-shared:     $(ELMUNIDATA_OBJ) ../shlib/libelmme-base.so 
			$(CC) $(LFLAGS) -o $@ $(ELMUNIDATA_OBJ) ../shlib/libelmme-base.so  $(LIB2)


$(DEST)/newmail:	$(BIN)/newmail-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(RM) $@
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/answer:		$(BIN)/answer-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/elmalias:	$(BIN)/elmalias-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/fastmail:	$(BIN)/fastmail-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/frm:		$(BIN)/frm-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/nfrm:		$(DEST)/frm
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(RM) $@
			$(LN) $? $@

$(DEST)/newalias:	$(BIN)/newalias-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/readmsg:	$(BIN)/readmsg-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(LIB)/prlong:		$(BIN)/prlong-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(LIB)/elmcharset:	$(BIN)/elmcharset-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(LIB)/elmterminal:	$(BIN)/elmterminal-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(LIB)/elmunidata:	$(BIN)/elmunidata-shared
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@


!NO!SUBS!

else

cat >>Makefile <<'!NO!SUBS!'

$(DEST)/newmail:	$(BIN)/newmail
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(RM) $@
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/answer:		$(BIN)/answer
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/elmalias:	$(BIN)/elmalias
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/fastmail:	$(BIN)/fastmail
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/frm:		$(BIN)/frm
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/nfrm:		$(DEST)/frm
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(RM) $@
			$(LN) $? $@

$(DEST)/newalias:	$(BIN)/newalias
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(DEST)/readmsg:	$(BIN)/readmsg
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(LIB)/prlong:		$(BIN)/prlong
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(LIB)/elmcharset:	$(BIN)/elmcharset
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(LIB)/elmterminal:	$(BIN)/elmterminal
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

$(LIB)/elmunidata:	$(BIN)/elmunidata
			-$(MV) $@ $@.old
			-$(RM) $@.old
			$(CP) $? $@
			$(CHMOD) a+x $@

!NO!SUBS!

fi






