/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: crypt.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_crypt_h_
#define	_crypt_h_

#include "osd.h"

/* Include module headers here */
#include "crypt0.h"
#include "crypt1.h"
#include "crypt2.h"
#include "crypt3.h"
#include "crypt4.h"
#include "crypt5.h"
#include "crypt6.h"
#include "crypt7.h"
#include "crypt8.h"

#ifdef	__cplusplus
extern "C" {
#endif

/* Perform 'diequick' tests on a buffer of PRNG
 * words (32 bits) at 'buffer', where 'size' is
 * the buffer's size in bytes, i.e. words * 4
 */
int crypto_diequick(const char *name, void *buffer, size_t size);

int rnd_get(void *buffer, size_t size);
void rnd_entropy(int value);

size_t crypto_module_indx(const char *module);
const char *crypto_module_name(size_t indx);
int crypto_module_supp(size_t module);

int crypto(void);
int crypto_init(size_t module, void **pptr, void *data, size_t size,
	int diequick);
int crypto_exit(size_t module, void *ptr);
int encrypt_msg(size_t module, void *ptr, void *ct, void *pt,
	size_t *outsize, size_t insize);
int decrypt_msg(size_t module, void *ptr, void *pt, void *ct,
	size_t *outsize, size_t insize);

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_crypt_h_) */
