/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: ek5.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef _ek5_h_
#define _ek5_h_

#include "osd.h"
#include "tools.h"

#define	EK5SIZE	16
#define	EK5_PREPEND	"ENTROPY"

/* defines the state of the modified MD5-like algorithm */
typedef struct ek5_state_s {
	uint8_t accu[64];		/* accumulator */
	uint32_t count[2];		/* message length in bits, LSW first */
	uint32_t state[4];		/* digest buffer */
}	ek5_state_t;

typedef struct ek5_digest_s {
	uint8_t digest[EK5SIZE];
}	ek5_digest_t;

#ifdef __cplusplus
extern "C" {
#endif

void ek5_init(ek5_state_t *pms);
void ek5_append(ek5_state_t *pms, const void *src, size_t len);
void ek5_finish(ek5_state_t *pms, ek5_digest_t *pd);
void ek5(const void *src, size_t len, ek5_digest_t *pd);
const char *ek5_hexstr(const ek5_digest_t *pd);
const char *ek5_hexshort(const ek5_digest_t *pd);
void ek5_from_sha1(const uint8_t sha1[20], ek5_digest_t *pd);

#ifdef __cplusplus
}
#endif

#endif	/* !defined(_ek5_h_) */
