/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: png.h,v 1.2 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_png_h_
#define	_png_h_

#include "osd.h"

#define	COLOR_GRAYSCALE	0
#define	COLOR_RGBTRIPLE	2
#define	COLOR_PALETTE	3
#define	COLOR_GRAYALPHA	4
#define	COLOR_RGBALPHA	6

typedef	struct png_s {
	void *user;
	int (*input)(void *user);
	int (*output)(void *user, uint8_t data);
	uint32_t crc;
	/* image header information */
	int w, h, bpp;
	uint8_t color;
	uint8_t depth;
	uint8_t compression;
	uint8_t filter;
	uint8_t interlace;
	/* physical pixel dimensions */
	uint32_t px, py;
	uint8_t unit;
	/* time stamp C,Y,M,D,H,M,S */
	uint8_t time[7];
	/* background color */
	size_t bkgd_size;
	uint8_t bkgd[6];
	/* transparency */
	size_t trns_size;
	uint8_t trns[256];
	/* working variables */
	size_t row, offs, size;
	uint8_t *img;
	uint8_t pal[3*256];
	char *comment;
	char *author;
}	png_t;

#ifdef	__cplusplus
extern "C" {
#endif

#define	PNG_RGB(r,g,b)	((((r)&0xff)<<16)|(((g)&0xff)<<8)|((b)&0xff))

png_t *png_read(const char *filename,
	void *user, int (*output)(void *user, uint8_t data));
png_t *png_create(int w, int h, int color, int depth,
	void *user, int (*output)(void *user, uint8_t data));
int png_finish(png_t *png);
int png_set_palette(png_t *png, int idx, int color);
int png_put_pixel(png_t *png, int x, int y, int color, int alpha);
int png_get_pixel(png_t *png, int x, int y, int *color, int *alpha);
int png_rectangle(png_t *png, int x0, int y0, int x1, int y1,
	int color, int alpha);
int png_filled_rectangle(png_t *png, int x0, int y0, int x1, int y1,
	int color, int alpha);
int png_tinted_rectangle(png_t *png, int x0, int y0, int x1, int y1,
	int color, int alpha);
int png_printf(png_t *png, int x, int y, int color, int alpha,
	const char *fmt, ...);
int png(void);

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_png_h_) */
