/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: proxy.h,v 1.6 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef	_proxy_h_
#define	_proxy_h_

#include "osd.h"
#include "memalloc.h"
#include "temp.h"
#include "i18n.h"
#include "key.h"
#include "uri.h"
#include "file.h"
#include "peer.h"
#include "news.h"
#include "store.h"
#include "gif.h"
#include "png.h"
#include "vt.h"
#include "i18n.h"
#include "sock.h"
#include "mime.h"

/*	a meta doc
 *	pointers to a variable/value pair
 *	*val might be NULL
 */
typedef struct meta_doc_s {
	int idx;
	char *var;
	char *val;
}	meta_doc_t;

/*
 *	a meta list
 *	*data is the entire document list
 *	docs[] is an array of var/val pairs
 */
typedef struct meta_s {
	size_t size;
	char *data;
	size_t max, count;
	meta_doc_t docs[1];
}	meta_t;

/*
 *	a proxy cache entry
 *	time is the last access time in seconds
 *	key is the content hash key of that document
 *	*meta points to a meta list
 */
typedef struct proxy_cache_s {
	time_t time;
	sha1_digest_t sha1;
	meta_t *meta;
}	proxy_cache_t;

/*
 *	A file download structure. This is used to pass information about
 *	a split file (FEC or old format) or big file download between
 *	page reloads initiated by a "meta http-equiv refresh" header.
 */
typedef struct file_dn_s {
	int rc;
	char fquri[80];
	char *key;
	char *status;
}	file_dn_t;

/*
 *	A file upload structure. This is used to pass information about
 *	a pending file insert between page reloads initiated by a
 *	"meta http-equiv refresh" header.
 */
typedef struct file_up_s {
	int rc;
	char fquri[80];
	char tmpfile[MAXPATHLEN];		/* tempfile name */
	char *key;				/* user specified key */
	char *content_type;		/* content type */
	char *filename;			/* local filename */
	int htl;				/* hops to live for this insert */
	size_t dataoffs;		/* data offset in the temp file */
	size_t datasize;		/* data size in the temp file */
	size_t metasize;		/* meta data size */
}	file_up_t;
	

/*
 *	A pointer to this structure s kept in the conn->temp
 *	user pointer during a connection. It is used to pass
 *	information between the accepting child process and
 *	the output dispatching functions. I should clean it up some day.
 */
typedef struct proxy_reply_s {
	int htl;				/* hops-to-live value from g_conf or ?htl=x */
	int meta;				/* display document's meta data instead of data */
	int result_code;		/* 200 OK, 404 Document not found, etc. */
	int no_cache;			/* non zero if this document shall not be cached */
	int request_type;		/* HTTP_GET, HTTP_HEAD or HTTP_POST */
	int accept_encoding;	/* non zero if the browser accepts gzip */
	int legend;				/* non zero if ?legend=1 in the request */
	int retry_number;		/* value of ?try=xx in the request */
	char *stylesheet;		/* internal stylesheet for this document */
	chkey_t key;			/* key for a news reply */
	char *board;			/* board name for a news post/reply */
	char *subject;			/* subject for a news post/reply */
	char *from;				/* from for a news post/reply */
	struct tm date;			/* date/time for a news post/reply */
	char *body;				/* body text of a news post/reply */
	char *chat_output;		/* collected chat output */
	char *chat_status;		/* collected chat status */
	char *chat_channel;		/* chat channel to write to */
	char *chat_sender;		/* chat sender name */
	uint32_t chat_color;		/* chat sender color */
	char *chat_payload;		/* chat payload for broadcast */
	file_up_t *file_up;		/* file upload handle */
	file_dn_t *file_dn;		/* file download handle (yet unused) */
	news_post_t *news_post;	/* news post handle */
	char submit[31+1];		/* submit value */
	size_t content_length;	/* length of the content (may be UNKNOWN_LENGTH) */
	char *content_type;		/* content type (MIME-type) */
	char *charset;			/* charset for the GET/HEAD/POST */
	char *location;			/* a redirect location */
	char language[2+1];		/* 2 character language code (default or browser) */
	void *user;				/* user data for a passthru */
	int (*passthru)(conn_t *conn);
}	proxy_reply_t;

/*
 *	proxy data - in shared memory
 *	sem is used to lock this down during changes
 *	size is the number of entries in the cache
 *	cache[] points to the entries in shared memory
 */
typedef struct proxy_s {
	osd_sem_t sem;
	size_t size;
	proxy_cache_t cache[1];
}	proxy_t;

#ifdef	__cplusplus
extern "C" {
#endif
extern proxy_t *g_proxy;

int proxy(void);
#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_proxy_h_) */
