/*****************************************************************************
 *  ENTROPY - emerging network to reduce orwellian potency yield
 *
 *  Copyright (C) 2002 Juergen Buchmueller <pullmoll@stop1984.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 *	$Id: tools.h,v 1.3 2005/07/12 23:19:26 pullmoll Exp $
 *****************************************************************************/
#ifndef _tools_h_
#define	_tools_h_

#include "osd.h"
#include "memalloc.h"
#include "logger.h"

#define	O_WR	(O_RDWR|O_CREAT|O_TRUNC|O_BINARY)
#define	O_RD	(O_RDWR|O_BINARY)

#ifdef	__cplusplus
extern "C" {
#endif

int bitsum(uint32_t bits);

const char *usec_str(uint64_t us);
void tv_add(struct timeval *dst, const struct timeval *src, uint64_t add);
void tv_sub(struct timeval *dst, const struct timeval *src, uint64_t sub);
int64_t tv_diff(const struct timeval *dst, const struct timeval *src);
int tv_cmp(const struct timeval *dst, const struct timeval *src);

const char *datetime_str(time_t t);
int parse_tm_date(struct tm *tm, const char *src);
int parse_tm_time(struct tm *tm, const char *src);
const char *age_str(const char *lang, const char *charset, time_t t0, time_t t);
const char *flags_str(int flags);

uint64_t strtoul_KMG(const char *src);
const char *size_KMG(uint64_t size);
const char *round_KMG(uint64_t size);

int pm_vsnprintf(char *dst, size_t size, const char *fmt, va_list ap);
int pm_snprintf(char *dst, size_t size, const char *fmt, ...);
int pm_vasprintf(char **pdst, const char *fmt, va_list ap);
int pm_asprintf(char **pdst, const char *fmt, ...);

int pm_spprintf(char *dst, char *base, size_t size, const char *fmt, ...);
int pm_append(char **dst, char **base, size_t *size, const char *fmt, ...);

const char *hexstr(const uint8_t *src, size_t len);
const char *hexdump(const uint8_t *src, size_t len);

int gzip(void **dst, size_t *dstsize, const void *src, size_t srcsize);
int gunzip(void **dst, size_t *dstsize, const void *src, size_t srcsize);

int mkstemp_binary(char *path, const char *name);
int mkstemp_closed(char *path, const char *name);
int set_signal_handler(int sig, void (*sighandler)(int));

#ifdef	__cplusplus
}
#endif
#endif	/* !defined(_tools_h_) */
