#if !defined(EC_GTK_H)
#define EC_GTK_H

#include <gtk/gtk.h>

extern void Ginterface_InitTitle(char *ip, char *mac, char *subnet);
extern void Ginterface_Screen_Init(void);
extern void Ginterface_Screen_Close(void);
extern void Ginterface_WExit(char *buffer);
extern void Ginterface_Run(void);
extern void Ginterface_Connect(void);
extern void Ginterface_OldStyleSniff(short mode);
extern void Ginterface_CheckForPoisoner(void);
extern void Ginterface_FingerPrint(void);
extern void Ginterface_OnlyPoison(void);
extern void Ginterface_Callback(gpointer data, guint action, GtkWidget *widget);

/* for pop-up notices
 *
 * PopUp - a message with an OK button
 * PupUpN - a notice closed by program
 * PopUpNP - a notice with a progress bar
 * PopUpQ - a yes or no question that returns y or n
 */
extern void Ginterface_PopUp(char *question, ...);  /* for messages, controlled by user */
extern void Ginterface_PopUpN(char *notice);        /* for notices, controlled by program */
extern void Ginterface_PopUpNP(char *notice);       /* notices with progress bars */
extern char Ginterface_PopUpQ(char *question, ...); /* for yes/no questions */

/* help functions
 *
 * Manual - displays ettercap manpage by running `man ettercap | col -b`
 * About - displays logo, authors, and contributors
 * HelpWindow - gtk version of old help call
 */
extern void Ginterface_Manual(void);
extern void Ginterface_About(void);
extern void Ginterface_HelpWindow(char *help[]);

/* functions for modifing the top frame info */
extern void Ginterface_EditTop(int which, char *message);
extern void Ginterface_ClearTop(void);
extern void Ginterface_AppendTop(int which, char *message);

/* functions for modifing the bottom frame info */
extern void Ginterface_EditBottom(int which, char *message);
extern void Ginterface_ClearBottom(void);
extern void Ginterface_AppendBottom(int which, char *message);

/* notebook page callback, image path (installed vs source dir), and auto-scroll function */
extern void Ginterface_SwitchPage(GtkNotebook *notebook, GtkNotebookPage *page, gint page_num, gpointer user_data);
extern void Ginterface_CheckImgPath(char *path);

#ifndef HAVE_FORM
extern void trim_buffer(char *buffer, char trim);
#endif

/* common menu entries */
#define MENU_COMMON       { "/Quit", "q", Ginterface_Callback, 'q', "<StockItem>", GTK_STOCK_QUIT }, \
      { "/Sniff", NULL, NULL, 0, "<Branch>", NULL}, \
      { "/Sniff/ARP poison based sniffing", "a", Ginterface_Callback, 'a', "<Item>", NULL}, \
      { "/Sniff/MAC based sniffing", "m", Ginterface_Callback, 'm', "<Item>", NULL}, \
      { "/Sniff/IP based sniffing", "s", Ginterface_Callback, 's', "<Item>", NULL}, \
      { "/Sniff/Passive host identification", "o", Ginterface_Callback, 'o', "<Item>", NULL}, \
      { "/Sniff/Run a plugin", "p", Ginterface_Callback, 'p', "<Item>", NULL},


/* global variables for Interface... */
extern GtkWidget *window, *notebook, *frame[3], *mainbox[6], *tablabel[6];
extern GtkWidget *tb_label[9], *tb_table, *bb_label[2], *ec_table, *arrows;
extern GtkItemFactory *main_menu;
extern GtkAccelGroup *accel_group;

/* for the host lists */
extern GtkWidget         *h_scrolled;
extern GtkListStore      *h_list[2];
extern GtkTreeIter        h_iter[2];
extern GtkCellRenderer   *h_renderer;
extern GtkTreeViewColumn *h_column;
extern GtkWidget         *h_treeview[2];
extern GtkTreeSelection  *h_selection[2];

extern GtkWidget *s_scrolled; /* for sniffer modes */
extern GtkWidget *pbar;       /* progress bar, defined in splash */ 
extern GtkWidget *o_win;      /* plugin output window */

extern int gBase_Pointer;
extern int gSource_Pointer;
extern int gDest_Pointer;
extern int *gPointer;
extern int Sel_Number;

extern char title_bottom_window[100];
extern char title_main_window[100];
extern char title_top_window[100];
extern char image_path[100];

#endif

/* EOF */

// vim:ts=3:expandtab
