;;  biosdef.inc:
;;	include file for using the *.asm files
;;	Written by KIMURA Takamichi <takamiti@tsden.org> 1999/03/14
;;
;;  $Id: biosdef.inc,v 1.1.1.1 2000/11/29 11:58:06 takamiti Exp $

VIDEOBIOS	equ	0x10
DISKBIOS	equ	0x13
KEYBIOS		equ	0x16
TIMERBIOS	equ	0x1A

BOOT_LOC	equ	0x0600
BIOS_LOC	equ	0x7C00

EXTDOS_PART	equ 	0x05
EXTLINUX_PART	equ	0x85
EXTDOSLBA_PART	equ	0x0f

SECTOR_SIZE	equ	512
IPL_MAGIC	equ	0xAA55
PART_TBL_OFS	equ	0x01be
IPL_MAGIC_OFS	equ	0x01fe

NULL		equ	0x00
BELL		equ	0x07
LF		equ	0x0A
CR		equ	0x0D

CAPS_BIT	equ	0x40
NUM_BIT		equ	0x20
SCROL_BIT	equ	0x10
ALT_BIT		equ	0x08
CTRL_BIT	equ	0x04
LEFT_SHIFT	equ	0x02
RIGHT_SHIFT	equ	0x01
SHIFT_BIT	equ	(LEFT_SHIFT | RIGHT_SHIFT)

ENTER_SCAN	equ	0x1c0d
LF_SCAN		equ	0x1c0a
ENTER_KEY	equ	0x1c
EXEC_SCAN	equ	0x4f00
END_SCAN	equ	0x4f00
EXEC_KEY	equ	0x4f
SPACE_SCAN	equ	0x3920
BS_SCAN		equ	0x0e08
UP_SCAN		equ	0x4800
DOWN_SCAN	equ	0x5000
LEFT_SCAN	equ	0x4b00
RIGHT_SCAN	equ	0x4d00
KEY_k		equ	0x256b
KEY_j		equ	0x246a
KEY_h		equ	0x2368
KEY_l		equ	0x266c
KEY_0		equ	0x0b30
KEYPAD_0	equ	0x5230
