/*****************************************************************
 * fbext.c: FBM Release 1.2 07-Apr-93 Michael Mauldin
 *
 * Copyright (C) 1989-1993 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbext.c: 
 *
 * USAGE
 *	% fbext [ -w<width> -h<height> -W<maxwidth> -H<maxheight>
 *		 -a<aspect> -t'title' -c'credits' ]
 *	       [ x y width height ] < foo.fbm > bar.fbm
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:02:18 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbext.c
 *
 * HISTORY
 * 07-Apr-93  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Added -J switch
 *
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 20-May-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Bug fix from Dave Cohrs <dave@cs.wisc.edu>
 *
 * 20-Apr-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.91) mlm@cs.cmu.edu
 *
 * 22-Aug-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

int allowrot = 0;

# define USAGE \
"Usage:	fbext [ -w<width> -h<height> ] [ -R ]\n\
	      [ -W<maxwdith> -H<maxheight> -s<size> ]\n\
	      [ -a<aspect> -t'title' -c'credits' ] [ -<type> ]\n\
	      [ x y [ width height ] ]	< image > image"

#ifndef lint
static char *fbmid =
"$FBM fbext.c <1.2> 07-Apr-93 (C) 1989-1993 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ int xo = -1, yo = -1, w = -1, h = -1, ow = -1, oh = -1, size = -1;
  int mh = -1, mw = -1;
  double aspect = -1.0;
  char title[FBM_MAX_TITLE], credits[FBM_MAX_TITLE];
  FBM input, rotated, output, *image = &input;
  int outtype = FMT_FBM;

  /* Clear the memory pointers so alloc_fbm won't be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  rotated.cm = rotated.bm = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  title[0] = '\0';
  credits[0] = '\0';

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 't':	strcpy (title, *argv+1); CLRARG; break;
	case 'c':	strcpy (credits, *argv+1); CLRARG; break;
	case 'a':	aspect = atof (*argv+1); SKIPARG; break;
	case 'w':	ow = atoi (*argv+1); SKIPARG; break;
	case 'h':	oh = atoi (*argv+1); SKIPARG; break;
	case 'W':	mw = atoi (*argv+1); SKIPARG; break;
	case 'H':	mh = atoi (*argv+1); SKIPARG; break;
	case 'r':	allowrot++; break;
	case 's':	size = atoi (*argv+1); SKIPARG; break;
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'J':	outtype = FMT_JPEG; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'R':	outtype = FMT_RLE; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:	fprintf (stderr, "%s\n", USAGE);
			exit (1);
      }
    }
  }


  if (read_bitmap (&input, (char *) NULL))
  {
    if (image->hdr.physbits != 8)
    { fprintf (stderr,
	       "Can't handle images with %d bits and %d physbits per pixel\n",
	       image->hdr.bits, image->hdr.physbits);
      exit (1);
    }

    /* Get arguments */
    if (argc > 0)	xo	= atoi (argv[0]);
    if (xo < 0)		xo	= 0;

    if (argc > 1)	yo	= atoi (argv[1]);
    if (yo < 0)		yo	= 0;

    if (argc > 2)	w	= atoi (argv[2]);
    if (w < 0)		w	= image->hdr.cols - xo;

    if (argc > 3)	h	= atoi (argv[3]);
    if (h < 0)		h	= image->hdr.rows - yo;

    if (argc > 4)	ow	= atoi (argv[4]);

    if (argc > 5)	aspect = atof (argv[5]);
    
    /* If 'allowrot' is on, rotate image if its fits better */
    if (allowrot && mh > 0 && mw > 0)
    { int inhoriz=0, outhoriz=0;
    
      if (aspect < 0.0) aspect = 1.0;
    
      if (image->hdr.cols >= (image->hdr.aspect * image->hdr.rows)) inhoriz++;
      if (mw >= (aspect * mh))					 outhoriz++;
      
      if (inhoriz != outhoriz)
      { if (rotate_fbm (image, &rotated, 90))
        { free (image);
	  image = &rotated;
	  
	  fprintf (stderr, "Rotating [%dx%d] image for better fit [%dx%d]\n",
		   image->hdr.rows, image->hdr.cols, mw, mh);
	}
      }
      else
      { exit (1); }
    }

    /* If max number of pixels specified, calculate width and height */
    if (size > 0)
    { if (ow > 0 || oh > 0)
      { fprintf (stderr,
	  "fbext: error, can only specify one of size and width,height\n");
	exit (1);
      }
      
      aspect = 1.0;

      ow = sqrt ((double) size * w / (h * image->hdr.aspect));
      ow &= ~7;			/* Make width multiple of 8 */
      oh = ow * image->hdr.aspect * h / w;
    }

    /* If given width and height, must determine output aspect */
    if (aspect <= 0.0)
    { if (ow > 0 && oh > 0)
      { aspect = image->hdr.aspect * ow * h / (oh * w); }
      else
      { aspect = image->hdr.aspect; }
    }

    /* If given only maximum sizes, assume largest width */
    if (ow <= 0 && oh <= 0)
    { if (mw > 0)	ow = mw;
      else if (mh > 0)	oh = mh;
    }

    /*
     * If given one of width or height, calculate the other.
     * If given only aspect ratio, inflate the smaller dimension
     */

    if (ow > 0 && oh > 0)
    { /* Nothing to pick */ }
    else if (ow <= 0 && oh > 0)
    { ow = ((double) oh + 0.5) * (aspect / image->hdr.aspect) * w / h; }
    else if (ow > 0 && oh <= 0)
    { oh = ((double) ow + 0.5) * (image->hdr.aspect / aspect) * h / w; }
    else if (aspect != image->hdr.aspect)
    { if (aspect > image->hdr.aspect)
      { oh = h;
        ow = ((double) oh + 0.5) * (aspect / image->hdr.aspect) * w / h;
      }
      else
      { ow = w;
        oh = ((double) ow + 0.5) * (input.hdr.aspect / aspect) * h / w;
      }
    }
    else
    { ow = w; oh = h; }
     
    /* If either dimension exceeds given maximums, shrink the image to fit */
    if (mh > 0 && oh > mh)
    { ow = ow * mh / oh; oh = mh; }

    /* Now extract the specified rectangle and write it out */
    if (mw > 0 && ow > mw)
    { oh = oh * mw / ow; ow = mw; }

    if (extract_fbm (&input, &output, xo, yo, w, h, ow, oh,
		     title[0] ? title : NULL,
		     credits[0] ? credits : NULL))
    { if (write_bitmap (&output, stdout, outtype)) exit (0); }
  }
  
  exit (1);
}
