/*****************************************************************
 * fbm2tiff.c: FBM Release 1.2 24-Mar-93 Michael Mauldin
 *
 * Copyright (C) 1993 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * fbm2tiff.c: 
 *	Convert an FBM format image to TIFF format.  Uses Sam Leffler's
 *	libtiff.a TIFF image library to write TIFF format.  See also,
 *	tiff2fbm for the opposite conversion.
 *
 * USAGE
 *	% fbm2tiff [-N -g<graybits>] output.tiff < input.fbm
 *
 * EDITLOG
 *	LastEditDate = Wed Mar 24 13:05:46 EST 1993 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/fbm2tiff.c
 *
 * HISTORY
 * 24-Mar-93  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Moved writing code to fltiff.c for release 1.2
 *
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 13-Jun-90  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <ctype.h>
# include "fbm.h"

# define USAGE \
  "Usage: fbm2tiff [-N -g<graybits>] output.tiff < input.fbm"

/****************************************************************
 * main
 ****************************************************************/

#ifndef lint
static char *fbmid =
"$FBM fbm2tiff.c <1.2> 24-Mar-93  (C) 1993 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ FBM image;
  int graybit=0;

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 'N':	graybit = 2; break;
	case 'g':	graybit = atoi (*argv+1); SKIPARG; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }
  
  if (argc != 1)
  { fprintf (stderr, "%s\n", USAGE); }

  image.cm = image.bm = (unsigned char *) NULL;

  /* Now read in an FBM image and write a TIFF format file */
  if (read_bitmap (&image, (char *) NULL) &&
      write_tiff (&image, argv[0], graybit))
  { exit (0); }
  else
  { exit (1); }
}
