/*****************************************************************
 * gray2clr.c: FBM Release 1.2 07-Apr-93 Michael Mauldin
 *
 * Copyright (C) 1989-1993 by Michael Mauldin.  Permission is granted
 * to use this file in whole or in part for any purpose, educational,
 * recreational or commercial, provided that this copyright notice
 * is retained unchanged.  This software is available to all free of
 * charge by anonymous FTP and in the UUNET archives.
 *
 * gray2clr.c: 
 *
 * USAGE
 *	% gray2clr [ flags ] arguments
 *
 * EDITLOG
 *	LastEditDate = Mon Jun 25 00:18:17 1990 - Michael Mauldin
 *	LastFileName = /usr2/mlm/src/misc/fbm/gray2clr.c
 *
 * HISTORY
 * 07-Apr-93  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Added -J switch
 *
 * 25-Jun-90  Michael Mauldin (mlm@cs.cmu.edu) Carnegie Mellon
 *	Package for Release 1.0
 *
 * 07-Mar-89  Michael Mauldin (mlm) at Carnegie Mellon University
 *	Beta release (version 0.9) mlm@cs.cmu.edu
 *
 *  1-Dec-88  Michael Mauldin (mlm) at Carnegie-Mellon University
 *	Created.
 *****************************************************************/

# include <stdio.h>
# include <math.h>
# include "fbm.h"

# define USAGE "gray2clr [ -<type> ] [ -u ] < gray > color"

#ifndef lint
static char *fbmid =
"$FBM gray2clr.c <1.2> 07-Apr-93 (C) 1989-1993 by Michael Mauldin, source \
code available free from MLM@CS.CMU.EDU and from UUNET archives$";
#endif

main (argc, argv)
char *argv[];
{ FBM input, output;
  int outtype = DEF_8BIT;
  int mapped = 1;

  /* If invoked as 'unmap', set option to mapped=0 */
  if (strcmp (argv[0] + strlen (argv[0]) - 5, "unmap") == 0)
  { mapped = 0; }

  /* Get the options */
  while (--argc > 0 && (*++argv)[0] == '-')
  { while (*++(*argv))
    { switch (**argv)
      { case 'u':	mapped = 0; break;
	case 'A':	outtype = FMT_ATK; break;
	case 'B':	outtype = FMT_FACE; break;
	case 'F':	outtype = FMT_FBM; break;
	case 'G':	outtype = FMT_GIF; break;
	case 'I':	outtype = FMT_IFF; break;
	case 'J':	outtype = FMT_JPEG; break;
	case 'L':	outtype = FMT_LEAF; break;
	case 'M':	outtype = FMT_MCP; break;
	case 'P':	outtype = FMT_PBM; break;
	case 'R':	outtype = FMT_RLE; break;
	case 'S':	outtype = FMT_SUN; break;
	case 'T':	outtype = FMT_TIFF; break;
	case 'X':	outtype = FMT_X11; break;
	case 'Z':	outtype = FMT_PCX; break;
	default:        fprintf (stderr, "%s\n", USAGE);
                        exit (1);
      }
    }
  }

  /* Clear the memory pointers so alloc_fbm won't be confused */
  input.cm  = input.bm  = (unsigned char *) NULL;
  output.cm = output.bm = (unsigned char *) NULL;

  /* Read the image and convert it */
  if (read_bitmap (&input, (char *) NULL) &&
      (mapped ?
       gray2clr (&input, &output, outtype == FMT_SUN) :
       clr_unmap (&input, &output)) &&
      write_bitmap (&output, stdout, outtype))
  { exit (0); }

  exit (1);
}
