/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:19:44 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-backward 7 */

/*
 * This function contains 157 FP additions, 127 FP multiplications,
 * (or, 138 additions, 108 multiplications, 19 fused multiply/add),
 * 32 stack variables, and 56 memory accesses
 */
static const fftw_real K222520933 = FFTW_KONST(+0.222520933956314404288902564496794759466355569);
static const fftw_real K900968867 = FFTW_KONST(+0.900968867902419126236102319507445051165919162);
static const fftw_real K623489801 = FFTW_KONST(+0.623489801858733530525004884004239810632274731);
static const fftw_real K781831482 = FFTW_KONST(+0.781831482468029808708444526674057750232334519);
static const fftw_real K974927912 = FFTW_KONST(+0.974927912181823607018131682993931217232785801);
static const fftw_real K433883739 = FFTW_KONST(+0.433883739117558120475768332848358754609990728);
static const fftw_real K2_000000000 = FFTW_KONST(+2.000000000000000000000000000000000000000000000);
static const fftw_real K1_801937735 = FFTW_KONST(+1.801937735804838252472204639014890102331838324);
static const fftw_real K445041867 = FFTW_KONST(+0.445041867912628808577805128993589518932711138);
static const fftw_real K1_246979603 = FFTW_KONST(+1.246979603717467061050009768008479621264549462);
static const fftw_real K867767478 = FFTW_KONST(+0.867767478235116240951536665696717509219981456);
static const fftw_real K1_949855824 = FFTW_KONST(+1.949855824363647214036263365987862434465571601);
static const fftw_real K1_563662964 = FFTW_KONST(+1.563662964936059617416889053348115500464669037);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_backward_7(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (7 * iostride);
     {
	  fftw_real tmp112;
	  fftw_real tmp116;
	  fftw_real tmp114;
	  fftw_real tmp104;
	  fftw_real tmp107;
	  fftw_real tmp105;
	  fftw_real tmp106;
	  fftw_real tmp108;
	  fftw_real tmp115;
	  fftw_real tmp113;
	  fftw_real tmp109;
	  fftw_real tmp111;
	  fftw_real tmp110;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp109 = Y[-2 * iostride];
	  tmp111 = Y[-iostride];
	  tmp110 = Y[-3 * iostride];
	  tmp112 = (K1_563662964 * tmp109) - (K1_949855824 * tmp110) - (K867767478 * tmp111);
	  tmp116 = (K867767478 * tmp109) + (K1_563662964 * tmp110) - (K1_949855824 * tmp111);
	  tmp114 = (K1_563662964 * tmp111) + (K1_949855824 * tmp109) + (K867767478 * tmp110);
	  tmp104 = X[0];
	  tmp107 = X[3 * iostride];
	  tmp105 = X[iostride];
	  tmp106 = X[2 * iostride];
	  tmp108 = tmp104 + (K1_246979603 * tmp106) - (K445041867 * tmp107) - (K1_801937735 * tmp105);
	  tmp115 = tmp104 + (K1_246979603 * tmp107) - (K1_801937735 * tmp106) - (K445041867 * tmp105);
	  tmp113 = tmp104 + (K1_246979603 * tmp105) - (K1_801937735 * tmp107) - (K445041867 * tmp106);
	  X[4 * iostride] = tmp108 - tmp112;
	  X[3 * iostride] = tmp108 + tmp112;
	  X[0] = tmp104 + (K2_000000000 * (tmp105 + tmp106 + tmp107));
	  X[2 * iostride] = tmp115 + tmp116;
	  X[5 * iostride] = tmp115 - tmp116;
	  X[6 * iostride] = tmp113 + tmp114;
	  X[iostride] = tmp113 - tmp114;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 6) {
	  fftw_real tmp42;
	  fftw_real tmp51;
	  fftw_real tmp45;
	  fftw_real tmp48;
	  fftw_real tmp67;
	  fftw_real tmp81;
	  fftw_real tmp94;
	  fftw_real tmp97;
	  fftw_real tmp85;
	  fftw_real tmp70;
	  fftw_real tmp52;
	  fftw_real tmp61;
	  fftw_real tmp55;
	  fftw_real tmp58;
	  fftw_real tmp74;
	  fftw_real tmp86;
	  fftw_real tmp98;
	  fftw_real tmp93;
	  fftw_real tmp82;
	  fftw_real tmp63;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp65;
	       fftw_real tmp64;
	       fftw_real tmp66;
	       fftw_real tmp49;
	       fftw_real tmp50;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp42 = X[0];
	       tmp49 = X[3 * iostride];
	       tmp50 = Y[-4 * iostride];
	       tmp51 = tmp49 + tmp50;
	       tmp65 = tmp49 - tmp50;
	       {
		    fftw_real tmp43;
		    fftw_real tmp44;
		    fftw_real tmp46;
		    fftw_real tmp47;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp43 = X[iostride];
		    tmp44 = Y[-6 * iostride];
		    tmp45 = tmp43 + tmp44;
		    tmp64 = tmp43 - tmp44;
		    tmp46 = X[2 * iostride];
		    tmp47 = Y[-5 * iostride];
		    tmp48 = tmp46 + tmp47;
		    tmp66 = tmp46 - tmp47;
	       }
	       tmp67 = (K433883739 * tmp64) + (K974927912 * tmp65) - (K781831482 * tmp66);
	       tmp81 = (K781831482 * tmp64) + (K974927912 * tmp66) + (K433883739 * tmp65);
	       tmp94 = (K974927912 * tmp64) - (K781831482 * tmp65) - (K433883739 * tmp66);
	       tmp97 = tmp42 + (K623489801 * tmp51) - (K900968867 * tmp48) - (K222520933 * tmp45);
	       tmp85 = tmp42 + (K623489801 * tmp45) - (K900968867 * tmp51) - (K222520933 * tmp48);
	       tmp70 = tmp42 + (K623489801 * tmp48) - (K222520933 * tmp51) - (K900968867 * tmp45);
	  }
	  {
	       fftw_real tmp72;
	       fftw_real tmp73;
	       fftw_real tmp71;
	       fftw_real tmp59;
	       fftw_real tmp60;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp52 = Y[0];
	       tmp59 = Y[-3 * iostride];
	       tmp60 = X[4 * iostride];
	       tmp61 = tmp59 - tmp60;
	       tmp72 = tmp59 + tmp60;
	       {
		    fftw_real tmp53;
		    fftw_real tmp54;
		    fftw_real tmp56;
		    fftw_real tmp57;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp53 = Y[-iostride];
		    tmp54 = X[6 * iostride];
		    tmp55 = tmp53 - tmp54;
		    tmp73 = tmp53 + tmp54;
		    tmp56 = Y[-2 * iostride];
		    tmp57 = X[5 * iostride];
		    tmp58 = tmp56 - tmp57;
		    tmp71 = tmp56 + tmp57;
	       }
	       tmp74 = (K781831482 * tmp71) - (K974927912 * tmp72) - (K433883739 * tmp73);
	       tmp86 = (K781831482 * tmp73) + (K974927912 * tmp71) + (K433883739 * tmp72);
	       tmp98 = (K433883739 * tmp71) + (K781831482 * tmp72) - (K974927912 * tmp73);
	       tmp93 = tmp52 + (K623489801 * tmp61) - (K900968867 * tmp58) - (K222520933 * tmp55);
	       tmp82 = tmp52 + (K623489801 * tmp55) - (K900968867 * tmp61) - (K222520933 * tmp58);
	       tmp63 = tmp52 + (K623489801 * tmp58) - (K222520933 * tmp61) - (K900968867 * tmp55);
	  }
	  X[0] = tmp42 + tmp45 + tmp48 + tmp51;
	  {
	       fftw_real tmp89;
	       fftw_real tmp91;
	       fftw_real tmp88;
	       fftw_real tmp90;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp89 = tmp82 - tmp81;
	       tmp91 = tmp85 + tmp86;
	       tmp88 = c_re(W[5]);
	       tmp90 = c_im(W[5]);
	       Y[0] = (tmp88 * tmp89) - (tmp90 * tmp91);
	       X[6 * iostride] = (tmp90 * tmp89) + (tmp88 * tmp91);
	  }
	  {
	       fftw_real tmp101;
	       fftw_real tmp103;
	       fftw_real tmp100;
	       fftw_real tmp102;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp101 = tmp94 + tmp93;
	       tmp103 = tmp97 + tmp98;
	       tmp100 = c_re(W[1]);
	       tmp102 = c_im(W[1]);
	       Y[-4 * iostride] = (tmp100 * tmp101) - (tmp102 * tmp103);
	       X[2 * iostride] = (tmp102 * tmp101) + (tmp100 * tmp103);
	  }
	  {
	       fftw_real tmp95;
	       fftw_real tmp99;
	       fftw_real tmp92;
	       fftw_real tmp96;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp95 = tmp93 - tmp94;
	       tmp99 = tmp97 - tmp98;
	       tmp92 = c_re(W[4]);
	       tmp96 = c_im(W[4]);
	       Y[-iostride] = (tmp92 * tmp95) - (tmp96 * tmp99);
	       X[5 * iostride] = (tmp96 * tmp95) + (tmp92 * tmp99);
	  }
	  Y[-6 * iostride] = tmp52 + tmp55 + tmp58 + tmp61;
	  {
	       fftw_real tmp68;
	       fftw_real tmp75;
	       fftw_real tmp62;
	       fftw_real tmp69;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp68 = tmp63 - tmp67;
	       tmp75 = tmp70 - tmp74;
	       tmp62 = c_re(W[3]);
	       tmp69 = c_im(W[3]);
	       Y[-2 * iostride] = (tmp62 * tmp68) - (tmp69 * tmp75);
	       X[4 * iostride] = (tmp69 * tmp68) + (tmp62 * tmp75);
	  }
	  {
	       fftw_real tmp77;
	       fftw_real tmp79;
	       fftw_real tmp76;
	       fftw_real tmp78;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp77 = tmp67 + tmp63;
	       tmp79 = tmp70 + tmp74;
	       tmp76 = c_re(W[2]);
	       tmp78 = c_im(W[2]);
	       Y[-3 * iostride] = (tmp76 * tmp77) - (tmp78 * tmp79);
	       X[3 * iostride] = (tmp78 * tmp77) + (tmp76 * tmp79);
	  }
	  {
	       fftw_real tmp83;
	       fftw_real tmp87;
	       fftw_real tmp80;
	       fftw_real tmp84;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp83 = tmp81 + tmp82;
	       tmp87 = tmp85 - tmp86;
	       tmp80 = c_re(W[0]);
	       tmp84 = c_im(W[0]);
	       Y[-5 * iostride] = (tmp80 * tmp83) - (tmp84 * tmp87);
	       X[iostride] = (tmp84 * tmp83) + (tmp80 * tmp87);
	  }
     }
     if (i == m) {
	  fftw_real tmp13;
	  fftw_real tmp11;
	  fftw_real tmp12;
	  fftw_real tmp21;
	  fftw_real tmp14;
	  fftw_real tmp22;
	  fftw_real tmp1;
	  fftw_real tmp3;
	  fftw_real tmp17;
	  fftw_real tmp5;
	  fftw_real tmp18;
	  fftw_real tmp19;
	  fftw_real tmp7;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp10;
	       fftw_real tmp6;
	       fftw_real tmp2;
	       fftw_real tmp4;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp10 = Y[-iostride];
	       tmp13 = Y[-2 * iostride];
	       tmp11 = Y[0];
	       tmp12 = tmp10 + tmp11;
	       tmp21 = tmp10 - tmp11;
	       tmp14 = tmp10 + tmp13;
	       tmp22 = tmp10 - tmp13;
	       tmp1 = X[0];
	       tmp6 = X[3 * iostride];
	       tmp2 = X[iostride];
	       tmp4 = X[2 * iostride];
	       tmp3 = tmp1 + tmp2;
	       tmp17 = tmp2 - tmp1;
	       tmp5 = tmp2 + tmp4;
	       tmp18 = tmp4 - tmp2;
	       tmp19 = tmp6 - tmp4;
	       tmp7 = tmp4 + tmp6;
	  }
	  X[0] = tmp1 + tmp3 + tmp5 + tmp7;
	  {
	       fftw_real tmp36;
	       fftw_real tmp39;
	       fftw_real tmp38;
	       fftw_real tmp35;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp36 = (K781831482 * tmp14) - (K974927912 * tmp13) - (K433883739 * tmp12);
	       tmp39 = tmp11 + (K222520933 * tmp13) - (K623489801 * tmp22) - (K900968867 * tmp21);
	       tmp38 = (K433883739 * tmp17) + (K974927912 * tmp19) - (K781831482 * tmp18);
	       tmp35 = tmp1 + (K623489801 * tmp5) - (K222520933 * tmp7) - (K900968867 * tmp3);
	       {
		    fftw_real tmp34;
		    fftw_real tmp37;
		    fftw_real tmp40;
		    fftw_real tmp41;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp34 = c_re(W[2]);
		    tmp37 = c_im(W[2]);
		    X[3 * iostride] = (tmp34 * (tmp35 + tmp36)) + (tmp37 * (tmp38 + tmp39));
		    tmp40 = c_re(W[3]);
		    tmp41 = c_im(W[3]);
		    X[4 * iostride] = (tmp40 * (tmp35 - tmp36)) + (tmp41 * (tmp39 - tmp38));
	       }
	  }
	  {
	       fftw_real tmp15;
	       fftw_real tmp23;
	       fftw_real tmp20;
	       fftw_real tmp9;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp15 = (K781831482 * tmp12) + (K974927912 * tmp14) + (K433883739 * tmp13);
	       tmp23 = (K623489801 * tmp21) + tmp11 + (K222520933 * tmp22) + (K900968867 * tmp13);
	       tmp20 = (K781831482 * tmp17) + (K974927912 * tmp18) + (K433883739 * tmp19);
	       tmp9 = tmp1 + (K623489801 * tmp3) - (K900968867 * tmp7) - (K222520933 * tmp5);
	       {
		    fftw_real tmp8;
		    fftw_real tmp16;
		    fftw_real tmp24;
		    fftw_real tmp25;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp8 = c_re(W[0]);
		    tmp16 = c_im(W[0]);
		    X[iostride] = (tmp8 * (tmp9 - tmp15)) + (tmp16 * (tmp20 + tmp23));
		    tmp24 = c_re(W[5]);
		    tmp25 = c_im(W[5]);
		    X[6 * iostride] = (tmp24 * (tmp9 + tmp15)) + (tmp25 * (tmp23 - tmp20));
	       }
	  }
	  {
	       fftw_real tmp28;
	       fftw_real tmp31;
	       fftw_real tmp27;
	       fftw_real tmp30;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp28 = (K974927912 * tmp17) - (K781831482 * tmp19) - (K433883739 * tmp18);
	       tmp31 = (K433883739 * tmp14) + (K781831482 * tmp13) - (K974927912 * tmp12);
	       tmp27 = tmp11 + (K900968867 * tmp22) - (K623489801 * tmp13) - (K222520933 * tmp21);
	       tmp30 = tmp1 + (K623489801 * tmp7) - (K900968867 * tmp5) - (K222520933 * tmp3);
	       {
		    fftw_real tmp26;
		    fftw_real tmp29;
		    fftw_real tmp32;
		    fftw_real tmp33;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp26 = c_im(W[4]);
		    tmp29 = c_re(W[4]);
		    X[5 * iostride] = (tmp26 * (tmp27 - tmp28)) + (tmp29 * (tmp30 - tmp31));
		    tmp32 = c_im(W[1]);
		    tmp33 = c_re(W[1]);
		    X[2 * iostride] = (tmp32 * (tmp28 + tmp27)) + (tmp33 * (tmp30 + tmp31));
	       }
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6};
fftw_codelet_desc fftw_hc2hc_backward_7_desc =
{
     "fftw_hc2hc_backward_7",
     (void (*)()) fftw_hc2hc_backward_7,
     7,
     FFTW_BACKWARD,
     FFTW_HC2HC,
     123,
     6,
     twiddle_order,
};
