/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:41 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 2 */

/*
 * This function contains 9 FP additions, 6 FP multiplications,
 * (or, 6 additions, 3 multiplications, 3 fused multiply/add),
 * 11 stack variables, and 16 memory accesses
 */

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_2(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (2 * iostride);
     {
	  fftw_real tmp13;
	  fftw_real tmp14;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp13 = X[0];
	  tmp14 = X[iostride];
	  X[iostride] = tmp13 - tmp14;
	  X[0] = tmp13 + tmp14;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 1) {
	  fftw_real tmp5;
	  fftw_real tmp11;
	  fftw_real tmp10;
	  fftw_real tmp12;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp5 = X[0];
	  tmp11 = Y[-iostride];
	  {
	       fftw_real tmp7;
	       fftw_real tmp9;
	       fftw_real tmp6;
	       fftw_real tmp8;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp7 = X[iostride];
	       tmp9 = Y[0];
	       tmp6 = c_re(W[0]);
	       tmp8 = c_im(W[0]);
	       tmp10 = (tmp6 * tmp7) - (tmp8 * tmp9);
	       tmp12 = (tmp8 * tmp7) + (tmp6 * tmp9);
	  }
	  Y[-iostride] = tmp5 - tmp10;
	  X[0] = tmp5 + tmp10;
	  X[iostride] = -(tmp11 - tmp12);
	  Y[0] = tmp12 + tmp11;
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp3;
	  fftw_real tmp4;
	  fftw_real tmp2;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  tmp3 = X[iostride];
	  tmp4 = c_im(W[0]);
	  Y[0] = tmp4 * tmp3;
	  tmp2 = c_re(W[0]);
	  X[0] = tmp1 + (tmp2 * tmp3);
     }
}

static const int twiddle_order[] =
{1};
fftw_codelet_desc fftw_hc2hc_forward_2_desc =
{
     "fftw_hc2hc_forward_2",
     (void (*)()) fftw_hc2hc_forward_2,
     2,
     FFTW_FORWARD,
     FFTW_HC2HC,
     35,
     1,
     twiddle_order,
};
