/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:42 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 6 */

/*
 * This function contains 88 FP additions, 50 FP multiplications,
 * (or, 72 additions, 34 multiplications, 16 fused multiply/add),
 * 30 stack variables, and 48 memory accesses
 */
static const fftw_real K500000000 = FFTW_KONST(+0.500000000000000000000000000000000000000000000);
static const fftw_real K866025403 = FFTW_KONST(+0.866025403784438646763723170752936183471402627);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_6(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (6 * iostride);
     {
	  fftw_real tmp96;
	  fftw_real tmp106;
	  fftw_real tmp102;
	  fftw_real tmp104;
	  fftw_real tmp99;
	  fftw_real tmp105;
	  fftw_real tmp94;
	  fftw_real tmp95;
	  fftw_real tmp103;
	  fftw_real tmp107;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp94 = X[0];
	  tmp95 = X[3 * iostride];
	  tmp96 = tmp94 - tmp95;
	  tmp106 = tmp94 + tmp95;
	  {
	       fftw_real tmp100;
	       fftw_real tmp101;
	       fftw_real tmp97;
	       fftw_real tmp98;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp100 = X[4 * iostride];
	       tmp101 = X[iostride];
	       tmp102 = tmp100 - tmp101;
	       tmp104 = tmp100 + tmp101;
	       tmp97 = X[2 * iostride];
	       tmp98 = X[5 * iostride];
	       tmp99 = tmp97 - tmp98;
	       tmp105 = tmp97 + tmp98;
	  }
	  Y[-iostride] = K866025403 * (tmp102 - tmp99);
	  tmp103 = tmp99 + tmp102;
	  X[iostride] = tmp96 - (K500000000 * tmp103);
	  X[3 * iostride] = tmp96 + tmp103;
	  Y[-2 * iostride] = -(K866025403 * (tmp104 - tmp105));
	  tmp107 = tmp105 + tmp104;
	  X[2 * iostride] = tmp106 - (K500000000 * tmp107);
	  X[0] = tmp106 + tmp107;
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 5) {
	  fftw_real tmp44;
	  fftw_real tmp68;
	  fftw_real tmp87;
	  fftw_real tmp91;
	  fftw_real tmp66;
	  fftw_real tmp70;
	  fftw_real tmp78;
	  fftw_real tmp82;
	  fftw_real tmp55;
	  fftw_real tmp69;
	  fftw_real tmp75;
	  fftw_real tmp81;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp38;
	       fftw_real tmp86;
	       fftw_real tmp43;
	       fftw_real tmp85;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp38 = X[0];
	       tmp86 = Y[-5 * iostride];
	       {
		    fftw_real tmp40;
		    fftw_real tmp42;
		    fftw_real tmp39;
		    fftw_real tmp41;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp40 = X[3 * iostride];
		    tmp42 = Y[-2 * iostride];
		    tmp39 = c_re(W[2]);
		    tmp41 = c_im(W[2]);
		    tmp43 = (tmp39 * tmp40) - (tmp41 * tmp42);
		    tmp85 = (tmp41 * tmp40) + (tmp39 * tmp42);
	       }
	       tmp44 = tmp38 - tmp43;
	       tmp68 = tmp38 + tmp43;
	       tmp87 = tmp85 + tmp86;
	       tmp91 = tmp86 - tmp85;
	  }
	  {
	       fftw_real tmp60;
	       fftw_real tmp76;
	       fftw_real tmp65;
	       fftw_real tmp77;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp57;
		    fftw_real tmp59;
		    fftw_real tmp56;
		    fftw_real tmp58;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp57 = X[4 * iostride];
		    tmp59 = Y[-iostride];
		    tmp56 = c_re(W[3]);
		    tmp58 = c_im(W[3]);
		    tmp60 = (tmp56 * tmp57) - (tmp58 * tmp59);
		    tmp76 = (tmp58 * tmp57) + (tmp56 * tmp59);
	       }
	       {
		    fftw_real tmp62;
		    fftw_real tmp64;
		    fftw_real tmp61;
		    fftw_real tmp63;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp62 = X[iostride];
		    tmp64 = Y[-4 * iostride];
		    tmp61 = c_re(W[0]);
		    tmp63 = c_im(W[0]);
		    tmp65 = (tmp61 * tmp62) - (tmp63 * tmp64);
		    tmp77 = (tmp63 * tmp62) + (tmp61 * tmp64);
	       }
	       tmp66 = tmp60 - tmp65;
	       tmp70 = tmp60 + tmp65;
	       tmp78 = tmp76 + tmp77;
	       tmp82 = tmp76 - tmp77;
	  }
	  {
	       fftw_real tmp49;
	       fftw_real tmp73;
	       fftw_real tmp54;
	       fftw_real tmp74;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp46;
		    fftw_real tmp48;
		    fftw_real tmp45;
		    fftw_real tmp47;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp46 = X[2 * iostride];
		    tmp48 = Y[-3 * iostride];
		    tmp45 = c_re(W[1]);
		    tmp47 = c_im(W[1]);
		    tmp49 = (tmp45 * tmp46) - (tmp47 * tmp48);
		    tmp73 = (tmp47 * tmp46) + (tmp45 * tmp48);
	       }
	       {
		    fftw_real tmp51;
		    fftw_real tmp53;
		    fftw_real tmp50;
		    fftw_real tmp52;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp51 = X[5 * iostride];
		    tmp53 = Y[0];
		    tmp50 = c_re(W[4]);
		    tmp52 = c_im(W[4]);
		    tmp54 = (tmp50 * tmp51) - (tmp52 * tmp53);
		    tmp74 = (tmp52 * tmp51) + (tmp50 * tmp53);
	       }
	       tmp55 = tmp49 - tmp54;
	       tmp69 = tmp49 + tmp54;
	       tmp75 = tmp73 + tmp74;
	       tmp81 = tmp73 - tmp74;
	  }
	  {
	       fftw_real tmp83;
	       fftw_real tmp67;
	       fftw_real tmp80;
	       fftw_real tmp93;
	       fftw_real tmp90;
	       fftw_real tmp92;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp83 = K866025403 * (tmp81 - tmp82);
	       tmp67 = tmp55 + tmp66;
	       tmp80 = tmp44 - (K500000000 * tmp67);
	       Y[-3 * iostride] = tmp44 + tmp67;
	       X[iostride] = tmp80 + tmp83;
	       Y[-5 * iostride] = tmp80 - tmp83;
	       tmp93 = K866025403 * (tmp66 - tmp55);
	       tmp90 = tmp81 + tmp82;
	       tmp92 = tmp91 - (K500000000 * tmp90);
	       X[3 * iostride] = -(tmp90 + tmp91);
	       Y[-iostride] = tmp93 + tmp92;
	       X[5 * iostride] = -(tmp92 - tmp93);
	  }
	  {
	       fftw_real tmp79;
	       fftw_real tmp71;
	       fftw_real tmp72;
	       fftw_real tmp88;
	       fftw_real tmp84;
	       fftw_real tmp89;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp79 = K866025403 * (tmp75 - tmp78);
	       tmp71 = tmp69 + tmp70;
	       tmp72 = tmp68 - (K500000000 * tmp71);
	       X[0] = tmp68 + tmp71;
	       Y[-4 * iostride] = tmp72 + tmp79;
	       X[2 * iostride] = tmp72 - tmp79;
	       tmp88 = K866025403 * (tmp70 - tmp69);
	       tmp84 = tmp75 + tmp78;
	       tmp89 = tmp87 - (K500000000 * tmp84);
	       Y[0] = tmp84 + tmp87;
	       Y[-2 * iostride] = tmp89 - tmp88;
	       X[4 * iostride] = -(tmp88 + tmp89);
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp15;
	  fftw_real tmp29;
	  fftw_real tmp18;
	  fftw_real tmp31;
	  fftw_real tmp19;
	  fftw_real tmp32;
	  fftw_real tmp4;
	  fftw_real tmp22;
	  fftw_real tmp8;
	  fftw_real tmp24;
	  fftw_real tmp11;
	  fftw_real tmp26;
	  fftw_real tmp12;
	  fftw_real tmp27;
	  fftw_real tmp3;
	  fftw_real tmp2;
	  fftw_real tmp21;
	  fftw_real tmp33;
	  fftw_real tmp5;
	  fftw_real tmp20;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  {
	       fftw_real tmp14;
	       fftw_real tmp13;
	       fftw_real tmp28;
	       fftw_real tmp17;
	       fftw_real tmp16;
	       fftw_real tmp30;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp14 = X[4 * iostride];
	       tmp13 = c_re(W[3]);
	       tmp15 = tmp13 * tmp14;
	       tmp28 = c_im(W[3]);
	       tmp29 = tmp28 * tmp14;
	       tmp17 = X[iostride];
	       tmp16 = c_re(W[0]);
	       tmp18 = tmp16 * tmp17;
	       tmp30 = c_im(W[0]);
	       tmp31 = tmp30 * tmp17;
	  }
	  tmp19 = tmp15 + tmp18;
	  tmp32 = tmp29 + tmp31;
	  tmp3 = X[3 * iostride];
	  tmp2 = c_re(W[2]);
	  tmp4 = tmp2 * tmp3;
	  tmp21 = c_im(W[2]);
	  tmp22 = tmp21 * tmp3;
	  {
	       fftw_real tmp7;
	       fftw_real tmp6;
	       fftw_real tmp23;
	       fftw_real tmp10;
	       fftw_real tmp9;
	       fftw_real tmp25;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp7 = X[2 * iostride];
	       tmp6 = c_re(W[1]);
	       tmp8 = tmp6 * tmp7;
	       tmp23 = c_im(W[1]);
	       tmp24 = tmp23 * tmp7;
	       tmp10 = X[5 * iostride];
	       tmp9 = c_re(W[4]);
	       tmp11 = tmp9 * tmp10;
	       tmp25 = c_im(W[4]);
	       tmp26 = tmp25 * tmp10;
	  }
	  tmp12 = tmp8 + tmp11;
	  tmp27 = tmp24 + tmp26;
	  tmp33 = tmp27 + tmp32;
	  Y[0] = tmp22 + tmp33;
	  Y[-2 * iostride] = tmp22 - (K500000000 * tmp33) - (K866025403 * (tmp19 - tmp12));
	  tmp5 = tmp1 + tmp4;
	  tmp20 = tmp12 + tmp19;
	  X[0] = tmp5 + tmp20;
	  X[2 * iostride] = tmp5 - (K866025403 * (tmp27 - tmp32)) - (K500000000 * tmp20);
	  {
	       fftw_real tmp34;
	       fftw_real tmp37;
	       fftw_real tmp35;
	       fftw_real tmp36;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp34 = tmp24 - tmp26;
	       tmp37 = tmp15 - tmp18;
	       tmp35 = tmp29 - tmp31;
	       tmp36 = tmp8 - tmp11;
	       Y[-iostride] = (K866025403 * (tmp37 - tmp36)) - (K500000000 * (tmp34 + tmp35)) - tmp22;
	       X[iostride] = tmp1 + (K866025403 * (tmp34 - tmp35)) - (K500000000 * (tmp36 + tmp37)) - tmp4;
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5};
fftw_codelet_desc fftw_hc2hc_forward_6_desc =
{
     "fftw_hc2hc_forward_6",
     (void (*)()) fftw_hc2hc_forward_6,
     6,
     FFTW_FORWARD,
     FFTW_HC2HC,
     99,
     5,
     twiddle_order,
};
