#!/bin/sh
#
#	fhist - file history and comparison tools
#	Copyright (C) 1993, 1994, 1998, 2000, 2003, 2004 Peter Miller;
#	All rights reserved.
#
#	This program is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
#
# MANIFEST: Test the fcomp -s option
#

work=/tmp/$$
PAGER=cat
export PAGER
LINES=24
export LINES
COLS=80
export COLS

fail()
{
	set +x
	echo FAILED test of the fcomp -s option 1>&2
	cd $here
	rm -rf $work
	exit 1
}
pass()
{
	set +x
	echo PASSED 1>&2
	cd $here
	rm -rf $work
	exit 0
}
trap "fail" 1 2 3 15

#
# use the built-in error messages
#
FHIST_MESSAGE_LIBRARY=$$work/no-such-dir
export FHIST_MESSAGE_LIBRARY
unset LANG
unset LANGUAGE

here=`pwd`
if test $? -ne 0 ; then exit 1; fi
mkdir $work
if test $? -ne 0 ; then exit 1; fi
cd $work
if test $? -ne 0 ; then fail; fi

if [ "$1" != "" ]; then bin=$here/$1/bin; else bin=$here/bin; fi

#
# test for deletion
#
cat > test.first << 'fubar'
one
two two
three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
two  two
four
five
six
seven
eight
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
FILE A: test.first
FILE B: test.second
TOTALS: 0 inserted  4 deleted  6 matched

******************** DELETE [A 1, B 1]:
one

******************** DELETE [A 3, B 2]:
three

******************** DELETE [A 9-10, B 7]:
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -s test.first test.second > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test for insertion
#
cat > test.first << 'fubar'
one
two
three three three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
one
two
three   three   three
four
five
six
six and a half
seven
eight
nine
ten
eleven
twelve
thirteen
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
FILE A: test.first
FILE B: test.second
TOTALS: 4 inserted  0 deleted  10 matched

******************** INSERT [A 7, B 7]:
six and a half

******************** INSERT [A 11, B 12-14]:
eleven
twelve
thirteen
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -s test.first test.second > test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# test for replace
#
cat > test.first << 'fubar'
one
two two
three
four
five
six
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.second << 'fubar'
one
two  two
three
ruof
evif
xis
seven
eight
nine
ten
fubar
if test $? -ne 0 ; then fail; fi
cat > test.ok << 'fubar'
FILE A: test.first
FILE B: test.second
TOTALS: 3 inserted  3 deleted  7 matched

******************** REPLACE [A 4-6, B 4-6]:
four
five
six
******************** WITH:
ruof
evif
xis
fubar
if test $? -ne 0 ; then fail; fi
$bin/fcomp -s test.first test.second -o test.out
if test $? -ne 0 ; then fail; fi
diff test.ok test.out
if test $? -ne 0 ; then fail; fi

#
# Only definite negatives are possible.
# The functionality exercised by this test appears to work,
# no other guarantees are made.
#
pass
