/*
   const.h
   
   for Final Battle
   
   By Mike Hufnagel and Bill Kendrick
   Previously modified: 12/5/95
   Last modified: 4/2/98
   
   Holds definitions of all constants for Final Battle.
*/


#ifndef CONST_H
#define CONST_H


/* -------------- USER DEFINABLE (TWEAKABLE) GAME VALUES ---------- */


/* MAXIMUM NUMBER OF SERVERS: */

#define SERV 4


/* NORMAL KEYBOARD COMMANDS: */

#define FIRE           ' '    /* Fire projectile */
#define WEAPON_SELECT  'S'    /* Select weapon */
#define RADAR_CLOAK    'C'    /* Cloak from radar */
#define TOTAL_CLOAK    'X'    /* Total cloak */
#define MESSAGE_START  'M'    /* Switch to message mode */
#define REPAIR         'R'    /* Auto-repair */
#define UNREPAIR       'U'    /* Unassign repair crew */
#define QUIT           'Q'    /* Abort from game */


/* KEYBOARD OPTIONS: */

#define DOWN_KEY 0  /* 0 to slow down on down arrow.
		       1 to reverse thrusters on down arrow. */


/* ARROW KEY CONSTS: */

#define KEY_UP 0
#define KEY_DOWN 1
#define KEY_LEFT 2
#define KEY_RIGHT 3


/* TIMING: */

#define EVENT_LOOP_RATIO 500   /* To make events go more often then output */
#define RADAR_WAIT 10          /* Update radar every N frames */
#define DAMAGE_TIME_INC 1000   /* Min. repair time (*1 if dam, *2 if dest) */
#define DAMAGE_TIME_RANGE 5000 /* Random extra time for repairs */
#define FPS_SPEED 100000       /* How many millisecs. to wait before
				  continuing with the game (keeps the
				  game's speed relatively constant). */


/* GAME OPTIONS: */

#define BEST_CLOAK 1          /* 1=do radar cloak if we can if you try to
				 do total cloak but don't have it. 0=don't */
#define REPLAY_ON_DEATH 1     /* Whether or not to reincarnate people */


/* MISCELLANEOUS: */

#define ERROR_VOLUME 75       /* Percent volume for XBell() on errors */
#define GOD "Message"         /* Sender-name for general comm. messages */
#define INITIAL_ENERGY 100000 /* amount of enery to start with. */
#define ENERGY_FACTOR 1000    /* number to multiply by to get amount of energy
				 gained. */
#define DRONE_HOMETIME_MAX 50  /* Max. time for drones to home in on you */
#define DRONE_FIRING_PROXIMITY 200 /* How close drones fire at you */
#define DEBRIS_DAMAGE 20      /* How low damage is before random
				 debris comes out */
#define RADAR_STATIC 2000     /* How many chunks of static to draw when
				 the radar window is messed up */
#define STOP_HOME_RANGE 200   /* How close you need to be to homing/auto-p.
				 location to stop homing */
#define BACKBUFFER 1          /* Set to 1 to use a backbuffer.  Set to 0
				 if you get "Bad Value" when trying to
				 "CreatePixmap"... */


/* UNIVERSE ATTRIBUTES: */

#define HEIGHT_OF_WORLD 2400  /* Size of the world... */
#define WIDTH_OF_WORLD 2400
#define WORLD_WRAP 0          /* Wrap at edge of world=1, stop=0 */


/* EVENT MASKS FOR THE WINDOWS: */

#define ACTION_EVENT_MASK (KeyPressMask | KeyReleaseMask | ExposureMask)
#define TITLE_EVENT_MASK (KeyPressMask | KeyReleaseMask | ExposureMask | \
			  ButtonPressMask)
#define RADAR_EVENT_MASK (KeyPressMask | KeyReleaseMask | ExposureMask | \
			  ButtonPressMask)
#define WEAPON_EVENT_MASK (KeyPressMask | KeyReleaseMask | ExposureMask | \
			   ButtonPressMask)
#define DAMAGE_EVENT_MASK (KeyPressMask | KeyReleaseMask | ExposureMask | \
			   ButtonPressMask)
#define UPGRADE_EVENT_MASK (KeyPressMask | KeyReleaseMask | ExposureMask | \
			    ButtonPressMask)
#define COMM_EVENT_MASK (KeyPressMask | KeyReleaseMask | ExposureMask | \
			 ButtonPressMask)


/* MAXIMUM THRUST (NORMAL, AND WITH UPGRADED SPEED): */

#define MAX_SPEED 16
#define SUPER_SPEED 24


/* MAXIMUM NUMBER OF OBJECTS: */

#define NUM_ASTEROIDS 150
#define NUM_DRONES 20
#define NUM_DEBRIS 100
#define NUM_DEADMAN 16
#define NUM_STARS 200
#define NUM_UPGRADES 50
#define NUM_WEAPONS 200


/* RANDOM CHANCES: */

#define CHANCE_OF_UPGRADE 2    /* about 1/2 the time when killing asteroids */
#define CHANCE_OF_WEAPON 2     /* about 1/2 the time out of upgrades */
#define CHANCE_OF_DAMAGE 8     /* 1/8 the time out of hits */
#define CHANCE_OF_CREWDEATH 10 /* 1/10 the time life support is damaged */
#define CHANCE_DRONENOTHOME 2  /* Doesn't decide to home 1/2 of the time */
#define CHANCE_DRONE_ROTATE 3  /* Doesn't always home towards you */
#define CHANCE_DRONE_FIRE 10   /* Shoots one 1/10th of the time */
#define CHANCE_OF_DEBRIS 3     /* about 1/3 the time you're really damaged */


/* MESSAGE AND NAME SIZES: */

#define NUM_MESSAGES 7         /* Number of messages in the comm. window */
#define MAX_MESG_SIZE 40       /* Maximum message size */
#define MAX_NAME_SIZE 10       /* Maximum user(ship)name size */
#define ACTION_WIN_MESSAGE_LENGTH 100 /* How many frames for action window
					 messages to stick around */

static char * message_colors[NUM_MESSAGES] = {"dim gray",
					      "slate gray",
					      "light slate gray",
					      "gray",
					      "light gray",
					      "gray87",
					      "white"};

static char * message_highlight_color = {"yellow"};


/* WORMHOLE VALUES: */

#define CHANCE_OF_WORMHOLE 700 /* How often the wormhole pops up*/
#define WORMHOLESIZE 100       /* Size (in radius) of the wormhole graphic */
#define WORMHOLESPEED 6        /* Maximum speed of the wormhole to move */
#define WORMHOLERANGE 500      /* Maximum time wormhole will be around */


/* -------------- INTERNAL GAME VALUES ---------- */

/* DAMAGE STATES: */

#define OK 0
#define DAMAGED 1
#define DESTROYED 2
#define UNIQUE_DAMAGE_STATES 3

static char *damage_name_strings[UNIQUE_DAMAGE_STATES] = {
  "ok           ",
  "DAMAGED!!    ",
  "DESTROYED!!! "
};


/* COLORS: */

#define EXPLODE_COLORS 3       /* Number of explosion colors */
#define STAR_COLORS 3          /* Number of star colors */

static char *explode_colors[EXPLODE_COLORS] = {
  "red",
  "orange red",
  "orange"
};

static char *star_colors[STAR_COLORS] = {
  "white",
  "red",
  "blue"
};

static char *damage_colors[UNIQUE_DAMAGE_STATES] = {
  "white",   /* ok */
  "orange",  /* damaged */
  "red"      /* destroyed */
};

static char *weapon_colors[2] = {
  "navy blue",      /* no weapons */
  "light sky blue"  /* some weapons */
};

static char *upgrade_colors[2] = {
  "blue",           /* no upgrade */
  "light sky blue"  /* some upgrade */
};

#define hilight_color    "pale green"
#define middle_color     "dark green"
#define shadow_color     "black"

#define ASTEROID_COLOR   "brown"
#define SHIP_COLOR       "blue"
#define DRONE_COLOR      "purple"
#define UPGRADE_COLOR    "light blue"
#define RADAR_FORE_COLOR "medium aquamarine"
#define RADAR_BACK_COLOR "dark slate grey"


/* WEAPONS: */

#define STANDARD 0
#define TWO_WAY 1
#define FOUR_WAY 2
#define EIGHT_WAY 3
#define MISSILE 4
#define HOMING_MISSILE 5
#define TWO_SPLIT 6
#define THREE_SPLIT 7
#define UNIQUE_WEAPONS 8

static char *weapon_name_strings[UNIQUE_WEAPONS] = {
  "Standard",
  "Two-Way",
  "Four-Way",
  "Eight-Way",
  "Missile",
  "Homing-Missile",
  "Two-Split",
  "Three-Split"
};


/* SPECIAL VALUES FOR NUMBER OF WEAPONS AND WEAPON CHOOSEN */

#define NONE -1
#define UNLIMITED -1


/* ATTRIBUTES OF THE DIFFERENT WEAPONS: */

static int num_to_shoot[UNIQUE_WEAPONS] = {1, 2, 4, 8, 1, 1, 2, 3};
static int range_of_weapon[UNIQUE_WEAPONS] = {30, 20, 10, 10, 100, 100, 20,
					      30};
static int weapon_energy_consumption[UNIQUE_WEAPONS] = {100, 200, 300,
							400, 100, 100,
							150, 200};


/* UPGRADES: */

#define UPGRADE_ARMOR 0
#define UPGRADE_SHIELDS 1
#define UPGRADE_CLOAK 2
#define UPGRADE_TOTALCLOAK 3
#define UPGRADE_CLOAKRADAR 4
#define UPGRADE_WARP 5
#define UPGRADE_HOME 6
#define UPGRADE_AUTO 7
#define UPGRADE_SPEED 8
#define UPGRADE_ENERGY 9
#define UPGRADE_WEAPON 10               /* Weapons must always be last... */
#define UNIQUE_UPGRADES 11

static char *upgrade_name_strings[UNIQUE_UPGRADES - 1] = {
  "Armor",
  "Shields",
  "Cloak",
  "Total-Cloak",
  "Cloak-Radar",
  "Warp",
  "Homing",
  "Auto-Pilot",
  "Speed",
  "Energy"
};

static char *upgrade_help_strings[UNIQUE_UPGRADES] = {
  "",
  "",
  "Use C to Cloak",
  "Use X to Total-Clock",
  "(Automatic)",
  "Click in Radar to Warp",
  "Click in Radar to Home",
  "Click in Radar to Auto-Pilot",
  "",
  "",
  "Use S to Select"
};

#define NUM_SHOWN_UPGRADES 7

static int upgradenums[NUM_SHOWN_UPGRADES] = {
  UPGRADE_CLOAK, UPGRADE_TOTALCLOAK,
  UPGRADE_CLOAKRADAR, UPGRADE_WARP,
  UPGRADE_HOME, UPGRADE_AUTO,
  UPGRADE_SPEED
};


/* DAMAGABLE SHIP COMPONENTS: */

#define DAM_ENGINE 0
#define DAM_THRUST 1
#define DAM_RADAR 2
#define DAM_LIFE 3
#define DAM_WEAPONS 4
#define UNIQUE_DAMAGABLES 5

static char *damagable_name_strings[UNIQUE_DAMAGABLES] = {
  "Engine",
  "Thrusters",
  "Radar",
  "Life Support",
  "Weapons"
};

static char *damage_help_string = {
  "Press R to repair, or click in Damage Window"};


/* HOMING MODES: */

#define HOME_NONE 0
#define HOME_AUTO 1
#define HOME_HOMING 2


/* CLOAK MODES: */

#define CLOAK_NONE 0
#define CLOAK_NORMAL 1
#define CLOAK_TOTAL 2


#define VISUAL (Visual *)CopyFromParent  /* Always use parent's visual... */


/* TABLE DETERMINING HOW TO CHANGE MOMENTUM BASED ON YOUR DIRECTION:
   (going clockwise: 0 is up, 4 is right, 8 is down, 12 is left) */

static int xmove[16] = {0, 1, 2, 2, 2, 2, 2, 1, 0, -1, -2, -2, -2, -2, -2, -1};
static int ymove[16] = {-2, -2, -2, -1, 0, 1, 2, 2, 2, 2, 2, 1, 0, -1, -2, -2};

#endif /* CONST_H */
