/*
   final.c:  "FINAL BATTLE"
   
   By Mike Hufnagel (hufnagel@zippy.sonoma.edu)
   & Bill Kendrick (kendrick@zippy.sonoma.edu)
   
   CS 495 Fall 1995
   Special Studies final project: Multiuser realtime application in X.
   
   Advisor: Dr. David Butcher (dbutcher@sonoma.edu)
   
   Version 0.0  First release
   
   Original code: October 18, 1995 - December 6, 1995
   Last change: April 2, 1998
*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>
#include "actionwin.h"
#include "commwin.h"
#include "const.h"
#include "event.h"
#include "glovar.h"
#include "misc.h"
#include "movement.h"
#include "radarwin.h"
#include "setup.h"
#include "types.h"


int main(int argc, char *argv[])
{
  int done = 0;                     /* "Game is done, let's quit" flag */
  int anyexist;                     /* ... and "Any players at all?" flag */
  int i;                            /* Counters */
  int pln;                          /* player number */
  int radar_count = 0;              /* Counter for N-frame radar update */
  int found;                        /* Search-and-destroy flag */
  int num_players;                  /* How many players are there? */
  char str[100];                    /* Temp string */
  struct timeval tp_now, tp_then;   /* Time buffers */
  long time_padding;
  
  
  /* Parse command line and do setup stuff */
  
  setup(argc, argv);
  
  
  /* Welcome everyone */  
  
  message_all("Welcome", "'Final Battle' version 0.0.");
  message_all("", "by Mike Hufnagel and Bill Kendrick, 1995-1998");
  
  
  /* Main game loop: */
  
  while (!done)
    {
      gettimeofday(&tp_then, NULL);
      
      
      /* Generic stuff: */
      
      anyexist = 0;                    /* Might be no players left */
      radar_count++;                   /* For radar update */
      if (radar_count == RADAR_WAIT)
	radar_count = 0;               /* Time to update */
      toggle = 1 - toggle;             /* Toggle the toggle flag: */
      
      
      /* Global (non-player) stuff */
      
      moveweapon();
      moveasteroid();
      movedrone();
      moveupgrades();
      movedebris();
      movedeadman();
      movewormhole();
      
      
      /* Count how many players there are: */
      
      num_players = 0;
      
      for (pln = 0; pln < SERV; pln++)
	{
	  if (player[pln].exist)
	    num_players++;
	}
      
      
      /* Local (player) stuff */

      for (pln = 0; pln < SERV; pln++)
	{
	  for (i = 0; i < EVENT_LOOP_RATIO / num_players; i++)
	    {
	      /* If the server is still in the game... */
	      
	      if (player[pln].exist)
		{
		  /* Get an event from them, if any: */
		  
		  if (XPending(display[pln]))
		    {
		      XNextEvent(display[pln], &event);
		      whichwin = event.xany.window;
		      
		      if (event.type == KeyPress)
			{
			  /* Keyboard events */
			  
			  kbd_event(pln);
			}
		      else if (event.type == KeyRelease)
			{
			  /* Arrow key release? */
			  
			  kbd_release(pln);
			}
		      else if (event.type == ButtonPress)
			{
			  /* Mouse events */

			  button_event(pln, whichwin, event.xbutton.x,
				       event.xbutton.y, event.xbutton.button);
			}
		      else if (event.type == Expose)
			{
			  /* Expose events */
			  
			  expose_event(pln, whichwin);
			}
		      else if (event.type == MapNotify)
			{
			  /* Map events */
			  
			  map_event(pln);
			}
		      else if (event.type == ClientMessage)
			{
			  /* Client message */			  
			  
			  client_event(pln);
			}
		      else if (event.type == ConfigureNotify)
			{
			  /* Configure event (window structure change) */
			  
			  configure_event(pln, whichwin,
					  event.xconfigure.width,
					  event.xconfigure.height);
			}
		    }
		}
	    }
	  
	  
	  keep_handling_keyboard_control(pln);
	  
	  
	  /* If they still exist, now do some control and output... */
	  
	  if (player[pln].exist)
	    {
	      /* Don't quit yet - someone's still playing! */
	      
	      anyexist = 1;
	      
	      
	      /* Move the current player */
	      
	      moveship(pln);
	      
	      
	      /* Check for collision with objects */
	      
	      collision(pln);
	      
	      
	      /* Update damage repair... */
	      
	      for (i = 0; i < UNIQUE_DAMAGABLES; i++)
		{
		  /* If it's fixed, stop fixing it! */
		  
		  if ((player[pln].damage[i] == OK) &&
		      (player[pln].crew_working[i] != 0))
		    {
		      /* Free the crew working on it: */
		      
		      player[pln].crew_free = player[pln].crew_free +
			player[pln].crew_working[i];
		      player[pln].crew_working[i] = 0;
		      
		      
		      /* Tell the player it's fixed: */
		      
		      sprintf(str, "%s is fixed.", damagable_name_strings[i]);
		      message(pln, GOD, str);
		      updatedamagewin(pln);
		    }
		  else
		    {
		      /* Slowly fix things: */
		      
		      player[pln].damagetime[i] = player[pln].damagetime[i] -
			player[pln].crew_working[i];
		      
		      if (player[pln].damagetime[i] <= 0)
			{
			  player[pln].damage[i] = OK;
			}
		    }
		}
	      
	      
	      /* Update this user's constantly-updated windows */
	      
	      drawactionwin(pln);
	      
	      if (BACKBUFFER)
		XCopyArea(display[pln],
			  actionwin[pln], realactionwin[pln],
			  realactiongc[pln], 0, 0,
			  actiongeom[pln].w, actiongeom[pln].h, 0, 0);
	      
	      if (radar_count == 0)
		drawradar(pln);
	      
	      updatedefense(pln);
	      
	      
	      /* Eat energy: */
	      
	      player[pln].energy--;
	      
	      if (player[pln].energy <= 0)
		kill(pln, 0, 0, "energy was depleted!");
	      
	      if (player[pln].energy <= 2000 && player[pln].energylow == 0)
		{
		  player[pln].energylow = 1;
		  actionmessage(pln, "ENERGY LOW!");
		}
	      
	      
	      /* Spit out debris if you're damaged: */
	      
	      if (player[pln].armor < DEBRIS_DAMAGE &&
		  rndm(CHANCE_OF_DEBRIS) < 1)
		{
		  add_debris(player[pln].x, player[pln].y,
			     xmove[(player[pln].dir + 8)% 16],
			     ymove[(player[pln].dir + 8)% 16]);
		}
	      
	      
	      /* Eat crew members (if life support is down) */
	      
	      if (((player[pln].damage[DAM_LIFE] == DESTROYED) ||
		   (player[pln].damage[DAM_LIFE] == DAMAGED) &&
		   (rndm(10) < 5)) && rndm(CHANCE_OF_CREWDEATH) < 1)
		{
		  if (player[pln].crew_free > 0)
		    {
		      /* Kill some free crewman: */
		      
		      player[pln].crew_free--;
		    }
		  else
		    {
		      /* Kill some working crewman, if there ARE any:  */
		      
		      found = 0;
		      
		      for (i = 0; i < UNIQUE_DAMAGABLES; i++)
			{
			  if (player[pln].crew_working[i] != 0)
			    found = 1;
			}
		      
		      /* So there is one, let's kill one: */
		      
		      if (found == 1)
			{
			  found = 0;
			  
			  /* Pick a random damaged thing, until we find a
			     crewman to kill: */
			  
			  do
			    {
			      i = rndm(UNIQUE_DAMAGABLES);
			      
			      if (player[pln].crew_working[i] != 0)
				{
				  player[pln].crew_working[i]--;
				  found = 1;
				}
			    }
			  while (found == 0);
			}
		      else
			{
			  kill(pln, 0, 0, "crew is dead!");
			}
		    }
		  
		  add_deadman(player[pln].x, player[pln].y);
		  
		  updatedamagewin(pln);
		}
	    }
	}
      
      
      gettimeofday(&tp_now, NULL);
      
      time_padding = FPS_SPEED - ((tp_now.tv_sec - tp_then.tv_sec) *
				  1000000 +
				  (tp_now.tv_usec - tp_then.tv_usec));
      
      if (time_padding > 0)
	usleep(time_padding);
      
      
      /* No more players?  Bye! */
      
      if (!anyexist)
	done = 1;
    } /* (while !done) */
  
  
  /* Close everyone up */
  
  for (pln = 0; pln < SERV; pln++)
    {
      if (player[pln].exist)
	disconnect(pln);
    }
  
  printf("Game over!\n");
  printf("Thanks for playing!\n\n");
  
  exit(0);
}
