/*
  graphics.c
  
  For Final Battle

  By Mike Hufnagel and Bill Kendrick
  Previously modified: 12/6/95
  Last modified: 4/2/98
*/

#include "graphics.h"
#include "const.h"
#include "glovar.h"
#include "types.h"
#include <stdio.h>


void drawship(int pln, int opln)
{
  int x, y;           /* Position */

  
  /* Determine position of other player relative to ours */
  
  x = player[opln].x - player[pln].x + actiongeom[pln].w / 2;
  y = player[opln].y - player[pln].y + actiongeom[pln].h / 2;
  
  
  /* If it's within our window, let's draw it! */
  
  if (x >= -32 && y >= -32 && x <= actiongeom[pln].w && y <= actiongeom[pln].h)
    {
      /* Only show if it's uncloaked (or it's you) */
      
      if ((player[opln].cloaked != CLOAK_TOTAL) ||
	  (opln == pln && toggle == 0))
	{
	  XSetClipMask(display[pln], actiongc_ship[pln],
		       shipbitmasks[pln][opln][player[opln].dir]);
	  
	  XSetClipOrigin(display[pln], actiongc_ship[pln], x, y);
	  
	  drawbitmap(display[pln], actionwin[pln], actiongc_ship[pln], x, y,
		     shipbitmaps[pln][opln][player[opln].dir]);
	  drawtext(display[pln], actionwin[pln], actiongc_white[pln],
		   x, y + fh[pln] + 32, name[opln]);
	  drawtext(display[pln], actionwin[pln], actiongc_white[pln],
		   x, y + fh[pln] * 2 + 32, arrow_key[opln]);
	  
	  
	  /* Draw shields (if they have any): */
	  
	  if (player[opln].shields != 0)
	    {
	      XDrawArc(display[pln], actionwin[pln], actiongc_white[pln],
		       x - toggle * 5, y - toggle * 5, 
		       32 + toggle * 10, 32 + toggle * 10,
		       0, 360 * 64);
	    }
	}
    }
}


void drawweapon(int pln, int weap)
{
  int x, y;     /* Position */
  
  
  /* Determine position of the weapon relative to us */
  
  x = weapons[weap].x - player[pln].x + actiongeom[pln].w / 2;
  y = weapons[weap].y - player[pln].y + actiongeom[pln].h / 2;
  
  
  /* If it's within our window, let's draw it! */
  
  if (x >= 0 && y >= 0 && x <= actiongeom[pln].w && y <= actiongeom[pln].h)
    {
      if (weapons[weap].type != MISSILE &&
	  weapons[weap].type != HOMING_MISSILE)
	{
	  /* Draw a ball for all weapons except missile and homing missile: */
	  
	  XFillArc(display[pln], actionwin[pln], actiongc_white[pln],
		   x - 3, y - 3, 6, 6, 0, (360*64));
	}
      else
	{
	  /* Draw a line for missile and homing missile: */
	  
	  XDrawLine(display[pln], actionwin[pln], actiongc_white[pln],
		    x, y, x + weapons[weap].xm / 2, y + weapons[weap].ym / 2);
	}
    }
}


void drawasteroid(int pln, int ast)
{
  int x, y;     /* Position */
  
  
  /* Determine position of asteroid relative to us */
  
  x = asteroid[ast].x - player[pln].x + actiongeom[pln].w / 2;
  y = asteroid[ast].y - player[pln].y + actiongeom[pln].h / 2;
  
  
  /* If it's within our window, let's draw it! */
  
  if (x >= -32 && y >= -32 && x <= actiongeom[pln].w && y <= actiongeom[pln].h)
    {
      XSetClipMask(display[pln], actiongc_asteroid[pln],
		   asteroidbitmasks[pln][asteroid[ast].rotation]);
      
      XSetClipOrigin(display[pln], actiongc_asteroid[pln], x, y);
      
      drawbitmap(display[pln], actionwin[pln], actiongc_asteroid[pln], x, y,
		 asteroidbitmaps[pln][asteroid[ast].rotation]);
    }
}


void drawdrone(int pln, int drn)
{
  int x, y;     /* Position */
  
  
  /* Determine position of asteroid relative to us */
  
  x = drone[drn].x - player[pln].x + actiongeom[pln].w / 2;
  y = drone[drn].y - player[pln].y + actiongeom[pln].h / 2;
  
  
  /* If it's within our window, let's draw it! */
  
  if (x >= -32 && y >= -32 && x <= actiongeom[pln].w && y <= actiongeom[pln].h)
    {
      XSetClipMask(display[pln], actiongc_drone[pln],
		   dronebitmasks[pln]);
      
      XSetClipOrigin(display[pln], actiongc_drone[pln], x, y);
      
      drawbitmap(display[pln], actionwin[pln], actiongc_drone[pln], x, y,
		 dronebitmaps[pln]);
    }
}


void drawupgrade(int pln, int upg)
{
  int x, y;                  /* Position */
  int weapon, rotation;      /* So we don't ref. the struct over and over... */
  int type;
  
  
  /* Determine position of upgrade relative to us (and other attribs): */
  
  x = upgrade[upg].x - player[pln].x + actiongeom[pln].w / 2;
  y = upgrade[upg].y - player[pln].y + actiongeom[pln].h / 2;
  type = upgrade[upg].type;
  weapon = upgrade[upg].weapon_num;
  rotation = upgrade[upg].rotation;
  
  
  /* If it's within our window, let's draw it! */
  
  if (x >= -32 && y >= -32 && x <= actiongeom[pln].w && y <= actiongeom[pln].h)
    {
      if (type == UPGRADE_WEAPON)
	{
	  /* Weapon */
	  
	  XSetClipMask(display[pln], actiongc_upgrade[pln],
		       weaponbitmasks[pln][weapon]);
	  
	  XSetClipOrigin(display[pln], actiongc_upgrade[pln], x, y);

	  drawbitmap(display[pln], actionwin[pln], actiongc_upgrade[pln], x, y,
		     weaponbitmaps[pln][weapon]);
	}
      else
	{
	  /* Normal upgrade (not a weapon) */
	  
	  XSetClipMask(display[pln], actiongc_upgrade[pln],
		       upgradebitmasks[pln][type][rotation]);
	  
	  XSetClipOrigin(display[pln], actiongc_upgrade[pln], x, y);
	  
	  drawbitmap(display[pln], actionwin[pln], actiongc_upgrade[pln], x, y,
		     upgradebitmaps[pln][type][rotation]);
	}
    } /* (if in our window) */
}


void drawstar(int pln, int str)
{
  int x, y;  /* Position */
  
  
  /* Determine position of star relative to us */

  x = star[str].x - player[pln].x + actiongeom[pln].w / 2;
  y = star[str].y - player[pln].y + actiongeom[pln].h / 2;
  
  
  /* If it's within our window, let's draw it! */
  
  if (x >= 0 && y >= 0 && x <= actiongeom[pln].w && y <= actiongeom[pln].h)
    XDrawPoint(display[pln], actionwin[pln],
	       actiongc_star[pln][star[str].color], x, y);
}


void drawdebris(int pln, int deb)
{
  int x, y;  /* Position */
  
  
  /* Determine position of star relative to us */
  
  x = debris[deb].x - player[pln].x + actiongeom[pln].w / 2;
  y = debris[deb].y - player[pln].y + actiongeom[pln].h / 2;
  
  
  /* If it's within our window, let's draw it! */
  
  if (x >= 0 && y >= 0 && x <= actiongeom[pln].w && y <= actiongeom[pln].h)
    {
      XDrawLine(display[pln], actionwin[pln],
		actiongc_explode[pln][debris[deb].color],
		x, y, x + debris[deb].xm, y + debris[deb].ym);
    }
}


void drawdeadman(int pln, int ded)
{
  int x, y;  /* Position */
  
  
  /* Determine position of star relative to us */
  
  x = deadman[ded].x - player[pln].x + actiongeom[pln].w / 2;
  y = deadman[ded].y - player[pln].y + actiongeom[pln].h / 2;
  
  
  /* If it's within our window, let's draw it! */
  
  if (x >= 0 && y >= 0 && x <= actiongeom[pln].w && y <= actiongeom[pln].h)
    {
      XDrawPoint(display[pln], actionwin[pln], actiongc_white[pln],
		 x - 1, y);
      XDrawPoint(display[pln], actionwin[pln], actiongc_white[pln],
		 x + 1, y);
      XDrawPoint(display[pln], actionwin[pln], actiongc_white[pln],
		 x, y);
      XDrawPoint(display[pln], actionwin[pln], actiongc_white[pln],
		 x, y - 1);
      XDrawPoint(display[pln], actionwin[pln], actiongc_white[pln],
		 x, y + 1);
      XDrawPoint(display[pln], actionwin[pln], actiongc_white[pln],
		 x - 1, y + 2);
      XDrawPoint(display[pln], actionwin[pln], actiongc_white[pln],
		 x + 1, y + 2);
    }
}


void drawbitmap(Display *display, Window w, GC gc, int x, int y, Pixmap b)
{
  XCopyPlane(display, b, w, gc, 0, 0, 32, 32, x, y, 1);
}


void drawwormhole(int pln)
{
  int x, y, r;
  
  
  /* Draw inlet: */
  
  x = wormhole.x - player[pln].x + actiongeom[pln].w / 2;
  y = wormhole.y - player[pln].y + actiongeom[pln].h / 2;
  
  r = (wormhole.range * 20) % WORMHOLESIZE;
  
  XDrawArc(display[pln], actionwin[pln], actiongc_white[pln],
	   x - r, y - r, r * 2, r * 2, 0, (360 * 64));
  
  r = WORMHOLESIZE; 
  
  XDrawArc(display[pln], actionwin[pln], actiongc_white[pln],
	   x - r, y - r, r * 2, r * 2, 0, (360 * 64));
  
  
  /* Draw outlet: */
  
  x = wormhole.warpx - player[pln].x + actiongeom[pln].w / 2;
  y = wormhole.warpy - player[pln].y + actiongeom[pln].h / 2;
  
  r = WORMHOLESIZE - (wormhole.range * 10) % WORMHOLESIZE;
  
  XDrawArc(display[pln], actionwin[pln], actiongc_white[pln],
	   x - r, y - r, r * 2, r * 2, 0, (360 * 64));
}
