/* 
   weapons.c
   
   for Final Battle
   
   Mike Hufnagel & Bill Kendrick
   Previously modified: 12/6/95
   Last modified: 4/2/98
*/

#include "const.h"
#include "types.h"
#include "glovar.h"
#include "weapons.h"
#include "movement.h"


void adjustweapon(int which)
{
  /* Change or X-momentum depending on our location and the location of the
     target */
  
  if ((weapons[which].x < weapons[which].targetx) &&
      (weapons[which].xm < SUPER_SPEED))
    {
      /* If we're on the left, aim more to the right */
  
      weapons[which].xm++;
    }
  else if ((weapons[which].x > weapons[which].targetx) &&
	   (weapons[which].xm > -SUPER_SPEED))
    {
      /* If we're on the right, aim more to the left */
      
      weapons[which].xm--;
    }
  else
    {
      /* If it's right above or below us, stop going left or right! */
      
      weapons[which].xm = weapons[which].xm - sign(weapons[which].xm);
    }

  
  /* Change or Y-momentum depending on our location and the location of the
     target */
  
  if ((weapons[which].y < weapons[which].targety) &&
      (weapons[which].ym < SUPER_SPEED))
    {
      /* If we're above it, aim more downwards */
  
      weapons[which].ym++;
    }
  else if ((weapons[which].y > weapons[which].targety) &&
	   (weapons[which].ym > -SUPER_SPEED))
    {
      /* If we're below it, aim more upwards */
  
      weapons[which].ym--;
    }
  else
    {
      /* If it's right to the left or right of us, stop going up or down! */
      
      weapons[which].ym = weapons[which].ym - sign(weapons[which].ym);
    }
}


void fireweapon(int pln)
{
  int free_weapon, i;       /* For free-slot testing */
  int bullets;              /* How many bullets to fire at a time */
  int current_bullet;       /* Counter for the bullets */
  int angle;                /* For deciding angles on multishot weapons */
  int target;               /* Which ship to track (homing) */
  char str[100];            /* For out-of-ammo. message to Comm. window */
  
  
  /* How many bullets to shoot? */
  
  /* Reduce the amount of energy: */
  
  player[pln].energy -=
    weapon_energy_consumption[player[pln].current_weapon];
  
  bullets = num_to_shoot[player[pln].current_weapon];

  
  for (current_bullet = 0; current_bullet < bullets; current_bullet++)
    {
      /* Do they even have any (more) of the selected weapon? */
      
      if (player[pln].weapons[player[pln].current_weapon])
	{
	  /* Find a free slot */
	  
	  free_weapon = -1;
	  
	  for (i = 0; i < NUM_WEAPONS; i++)
	    {
	      if (weapons[i].exist == 0)
		{
		  free_weapon = i;
		  break;
		}
	    }
	  
	  
	  /* We did find a slot (I would hope so, since NUM_WEAPONS is huge) */
	  
	  if (free_weapon != -1)
	    {
	      weapons[free_weapon].exist = 1;
	      weapons[free_weapon].type = player[pln].current_weapon;
	      
	      
	      /* Unless you have unlimited supply, reduce your supply */
	      
	      if (player[pln].weapons[player[pln].current_weapon] != UNLIMITED)
		player[pln].weapons[player[pln].current_weapon]--;
	 
	      
	      /* Starting momentum (your direction, mostly, but of course
		 your momentum affects it, too) */
	      
	      /* (For multi-shot weapons, also decide an angle other than
		 straight ahead) */
	      
	      if (player[pln].current_weapon == TWO_WAY)
		angle = 8 * current_bullet;
	      else if (player[pln].current_weapon == FOUR_WAY)
		angle = 4 * current_bullet;
	      else if (player[pln].current_weapon == EIGHT_WAY)
		angle = 2 * current_bullet;
	      else if (player[pln].current_weapon == TWO_SPLIT)
		angle = 15 + current_bullet * 2;
	      else if (player[pln].current_weapon == THREE_SPLIT)
		angle = 15 + current_bullet;
	      else
		angle = 0;
	      
	      angle = (angle + player[pln].dir) % 16;
	      weapons[free_weapon].xm = xmove[angle] * SUPER_SPEED / 2
		+ player[pln].xm;
	      weapons[free_weapon].ym = ymove[angle] * SUPER_SPEED / 2
		+ player[pln].ym;
	      
	      
	      /* Starting position (where the ship is, of course) */
	      
	      weapons[free_weapon].x = player[pln].x + 16 +
		weapons[free_weapon].xm;
	      weapons[free_weapon].y = player[pln].y + 16 +
		weapons[free_weapon].ym;
	      
	      
	      /* Starting range counter */
	      
	      weapons[free_weapon].range =
		range_of_weapon[player[pln].current_weapon];
	      
	      
	      /* Pick a target for missiles and homing missiles */
	      
	      target = nearest_ship(player[pln].x, player[pln].y, pln);
	      weapons[free_weapon].targetship = target;
	      weapons[free_weapon].targetx = player[target].x;
	      weapons[free_weapon].targety = player[target].y;
	      
	    } /* (if free_weapon != -1) */
	} /* (if weapons[current_weapon]) */
      else
	{
	  /* (Beep and complain only once per call) */
	  
	  if (current_bullet == 0)
	    {
	      sprintf(str, "You have no %s-weapon ammunition!",
		      weapon_name_strings[player[pln].current_weapon]);
	      
	      complain(pln, str);
	      
	      
	      /* Find the next available weapon: */
	      
	      do
		{
		  player[pln].current_weapon = (player[pln].current_weapon + 1)
		    % UNIQUE_WEAPONS;
		}
	      while (player[pln].weapons[player[pln].current_weapon] == 0);
	      
	      sprintf(str, "(Selected %s-weapon instead.)",
		      weapon_name_strings[player[pln].current_weapon]);
	      message(pln, GOD, str);
	    }
	}
    } /* (for current_bullet) */
}


void dronefireweapon(int d, int pln)
{
  int free_weapon, i;       /* For free-slot testing */
  
  for (i = 0; i < NUM_WEAPONS; i++)
    {
      if (weapons[i].exist == 0)
	{
	  free_weapon = i;
	  break;
	}
    }
  

  /* We did find a slot (I would hope so, since NUM_WEAPONS is huge) */
  
  if (free_weapon != -1)
    {
      weapons[free_weapon].exist = 1;
      weapons[free_weapon].type = STANDARD;
      
      weapons[free_weapon].xm = sign(player[pln].x - drone[d].x) * 16;
      
      weapons[free_weapon].ym = sign(player[pln].y - drone[d].y) * 16;
      
      
      /* Starting position (where the ship is, of course) */
      
      weapons[free_weapon].x = drone[d].x + 16 +
	(weapons[free_weapon].xm * 2);
      weapons[free_weapon].y = drone[d].y + 16 +
	(weapons[free_weapon].ym * 2);
      
      
      /* Starting range counter */

      weapons[free_weapon].range = range_of_weapon[STANDARD];
    }
}
