/*
 * FISG
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2003 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _FISG_H
#define _FISG_H

/*
 * Program name, version
 */
#define RA_NAME		"FISG"
#define RA_VERSION	"0.2.0"
#define RA_COPYRIGHT	"by ccr/TNSP (C) Copyright 2003 TNSP"
#define RA_FULLNAME	"Fast IRC Stats Generator"

/*
 * Configuration file section defines
 */
#define CFG_GEN_CHANNEL			"gen_channel"
#define CFG_GEN_IRCNET			"gen_ircnet"
#define CFG_GEN_MESSAGE			"gen_message"
#define CFG_GEN_DATEFORMAT		"gen_dateformat"
#define CFG_GEN_AUTO_ALIAS_NICKS	"gen_auto_alias_nicks"
#define CFG_GEN_USER_FILE		"gen_user_file"
#define CFG_GEN_SHOWMAX			"gen_showmax"
#define CFG_GEN_SHOWREST		"gen_showrest"
#define CFG_GEN_USE_PISG_SCORING	"gen_use_pisg_scoring"

#define DEF_GEN_DATEFORMAT		"%c"

/*
 * Settings
 */
#define SET_MAX_INFILES		(2048)
#define SET_MAX_NICKLEN		(32)
#define SET_HASH_MAXINDEX	(128)
#define SET_MAX_BUF		(1024)

#define	SET_HOURS_DAY		(24)
#define	SET_DAY_DIVISOR		(6)

 
/*
 * Typedefs, structures
 */
typedef float	t_float;
typedef unsigned long int t_int;

typedef struct tusernode {
	/* Read from config */
	char	*userHandle;			/* Handle (real nick) */
	char	*picPath;			/* Path/filename of user's picture */

	/* Calculated during parsing */
	t_int	nWords, nChars, nPublics, nCaps,
		nQuestions, nYelling,
		nHappyFaces, nSadFaces,		
		nKicks, nModeChanges, nTopicSets,
		nActions, nGotKicked, nURLs;

	t_int	nWordsPerHour[SET_HOURS_DAY],
		nPublicsPerHour[SET_HOURS_DAY];

	char	*sComment;

	/* Computed after parsing */
	t_float	nWordsPerPublic,
		nCharsPerWord,
		nHappiness,
		nTotalScore,
		activityPercentPerHour[SET_HOURS_DAY];

	struct tusernode *pPrev, *pNext;
} t_user_entry;


typedef struct tnicknode {
	char nick[SET_MAX_NICKLEN];

	t_user_entry *user;

	struct tnicknode *pPrev, *pNext;
} t_nick_entry;


typedef struct {
	/* Computed during parsing */
	t_user_entry *userList;
	t_nick_entry *nickList[SET_HASH_MAXINDEX];

	t_int nLines, nChars, nLogFiles, nDays;
	
	/* Computed after parsing */
	t_user_entry **userIndex;
	long int nUsers;

	t_user_entry
		*mostStupid,
		*mostLoud,
		*mostActions,
		*mostModes,
		*mostKicks,
		*mostKicked,
		*mostCaps,
		*mostHappy,
		*mostSad,
		*mostURLs;

	t_int	nTimeElapsed;
	t_float	activityPercentPerHour[SET_HOURS_DAY];
	int	activityPeak;
} t_stats;


/*
 * Functions
 */
t_user_entry	*user_new(char *userHandle);
t_nick_entry	*nick_new(char *newNick);
void		user_insert(t_user_entry **userList, t_user_entry *pNode);
void		nick_insert(t_nick_entry *nickList[], t_nick_entry *pNode);
t_user_entry	*user_search(t_nick_entry *nickList[], char *findNick);


#endif /* _FISG_H */
