/*
 * FISG - Input Formats (NOTICE! THIS IS NOT A REAL HEADER FILE!)
 * Programmed and designed by Matti 'ccr' Hamalainen
 * (C) Copyright 2003 Tecnic Software productions (TNSP)
 *
 * Please read file 'COPYING' for information on license and distribution.
 */
#ifndef _IN_FORMATS_H
#define _IN_FORMATS_H

/*
 * Defination of the in-format structure
 */
typedef struct {
	char	*ifName,	/* Name of this logfile-format */
		*ifDescription,	/* Short description */

		*fmtPublic,	/* Format-string for public messages */
		*fmtNotice,
		*fmtAction,
		*fmtModeChange,
		*fmtJoin,
		*fmtPart,
		*fmtQuit,
		*fmtKick,
		*fmtNickChange,
		
		*fmtDayChange;
} t_logformat;


/*
 * List of pre-defined input formats
 * Please read file FORMATS for information about these strings
 */
t_logformat	inputFormats[] = {

	{ "irssi", "Handles the DEFAULT Irssi-style logs",
		"%H:%M <%@%n> ",
		"%H:%M -%n:%*-",
		"%H:%M  * %n ",
		"%H:%M -!- mode/%* [%m] by %n",
		"%H:%M -!- %n [%*] has joined ",
		"%H:%M -!- %n [%*] has left ",
		"%H:%M -!- %n [%*] has quit ",
		"%H:%M -!- %n was kicked from %c by %N ",
		"%H:%M -!- %n is now known as %N",
		"--- Day changed"
	},
	
	{ "irssi-th", "Handles the 'th'-style Irssi logs",
		"%H:%M:%S<%@%n> ",
		"%H:%M:%S-%n:%*-",
		"%H:%M:%S * %n ",
		"%H:%M:%S-!- mode/%* [%m] by %n",
		"%H:%M:%S-!- %n [%*] has joined ",
		"%H:%M:%S-!- %n [%*] has left ",
		"%H:%M:%S-!- %n [%*] has quit ",
		"%H:%M:%S-!- %n was kicked from %c by %N ",
		"%H:%M:%S-!- %n is now known as %N",
		"--- Day changed"
	},
	
	{ "eggdrop", "Eggdrop log-format",
		"[%H:%M] <%n> ",
		"-fewr",
		"[%H:%M] Action: %n ",
		"[%H:%M] %*: mode change '%m' by %n!",
		"[%H:%M] %n joined ",
		"[%H:%M] %n (%*) ",
		"[%H:%M] %n (%*) left irc:  ",
		"[%H:%M] %n kicked from %c by %N:",
		"[%H:%M] Nick change: %n -> %N",
		"-fdsfsd"
	},
/*	
	{ "mirc", "mIRC-style log-format",
		""
	}
*/
};


const int	nInputFormats = (sizeof(inputFormats) / sizeof(t_logformat));

#endif /* _IN_FORMATS_H */
