/*
 * Test suite for th_str*match() functions
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "th_util.h"


typedef struct {
	char *testStr;
	BOOL testResult;
} t_test;


char *testString = "foo.foo.bar..bar.baz";

t_test testList[] = {
	{ "*.baz",	TRUE },
	{ "*b*.BAZ",	TRUE },
	{ "*b*.baz",	TRUE },
	{ "*A*",	TRUE },
	{ "f*",		TRUE },
	{ "f*z",	TRUE },
	{ "*",		TRUE },
	{ "?*",		TRUE },
	{ "*?",		TRUE },
	{ "*a?",	TRUE },
	{ "*z?",	FALSE },
	{ "*az",	TRUE },
	{ "*ar?",	FALSE },
	{ "*bar*",	TRUE },
	{ "*b?r*",	TRUE },
	{ "*.baz*",	TRUE },
	{ "*foo*foo*bar*", TRUE },
	{ "*foo*bar.baz", TRUE },
	{ "f*z*", 	TRUE },
	{ "*z*", 	TRUE },
	{ "?*z",	TRUE },
};

const int ntestList = (sizeof(testList) / sizeof(t_test));

void TST(char *s, char *p)
{
 printf("['%s' - '%s'] == %i\n",
 	s, p, th_strcasematch(s, p));
}

int main(void)
{
 int i, nFailed = 0, nPassed = 0;
 BOOL iResult;

 for (i = 0; i < ntestList; i++)
	{
	printf("-------------------------\n");
	printf("TEST #%i: [\"%s\" -- \"%s\"]\n",
		i,
	 	testString,
	 	testList[i].testStr);


	iResult = th_strcasematch(testString, testList[i].testStr);

	printf("TEST #%i RESULT: %s\n",
		i,
		(testList[i].testResult == iResult) ? "PASSED" : "FAILED"
		);

	if (testList[i].testResult == iResult)
		nPassed++;
		else
		nFailed++;
	}

 TST("cras", "*cras*");
 TST("cras", "*cras");
 TST("cras", "cras*");
 TST("cras", "cras");

 TST("cras_", "*cras*");
 TST("cra", "*cras*");
 TST("cras", "cra*");
 TST("cras", "*r*");
 TST("cras", "*ra*");
 TST("cras", "c*s");
 TST("cras", "c*a");
 TST("cras", "*a?");
 TST("cras", "*r?*");
 TST("cras", "*r??*");
 TST("cras", "**");
 
 printf("Tests passed: %i, failed: %i\n", nPassed, nFailed);
 return 0;
}
