#include "charsetlist.h"
#include "detector.h"
#include <ctype.h>
#include <algorithm>

void CharsetList::append(const string &list)
{
string c;
bool between=true;
for(string::const_iterator p=list.begin();p!=list.end();p++)
   {
   if(isspace(*p) || *p==':' || *p==';' || *p==',')
     {
     if(!between)
       {
       if(!c.empty())
         push_back(c);
       c="";
       between=true;
       }
     }
   else
     {
     if(between)
       between=false;
     c+=*p;
     }
   }
if(!between && !c.empty())
  push_back(c);
}

CharsetList::CharsetList(bool aPolicy):
             policy(aPolicy)
{
}

CharsetList::CharsetList(bool aPolicy,const string &list):
             policy(aPolicy)
{
append(list);
}

CharsetList &CharsetList::operator =(const string &list)
{
clear();
append(list);
return *this;
}

CharsetList &CharsetList::operator +=(const string &list)
{
append(list);
return *this;
}

class SameCharset
{
private:

string charset;

public:

SameCharset(const string &aCharset):
           charset(aCharset)
{
}

bool operator()(const string &peer)
{
return isSameCharset(charset,peer);
}

};

bool CharsetList::contains(const string &charset)
{
return empty() ? policy
               : find_if(begin(),end(),SameCharset(charset))!=end();
}
