#ifndef __DETECTOR_H
#define __DETECTOR_H

#include <string>
#include <vector>

using namespace std;

class Detector
{
protected:

string defaultCharset;
string lang;
int total;

public:

struct LangInfo
{
string code,name;
};
typedef vector<LangInfo> LangList;

static Detector *defaultDetector(const string &,const string &);
static const LangList &getLanguages();
static bool isLanguageValid(const string &);
static string getDetectorName();

Detector(const string &,const string &);
virtual ~Detector();

virtual void scan(const string &);
virtual string getCharset() const=0;
bool isAscii() const;
};

bool operator ==(const Detector::LangInfo &,const string &);

bool isSameCharset(const string &,const string &);

#endif /* __DETECTOR_H */
