// @(#) $Id: parser.cc,v 1.6 2003/12/30 13:36:42 balu Exp $

#include "parser.h"
#include <ctype.h>

ContentType::ContentType():
             type("text"),subtype("plain")
{
attrs["charset"]="us-ascii";
}

ContentType::ContentType(const string &s,const string &charset):
             type("text"),subtype("plain")
{
attrs["charset"]=charset;
parseContentType(s,*this);
}

string ContentType::getType() const
{
return type;
}

string ContentType::getSubtype() const
{
return subtype;
}

string ContentType::getFullType() const
{
return getType()+'/'+getSubtype();
}

void ContentType::setType(const string &aType)
{
type=aType;
}

void ContentType::setSubtype(const string &aSubtype)
{
subtype=aSubtype;
}

string &ContentType::getAttr(const string &name)
{
return attrs[name];
}

void ContentType::setAttr(const string &name,const string &value)
{
attrs[name]=value;
}

string &ContentType::operator[](const string &name)
{
return getAttr(name);
}

string ContentType::getHeader() const
{
string s="Content-Type: "+getFullType();
for(Attrs::const_iterator i=attrs.begin();i!=attrs.end();i++)
   s+="; "+i->first+"=\""+i->second+"\"";
return s;
}

string toLower(const string &s)
{
string c;
for(string::const_iterator i=s.begin();i!=s.end();i++)
   c+=tolower(*i);
return c;
}

string crop(const string &s)
{
string::const_iterator first,last;
for(first=s.begin();first!=s.end() && isspace(*first);first++);
if(first==s.end())
  return string();
for(last=s.end(),last--;isspace(*last);last--);
last++;
return string(first,last);
}

string getHeaderName(const string &s)
{
string c;
for(string::const_iterator i=s.begin();
    i!=s.end() && (isalpha(*i) || *i=='-');
    i++)
   c+=tolower(*i);
return c;
}

string getTransferEncoding(const string &s)
{
int pos=s.find(':');
if(pos==string::npos)
  return "";
return toLower(crop(s.substr(pos+1)));
}

void parseTypeName(const string &s,ContentType &ct)
{
string c=toLower(s);
int pos=c.find('/');
if(pos!=string::npos)
  {
  ct.setType(c.substr(0,pos));
  ct.setSubtype(c.substr(pos+1));
  }
else
  ct.setType(c);
}

void parseParameter(const string &s,ContentType &ct)
{
int pos=s.find('=');
if(pos!=string::npos)
  {
  string name=toLower(crop(s.substr(0,pos)));
  string value=crop(s.substr(pos+1));
  if(value[0]=='"')
    value=value.substr(1,value.length()-2);
  ct.setAttr(name,value);
  }
else
  ct.setAttr(s,"");
}

void parseContentType(const string &s,ContentType &ct)
{
int pos=s.find(':');
if(pos==string::npos)
  return;
string value=s.substr(pos+1);
string c;
bool type=true;
for(;;)
   {
   pos=value.find(';');
   if(pos==string::npos)
     {
     c=value;
     value=string();
     }
   else
     {
     c=value.substr(0,pos);
     value=value.substr(pos+1);
     }
   if(type)
     {
     parseTypeName(crop(c),ct);
     type=false;
     }
   else
     parseParameter(crop(c),ct);
   if(value.empty())
     break;
   }
}

Header::Header():
        position(0),length(0)
{
}

bool Header::isMissing() const
{
return position==0;
}

int Header::getPosition() const
{
return position;
}

void Header::setPosition(int aPosition)
{
position=aPosition;
}

int Header::getLength() const
{
return length;
}

string Header::getBody() const
{
return body;
}

Header::operator string() const
{
return getBody();
}

void Header::setBody(const string &aBody)
{
body=aBody;
length=1;
}

Header &Header::operator =(const string &aBody)
{
setBody(aBody);
return *this;
}

void Header::add(const string &s)
{
if(!body.empty())
  body+=' ';
body+=s;
length++;
}

Header &Header::operator +=(const string &s)
{
add(s);
return *this;
}
