// @(#) $Id: parser.h,v 1.3 2003/08/07 11:57:20 balu Exp $

#ifndef __PARSER_H
#define __PARSER_H

#include <string>
#include <map>

using namespace std;

class ContentType
{
private:

typedef map<string,string> Attrs;

string type;
string subtype;
Attrs attrs;

public:

ContentType();
ContentType(const string &,const string &charset="us-ascii");

string getType() const;
string getSubtype() const;
string getFullType() const;
void setType(const string &);
void setSubtype(const string &);

string &getAttr(const string &);
void setAttr(const string &,const string &);
string &operator[](const string &);

string getHeader() const;
};

string getHeaderName(const string &);
string getTransferEncoding(const string &);
void parseContentType(const string &,ContentType &);

class Header
{
private:

string body;
int position,length;

public:

Header();

bool isMissing() const;

int getPosition() const;
void setPosition(int);
int getLength() const;

string getBody() const;
operator string() const;
void setBody(const string &);
Header &operator =(const string &);

void add(const string &);
Header &operator +=(const string &);
};

#endif /* __PARSER_H */
