/* $Header: /home/yav/catty/fkiss/RCS/cursor.c,v 1.12 2000/08/24 02:14:13 yav Exp $
 * fkiss cursor font
 * written by yav <yav@bigfoot.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

char cursor_id[] = "$Id: cursor.c,v 1.12 2000/08/24 02:14:13 yav Exp $";

#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>

#include "config.h"

#include <stdio.h>

#include "headers.h"
#include "fkiss.h"
#include "work.h"

#define PUBLIC_CURSOR_C
#include "extern.h"

#define CUR_Undef	(-1)
#define CUR_NULL	0
#define CUR_HAND	1
#define CUR_GRIP	2
#define CUR_ARROW	3
#define CUR_CROSS	4
#define CUR_FLEUR	5
#define MAX_CUR		6

typedef struct {
  Cursor id;
  Pixmap font;
  Pixmap mask;
} CURSOR_RESOURCE;

static CURSOR_RESOURCE *crs = NULL;
static unsigned char ptrn_null[] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#include "hand0.xbm"
#include "hand1.xbm"
#include "grip0.xbm"
#include "grip1.xbm"

/* install cursor resource */
void init_cursor()
{
  int i;
  CURSOR_RESOURCE *p;
  XColor cfore, cback;
  static struct {
    unsigned char *mask;	/* mask pattern bitmap data */
    unsigned char *font;	/* font pattern bitmap data */
    int w;			/* bitmap width or X Cursor code */
    int h;			/* bitmap height */
    int x, y;			/* hotspot */
  } ctbl[MAX_CUR] = {
    {				/* 0:CUR_NULL */
      ptrn_null, ptrn_null,
      16, 16, 0, 0},
    {				/* 1:CUR_HAND */
      hand0_bits, hand1_bits,
      hand1_width, hand1_height, hand1_x_hot, hand1_y_hot},
    {				/* 2:CUR_GRIP */
      grip0_bits, grip1_bits,
      grip1_width, grip1_height, grip1_x_hot, grip1_y_hot},
    {
      NULL, NULL,
      XC_top_left_arrow, 0, 0, 0},
    {
      NULL, NULL,
      XC_tcross, 0, 0, 0},
    {
      NULL, NULL,
      XC_fleur, 0, 0, 0}
  };
  
  if (!cursor_mode)
    return;
  if (crs == NULL) {
    crs = (CURSOR_RESOURCE *)ks_malloc(sizeof(CURSOR_RESOURCE)*MAX_CUR);
    bzero((char *)crs, sizeof(CURSOR_RESOURCE)*MAX_CUR);
  }
  XParseColor(dsp, cmap, str_curs_fore, &cfore);
  XParseColor(dsp, cmap, str_curs_back, &cback);
  for (p = crs, i = 0; i < MAX_CUR; p++, i++) {
    if (p->id != None) {
      XFreeCursor(dsp, p->id);
      p->id = None;
    }
    if (p->mask != None) {
      XFreePixmap(dsp, p->mask);
      p->mask = None;
    } 
    if (p->font != None) {
      XFreePixmap(dsp, p->font);
      p->font = None;
    }
    if (ctbl[i].mask != NULL) {
      p->mask =
	XCreateBitmapFromData(dsp, rootwin, ctbl[i].mask,
			      ctbl[i].w, ctbl[i].h);
      p->font =
	XCreateBitmapFromData(dsp, rootwin, ctbl[i].font,
			      ctbl[i].w, ctbl[i].h);
      p->id = XCreatePixmapCursor(dsp, p->font, p->mask,
				  &cfore, &cback,
				  ctbl[i].x, ctbl[i].y);
    } else {
      p->id = XCreateFontCursor(dsp, ctbl[i].w);
    }
  }
}

/* install cursor font */
void cursor_set(win, n)
     Window win;
     int n;
{
  if (n == CUR_Undef)
    XUndefineCursor(dsp, win);
  else
    XDefineCursor(dsp, win, (crs+n)->id);
}

void set_cursor(n)
     int n;
{
  if (cursor_mode)
    cursor_set(viewwin, n);
}

void cursor_grip()
{
  set_cursor((cursor_mode & 2) ? CUR_GRIP : CUR_NULL);
}

void cursor_hand()
{
  set_cursor((cursor_mode & 1) ? CUR_HAND : CUR_Undef);
}

void cursor_scroll()
{
  set_cursor(CUR_FLEUR);
}

/* End of file */
