/* These constants can be changed if necessary */
#define NMLNGTH    10        /* required # of characters in sequence name */
#define iters      50        /* how hard to try to estimate theta */
#define menu       true      /* are we using the menu? */
#define epsilon    0.0000001 /* a small number */
#define thetaout   false     /* create "thetafile" with running tally
                                  of theta estimates? */
#define onebestree true      /* "true" = only single bestree in file "bestree"
                                "false" = running tally of bestrees in file
                                "bestree" */
#define MINTHETA   0.00001     /* low end of table */
#define MAXTHETA   10.0      /* high end of table */
#define THETALID   1000.0     /* maximum allowable theta */
#define GLID       100000.0   /* maximum allowable g */
#define EXPMIN    -40.0      /* minimum value of "x" in "exp(x)" */
#define EXPMAX     200.0     /* maximum value of "x" in "exp(x)" */
#define EPSILON    10e-50    /* a really small number */
#define REPEAT_TOLERANCE 50   /* how many times (sequentially) should the
                                exact same prior-likelihood value be
                                encountered in point estimation before
                                giving up.
                                ALSO
                                how many times do we reset huge growth */

/* these constants are used only in dealing with the changing population
   size */
#define LHOP_TOLERANCE 10e-5 /* when to start using an approximation in
                                calculating likelihoods; the +tolerance
                                is the upper bound and -tolerance the lower */

/* The following program constants should not be changed */
#define point        "."
#define rootlength   10000       /* length of root branch must be much
                                    larger than the total height of the
                                    tree */
#define LINESIZE     128         /* this is actually (maximum linesize)+1
                                    because of trailing '\0' */
#define NUMBOOL       10         /* number of boolean tokens in parameter
                                    file */
#define NUMNUMBER      8         /* number of numeric (double) tokens in
                                    parameter file */
#define POSMAX       DBL_MAX     /* largest positive number */
#define NEGMAX  -(DBL_MAX - 1.0) /* smallest negative number */
#define NUM_TYPE_CHAINS 2        /* number of different kinds of chains */
#define NUMPARAMETERS   2        /* number of parameters of interest */
#define baseA          0
#define baseC          1
#define baseG          2
#define baseT          3
