// resource.hh for fluxter - a pager tool for Blackbox
//
//  Copyright (c) 2002 Steve Cooper, stevencooper@isomedia.com
//  Copyright (c) 1998-2000 John Kennis, jkennis@chello.nl
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __RESOURCE_HH
#define __RESOURCE_HH

#include "fluxter.hh"
#include "Baseresource.hh"

class BaseResource;

enum {none=0, border=1, texture=2};
enum WHICH_BUTTON { INVALID_BUTTON = 0, LEFT_BUTTON, MIDDLE_BUTTON,
					RIGHT_BUTTON, FOURTH_BUTTON, FIFTH_BUTTON};

const int ABS_MAX_WORKSPACES = 32;

struct FRAME {
  int width;
  int height;
  BTexture texture;
  int bevelWidth;
  XFontStruct *font;
};

struct POSITION {
  int x;
  int y;
  int mask;
  bool vertical;
  bool horizontal;
};

struct SIZE {
  unsigned int width;
  unsigned int height;
};

struct REPORT {
  bool auto_raise;
};

struct FLUXTERWIN {
  BTexture texture;
  BTexture focusedTexture;
  BColor activeColor;
  BColor inactiveColor;
};

class Resource : public BaseResource {

public:
  Resource(ToolWindow *);
  ~Resource(void);

  struct FRAME frame;
  struct POSITION position;
  struct SIZE desktopSize;
  struct REPORT report;
  struct FLUXTERWIN pagerwin;
  struct FLUXTERWIN desktopwin;
  int columns;
  int rows;
  int getFocusStyle(void) { return focus_style; }
  int getDesktopFocusStyle(void) { return desktop_focus_style; }
  WHICH_BUTTON getWindowMoveButton(void) { return window_move_button; }
  WHICH_BUTTON getDesktopChangeButton(void) { return desktop_change_button; }
  WHICH_BUTTON getWindowRaiseButton(void) { return window_raise_button; }
  WHICH_BUTTON getWindowFocusButton(void) { return window_focus_button; }
  char *getRootCommand(int ndesk) { return (ndesk >= 0 && ndesk < ABS_MAX_WORKSPACES
                                                ? root_commands[ndesk] : NULL); }


protected:
  virtual void  LoadBBToolResource(void);

private:
  void Frame(void);
  void SizeAndPosition(void);
  void PagerWin(void);
  void Workspaces(void);
  int focus_style;
  int desktop_focus_style;
  char *root_commands[ABS_MAX_WORKSPACES];
  WHICH_BUTTON window_move_button;
  WHICH_BUTTON desktop_change_button;
  WHICH_BUTTON window_raise_button;
  WHICH_BUTTON window_focus_button;
  void Clean(void);
};
#endif /* __RESOURCE_HH */
