/*****************************************************************************
 *  FTools - Freenet Client Protocol Tools
 *
 *  Copyright (C) 2002 Juergen Buchmueller <juergen@pullmoll.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *	$Id: ftmime.c,v 1.4 2003/11/04 23:15:36 pullmoll Exp $
 *****************************************************************************/
#include "ftmime.h"

#define	APPLICATION_OCTETSTREAM	"application/octet-stream"
#define	APPLICATION_BINHEX40	"application/mac-binhex40"
#define	APPLICATION_COMPACTPRO	"application/mac-compactpro"
#define	APPLICATION_MSWORD		"application/msword"
#define	APPLICATION_PDF			"application/pdf"
#define	APPLICATION_POSTSCRIPT	"application/postscript"
#define	APPLICATION_RTF			"application/rtf"
#define	APPLICATION_SMIL		"application/smil"
#define	APPLICATION_MS_EXCEL	"application/vnd.ms-excel"
#define	APPLICATION_MS_POWERPT	"application/vnd.ms-powerpoint"
#define	APPLICATION_ZIP			"application/zip"
#define	APPLICATION_BCPIO		"application/x-bcpio"
#define	APPLICATION_BZIP		"application/x-bzip"
#define	APPLICATION_BZIP2		"application/x-bzip2"
#define	APPLICATION_CDLINK		"application/x-cdlink"
#define	APPLICATION_CHESS_PGN	"application/x-chess-pgn"
#define	APPLICATION_COMPRESS	"application/x-compress"
#define	APPLICATION_CPIO		"application/x-cpio"
#define	APPLICATION_CSH			"application/x-csh"
#define	APPLICATION_DIRECTOR	"application/x-director"
#define	APPLICATION_DVI			"application/x-dvi"
#define	APPLICATION_SPLASH		"application/x-futuresplash"
#define	APPLICATION_GTAR		"application/x-gtar"
#define	APPLICATION_GZIP		"application/x-gzip"
#define	APPLICATION_HDF			"application/x-hdf"
#define	APPLICATION_JAVASCRIPT	"application/x-javascript"
#define	APPLICATION_KOAN		"application/x-koan"
#define	APPLICATION_LATEX		"application/x-latex"
#define	APPLICATION_NETCDF		"application/x-netcdf"

#define	AUDIO_BASIC				"audio/basic"
#define	AUDIO_MIDI				"audio/midi"
#define	AUDIO_MPEG				"audio/mpeg"
#define	AUDIO_X_AIFF			"audio/x-aiff"
#define	AUDIO_X_MPEGURL			"audio/x-mpegurl"
#define	AUDIO_X_PN_REALAUDIO	"audio/x-pn-realaudio"
#define	AUDIO_X_PN_REALAUDIO_P	"audio/x-pn-realaudio-plugn"
#define	AUDIO_X_REALAUDIO		"audio/x-realaudio"
#define	AUDIO_X_WAV				"audio/x-wav"

#define	IMAGE_BMP				"image/bmp"
#define	IMAGE_GIF				"image/gif"
#define	IMAGE_IEF				"image/ief"
#define	IMAGE_JPEG				"image/jpeg"
#define	IMAGE_PNG				"image/png"
#define	IMAGE_TIFF				"image/tiff"
#define	IMAGE_X_CMU_RASTER		"image/x-cmu-raster"
#define	IMAGE_X_PORTABLE_ANYMAP	"image/x-portable-anymap"
#define	IMAGE_X_PORTABLE_BITMAP	"image/x-portable-bitmap"
#define	IMAGE_X_PORTABLE_GRAYMAP	"image/x-portable-graymap"
#define	IMAGE_X_PORTABLE_PIXMAP	"image/x-portable-pixmap"
#define	IMAGE_X_RGB				"image/x-rgb"
#define	IMAGE_X_XBITMAP			"image/x-xbitmap"
#define	IMAGE_X_XPIXMAP			"image/x-xpixmap"
#define	IMAGE_X_XWINDOWDUMP		"image/x-xwindowdump"

#define	VIDEO_MPEG				"video/mpeg"
#define	VIDEO_QUICKTIME			"video/quicktime"
#define	VIDEO_VND_MPEGURL		"video/vn.mpegurl"
#define	VIDEO_X_MSVIDEO			"video/x-msvideo"
#define	VIDEO_X_SGI_MOVIE		"video/x-sgi-movie"

#define	TEXT_HTML				"text/html"
#define	TEXT_PLAIN				"text/plain"
#define	TEXT_CSS				"text/css"
#define	TEXT_RICHTEXT			"text/richtext"
#define	TEXT_RTF				"text/rtf"
#define	TEXT_RTF				"text/rtf"
#define	TEXT_SGML				"text/sgml"
#define	TEXT_TSV				"text/tab-separated-values"
#define	TEXT_VND_WAP_WML		"text/vnd.wap.wml"
#define	TEXT_VND_WAP_WMLSCRIPT	"text/vnd.wap.wmlscript"
#define	TEXT_XML				"text/xml"

const char *mimetype_guess(const char *filename)
{
	char *ext = strrchr(filename, '.');

	if (NULL == ext) {
		return APPLICATION_OCTETSTREAM;
	}
	if (0 == strcasecmp(ext, ".htm") ||
		0 == strcasecmp(ext, ".html")) {
		return TEXT_HTML;
	}
	if (0 == strcasecmp(ext, ".txt")) {
		return TEXT_PLAIN;
	}
	if (0 == strcasecmp(ext, ".css")) {
		return TEXT_CSS;
	}
	if (0 == strcasecmp(ext, ".rtx")) {
		return TEXT_RICHTEXT;
	}
	if (0 == strcasecmp(ext, ".rtf")) {
		return TEXT_RTF;
	}
	if (0 == strcasecmp(ext, ".sgml") ||
		0 == strcasecmp(ext, ".sgm")) {
		return TEXT_SGML;
	}
	if (0 == strcasecmp(ext, ".tsv")) {
		return TEXT_TSV;
	}
	if (0 == strcasecmp(ext, ".wml")) {
		return TEXT_VND_WAP_WML;
	}
	if (0 == strcasecmp(ext, ".wmls")) {
		return TEXT_VND_WAP_WMLSCRIPT;
	}
	if (0 == strcasecmp(ext, ".xml") ||
		0 == strcasecmp(ext, ".xsl")) {
		return TEXT_XML;
	}

/* audio formats */
	if (0 == strcasecmp(ext, ".au") ||
		0 == strcasecmp(ext, ".snd")) {
		return AUDIO_BASIC;
	}
	if (0 == strcasecmp(ext, ".mid") ||
		0 == strcasecmp(ext, ".midi") ||
		0 == strcasecmp(ext, ".midi")) {
		return AUDIO_MIDI;
	}
	if (0 == strcasecmp(ext, ".mpga") ||
		0 == strcasecmp(ext, ".mp2") ||
		0 == strcasecmp(ext, ".mp3")) {
		return AUDIO_MPEG;
	}
	if (0 == strcasecmp(ext, ".aif") ||
		0 == strcasecmp(ext, ".aiff") ||
		0 == strcasecmp(ext, ".aifc")) {
		return AUDIO_X_AIFF;
	}
	if (0 == strcasecmp(ext, ".m3u")) {
		return AUDIO_X_MPEGURL;
	}
	if (0 == strcasecmp(ext, ".ram") ||
		0 == strcasecmp(ext, ".rm")) {
		return AUDIO_X_PN_REALAUDIO;
	}
	if (0 == strcasecmp(ext, ".rpm")) {
		return AUDIO_X_PN_REALAUDIO_P;
	}
	if (0 == strcasecmp(ext, ".ra")) {
		return AUDIO_X_REALAUDIO;
	}
	if (0 == strcasecmp(ext, ".wav")) {
		return AUDIO_X_WAV;
	}

/* image formats */
	if (0 == strcasecmp(ext, ".bmp")) {
		return IMAGE_BMP;
	}
	if (0 == strcasecmp(ext, ".gif")) {
		return IMAGE_GIF;
	}
	if (0 == strcasecmp(ext, ".ief")) {
		return IMAGE_IEF;
	}
	if (0 == strcasecmp(ext, ".jpeg") ||
		0 == strcasecmp(ext, ".jpg") ||
		0 == strcasecmp(ext, ".jpe")) {
		return IMAGE_JPEG;
	}
	if (0 == strcasecmp(ext, ".png")) {
		return IMAGE_PNG;
	}
	if (0 == strcasecmp(ext, ".tiff") ||
		0 == strcasecmp(ext, ".tif")) {
		return IMAGE_TIFF;
	}
	if (0 == strcasecmp(ext, ".ras")) {
		return IMAGE_X_CMU_RASTER;
	}
	if (0 == strcasecmp(ext, ".pnm")) {
		return IMAGE_X_PORTABLE_ANYMAP;
	}
	if (0 == strcasecmp(ext, ".pbm")) {
		return IMAGE_X_PORTABLE_BITMAP;
	}
	if (0 == strcasecmp(ext, ".pgm")) {
		return IMAGE_X_PORTABLE_GRAYMAP;
	}
	if (0 == strcasecmp(ext, ".ppm")) {
		return IMAGE_X_PORTABLE_PIXMAP;
	}
	if (0 == strcasecmp(ext, ".rgb")) {
		return IMAGE_X_RGB;
	}
	if (0 == strcasecmp(ext, ".xbm")) {
		return IMAGE_X_XBITMAP;
	}
	if (0 == strcasecmp(ext, ".xpm")) {
		return IMAGE_X_XPIXMAP;
	}
	if (0 == strcasecmp(ext, ".xwd")) {
		return IMAGE_X_XWINDOWDUMP;
	}

/* video formats */
	if (0 == strcasecmp(ext, ".mpg") ||
		0 == strcasecmp(ext, ".mpe") ||
		0 == strcasecmp(ext, ".mpeg")) {
		return VIDEO_MPEG;
	}
	if (0 == strcasecmp(ext, ".qt") ||
		0 == strcasecmp(ext, ".mov")) {
		return VIDEO_QUICKTIME;
	}
	if (0 == strcasecmp(ext, ".mxu")) {
		return VIDEO_VND_MPEGURL;
	}
	if (0 == strcasecmp(ext, ".avi") ||
		0 == strcasecmp(ext, ".wmf")) {
		return VIDEO_X_MSVIDEO;
	}
	if (0 == strcasecmp(ext, ".movie")) {
		return VIDEO_X_SGI_MOVIE;
	}

/* various application formats */
	if (0 == strcasecmp(ext, ".hqx")) {
		return APPLICATION_BINHEX40;
	}
	if (0 == strcasecmp(ext, ".cpt")) {
		return APPLICATION_COMPACTPRO;
	}
	if (0 == strcasecmp(ext, ".doc")) {
		return APPLICATION_MSWORD;
	}
	if (0 == strcasecmp(ext, ".pdf")) {
		return APPLICATION_PDF;
	}
	if (0 == strcasecmp(ext, ".ai") ||
		0 == strcasecmp(ext, ".eps") ||
		0 == strcasecmp(ext, ".ps")) {
		return APPLICATION_POSTSCRIPT;
	}
	if (0 == strcasecmp(ext, ".smi") ||
		0 == strcasecmp(ext, ".smil")) {
		return APPLICATION_SMIL;
	}
	if (0 == strcasecmp(ext, ".rtf")) {
		return APPLICATION_RTF;
	}
	if (0 == strcasecmp(ext, ".xls")) {
		return APPLICATION_MS_EXCEL;
	}
	if (0 == strcasecmp(ext, ".ppt")) {
		return APPLICATION_MS_POWERPT;
	}
	if (0 == strcasecmp(ext, ".bcpio")) {
		return APPLICATION_BCPIO;
	}
	if (0 == strcasecmp(ext, ".bz")) {
		return APPLICATION_BZIP;
	}
	if (0 == strcasecmp(ext, ".bz2")) {
		return APPLICATION_BZIP2;
	}
	if (0 == strcasecmp(ext, ".vcd")) {
		return APPLICATION_CDLINK;
	}
	if (0 == strcasecmp(ext, ".pgn")) {
		return APPLICATION_CHESS_PGN;
	}
	if (0 == strcasecmp(ext, ".z")) {
		return APPLICATION_COMPRESS;
	}
	if (0 == strcasecmp(ext, ".cpio")) {
		return APPLICATION_CPIO;
	}
	if (0 == strcasecmp(ext, ".csh")) {
		return APPLICATION_CSH;
	}
	if (0 == strcasecmp(ext, ".dcr") ||
		0 == strcasecmp(ext, ".dir") ||
		0 == strcasecmp(ext, ".dxr")) {
		return APPLICATION_DIRECTOR;
	}
	if (0 == strcasecmp(ext, ".dvi")) {
		return APPLICATION_DVI;
	}
	if (0 == strcasecmp(ext, ".spl")) {
		return APPLICATION_SPLASH;
	}
	if (0 == strcasecmp(ext, ".gtar")) {
		return APPLICATION_GTAR;
	}
	if (0 == strcasecmp(ext, ".gz")) {
		return APPLICATION_GZIP;
	}
	if (0 == strcasecmp(ext, ".hdf")) {
		return APPLICATION_HDF;
	}
	if (0 == strcasecmp(ext, ".js")) {
		return APPLICATION_JAVASCRIPT;
	}
	if (0 == strcasecmp(ext, ".skp") ||
		0 == strcasecmp(ext, ".skd") ||
		0 == strcasecmp(ext, ".skt") ||
		0 == strcasecmp(ext, ".skm")) {
		return APPLICATION_KOAN;
	}
	if (0 == strcasecmp(ext, ".latex")) {
		return APPLICATION_LATEX;
	}
	if (0 == strcasecmp(ext, ".nc") ||
		0 == strcasecmp(ext, ".cdf")) {
		return APPLICATION_NETCDF;
	}
	if (0 == strcasecmp(ext, ".zip")) {
		return APPLICATION_ZIP;
	}

	return APPLICATION_OCTETSTREAM;
}
