
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement maxval()/minval() intrinsics. */


#ifdef SUBROUTINE

/* Skeleton for minval()/maxval() intrinsics */

TYPE SUBROUTINE(g95_array_descriptor *array, G95_DINT *dim,
		g95_array_descriptor *mask) {

G95_AINT rank, array_count[G95_MAX_DIMENSIONS], mask_count[G95_MAX_DIMENSIONS];
TYPE extrema, *mp;
char *p;
int i;

    extrema = INITIAL;
    rank = array->rank;

    for(i=0; i<rank; i++) {
	array_count[i] = array->info[i].lbound;
	if (array->info[i].lbound > array->info[i].ubound)
	    return extrema;

	if (mask != NULL)
	    mask_count[i] = mask->info[i].lbound;
    }

    for(;;) {
	if (mask != NULL) {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask->info[i].mult * mask_count[i];

	    if (*(int *) p == 0)
		goto next;
	}

	p = array->offset;
	for(i=0; i<rank; i++)
	    p += array->info[i].mult * array_count[i];

	mp = (TYPE *) p;
	if (COMPARE(*mp, extrema))
	    extrema = *mp;

    next:
	if (bump_element(array, array_count))
	    break;

	if (mask != NULL)
	    bump_element(mask, mask_count);
    }

    return extrema;
}


TYPE SUBROUTINE_1(g95_array_descriptor *array, G95_DINT *dim,
		  G95_DINT *mask) {

    return *mask
	? SUBROUTINE(array, dim, NULL)
	: INITIAL;
}


g95_array_descriptor *SUBROUTINE_D(g95_array_descriptor *array,
				   G95_DINT *dim_p,
				   g95_array_descriptor *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
TYPE *p, *p1, extrema;
char *q, *m1, *m2;

    rank = array->rank;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	if (mask != NULL)
	    mask_x[i] = mask->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = (TYPE *) result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	if (mask != NULL) {
	    m1 = mask->offset;
	    for(i=0; i<rank; i++) {
		if (i == dim)
		    continue;

		m1 += mask->info[i].mult * mask_x[i];
	    }
	}

	extrema = INITIAL;

	for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
	    if (mask != NULL) {
		m2 = m1 + mask->info[dim].mult *
		    (i - array->info[dim].lbound + mask->info[dim].lbound);

		if (!extract_logical(m2, mask->element_size))
		    continue;
	    }

	    p1 = (TYPE *) (q + array->info[dim].mult * i);
	    if (COMPARE(*p1, extrema))
		extrema = *p1;
	}

	*p++ = extrema;

	if (mask != NULL)
	    bump_element_dim(mask, mask_x, dim);

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}



g95_array_descriptor *SUBROUTINE_1D(g95_array_descriptor *array,
				    G95_DINT *dim_p, G95_DINT *mask) {
G95_AINT dim, extent, array_x[G95_MAX_DIMENSIONS];
int i, m, rank, zero_size, mask_val;
g95_array_descriptor *result;
TYPE *p, *p1, extrema;
char *q, *m1;

    rank = array->rank;
    mask_val = (mask == NULL) ? 1 : *mask;

    dim = *dim_p;
    if (dim < 1 || dim > rank)
	bad_dim();

    dim--;    /* now zero based */

    section_info[0] = rank - 1;
    section_info[1] = array->element_size;

    zero_size = 0;
    m = 2;
    m1 = NULL;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	extent = array->info[i].ubound - array->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	if (i == dim)
	    continue;

	section_info[m++] = 1;
	section_info[m++] = extent;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = (TYPE *) result->base;

    for(;;) {
	q = array->offset;
	for(i=0; i<rank; i++) {
	    if (i == dim)
		continue;

	    q += array->info[i].mult * array_x[i];
	}

	extrema = INITIAL;

	if (mask_val)
	    for(i=array->info[dim].lbound; i<=array->info[dim].ubound; i++) {
		p1 = (TYPE *) (q + array->info[dim].mult * i);
		if (COMPARE(*p1, extrema))
		    extrema = *p1;
	    }

	*p++ = extrema;

	if (bump_element_dim(array, array_x, dim))
	    break;
    }

    return result;
}




#undef TYPE
#undef COMPARE
#undef INITIAL

#undef SUBROUTINE
#undef SUBROUTINE_D
#undef SUBROUTINE_1
#undef SUBROUTINE_1D

#else
#include "runtime.h"


#define TYPE           G95_INT1
#define COMPARE(a,b)   a > b
#define INITIAL        -G95_INT1_MAX
#define SUBROUTINE     prefix(maxval_i1)
#define SUBROUTINE_D   prefix(maxvald_i1)
#define SUBROUTINE_1   prefix(maxval1_i1)
#define SUBROUTINE_1D  prefix(maxval1d_i1)
#include "mmval.c"

#define TYPE           G95_INT1
#define COMPARE(a,b)   a < b
#define INITIAL        G95_INT1_MAX
#define SUBROUTINE     prefix(minval_i1)
#define SUBROUTINE_D   prefix(minvald_i1)
#define SUBROUTINE_1   prefix(minval1_i1)
#define SUBROUTINE_1D  prefix(minval1d_i1)
#include "mmval.c"

#define TYPE           G95_INT2
#define COMPARE(a,b)   a > b
#define INITIAL        -G95_INT2_MAX
#define SUBROUTINE     prefix(maxval_i2)
#define SUBROUTINE_D   prefix(maxvald_i2)
#define SUBROUTINE_1   prefix(maxval1_i2)
#define SUBROUTINE_1D  prefix(maxval1d_i2)
#include "mmval.c"

#define TYPE           G95_INT2
#define COMPARE(a,b)   a < b
#define INITIAL        G95_INT2_MAX
#define SUBROUTINE     prefix(minval_i2)
#define SUBROUTINE_D   prefix(minvald_i2)
#define SUBROUTINE_1   prefix(minval1_i2)
#define SUBROUTINE_1D  prefix(minval1d_i2)
#include "mmval.c"

#define TYPE           G95_INT4
#define COMPARE(a,b)   a > b
#define INITIAL        -G95_INT4_MAX
#define SUBROUTINE     prefix(maxval_i4)
#define SUBROUTINE_D   prefix(maxvald_i4)
#define SUBROUTINE_1   prefix(maxval1_i4)
#define SUBROUTINE_1D  prefix(maxval1d_i4)
#include "mmval.c"

#define TYPE           G95_INT4
#define COMPARE(a,b)   a < b
#define INITIAL        G95_INT4_MAX
#define SUBROUTINE     prefix(minval_i4)
#define SUBROUTINE_D   prefix(minvald_i4)
#define SUBROUTINE_1   prefix(minval1_i4)
#define SUBROUTINE_1D  prefix(minval1d_i4)
#include "mmval.c"

#ifdef G95_INT8

#define TYPE           G95_INT8
#define COMPARE(a,b)   a > b
#define INITIAL        -G95_INT8_MAX
#define SUBROUTINE     prefix(maxval_i8)
#define SUBROUTINE_D   prefix(maxvald_i8)
#define SUBROUTINE_1   prefix(maxval1_i8)
#define SUBROUTINE_1D  prefix(maxval1d_i8)
#include "mmval.c"

#define TYPE           G95_INT8
#define COMPARE(a,b)   a < b
#define INITIAL        G95_INT8_MAX
#define SUBROUTINE     prefix(minval_i8)
#define SUBROUTINE_D   prefix(minvald_i8)
#define SUBROUTINE_1   prefix(minval1_i8)
#define SUBROUTINE_1D  prefix(minval1d_i8)
#include "mmval.c"

#endif

#ifdef G95_INT16

#define TYPE           G95_INT16
#define COMPARE        >
#define INITIAL        -G95_INT16_MAX
#define SUBROUTINE     prefix(maxval_i16)
#define SUBROUTINE_D   prefix(maxvald_i16)
#define SUBROUTINE_1   prefix(maxval1_i16)
#define SUBROUTINE_1D  prefix(maxval1d_i16)
#include "mmval.c"

#define TYPE           G95_INT16
#define COMPARE        <
#define INITIAL        G95_INT16_MAX
#define SUBROUTINE     prefix(minval_i16)
#define SUBROUTINE_D   prefix(minvald_i16)
#define SUBROUTINE_1   prefix(minval1_i16)
#define SUBROUTINE_1D  prefix(minval1d_i16)
#include "mmval.c"

#endif


#define TYPE           float
#define COMPARE(a,b)   a > b
#define INITIAL        -prefix(huge_4)()
#define SUBROUTINE     prefix(maxval_r4)
#define SUBROUTINE_D   prefix(maxvald_r4)
#define SUBROUTINE_1   prefix(maxval1_r4)
#define SUBROUTINE_1D  prefix(maxval1d_r4)
#include "mmval.c"

#define TYPE           float
#define COMPARE(a,b)   a < b
#define INITIAL        prefix(huge_4)()
#define SUBROUTINE     prefix(minval_r4)
#define SUBROUTINE_D   prefix(minvald_r4)
#define SUBROUTINE_1   prefix(minval1_r4)
#define SUBROUTINE_1D  prefix(minval1d_r4)
#include "mmval.c"

#define TYPE           double
#define COMPARE(a,b)   a > b
#define INITIAL        -prefix(huge_8)()
#define SUBROUTINE     prefix(maxval_r8)
#define SUBROUTINE_D   prefix(maxvald_r8)
#define SUBROUTINE_1   prefix(maxval1_r8)
#define SUBROUTINE_1D  prefix(maxval1d_r8)
#include "mmval.c"

#define TYPE           double
#define COMPARE(a,b)   a < b
#define INITIAL        prefix(huge_8)()
#define SUBROUTINE     prefix(minval_r8)
#define SUBROUTINE_D   prefix(minvald_r8)
#define SUBROUTINE_1   prefix(minval1_r8)
#define SUBROUTINE_1D  prefix(minval1d_r8)
#include "mmval.c"


#define TYPE           packed16
#define COMPARE(a,b)   (__gttf2(a, b) > 0)
#define INITIAL        prefix(hugem_v16)
#define SUBROUTINE     prefix(maxval_r16)
#define SUBROUTINE_D   prefix(maxvald_r16)
#define SUBROUTINE_1   prefix(maxval1_r16)
#define SUBROUTINE_1D  prefix(maxval1d_r16)
#include "mmval.c"


#define TYPE           packed16
#define COMPARE(a,b)   (__lttf2(a, b) < 0)
#define INITIAL        prefix(huge_v16);
#define SUBROUTINE     prefix(minval_r16)
#define SUBROUTINE_D   prefix(minvald_r16)
#define SUBROUTINE_1   prefix(minval1_r16)
#define SUBROUTINE_1D  prefix(minval1d_r16)
#include "mmval.c"

#endif

