
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the UNPACK() intrinsic. */

#include "runtime.h"
#include <string.h>


#define unpack prefix(unpack)


g95_array_descriptor *unpack(g95_array_descriptor *vector,
			     g95_array_descriptor *mask,
			     g95_array_descriptor *field, 
			     alloc_struct *a) {

G95_AINT mask_x[G95_MAX_DIMENSIONS], field_x[G95_MAX_DIMENSIONS];
G95_AINT v, extent, element_size;
int i, m, rank, zero_size;

g95_array_descriptor *result;
char *p, *q;

    rank = mask->rank;
    element_size = vector->element_size;
    zero_size = 0;

    section_info[0] = rank;
    section_info[1] = vector->element_size;

    m = 2;
    for(i=0; i<rank; i++) {
	extent = mask->info[i].ubound - mask->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	section_info[m++] = 1;
	section_info[m++] = extent;

	mask_x[i]  = mask->info[i].lbound;
	field_x[i] = field->info[i].lbound;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;
    v = vector->info[0].lbound;

    for(;;) {
	q = mask->offset;
	for(i=0; i<rank; i++)
	    q += mask->info[i].mult * mask_x[i];

	if (extract_logical(q, mask->element_size)) {
	    q = vector->offset + vector->info[0].mult * v;
	    v++;

	} else {
	    q = field->offset;
	    for(i=0; i<rank; i++)
		q += field->info[i].mult * field_x[i];
	}

	if (a == NULL)
	    memcpy(p, q, element_size);

	else
	    deep_copy(p, q, element_size, a);

	p += element_size;

	bump_element(field, field_x);
	if (bump_element(mask, mask_x))
	    break;
    }

    return result;
}


#define unpack_s prefix(unpack_s)

g95_array_descriptor *unpack_s(g95_array_descriptor *vector,
			       g95_array_descriptor *mask,
			       char *field, alloc_struct *a) {
G95_AINT v, extent, element_size, mask_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, m, rank, zero_size;
char *p, *q;

    rank = mask->rank;
    element_size = vector->element_size;
    zero_size = 0;

    section_info[0] = rank;
    section_info[1] = vector->element_size;

    m = 2;
    for(i=0; i<rank; i++) {
	extent = mask->info[i].ubound - mask->info[i].lbound + 1;
	if (extent <= 0) {
	    extent = 0;
	    zero_size = 1;
	}

	section_info[m++] = 1;
	section_info[m++] = extent;

	mask_x[i]  = mask->info[i].lbound;
    }

    result = array_from_section(NULL);
    if (zero_size)
	return result;

    p = result->base;
    v = vector->info[0].lbound;

    for(;;) {
	q = mask->offset;
	for(i=0; i<rank; i++)
	    q += mask->info[i].mult * mask_x[i];

	q = extract_logical(q, mask->element_size)
	    ? vector->offset + vector->info[0].mult * v++
	    : field;

	if (a == NULL)
	    memcpy(p, q, element_size);

	else
	    deep_copy(p, q, element_size, a);

	p += element_size;

	if (bump_element(mask, mask_x))
	    break;
    }

    return result;
}
