
/* Copyright (C) 2002-2008 Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include <string.h>
#include "runtime.h"


static namelist_info *namelist_head=NULL, *namelist_tail=NULL;


/* namelist()-- Add a variable to the current namelist information.
 * Nodes are added to the end of the list so that namelist writes
 * produce output in the same order as the namelist. */

#define namelist prefix(namelist)

void namelist(char *name, int type, int kind, void *pointer, void *dt_info) {
namelist_info *p;

    p = get_mem(sizeof(namelist_info));

    p->name = name;
    p->type = type;
    p->kind = kind;

    p->pointer = pointer;
    p->dt_info = dt_info;

    if (namelist_head == NULL)
	namelist_head = namelist_tail = p;
    else {
	namelist_tail->next = p;
	namelist_tail = p;
    }
}


/* first_namelist()-- Return the first namelist node */

namelist_info *first_namelist(void) {

    return namelist_head;
}



/* find_namelist()-- Given a name, find the namelist node.  Returns
 * NULL if the node is not found. */

namelist_info *find_namelist(char *name) {
namelist_info *n;

    for(n=namelist_head; n; n=n->next)
	if (strcasecmp(name, n->name) == 0)
	    return n;

    return NULL;
}


/* namelist_done()-- Cleanup after a namelist transfer. */

void namelist_done(void) {
namelist_info *p, *q;

    for(p=namelist_head; p; p=q) {
	q = p->next;
	free_mem(p);
    }

    namelist_head = namelist_tail = NULL;
}

