
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include <math.h>
#include "runtime.h"


#define besj0_4 prefix(besj0_4)
float besj0_4(float *x) { return j0(*x); }

#define besj0_8 prefix(besj0_8)
double besj0_8(double *x) { return j0(*x); }


#define besj1_4 prefix(besj1_4)
float besj1_4(float *x) { return j1(*x); }

#define besj1_8 prefix(besj1_8)
double besj1_8(double *x) { return j1(*x); }


#define besjn_4 prefix(besjn_4)
float besjn_4(G95_DINT *n, float *x) { return jn(*n, *x); }

#define besjn_8 prefix(besjn_8)
double besjn_8(G95_DINT *n, double *x) { return jn(*n, *x); }


#define besy0_4 prefix(besy0_4)
float besy0_4(float *x) { return y0(*x); }

#define besy0_8 prefix(besy0_8)
double besy0_8(double *x) { return y0(*x); }


#define besy1_4 prefix(besy1_4)
float besy1_4(float *x) { return y1(*x); }

#define besy1_8 prefix(besy1_8)
double besy1_8(double *x) { return y1(*x); }


#define besyn_4 prefix(besyn_4)
float besyn_4(G95_DINT *n, float *x) { return yn(*n, *x); }

#define besyn_8 prefix(besyn_8)
double besyn_8(G95_DINT *n, double *x) { return yn(*n, *x); }

