

#include "runtime.h"

#if HAVE_SCHED_YIELD
#include <sched.h>
#endif

#include <stdlib.h>


/* x86/x86_64 */

#if defined(FPU_387)

int cas(volatile int *mem, int old, int new) {
char result;

    __asm__ __volatile__("lock; cmpxchgl %2, %0 \n"
			 "setz %1 \n"
			 : "+m"(*(mem)), "=q"(result)
			 : "r" (new), "a"(old) : "memory");

    return (int) result;
}

#elif defined(FPU_ALPHA)

/* alpha */

int cas(volatile int *addr, int old, int new) {
unsigned was_equal;
unsigned temp;

    __asm__ __volatile__(
                     "1: ldl_l %0, %1     \n"
                     "   cmpeq %0, %4, %2 \n"
                     "   mov %3, %0       \n"
                     "   beq %2, 2f       \n"
                     "   stl_c %0, %1     \n"
                     "   beq %0, 1b       \n"
                     "2:\n"
                     :"=&r" (temp), "=m" (*addr), "=&r" (was_equal)
                     : "r" (new), "Ir" (old)
                     :"memory");

    return was_equal;
}

#elif defined(_AIX)

/* powerpc/AIX.  Although this is basically powerpc, the label syntax
 * is different, and we must compile with -mpowerpc. */

int cas(volatile int *addr, int old, int new) {
int old_val;

    __asm__ __volatile__("LLL1:lwarx %0,0,%3\n"
			 "cmpw %0, %4\n"
			 "bne LLL2\n"
			 "stwcx. %2,0,%1\n"
			 "bne LLL1\n"
			 "LLL2:\n"

			 : "=&r" (old_val), "=p" (addr)
			 : "r" (new), "1"(addr), "r" (old)
			 : "memory");
 
    return old_val == old;
}


#elif defined(FPU_PPC1) || defined(FPU_PPC2)

/* powerpc */

int cas(volatile int *addr, int old, int new) {
int old_val;

    __asm__ __volatile__("1: lwarx %0, 0, %3  \n"
			 "   cmpw %0, %4      \n"
			 "   bne 2f           \n"
			 "   stwcx. %2, 0, %1 \n"
			 "   bne- 1b          \n"
			 "2:\n"

			 : "=&r" (old_val), "=p" (addr)
			 : "r" (new), "1"(addr), "r" (old)
			 : "memory");
 
    return old_val == old;
}


#elif defined(FPU_IA64)

/* IA-64 */

int cas(volatile int *addr, int old, int new) {
int old_val;

    __asm__ __volatile__("mov ar.ccv=%3                \n"
			 "cmpxchg4.acq %0=%1,%2,ar.ccv \n"
			 : "=r"(old_val), "+S"(*addr)
			 : "r"(new), "r"(old) : "memory");

    return old_val == old;
}

#elif defined(FPU_MIPS)

/* Mips */

int cas(volatile int *addr, int old, int new) {
int old_val, temp;

    __asm__ __volatile__("   move %5, %2     \n"
			 "1: move %2, %5     \n"
			 "   ll   %0, %4     \n"
			 "   bne  %0, %3, 2f \n"
			 "   sc   %2, %1     \n"
			 "   beqz %2, 1b     \n"
			 "2:\n"
			 : "=&r" (old_val), "=m" (*addr)
			 : "r" (new), "r" (old), "m" (*addr), "r" (temp)
			 : "memory");

    return old_val == old;
}

#elif defined(FPU_SPARC)

/* Sparc (v9) */

int cas(volatile int *mem, int old, int new) {

    __asm__ __volatile__("cas %0, %2, %1 \n"
                        : "+m" (*mem), "+r" (new)
                        : "r" (old)
                        : "memory" );

    return new == old;
}


#else

/* Fake cas(), doesn't really lock anything. */

int cas(volatile int *mem, int old, int new) {

    if (*mem != old)
	return 0;

    *mem = new;
    return 1;
}

#endif



/* aquire_lock()-- Aquire a lock.  Returns when we have the lock. */

void aquire_lock(volatile int *mem) {
int count;

    count = 0;

    for(;;) {
	if (cas(mem, 0, 1))
	    break;

	if (count < 10000)
	    count++;

	else {
#if HAVE_SCHED_YIELD
	    sched_yield();
#elif HAVE_WINDOWS
	    Sleep(0);
#else
	    usleep(1000);
#endif
	}
    }
}

