
/* Copyright (C) 2002-2008 Free Software Foundation, Inc.
  Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stddef.h>
#include <signal.h>

#include "runtime.h"


#if HAVE_DL_MALLOC
#include <malloc.h>
#endif


static st_parameter iobase;
st_parameter *ioparm = NULL;
global_t globals;

int init_flag=0;

#define string_len prefix(string_len)
#define library_return prefix(library_return)

G95_DINT string_len, junk_stat, library_return;

char **f__xargv;
int f__xargc;



void get_ioparm(void) {
st_parameter *p;

    p = (ioparm == NULL)
	? &iobase
	: temp_alloc(sizeof(st_parameter));

    memset(p, '\0', sizeof(st_parameter));

    p->prev = ioparm;
    p->unit_save = current_unit;
    p->file_save = filename;
    p->line_save = line;

    ioparm = p;
}


/* library_start()-- Called when an I/O call starts.  */

void library_start(void) {

    if (!init_flag)
	g95_runtime_start(0, NULL);

    if (ioparm->iostat != NULL)
	set_integer(ERROR_OK, ioparm->iostat, ioparm->iostat_kind);

    ioparm->library_rc = LIBRARY_OK;

#if HAVE_RESUME
    if (ioparm == &iobase) {
	sigset_t set;

	sigemptyset(&set);
	sigaddset(&set, SIGQUIT);
	sigaddset(&set, SIGALRM);
	sigprocmask(SIG_BLOCK, &set, NULL);
    }
#endif
}



/* library_end()-- Called when a library call is complete in order to
 * clean up for the next call. */

void library_end(void) {
st_parameter *p;

    library_return = ioparm->library_rc;

    if (ioparm == &iobase) {
	current_unit = NULL;
	filename = NULL;
	line = 0;

	memset(&ioparm, '\0', sizeof(ioparm));
	ioparm = NULL;

    } else {
	current_unit = ioparm->unit_save;
	filename = ioparm->file_save;
	line = ioparm->line_save;

	p = ioparm->prev;
	temp_free((void *) &ioparm);
	ioparm = p;
    }

#if HAVE_RESUME
    if (ioparm == NULL) {
	sigset_t set;

	sigemptyset(&set);
	sigaddset(&set, SIGQUIT);
	sigaddset(&set, SIGALRM);
	sigprocmask(SIG_UNBLOCK, &set, NULL);
    }
#endif
}



/* xorshift128()-- Internal random number generator used for various
 * things.  Developed by George Marsaglia, it has a period of 2^128-1
 * and passes all of his DIEHARD tests for random numbers. */

int xorshift128() {
static unsigned long x=123456789, y=362436069, z=521288629, w=88675123;
unsigned long t;

    t = x ^ (x << 20) ^ y ^ (y >> 11) ^ z ^ (z << 27) ^ w ^ (w << 6);

    x = y;
    y = z;
    z = w;
    w = t;

    return w;
}



/* g95_runtime_start()-- Get things ready to run */

void g95_runtime_start(int argc, char *argv[]) {

    f__xargc = argc;
    f__xargv = argv;

    init_variables();   /* Must be first */

#if HAVE_DL_MALLOC
    mallopt(M_MXFAST,         options.mem_mxfast);
    mallopt(M_TRIM_THRESHOLD, options.mem_trim_threshold);
    mallopt(M_TOP_PAD,        options.mem_top_pad);
#endif

    init_units();
    init_fpu();
    init_fpu_trap();
    init_random_seed(1);
    init_coarray();

    /* Check for special command lines */

    if (argc > 1 && strcmp(argv[1], "--g95") == 0)
	show_variables();

    init_memory();
    init_flag = 1;
}



/* g95_runtime_stop()-- Finish up runtime things */

void g95_runtime_stop(void) {

    if (options.view_exceptions)
	show_exceptions();

    close_units();
}
