
/* Copyright (C) 2005-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/


#include <sys/time.h>
#include <unistd.h>

#include "runtime.h"


/* system_clock()-- The system clock ticks at a rate determined by the
 * environment.  The maximum tick is always HUGE(0).  Internally, we
 * count microseconds. */

#define system_clock prefix(system_clock)

void system_clock(void *count, int count_kind,
		  void *count_rate_i, int count_rate_i_kind,
		  void *count_rate_r, int count_rate_r_kind,
		  void *count_max, int count_max_kind) {

static struct timeval base;
G95_DINT c, m0, m1, u0, u1;
static int have_base = 0;
struct timeval tv;

    if (options.system_clock_ticks <= 0 ||
	options.system_clock_ticks > 1000000) {  /* No clock */

	if (count != NULL)
	    set_integer(G95_DINT_MAX, count, count_kind);

	if (count_rate_i != NULL)
	    set_integer(0, count_rate_i, count_rate_i_kind);

	if (count_rate_r != NULL)
	    set_real(0, count_rate_r, count_rate_r_kind);

	if (count_max != NULL)
	    set_integer(0, count_max, count_max_kind);

    } else {
	if (count_rate_i != NULL)
	    set_integer(options.system_clock_ticks, count_rate_i,
			count_rate_i_kind);

	if (count_rate_r != NULL)
	    set_real(options.system_clock_ticks, count_rate_r,
		     count_rate_r_kind);
    
	if (count_max != NULL)
	    set_integer(G95_DINT_MAX, count_max, count_max_kind);

	if (count != NULL) {
	    gettimeofday(&tv, NULL);

	    if (!have_base) {
		base = tv;
		have_base = 1;
	    }

	    tv.tv_sec  -= base.tv_sec;
	    tv.tv_usec -= base.tv_usec;

	    if (tv.tv_usec < 0) {
		tv.tv_usec += 1000000;
		tv.tv_sec--;
	    }

	    m1 = options.system_clock_ticks % 1000;
	    m0 = options.system_clock_ticks / 1000;

	    u1 = tv.tv_usec % 1000;
	    u0 = tv.tv_usec / 1000;

	    c = ((G95_DINT) tv.tv_sec) * options.system_clock_ticks +
		u0*m0 + (m1*u1 + 1000*(u0*m1 + u1*m0))/1000000;

	    set_integer(c & G95_DINT_MAX, count, count_kind);
	}
    }
}
