
/* Copyright (C) 2003, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the PACK() intrinsic. */

#include <string.h>
#include "runtime.h"

#define pack prefix(pack)

g95_array_descriptor *pack(g95_array_descriptor *array,
			   g95_array_descriptor *mask,
			   g95_array_descriptor *vector,
			   alloc_struct *a) {

G95_AINT array_x[G95_MAX_DIMENSIONS], mask_x[G95_MAX_DIMENSIONS];
G95_AINT count, mask_count, vsize, element_size, e1, e2;
g95_array_descriptor *result;
int i, rank, zero_sized;
char *p, *q;

    count = 0;
    rank = array->rank;
    element_size = array->element_size;

    zero_sized = 0;

    for(i=0; i<rank; i++) {
	mask_x[i] = mask->info[i].lbound;

	e1 = array->info[i].ubound - array->info[i].lbound + 1;
	if (e1 <= 0) {
	    e1 = 0;
	    zero_sized = 1;
	}

	e2 = mask->info[i].ubound - mask->info[i].lbound + 1;
	if (e2 <= 0) {
	    e2 = 0;
	    zero_sized = 1;
	}

	if (e1 != e2)
	    runtime_error("ARRAY and MASK arguments to PACK do not conform"); 
    }

    if (!zero_sized)
	for(;;) {
	    p = mask->offset;
	    for(i=0; i<rank; i++)
		p += mask->info[i].mult * mask_x[i];

	    if (extract_logical(p, mask->element_size))
		count++;

	    if (bump_element(mask, mask_x))
		break;
	}

    mask_count = count;

    if (vector != NULL) {
	vsize = vector->info[0].ubound - vector->info[0].lbound + 1;
	if (vsize < 0)
	    vsize = 0;

	if (vsize > count)
	    count = vsize;
    }

    result = temp_array(1, element_size, count);
    if (count == 0)
	return result;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;
	mask_x[i]  = mask->info[i].lbound;
    }

    p = result->base;
    count = 0;

    while(!zero_sized) {
	q = mask->offset;
	for(i=0; i<rank; i++)
	    q += mask->info[i].mult * mask_x[i];

	if (extract_logical(q, mask->element_size)) {
	    q = array->offset;
	    for(i=0; i<rank; i++)
		q += array->info[i].mult * array_x[i];

	    if (a == NULL)
		memcpy(p, q, element_size);

	    else
		deep_copy(p, q, element_size, a);

	    p += element_size;
	}

	bump_element(mask, mask_x);
	if (bump_element(array, array_x))
	    break;
    }

/* Fill up things with vector */

    if (vector != NULL) {
	for(i=vector->info[0].lbound+mask_count;i<=vector->info[0].ubound;i++){
	    q = vector->offset + vector->info[0].mult*i;

	    if (a == NULL)
		memcpy(p, q, element_size);
	    else
		deep_copy(p, q, element_size, a);

	    p += element_size;
	}
    }

    return result;
}


#define pack_s prefix(pack_s)

g95_array_descriptor *pack_s(g95_array_descriptor *array, G95_DINT *mask,
			     g95_array_descriptor *vector, alloc_struct *a) {
G95_AINT vsize, mask_count, count, element_size, extent;
G95_AINT array_x[G95_MAX_DIMENSIONS];
g95_array_descriptor *result;
int i, rank, zero_sized;
char *p, *q;

    rank = array->rank;
    element_size = array->element_size;

    if (!*mask)
	count = 0;

    else {
	count = 1;

	for(i=0; i<rank; i++) {
	    extent = array->info[i].ubound - array->info[i].lbound + 1;
	    if (extent < 0)
		extent = 0;

	    count = count * extent;
	}
    }

    mask_count = count;

    if (vector != NULL) {
	vsize = vector->info[0].ubound - vector->info[0].lbound + 1;
	if (vsize < 0)
	    vsize = 0;

	if (vsize > count)
	    count = vsize;
    }

    result = temp_array(1, element_size, count);
    zero_sized = 0;

    for(i=0; i<rank; i++) {
	array_x[i] = array->info[i].lbound;

	if (array->info[i].lbound > array->info[i].ubound)
	    zero_sized = 1;
    }

    p = result->base;
    count = 0;

    if (*mask && !zero_sized)
	for(;;) {
	    q = array->offset;
	    for(i=0; i<rank; i++)
		q += array->info[i].mult * array_x[i];

	    if (a == NULL)
		memcpy(p, q, element_size);
	    else
		deep_copy(p, q, element_size, a);

	    p += element_size;

	    if (bump_element(array, array_x))
		break;
	}

/* Fill up things with vector */

    if (vector != NULL) {
	for(i=vector->info[0].lbound+mask_count;i<=vector->info[0].ubound;i++){
	    q = vector->offset + vector->info[0].mult*i;

	    if (a == NULL)
		memcpy(p, q, element_size);
	    else
		deep_copy(p, q, element_size, a);

	    p += element_size;
	}
    }

    return result;
}
