
/* Copyright (C) 2003-2008, Free Software Foundation, Inc.
   Contributed by Andy Vaught

  This file is part of g95.

  G95 is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  G95 is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with g95; see the file COPYING.  If not, write to
  the Free Software Foundation, 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.

  In addition to the permissions in the GNU General Public License, the
  Free Software Foundation gives you unlimited permission to link the
  compiled version of this file into combinations with other programs,
  and to distribute those combinations without any restriction coming
  from the use of this file.  (The General Public License restrictions
  do apply in other respects; for example, they cover modification of
  the file, and distribution when not linked into a combined executable.)
*/

/* Implement the reshape() intrinsic. */

#include "runtime.h"
#include <string.h>

#define reshape prefix(reshape)

g95_array_descriptor *reshape(g95_array_descriptor *source,
			      g95_array_descriptor *shape,
			      g95_array_descriptor *pad,
			      g95_array_descriptor *order) {


G95_AINT source_x[G95_MAX_DIMENSIONS],  pad_x[G95_MAX_DIMENSIONS], 
         perm[G95_MAX_DIMENSIONS],      r_index[G95_MAX_DIMENSIONS];
G95_AINT m, element_size;
int rank, i, n, zero_size, source_flag, reset_pad;
g95_array_descriptor *r;
char *p, *q;

    rank = shape->info[0].ubound - shape->info[0].lbound + 1;   

    /* Extract the shape */

    section_info[0] = rank;
    section_info[1] = element_size = source->element_size;
    n = 2;

    zero_size = 0;
    reset_pad = 1;

    for(i=0; i<rank; i++) {
	m = shape->info[0].lbound + i;
	p = shape->offset + m*shape->info[0].mult;

	section_info[n++] = 1;
	section_info[n] = *((int *) p);

	if (section_info[n++] <= 0)
	    zero_size = 1;

	r_index[i] = 1;
    }

    for(i=0; i<source->rank; i++)
	source_x[i] = source->info[i].lbound;

    source_flag = 1;

    for(i=0; i<source->rank; i++)
	if (source->info[i].lbound > source->info[i].ubound) {
	    source_flag = 0;
	    break;
	}

    r = array_from_section(NULL);
    if (zero_size)
	goto done;

    /* Extract the order array, otherwise create the identity
     * permutation. */

    if (order == NULL) {
	for(i=0; i<rank; i++)
	    perm[i] = i;

    } else {
	for(i=0; i<rank; i++) {
	    m = order->info[0].lbound + i;
	    p = order->offset + m*order->info[0].mult;

	    perm[i] = *((int *) p) - 1;
	}
    }

    /* Loop over the destination array. */

    for(;;) {
	p = r->offset;
	for(i=0; i<rank; i++)
	    p += r->info[i].mult * r_index[i];

	if (source_flag) {   /* Use source elements */
	    q = source->offset;
	    for(i=0; i<source->rank; i++)
		q += source->info[i].mult * source_x[i];

	    if (bump_element(source, source_x))
		source_flag = 0;

	} else {  /* Pad elements in array order */

	    if (pad == NULL)
		runtime_error("reshape(): "
			      "Exhausted source elements and no pad");

	    if (reset_pad) {
		reset_pad = 0;

		for(i=0; i<pad->rank; i++)
		    pad_x[i] = pad->info[i].lbound;
	    }

	    q = pad->offset;
	    for(i=0; i<pad->rank; i++)
		q += pad->info[i].mult * pad_x[i];

	    if (bump_element(pad, pad_x))
		reset_pad = 1;
	}

	memcpy(p, q, element_size);

	/* Normally, we'd just call bump_element() here, but the order
	 * of the subscripts is permuted. */

	i = 0;
	for(;;) {
	    m = perm[i];
	    if (++r_index[m] <= r->info[m].ubound)
		break;

	    r_index[m] = r->info[m].lbound;
	    if (++i >= r->rank)
		goto done;
	}
    }

done:
    return r;
}
