;;;============================================================================

;;; File: "_prims.scm", Time-stamp: <2009-06-03 16:07:48 feeley>

;;; Copyright (c) 1994-2009 by Marc Feeley, All Rights Reserved.

(include "fixnum.scm")

;;;----------------------------------------------------------------------------
;;
;; Primitive procedure database:

;;; - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

(define prim-procs '
(
;;                                                       lift pattern
;;                                                       /
;;                          side-effects?   strictness  /  result
;;                                      \   pattern    /   type
;; name                  call pattern    \  \         /    /     standard
;;  /                               \     \  \       /    /      |
("not"                                (1)   #f 0     0    boolean ieee)
("boolean?"                           (1)   #f 0     0    boolean ieee)
("eqv?"                               (2)   #f 0     0    boolean ieee)
("eq?"                                (2)   #f 0     0    boolean ieee)
("equal?"                             (2)   #f 0     0    boolean ieee)
("pair?"                              (1)   #f 0     0    boolean ieee)
("cons"                               (2)   #f ()    0    pair    ieee)
("car"                                (1)   #f 0     0    (#f)    ieee)
("cdr"                                (1)   #f 0     0    (#f)    ieee)
("set-car!"                           (2)   #t (1)   0    pair    ieee)
("set-cdr!"                           (2)   #t (1)   0    pair    ieee)
("caar"                               (1)   #f 0     0    (#f)    ieee)
("cadr"                               (1)   #f 0     0    (#f)    ieee)
("cdar"                               (1)   #f 0     0    (#f)    ieee)
("cddr"                               (1)   #f 0     0    (#f)    ieee)
("caaar"                              (1)   #f 0     0    (#f)    ieee)
("caadr"                              (1)   #f 0     0    (#f)    ieee)
("cadar"                              (1)   #f 0     0    (#f)    ieee)
("caddr"                              (1)   #f 0     0    (#f)    ieee)
("cdaar"                              (1)   #f 0     0    (#f)    ieee)
("cdadr"                              (1)   #f 0     0    (#f)    ieee)
("cddar"                              (1)   #f 0     0    (#f)    ieee)
("cdddr"                              (1)   #f 0     0    (#f)    ieee)
("caaaar"                             (1)   #f 0     0    (#f)    ieee)
("caaadr"                             (1)   #f 0     0    (#f)    ieee)
("caadar"                             (1)   #f 0     0    (#f)    ieee)
("caaddr"                             (1)   #f 0     0    (#f)    ieee)
("cadaar"                             (1)   #f 0     0    (#f)    ieee)
("cadadr"                             (1)   #f 0     0    (#f)    ieee)
("caddar"                             (1)   #f 0     0    (#f)    ieee)
("cadddr"                             (1)   #f 0     0    (#f)    ieee)
("cdaaar"                             (1)   #f 0     0    (#f)    ieee)
("cdaadr"                             (1)   #f 0     0    (#f)    ieee)
("cdadar"                             (1)   #f 0     0    (#f)    ieee)
("cdaddr"                             (1)   #f 0     0    (#f)    ieee)
("cddaar"                             (1)   #f 0     0    (#f)    ieee)
("cddadr"                             (1)   #f 0     0    (#f)    ieee)
("cdddar"                             (1)   #f 0     0    (#f)    ieee)
("cddddr"                             (1)   #f 0     0    (#f)    ieee)
("null?"                              (1)   #f 0     0    boolean ieee)
("list?"                              (1)   #f 0     0    boolean ieee)
("list"                               0     #f ()    0    list    ieee)
("length"                             (1)   #f 0     0    integer ieee)
("append"                             0     #f 0     0    list    ieee)
("reverse"                            (1)   #f 0     0    list    ieee)
("list-ref"                           (2)   #f 0     0    (#f)    ieee)
("memq"                               (2)   #f 0     0    list    ieee)
("memv"                               (2)   #f 0     0    list    ieee)
("member"                             (2)   #f 0     0    list    ieee)
("assq"                               (2)   #f 0     0    #f      ieee)
("assv"                               (2)   #f 0     0    #f      ieee)
("assoc"                              (2)   #f 0     0    #f      ieee)
("symbol?"                            (1)   #f 0     0    boolean ieee)
("symbol->string"                     (1)   #f 0     0    string  ieee)
("string->symbol"                     (1)   #f 0     0    symbol  ieee)
("number?"                            (1)   #f 0     0    boolean ieee)
("complex?"                           (1)   #f 0     0    boolean ieee)
("real?"                              (1)   #f 0     0    boolean ieee)
("rational?"                          (1)   #f 0     0    boolean ieee)
("integer?"                           (1)   #f 0     0    boolean ieee)
("exact?"                             (1)   #f 0     0    boolean ieee)
("inexact?"                           (1)   #f 0     0    boolean ieee)
("="                                  0     #f 0     0    boolean ieee)
("<"                                  0     #f 0     0    boolean ieee)
(">"                                  0     #f 0     0    boolean ieee)
("<="                                 0     #f 0     0    boolean ieee)
(">="                                 0     #f 0     0    boolean ieee)
("zero?"                              (1)   #f 0     0    boolean ieee)
("positive?"                          (1)   #f 0     0    boolean ieee)
("negative?"                          (1)   #f 0     0    boolean ieee)
("odd?"                               (1)   #f 0     0    boolean ieee)
("even?"                              (1)   #f 0     0    boolean ieee)
("max"                                1     #f 0     0    number  ieee)
("min"                                1     #f 0     0    number  ieee)
("+"                                  0     #f 0     0    number  ieee)
("*"                                  0     #f 0     0    number  ieee)
("-"                                  1     #f 0     0    number  ieee)
("/"                                  1     #f 0     0    number  ieee)
("abs"                                (1)   #f 0     0    number  ieee)
("quotient"                           (2)   #f 0     0    integer ieee)
("remainder"                          (2)   #f 0     0    integer ieee)
("modulo"                             (2)   #f 0     0    integer ieee)
("gcd"                                1     #f 0     0    integer ieee)
("lcm"                                1     #f 0     0    integer ieee)
("numerator"                          (1)   #f 0     0    integer ieee)
("denominator"                        (1)   #f 0     0    integer ieee)
("floor"                              (1)   #f 0     0    integer ieee)
("ceiling"                            (1)   #f 0     0    integer ieee)
("truncate"                           (1)   #f 0     0    integer ieee)
("round"                              (1)   #f 0     0    integer ieee)
("rationalize"                        (2)   #f 0     0    number  ieee)
("exp"                                (1)   #f 0     0    number  ieee)
("log"                                (1)   #f 0     0    number  ieee)
("sin"                                (1)   #f 0     0    number  ieee)
("cos"                                (1)   #f 0     0    number  ieee)
("tan"                                (1)   #f 0     0    number  ieee)
("asin"                               (1)   #f 0     0    number  ieee)
("acos"                               (1)   #f 0     0    number  ieee)
("atan"                               (1 2) #f 0     0    number  ieee)
("expt"                               (2)   #f 0     0    number  ieee)
("sqrt"                               (1)   #f 0     0    number  ieee)
("make-rectangular"                   (2)   #f 0     0    number  ieee)
("make-polar"                         (2)   #f 0     0    number  ieee)
("real-part"                          (1)   #f 0     0    real    ieee)
("imag-part"                          (1)   #f 0     0    real    ieee)
("magnitude"                          (1)   #f 0     0    real    ieee)
("angle"                              (1)   #f 0     0    real    ieee)
("exact->inexact"                     (1)   #f 0     0    number  ieee)
("inexact->exact"                     (1)   #f 0     0    number  ieee)
("number->string"                     (1 2) #f 0     0    string  ieee)
("string->number"                     (1 2) #f 0     0    number  ieee)
("char?"                              (1)   #f 0     0    boolean ieee)
("char=?"                             0     #f 0     0    boolean ieee)
("char<?"                             0     #f 0     0    boolean ieee)
("char>?"                             0     #f 0     0    boolean ieee)
("char<=?"                            0     #f 0     0    boolean ieee)
("char>=?"                            0     #f 0     0    boolean ieee)
("char-ci=?"                          0     #f 0     0    boolean ieee)
("char-ci<?"                          0     #f 0     0    boolean ieee)
("char-ci>?"                          0     #f 0     0    boolean ieee)
("char-ci<=?"                         0     #f 0     0    boolean ieee)
("char-ci>=?"                         0     #f 0     0    boolean ieee)
("char-alphabetic?"                   (1)   #f 0     0    boolean ieee)
("char-numeric?"                      (1)   #f 0     0    boolean ieee)
("char-whitespace?"                   (1)   #f 0     0    boolean ieee)
("char-upper-case?"                   (1)   #f 0     0    boolean ieee)
("char-lower-case?"                   (1)   #f 0     0    boolean ieee)
("char->integer"                      (1)   #f 0     0    integer ieee)
("integer->char"                      (1)   #f 0     0    char    ieee)
("char-upcase"                        (1)   #f 0     0    char    ieee)
("char-downcase"                      (1)   #f 0     0    char    ieee)
("string?"                            (1)   #f 0     0    boolean ieee)
("make-string"                        (1 2) #f 0     0    string  ieee)
("string"                             0     #f 0     0    string  ieee)
("string-length"                      (1)   #f 0     0    integer ieee)
("string-ref"                         (2)   #f 0     0    char    ieee)
("string-set!"                        (3)   #t 0     0    string  ieee)
("string=?"                           0     #f 0     0    boolean ieee)
("string<?"                           0     #f 0     0    boolean ieee)
("string>?"                           0     #f 0     0    boolean ieee)
("string<=?"                          0     #f 0     0    boolean ieee)
("string>=?"                          0     #f 0     0    boolean ieee)
("string-ci=?"                        0     #f 0     0    boolean ieee)
("string-ci<?"                        0     #f 0     0    boolean ieee)
("string-ci>?"                        0     #f 0     0    boolean ieee)
("string-ci<=?"                       0     #f 0     0    boolean ieee)
("string-ci>=?"                       0     #f 0     0    boolean ieee)
("substring"                          (3)   #f 0     0    string  ieee)
("string-append"                      0     #f 0     0    string  ieee)
("vector?"                            (1)   #f 0     0    boolean ieee)
("make-vector"                        (1 2) #f (1)   0    vector  ieee)
("vector"                             0     #f ()    0    vector  ieee)
("vector-length"                      (1)   #f 0     0    integer ieee)
("vector-ref"                         (2)   #f 0     0    (#f)    ieee)
("vector-set!"                        (3)   #t (1 2) 0    vector  ieee)
("procedure?"                         (1)   #f 0     0    boolean ieee)
("apply"                              2     #t 0     0    (#f)    ieee)
("map"                                2     #t 0     0    list    ieee)
("for-each"                           2     #t 0     0    #f      ieee)
("call-with-current-continuation"     1     #t 0     1113 (#f)    ieee)
("call-with-input-file"               (2)   #t 0     0    (#f)    ieee)
("call-with-output-file"              (2)   #t 0     0    (#f)    ieee)
("input-port?"                        (1)   #f 0     0    boolean ieee)
("output-port?"                       (1)   #f 0     0    boolean ieee)
;parameter! ("current-input-port"                 (0)   #f 0     0    port    ieee)
;parameter! ("current-output-port"                (0)   #f 0     0    port    ieee)
("open-input-file"                    (1)   #t 0     0    port    ieee)
("open-output-file"                   (1)   #t 0     0    port    ieee)
("close-input-port"                   (1)   #t 0     0    #f      ieee)
("close-output-port"                  (1)   #t 0     0    #f      ieee)
("eof-object?"                        (1)   #f 0     0    boolean ieee)
("read"                               (0 1) #t 0     0    #f      ieee)
("read-char"                          (0 1) #t 0     0    #f      ieee)
("peek-char"                          (0 1) #t 0     0    #f      ieee)
("write"                              (0 1) #t 0     0    #f      ieee)
("display"                            (0 1) #t 0     0    #f      ieee)
("newline"                            (0 1) #t 0     0    #f      ieee)
("write-char"                         (1 2) #t 0     0    #f      ieee)

;; for R4RS Scheme

("list-tail"                          (2)   #f 0     0    (#f)    r4rs)
("string->list"                       (1)   #f 0     0    list    r4rs)
("list->string"                       (1)   #f 0     0    string  r4rs)
("string-copy"                        (1)   #f 0     0    string  r4rs)
("string-fill!"                       (2)   #t 0     0    string  r4rs)
("vector->list"                       (1)   #f 0     0    list    r4rs)
("list->vector"                       (1)   #f 0     0    vector  r4rs)
("vector-fill!"                       (2)   #t 0     0    vector  r4rs)
("force"                              (1)   #t 0     0    #f      r4rs)
("with-input-from-file"               (2)   #t 0     0    (#f)    r4rs)
("with-output-to-file"                (2)   #t 0     0    (#f)    r4rs)
("char-ready?"                        (0 1) #f 0     0    boolean r4rs)
("load"                               (1)   #t 0     0    (#f)    r4rs)
("transcript-on"                      (1)   #t 0     0    #f      r4rs)
("transcript-off"                     (0)   #t 0     0    #f      r4rs)

;; for R5RS Scheme

("values"                             0     #f ()    0    (#f)    r5rs)
("call-with-values"                   (2)   #t 0     0    (#f)    r5rs)
("dynamic-wind"                       (3)   #t 0     0    (#f)    r5rs)
("eval"                               (1 2) #t 0     0    (#f)    r5rs)
("interaction-environment"            (0)   #f 0     0    #f      r5rs)
("null-environment"                   (0)   #f 0     0    #f      r5rs)
("scheme-report-environment"          (1)   #f 0     0    #f      r5rs)

;; for R6RS Scheme

("fixnum?"                            (1)   #f 0     0    boolean r6rs)
("fx="                                0     #f 0     0    boolean r6rs)
("fx<"                                0     #f 0     0    boolean r6rs)
("fx>"                                0     #f 0     0    boolean r6rs)
("fx<="                               0     #f 0     0    boolean r6rs)
("fx>="                               0     #f 0     0    boolean r6rs)
("fxzero?"                            (1)   #f 0     0    boolean r6rs)
("fxpositive?"                        (1)   #f 0     0    boolean r6rs)
("fxnegative?"                        (1)   #f 0     0    boolean r6rs)
("fxodd?"                             (1)   #f 0     0    boolean r6rs)
("fxeven?"                            (1)   #f 0     0    boolean r6rs)
("fxmax"                              1     #f 0     0    fixnum  r6rs)
("fxmin"                              1     #f 0     0    fixnum  r6rs)
("fxwrap+"                            0     #f 0     0    fixnum  r6rs)
("fx+"                                0     #f 0     0    fixnum  r6rs)
("fxwrap*"                            0     #f 0     0    fixnum  r6rs)
("fx*"                                0     #f 0     0    fixnum  r6rs)
("fxwrap-"                            1     #f 0     0    fixnum  r6rs)
("fx-"                                1     #f 0     0    fixnum  r6rs)
("fxwrapquotient"                     (2)   #f 0     0    fixnum  r6rs)
("fxquotient"                         (2)   #f 0     0    fixnum  r6rs)
("fxremainder"                        (2)   #f 0     0    fixnum  r6rs)
("fxmodulo"                           (2)   #f 0     0    fixnum  r6rs)
("fxnot"                              (1)   #f 0     0    fixnum  r6rs)
("fxand"                              0     #f 0     0    fixnum  r6rs)
("fxior"                              0     #f 0     0    fixnum  r6rs)
("fxxor"                              0     #f 0     0    fixnum  r6rs)
("fxif"                               (3)   #f 0     0    fixnum  r6rs)
("fxbit-count"                        (1)   #f 0     0    fixnum  r6rs)
("fxlength"                           (1)   #f 0     0    fixnum  r6rs)
("fxfirst-bit-set"                    (1)   #f 0     0    fixnum  r6rs)
("fxbit-set?"                         (2)   #f 0     0    fixnum  r6rs)
("fxwraparithmetic-shift"             (2)   #f 0     0    fixnum  r6rs)
("fxarithmetic-shift"                 (2)   #f 0     0    fixnum  r6rs)
("fxwraparithmetic-shift-left"        (2)   #f 0     0    fixnum  r6rs)
("fxarithmetic-shift-left"            (2)   #f 0     0    fixnum  r6rs)
("fxarithmetic-shift-right"           (2)   #f 0     0    fixnum  r6rs)
("fxwraplogical-shift-right"          (2)   #f 0     0    fixnum  r6rs)
("fxwrapabs"                          (1)   #f 0     0    fixnum  gambit)
("fxabs"                              (1)   #f 0     0    fixnum  gambit)

("flonum?"                            (1)   #f 0     0    boolean r6rs)
("fl="                                0     #f 0     0    boolean r6rs)
("fl<"                                0     #f 0     0    boolean r6rs)
("fl>"                                0     #f 0     0    boolean r6rs)
("fl<="                               0     #f 0     0    boolean r6rs)
("fl>="                               0     #f 0     0    boolean r6rs)
("flinteger?"                         (1)   #f 0     0    boolean r6rs)
("flzero?"                            (1)   #f 0     0    boolean r6rs)
("flpositive?"                        (1)   #f 0     0    boolean r6rs)
("flnegative?"                        (1)   #f 0     0    boolean r6rs)
("flodd?"                             (1)   #f 0     0    boolean r6rs)
("fleven?"                            (1)   #f 0     0    boolean r6rs)
("flfinite?"                          (1)   #f 0     0    boolean r6rs)
("flinfinite?"                        (1)   #f 0     0    boolean r6rs)
("flnan?"                             (1)   #f 0     0    boolean r6rs)
("flmax"                              1     #f 0     0    flonum  r6rs)
("flmin"                              1     #f 0     0    flonum  r6rs)
("fl+"                                0     #f 0     0    flonum  r6rs)
("fl*"                                0     #f 0     0    flonum  r6rs)
("fl-"                                1     #f 0     0    flonum  r6rs)
("fl/"                                1     #f 0     0    flonum  r6rs)
("flabs"                              (1)   #f 0     0    flonum  r6rs)
("flnumerator"                        (1)   #f 0     0    flonum  r6rs)
("fldenominator"                      (1)   #f 0     0    flonum  r6rs)
("flfloor"                            (1)   #f 0     0    flonum  r6rs)
("flceiling"                          (1)   #f 0     0    flonum  r6rs)
("fltruncate"                         (1)   #f 0     0    flonum  r6rs)
("flround"                            (1)   #f 0     0    flonum  r6rs)
("flexp"                              (1)   #f 0     0    flonum  r6rs)
("fllog"                              (1)   #f 0     0    flonum  r6rs)
("flsin"                              (1)   #f 0     0    flonum  r6rs)
("flcos"                              (1)   #f 0     0    flonum  r6rs)
("fltan"                              (1)   #f 0     0    flonum  r6rs)
("flasin"                             (1)   #f 0     0    flonum  r6rs)
("flacos"                             (1)   #f 0     0    flonum  r6rs)
("flatan"                             (1 2) #f 0     0    flonum  r6rs)
("flexpt"                             (2)   #f 0     0    flonum  r6rs)
("flsqrt"                             (1)   #f 0     0    flonum  r6rs)
("fixnum->flonum"                     (1)   #f 0     0    flonum  r6rs)

("finite?"                            (1)   #f 0     0    boolean r6rs)
("infinite?"                          (1)   #f 0     0    boolean r6rs)
("nan?"                               (1)   #f 0     0    boolean r6rs)

;; for Multilisp

("touch"                              (1)   #t 0     0    #f      multilisp)

;; for DSSSL

("keyword?"                           (1)   #f 0     0    boolean gambit)
("keyword->string"                    (1)   #f 0     0    string  gambit)
("string->keyword"                    (1)   #f 0     0    keyword gambit)

;; other

("void"                               (0)   #f 0     0    #f      gambit)

("will?"                              (1)   #f 0     0    boolean gambit)
("make-will"                          (2)   #t (2)   0    #f      gambit)
("will-testator"                      (1)   #f 0     0    (#f)    gambit)

("box?"                               (1)   #f 0     0    boolean gambit)
("box"                                (1)   #f ()    0    #f      gambit)
("unbox"                              (1)   #f 0     0    (#f)    gambit)
("set-box!"                           (2)   #t (1)   0    #f      gambit)

("s8vector?"                          (1)   #f 0     0    boolean gambit)
("s8vector"                           0     #f 0     0    #f      gambit)
("make-s8vector"                      (2)   #f 0     0    #f      gambit)
("s8vector-length"                    (1)   #f 0     0    integer gambit)
("s8vector-ref"                       (2)   #f 0     0    integer gambit)
("s8vector-set!"                      (3)   #t 0     0    #f      gambit)
("s8vector->list"                     (1)   #f 0     0    list    gambit)
("list->s8vector"                     (1)   #f 0     0    #f      gambit)

("u8vector?"                          (1)   #f 0     0    boolean gambit)
("u8vector"                           0     #f 0     0    #f      gambit)
("make-u8vector"                      (2)   #f 0     0    #f      gambit)
("u8vector-length"                    (1)   #f 0     0    integer gambit)
("u8vector-ref"                       (2)   #f 0     0    integer gambit)
("u8vector-set!"                      (3)   #t 0     0    #f      gambit)
("u8vector->list"                     (1)   #f 0     0    list    gambit)
("list->u8vector"                     (1)   #f 0     0    #f      gambit)

("s16vector?"                         (1)   #f 0     0    boolean gambit)
("s16vector"                          0     #f 0     0    #f      gambit)
("make-s16vector"                     (2)   #f 0     0    #f      gambit)
("s16vector-length"                   (1)   #f 0     0    integer gambit)
("s16vector-ref"                      (2)   #f 0     0    integer gambit)
("s16vector-set!"                     (3)   #t 0     0    #f      gambit)
("s16vector->list"                    (1)   #f 0     0    list    gambit)
("list->s16vector"                    (1)   #f 0     0    #f      gambit)

("u16vector?"                         (1)   #f 0     0    boolean gambit)
("u16vector"                          0     #f 0     0    #f      gambit)
("make-u16vector"                     (2)   #f 0     0    #f      gambit)
("u16vector-length"                   (1)   #f 0     0    integer gambit)
("u16vector-ref"                      (2)   #f 0     0    integer gambit)
("u16vector-set!"                     (3)   #t 0     0    #f      gambit)
("u16vector->list"                    (1)   #f 0     0    list    gambit)
("list->u16vector"                    (1)   #f 0     0    #f      gambit)

("s32vector?"                         (1)   #f 0     0    boolean gambit)
("s32vector"                          0     #f 0     0    #f      gambit)
("make-s32vector"                     (2)   #f 0     0    #f      gambit)
("s32vector-length"                   (1)   #f 0     0    integer gambit)
("s32vector-ref"                      (2)   #f 0     0    integer gambit)
("s32vector-set!"                     (3)   #t 0     0    #f      gambit)
("s32vector->list"                    (1)   #f 0     0    list    gambit)
("list->s32vector"                    (1)   #f 0     0    #f      gambit)

("u32vector?"                         (1)   #f 0     0    boolean gambit)
("u32vector"                          0     #f 0     0    #f      gambit)
("make-u32vector"                     (2)   #f 0     0    #f      gambit)
("u32vector-length"                   (1)   #f 0     0    integer gambit)
("u32vector-ref"                      (2)   #f 0     0    integer gambit)
("u32vector-set!"                     (3)   #t 0     0    #f      gambit)
("u32vector->list"                    (1)   #f 0     0    list    gambit)
("list->u32vector"                    (1)   #f 0     0    #f      gambit)

("s64vector?"                         (1)   #f 0     0    boolean gambit)
("s64vector"                          0     #f 0     0    #f      gambit)
("make-s64vector"                     (2)   #f 0     0    #f      gambit)
("s64vector-length"                   (1)   #f 0     0    integer gambit)
("s64vector-ref"                      (2)   #f 0     0    integer gambit)
("s64vector-set!"                     (3)   #t 0     0    #f      gambit)
("s64vector->list"                    (1)   #f 0     0    list    gambit)
("list->s64vector"                    (1)   #f 0     0    #f      gambit)

("u64vector?"                         (1)   #f 0     0    boolean gambit)
("u64vector"                          0     #f 0     0    #f      gambit)
("make-u64vector"                     (2)   #f 0     0    #f      gambit)
("u64vector-length"                   (1)   #f 0     0    integer gambit)
("u64vector-ref"                      (2)   #f 0     0    integer gambit)
("u64vector-set!"                     (3)   #t 0     0    #f      gambit)
("u64vector->list"                    (1)   #f 0     0    list    gambit)
("list->u64vector"                    (1)   #f 0     0    #f      gambit)

("f32vector?"                         (1)   #f 0     0    boolean gambit)
("f32vector"                          0     #f 0     0    #f      gambit)
("make-f32vector"                     (2)   #f 0     0    #f      gambit)
("f32vector-length"                   (1)   #f 0     0    integer gambit)
("f32vector-ref"                      (2)   #f 0     0    real    gambit)
("f32vector-set!"                     (3)   #t 0     0    #f      gambit)
("f32vector->list"                    (1)   #f 0     0    list    gambit)
("list->f32vector"                    (1)   #f 0     0    #f      gambit)

("f64vector?"                         (1)   #f 0     0    boolean gambit)
("f64vector"                          0     #f 0     0    #f      gambit)
("make-f64vector"                     (2)   #f 0     0    #f      gambit)
("f64vector-length"                   (1)   #f 0     0    integer gambit)
("f64vector-ref"                      (2)   #f 0     0    real    gambit)
("f64vector-set!"                     (3)   #t 0     0    #f      gambit)
("f64vector->list"                    (1)   #f 0     0    list    gambit)
("list->f64vector"                    (1)   #f 0     0    #f      gambit)

("bitwise-ior"                        0     #f 0     0    integer gambit)
("bitwise-xor"                        0     #f 0     0    integer gambit)
("bitwise-and"                        0     #f 0     0    integer gambit)
("bitwise-not"                        (1)   #f 0     0    integer gambit)
("arithmetic-shift"                   (2)   #f 0     0    integer gambit)

("call/cc"                            1     #t 0     1113 (#f)    gambit)

("continuation?"                      (1)   #f 0     0    boolean gambit)
("continuation-capture"               1     #t 0     1113 (#f)    gambit)
("continuation-graft"                 2     #t 0     2203 #f      gambit)
("continuation-return"                (2)   #t 0     0    #f      gambit)

;; for system interface

("##type"                             (1)   #f ()    0    integer extended)
("##type-cast"                        (2)   #f ()    0    (#f)    extended)
("##subtype"                          (1)   #f ()    0    integer extended)
("##subtype-set!"                     (2)   #t ()    0    #f      extended)

("##not"                              (1)   #f ()    0    boolean extended)
("##boolean?"                         (1)   #f ()    0    boolean extended)
("##null?"                            (1)   #f ()    0    boolean extended)
("##unbound?"                         (1)   #f ()    0    boolean extended)
("##eq?"                              (2)   #f ()    0    boolean extended)
("##eqv?"                             (2)   #f ()    0    boolean extended)
("##equal?"                           (2)   #f ()    0    boolean extended)
("##eof-object?"                      (1)   #f ()    0    boolean extended)

("##fixnum?"                          (1)   #f ()    0    boolean extended)
("##special?"                         (1)   #f ()    0    boolean extended)
("##pair?"                            (1)   #f ()    0    boolean extended)
("##pair-mutable?"                    (1)   #f ()    0    boolean extended)
("##subtyped?"                        (1)   #f ()    0    boolean extended)
("##subtyped-mutable?"                (1)   #f ()    0    boolean extended)
("##subtyped.vector?"                 (1)   #f ()    0    boolean extended)
("##subtyped.symbol?"                 (1)   #f ()    0    boolean extended)
("##subtyped.flonum?"                 (1)   #f ()    0    boolean extended)
("##subtyped.bignum?"                 (1)   #f ()    0    boolean extended)
("##vector?"                          (1)   #f ()    0    boolean extended)
("##ratnum?"                          (1)   #f ()    0    boolean extended)
("##cpxnum?"                          (1)   #f ()    0    boolean extended)
("##structure?"                       (1)   #f ()    0    boolean extended)
("##box?"                             (1)   #f ()    0    boolean extended)
("##values?"                          (1)   #f ()    0    boolean extended)
("##meroon?"                          (1)   #f ()    0    boolean extended)
("##jazz?"                            (1)   #f ()    0    boolean extended)
("##symbol?"                          (1)   #f ()    0    boolean extended)
("##keyword?"                         (1)   #f ()    0    boolean extended)
("##frame?"                           (1)   #f ()    0    boolean extended)
("##continuation?"                    (1)   #f ()    0    boolean extended)
("##promise?"                         (1)   #f ()    0    boolean extended)
("##will?"                            (1)   #f ()    0    boolean extended)
("##gc-hash-table?"                   (1)   #f ()    0    boolean extended)
("##mem-allocated?"                   (1)   #f ()    0    boolean extended)
("##procedure?"                       (1)   #f ()    0    boolean extended)
("##return?"                          (1)   #f ()    0    boolean extended)
("##foreign?"                         (1)   #f ()    0    boolean extended)
("##string?"                          (1)   #f ()    0    boolean extended)
("##s8vector?"                        (1)   #f ()    0    boolean extended)
("##u8vector?"                        (1)   #f ()    0    boolean extended)
("##s16vector?"                       (1)   #f ()    0    boolean extended)
("##u16vector?"                       (1)   #f ()    0    boolean extended)
("##s32vector?"                       (1)   #f ()    0    boolean extended)
("##u32vector?"                       (1)   #f ()    0    boolean extended)
("##s64vector?"                       (1)   #f ()    0    boolean extended)
("##u64vector?"                       (1)   #f ()    0    boolean extended)
("##f32vector?"                       (1)   #f ()    0    boolean extended)
("##f64vector?"                       (1)   #f ()    0    boolean extended)
("##flonum?"                          (1)   #f ()    0    boolean extended)
("##bignum?"                          (1)   #f ()    0    boolean extended)
("##char?"                            (1)   #f ()    0    boolean extended)
("##closure?"                         (1)   #f ()    0    boolean extended)
("##subprocedure?"                    (1)   #f ()    0    boolean extended)
("##return-dynamic-env-bind?"         (1)   #f ()    0    boolean extended)
("##number?"                          (1)   #f ()    0    boolean extended)
("##complex?"                         (1)   #f ()    0    boolean extended)
("##real?"                            (1)   #f ()    0    boolean extended)
("##rational?"                        (1)   #f ()    0    boolean extended)
("##integer?"                         (1)   #f ()    0    boolean extended)
("##exact?"                           (1)   #f ()    0    boolean extended)
("##inexact?"                         (1)   #f ()    0    boolean extended)

;; old fixnum/flonum procedures

("##fixnum.max"                       1     #f ()    0    fixnum  extended)
("##fixnum.min"                       1     #f ()    0    fixnum  extended)
("##fixnum.wrap+"                     0     #f ()    0    fixnum  extended)
("##fixnum.+"                         0     #f ()    0    fixnum  extended)
("##fixnum.+?"                        (2)   #f ()    0    #f      extended)
("##fixnum.wrap*"                     0     #f ()    0    fixnum  extended)
("##fixnum.*"                         0     #f ()    0    fixnum  extended)
("##fixnum.*?"                        (2)   #f ()    0    #f      extended)
("##fixnum.wrap-"                     1     #f ()    0    fixnum  extended)
("##fixnum.-"                         1     #f ()    0    fixnum  extended)
("##fixnum.-?"                        (1 2) #f ()    0    #f      extended)
("##fixnum.wrapquotient"              (2)   #f ()    0    fixnum  extended)
("##fixnum.quotient"                  (2)   #f ()    0    fixnum  extended)
("##fixnum.remainder"                 (2)   #f ()    0    fixnum  extended)
("##fixnum.modulo"                    (2)   #f ()    0    fixnum  extended)
("##fixnum.bitwise-ior"               0     #f ()    0    fixnum  extended)
("##fixnum.bitwise-xor"               0     #f ()    0    fixnum  extended)
("##fixnum.bitwise-and"               0     #f ()    0    fixnum  extended)
("##fixnum.bitwise-not"               (1)   #f ()    0    fixnum  extended)
("##fixnum.wraparithmetic-shift"      (2)   #f ()    0    fixnum  extended)
("##fixnum.arithmetic-shift"          (2)   #f ()    0    fixnum  extended)
("##fixnum.arithmetic-shift?"         (2)   #f ()    0    #f      extended)
("##fixnum.wraparithmetic-shift-left" (2)   #f ()    0    fixnum  extended)
("##fixnum.arithmetic-shift-left"     (2)   #f ()    0    fixnum  extended)
("##fixnum.arithmetic-shift-left?"    (2)   #f ()    0    #f      extended)
("##fixnum.arithmetic-shift-right"    (2)   #f ()    0    fixnum  extended)
("##fixnum.arithmetic-shift-right?"   (2)   #f ()    0    #f extended)
("##fixnum.wraplogical-shift-right"   (2)   #f ()    0    fixnum  extended)
("##fixnum.wraplogical-shift-right?"  (2)   #f ()    0    #f      extended)
("##fixnum.wrapabs"                   (1)   #f ()    0    fixnum  extended)
("##fixnum.abs"                       (1)   #f ()    0    fixnum  extended)
("##fixnum.abs?"                      (1)   #f ()    0    #f      extended)
("##fixnum.zero?"                     (1)   #f ()    0    boolean extended)
("##fixnum.positive?"                 (1)   #f ()    0    boolean extended)
("##fixnum.negative?"                 (1)   #f ()    0    boolean extended)
("##fixnum.odd?"                      (1)   #f ()    0    boolean extended)
("##fixnum.even?"                     (1)   #f ()    0    boolean extended)
("##fixnum.="                         0     #f ()    0    boolean extended)
("##fixnum.<"                         0     #f ()    0    boolean extended)
("##fixnum.>"                         0     #f ()    0    boolean extended)
("##fixnum.<="                        0     #f ()    0    boolean extended)
("##fixnum.>="                        0     #f ()    0    boolean extended)
("##fixnum.->char"                    (1)   #f ()    0    char    extended)
("##fixnum.<-char"                    (1)   #f ()    0    fixnum  extended)

("##flonum.->fixnum"                  (1)   #f ()    0    fixnum  extended)
("##flonum.<-fixnum"                  (1)   #f ()    0    real    extended)
("##flonum.max"                       1     #f ()    0    real    extended)
("##flonum.min"                       1     #f ()    0    real    extended)
("##flonum.+"                         0     #f ()    0    real    extended)
("##flonum.*"                         0     #f ()    0    real    extended)
("##flonum.-"                         1     #f ()    0    real    extended)
("##flonum./"                         1     #f ()    0    real    extended)
("##flonum.abs"                       (1)   #f ()    0    real    extended)
("##flonum.floor"                     (1)   #f ()    0    real    extended)
("##flonum.ceiling"                   (1)   #f ()    0    real    extended)
("##flonum.truncate"                  (1)   #f ()    0    real    extended)
("##flonum.round"                     (1)   #f ()    0    real    extended)
("##flonum.exp"                       (1)   #f ()    0    real    extended)
("##flonum.log"                       (1)   #f ()    0    real    extended)
("##flonum.sin"                       (1)   #f ()    0    real    extended)
("##flonum.cos"                       (1)   #f ()    0    real    extended)
("##flonum.tan"                       (1)   #f ()    0    real    extended)
("##flonum.asin"                      (1)   #f ()    0    real    extended)
("##flonum.acos"                      (1)   #f ()    0    real    extended)
("##flonum.atan"                      (1 2) #f ()    0    real    extended)
("##flonum.expt"                      (2)   #f ()    0    real    extended)
("##flonum.sqrt"                      (1)   #f ()    0    real    extended)
("##flonum.copysign"                  (2)   #f ()    0    real    extended)
("##flonum.integer?"                  (1)   #f ()    0    boolean extended)
("##flonum.zero?"                     (1)   #f ()    0    boolean extended)
("##flonum.positive?"                 (1)   #f ()    0    boolean extended)
("##flonum.negative?"                 (1)   #f ()    0    boolean extended)
("##flonum.odd?"                      (1)   #f ()    0    boolean extended)
("##flonum.even?"                     (1)   #f ()    0    boolean extended)
("##flonum.finite?"                   (1)   #f ()    0    boolean extended)
("##flonum.infinite?"                 (1)   #f ()    0    boolean extended)
("##flonum.nan?"                      (1)   #f ()    0    boolean extended)
("##flonum.<-fixnum-exact?"           (1)   #f ()    0    boolean extended)
("##flonum.="                         0     #f ()    0    boolean extended)
("##flonum.<"                         0     #f ()    0    boolean extended)
("##flonum.>"                         0     #f ()    0    boolean extended)
("##flonum.<="                        0     #f ()    0    boolean extended)
("##flonum.>="                        0     #f ()    0    boolean extended)


;; new fixnum/flonum procedures

("##fxmax"                       1     #f ()    0    fixnum  extended)
("##fxmin"                       1     #f ()    0    fixnum  extended)
("##fxwrap+"                     0     #f ()    0    fixnum  extended)
("##fx+"                         0     #f ()    0    fixnum  extended)
("##fx+?"                        (2)   #f ()    0    #f      extended)
("##fxwrap*"                     0     #f ()    0    fixnum  extended)
("##fx*"                         0     #f ()    0    fixnum  extended)
("##fx*?"                        (2)   #f ()    0    #f      extended)
("##fxwrap-"                     1     #f ()    0    fixnum  extended)
("##fx-"                         1     #f ()    0    fixnum  extended)
("##fx-?"                        (1 2) #f ()    0    #f      extended)
("##fxwrapquotient"              (2)   #f ()    0    fixnum  extended)
("##fxquotient"                  (2)   #f ()    0    fixnum  extended)
("##fxremainder"                 (2)   #f ()    0    fixnum  extended)
("##fxmodulo"                    (2)   #f ()    0    fixnum  extended)
("##fxnot"                       (1)   #f ()    0    fixnum  extended)
("##fxand"                       0     #f ()    0    fixnum  extended)
("##fxior"                       0     #f ()    0    fixnum  extended)
("##fxxor"                       0     #f ()    0    fixnum  extended)
("##fxif"                        (3)   #f ()    0    fixnum  extended)
("##fxbit-count"                 (1)   #f ()    0    fixnum  extended)
("##fxlength"                    (1)   #f ()    0    fixnum  extended)
("##fxfirst-bit-set"             (1)   #f ()    0    fixnum  extended)
("##fxbit-set?"                  (2)   #f ()    0    fixnum  extended)
("##fxwraparithmetic-shift"      (2)   #f ()    0    fixnum  extended)
("##fxarithmetic-shift"          (2)   #f ()    0    fixnum  extended)
("##fxarithmetic-shift?"         (2)   #f ()    0    #f      extended)
("##fxwraparithmetic-shift-left" (2)   #f ()    0    fixnum  extended)
("##fxarithmetic-shift-left"     (2)   #f ()    0    fixnum  extended)
("##fxarithmetic-shift-left?"    (2)   #f ()    0    #f      extended)
("##fxarithmetic-shift-right"    (2)   #f ()    0    fixnum  extended)
("##fxarithmetic-shift-right?"   (2)   #f ()    0    #f      extended)
("##fxwraplogical-shift-right"   (2)   #f ()    0    fixnum  extended)
("##fxwraplogical-shift-right?"  (2)   #f ()    0    #f      extended)
("##fxwrapabs"                   (1)   #f ()    0    fixnum  extended)
("##fxabs"                       (1)   #f ()    0    fixnum  extended)
("##fxabs?"                      (1)   #f ()    0    #f      extended)
("##fxzero?"                     (1)   #f ()    0    boolean extended)
("##fxpositive?"                 (1)   #f ()    0    boolean extended)
("##fxnegative?"                 (1)   #f ()    0    boolean extended)
("##fxodd?"                      (1)   #f ()    0    boolean extended)
("##fxeven?"                     (1)   #f ()    0    boolean extended)
("##fx="                         0     #f ()    0    boolean extended)
("##fx<"                         0     #f ()    0    boolean extended)
("##fx>"                         0     #f ()    0    boolean extended)
("##fx<="                        0     #f ()    0    boolean extended)
("##fx>="                        0     #f ()    0    boolean extended)
("##fx->char"                    (1)   #f ()    0    char    extended)
("##fx<-char"                    (1)   #f ()    0    fixnum  extended)

("##fixnum->char"                (1)   #f ()    0    char    extended)
("##char->fixnum"                (1)   #f ()    0    fixnum  extended)
("##flonum->fixnum"              (1)   #f ()    0    fixnum  extended)
("##fixnum->flonum"              (1)   #f ()    0    real    extended)
("##fixnum->flonum-exact?"       (1)   #f ()    0    boolean extended)

("##fl->fx"                      (1)   #f ()    0    fixnum  extended)
("##fl<-fx"                      (1)   #f ()    0    real    extended)
("##flmax"                       1     #f ()    0    real    extended)
("##flmin"                       1     #f ()    0    real    extended)
("##fl+"                         0     #f ()    0    real    extended)
("##fl*"                         0     #f ()    0    real    extended)
("##fl-"                         1     #f ()    0    real    extended)
("##fl/"                         1     #f ()    0    real    extended)
("##flabs"                       (1)   #f ()    0    real    extended)
("##flfloor"                     (1)   #f ()    0    real    extended)
("##flceiling"                   (1)   #f ()    0    real    extended)
("##fltruncate"                  (1)   #f ()    0    real    extended)
("##flround"                     (1)   #f ()    0    real    extended)
("##flexp"                       (1)   #f ()    0    real    extended)
("##fllog"                       (1)   #f ()    0    real    extended)
("##flsin"                       (1)   #f ()    0    real    extended)
("##flcos"                       (1)   #f ()    0    real    extended)
("##fltan"                       (1)   #f ()    0    real    extended)
("##flasin"                      (1)   #f ()    0    real    extended)
("##flacos"                      (1)   #f ()    0    real    extended)
("##flatan"                      (1 2) #f ()    0    real    extended)
("##flexpt"                      (2)   #f ()    0    real    extended)
("##flsqrt"                      (1)   #f ()    0    real    extended)
("##flcopysign"                  (2)   #f ()    0    real    extended)
("##flinteger?"                  (1)   #f ()    0    boolean extended)
("##flzero?"                     (1)   #f ()    0    boolean extended)
("##flpositive?"                 (1)   #f ()    0    boolean extended)
("##flnegative?"                 (1)   #f ()    0    boolean extended)
("##flodd?"                      (1)   #f ()    0    boolean extended)
("##fleven?"                     (1)   #f ()    0    boolean extended)
("##flfinite?"                   (1)   #f ()    0    boolean extended)
("##flinfinite?"                 (1)   #f ()    0    boolean extended)
("##flnan?"                      (1)   #f ()    0    boolean extended)
("##fl<-fx-exact?"               (1)   #f ()    0    boolean extended)
("##fl="                         0     #f ()    0    boolean extended)
("##fl<"                         0     #f ()    0    boolean extended)
("##fl>"                         0     #f ()    0    boolean extended)
("##fl<="                        0     #f ()    0    boolean extended)
("##fl>="                        0     #f ()    0    boolean extended)




("##char=?"                           0     #f ()    0    boolean extended)
("##char<?"                           0     #f ()    0    boolean extended)
("##char>?"                           0     #f ()    0    boolean extended)
("##char<=?"                          0     #f ()    0    boolean extended)
("##char>=?"                          0     #f ()    0    boolean extended)
("##char-alphabetic?"                 (1)   #f ()    0    boolean extended)
("##char-numeric?"                    (1)   #f ()    0    boolean extended)
("##char-whitespace?"                 (1)   #f ()    0    boolean extended)
("##char-upper-case?"                 (1)   #f ()    0    boolean extended)
("##char-lower-case?"                 (1)   #f ()    0    boolean extended)
("##char-upcase"                      (1)   #f ()    0    char    extended)
("##char-downcase"                    (1)   #f ()    0    char    extended)

("##cons"                             (2)   #f ()    0    pair    extended)
("##set-car!"                         (2)   #t ()    0    pair    extended)
("##set-cdr!"                         (2)   #t ()    0    pair    extended)
("##car"                              (1)   #f ()    0    (#f)    extended)
("##cdr"                              (1)   #f ()    0    (#f)    extended)
("##caar"                             (1)   #f ()    0    (#f)    extended)
("##cadr"                             (1)   #f ()    0    (#f)    extended)
("##cdar"                             (1)   #f ()    0    (#f)    extended)
("##cddr"                             (1)   #f ()    0    (#f)    extended)
("##caaar"                            (1)   #f ()    0    (#f)    extended)
("##caadr"                            (1)   #f ()    0    (#f)    extended)
("##cadar"                            (1)   #f ()    0    (#f)    extended)
("##caddr"                            (1)   #f ()    0    (#f)    extended)
("##cdaar"                            (1)   #f ()    0    (#f)    extended)
("##cdadr"                            (1)   #f ()    0    (#f)    extended)
("##cddar"                            (1)   #f ()    0    (#f)    extended)
("##cdddr"                            (1)   #f ()    0    (#f)    extended)
("##caaaar"                           (1)   #f ()    0    (#f)    extended)
("##caaadr"                           (1)   #f ()    0    (#f)    extended)
("##caadar"                           (1)   #f ()    0    (#f)    extended)
("##caaddr"                           (1)   #f ()    0    (#f)    extended)
("##cadaar"                           (1)   #f ()    0    (#f)    extended)
("##cadadr"                           (1)   #f ()    0    (#f)    extended)
("##caddar"                           (1)   #f ()    0    (#f)    extended)
("##cadddr"                           (1)   #f ()    0    (#f)    extended)
("##cdaaar"                           (1)   #f ()    0    (#f)    extended)
("##cdaadr"                           (1)   #f ()    0    (#f)    extended)
("##cdadar"                           (1)   #f ()    0    (#f)    extended)
("##cdaddr"                           (1)   #f ()    0    (#f)    extended)
("##cddaar"                           (1)   #f ()    0    (#f)    extended)
("##cddadr"                           (1)   #f ()    0    (#f)    extended)
("##cdddar"                           (1)   #f ()    0    (#f)    extended)
("##cddddr"                           (1)   #f ()    0    (#f)    extended)

("##list"                             0     #f ()    0    list    extended)

("##box"                              (1)   #f ()    0    #f      extended)
("##unbox"                            (1)   #f ()    0    (#f)    extended)
("##set-box!"                         (2)   #t ()    0    #f      extended)

("##make-will"                        (2)   #t ()    0    #f      extended)
("##will-testator"                    (1)   #f ()    0    (#f)    extended)

("##gc-hash-table-ref"                (2)   #f ()    0    (#f)    extended)
("##gc-hash-table-set!"               (3)   #t ()    0    (#f)    extended)
("##gc-hash-table-rehash!"            (2)   #t ()    0    (#f)    extended)

("##values"                           0     #f ()    0    (#f)    extended)

("##vector"                           0     #f ()    0    vector  extended)
("##make-vector"                      (2)   #f ()    0    vector  extended)
("##vector-length"                    (1)   #f ()    0    fixnum  extended)
("##vector-ref"                       (2)   #f ()    0    (#f)    extended)
("##vector-set!"                      (3)   #t ()    0    vector  extended)
("##vector-shrink!"                   (2)   #t ()    0    vector  extended)

("##string"                           0     #f ()    0    string  extended)
("##make-string"                      (2)   #f ()    0    string  extended)
("##string-length"                    (1)   #f ()    0    fixnum  extended)
("##string-ref"                       (2)   #f ()    0    char    extended)
("##string-set!"                      (3)   #t ()    0    string  extended)
("##string-shrink!"                   (2)   #t ()    0    string  extended)

("##s8vector"                         0     #f ()    0    #f      extended)
("##make-s8vector"                    (2)   #f ()    0    #f      extended)
("##s8vector-length"                  (1)   #f ()    0    fixnum  extended)
("##s8vector-ref"                     (2)   #f ()    0    fixnum  extended)
("##s8vector-set!"                    (3)   #t ()    0    #f      extended)
("##s8vector-shrink!"                 (2)   #t ()    0    #f      extended)

("##u8vector"                         0     #f ()    0    #f      extended)
("##make-u8vector"                    (2)   #f ()    0    #f      extended)
("##u8vector-length"                  (1)   #f ()    0    fixnum  extended)
("##u8vector-ref"                     (2)   #f ()    0    fixnum  extended)
("##u8vector-set!"                    (3)   #t ()    0    #f      extended)
("##u8vector-shrink!"                 (2)   #t ()    0    #f      extended)

("##s16vector"                        0     #f ()    0    #f      extended)
("##make-s16vector"                   (2)   #f ()    0    #f      extended)
("##s16vector-length"                 (1)   #f ()    0    fixnum  extended)
("##s16vector-ref"                    (2)   #f ()    0    fixnum  extended)
("##s16vector-set!"                   (3)   #t ()    0    #f      extended)
("##s16vector-shrink!"                (2)   #t ()    0    #f      extended)

("##u16vector"                        0     #f ()    0    #f      extended)
("##make-u16vector"                   (2)   #f ()    0    #f      extended)
("##u16vector-length"                 (1)   #f ()    0    fixnum  extended)
("##u16vector-ref"                    (2)   #f ()    0    fixnum  extended)
("##u16vector-set!"                   (3)   #t ()    0    #f      extended)
("##u16vector-shrink!"                (2)   #t ()    0    #f      extended)

("##s32vector"                        0     #f ()    0    #f      extended)
("##make-s32vector"                   (2)   #f ()    0    #f      extended)
("##s32vector-length"                 (1)   #f ()    0    fixnum  extended)
("##s32vector-ref"                    (2)   #f ()    0    fixnum  extended)
("##s32vector-set!"                   (3)   #t ()    0    #f      extended)
("##s32vector-shrink!"                (2)   #t ()    0    #f      extended)

("##u32vector"                        0     #f ()    0    #f      extended)
("##make-u32vector"                   (2)   #f ()    0    #f      extended)
("##u32vector-length"                 (1)   #f ()    0    fixnum  extended)
("##u32vector-ref"                    (2)   #f ()    0    fixnum  extended)
("##u32vector-set!"                   (3)   #t ()    0    #f      extended)
("##u32vector-shrink!"                (2)   #t ()    0    #f      extended)

("##s64vector"                        0     #f ()    0    #f      extended)
("##make-s64vector"                   (2)   #f ()    0    #f      extended)
("##s64vector-length"                 (1)   #f ()    0    fixnum  extended)
("##s64vector-ref"                    (2)   #f ()    0    fixnum  extended)
("##s64vector-set!"                   (3)   #t ()    0    #f      extended)
("##s64vector-shrink!"                (2)   #t ()    0    #f      extended)

("##u64vector"                        0     #f ()    0    #f      extended)
("##make-u64vector"                   (2)   #f ()    0    #f      extended)
("##u64vector-length"                 (1)   #f ()    0    fixnum  extended)
("##u64vector-ref"                    (2)   #f ()    0    fixnum  extended)
("##u64vector-set!"                   (3)   #t ()    0    #f      extended)
("##u64vector-shrink!"                (2)   #t ()    0    #f      extended)

("##f32vector"                        0     #f ()    0    #f      extended)
("##make-f32vector"                   (2)   #f ()    0    #f      extended)
("##f32vector-length"                 (1)   #f ()    0    fixnum  extended)
("##f32vector-ref"                    (2)   #f ()    0    real    extended)
("##f32vector-set!"                   (3)   #t ()    0    #f      extended)
("##f32vector-shrink!"                (2)   #t ()    0    #f      extended)

("##f64vector"                        0     #f ()    0    #f      extended)
("##make-f64vector"                   (2)   #f ()    0    #f      extended)
("##f64vector-length"                 (1)   #f ()    0    fixnum  extended)
("##f64vector-ref"                    (2)   #f ()    0    real    extended)
("##f64vector-set!"                   (3)   #t ()    0    #f      extended)
("##f64vector-shrink!"                (2)   #t ()    0    #f      extended)

("##structure-direct-instance-of?"    (2)   #f ()    0    boolean extended)
("##structure-instance-of?"           (2)   #f ()    0    boolean extended)
("##structure-type"                   (1)   #f ()    0    (#f)    extended)
("##structure-type-set!"              (2)   #t ()    0    (#f)    extended)
("##structure"                        1     #f ()    0    (#f)    extended)
("##structure-ref"                    (4)   #f ()    0    (#f)    extended)
("##structure-set!"                   (5)   #t ()    0    (#f)    extended)
("##direct-structure-ref"             (4)   #f ()    0    (#f)    extended)
("##direct-structure-set!"            (5)   #t ()    0    (#f)    extended)
("##unchecked-structure-ref"          (4)   #f ()    0    (#f)    extended)
("##unchecked-structure-set!"         (5)   #t ()    0    (#f)    extended)

("##type-id"                          (1)   #f ()    0    #f      extended)
("##type-name"                        (1)   #f ()    0    #f      extended)
("##type-flags"                       (1)   #f ()    0    #f      extended)
("##type-super"                       (1)   #f ()    0    #f      extended)
("##type-fields"                      (1)   #f ()    0    #f      extended)

("##symbol->string"                   (1)   #f ()    0    string  extended)

("##keyword->string"                  (1)   #f ()    0    string  extended)

("##closure-length"                   (1)   #f ()    0    fixnum  extended)
("##closure-code"                     (1)   #f ()    0    #f      extended)
("##closure-ref"                      (2)   #f ()    0    (#f)    extended)
("##closure-set!"                     (3)   #t ()    0    #f      extended)

("##subprocedure-id"                  (1)   #f ()    0    #f      extended)
("##subprocedure-parent"              (1)   #f ()    0    #f      extended)

("##procedure-info"                   (1)   #f ()    0    #f      extended)

("##make-promise"                     (1)   #f 0     0    (#f)    extended)
("##force"                            (1)   #t 0     0    #f      extended)

("##void"                             (0)   #f ()    0    #f      extended)

("current-thread"                     (0)   #f ()    0    #f      extended)
("##current-thread"                   (0)   #f ()    0    #f      extended)
("##run-queue"                        (0)   #f ()    0    #f      extended)

("##thread-save!"                     1     #t ()    1113 (#f)    extended)
("##thread-restore!"                  2     #t ()    2203 #f      extended)

("##continuation-capture"             1     #t ()    1113 (#f)    extended)
("##continuation-graft"               2     #t ()    2203 #f      extended)
("##continuation-graft-no-winding"    2     #t ()    2203 #f      extended)
("##continuation-return"              (2)   #t ()    0    #f      extended)
("##continuation-return-no-winding"   (2)   #t ()    0    #f      extended)

("##apply"                            (2)   #t ()    0    (#f)    extended)
("##call-with-current-continuation"   1     #t ()    1113 (#f)    extended)
("##make-global-var"                  (1)   #t ()    0    #f      extended)
("##global-var-ref"                   (1)   #f ()    0    (#f)    extended)
("##global-var-primitive-ref"         (1)   #f ()    0    (#f)    extended)
("##global-var-set!"                  (2)   #t ()    0    #f      extended)
("##global-var-primitive-set!"        (2)   #t ()    0    #f      extended)

("##first-argument"                   1     #f ()    0    (#f)    extended)
("##check-heap-limit"                 (0)   #t ()    0    (#f)    extended)

;; for front end

("##quasi-append"                     0     #f 0     0    list    extended)
("##quasi-list"                       0     #f ()    0    list    extended)
("##quasi-cons"                       (2)   #f ()    0    pair    extended)
("##quasi-list->vector"               (1)   #f 0     0    vector  extended)
("##quasi-vector"                     0     #f ()    0    vector  extended)
("##case-memv"                        (2)   #f 0     0    list    extended)

("##bignum.negative?"                 (1)   #f ()    0    boolean extended)
("##bignum.adigit-length"             (1)   #f ()    0    integer extended)
("##bignum.adigit-inc!"               (2)   #t ()    0    integer extended)
("##bignum.adigit-dec!"               (2)   #t ()    0    integer extended)
("##bignum.adigit-add!"               (5)   #t ()    0    integer extended)
("##bignum.adigit-sub!"               (5)   #t ()    0    integer extended)
("##bignum.mdigit-length"             (1)   #f ()    0    integer extended)
("##bignum.mdigit-ref"                (2)   #f ()    0    integer extended)
("##bignum.mdigit-set!"               (3)   #t ()    0    #f      extended)
("##bignum.mdigit-mul!"               (6)   #t ()    0    integer extended)
("##bignum.mdigit-div!"               (6)   #t ()    0    integer extended)
("##bignum.mdigit-quotient"           (3)   #f ()    0    integer extended)
("##bignum.mdigit-remainder"          (4)   #f ()    0    integer extended)
("##bignum.mdigit-test?"              (4)   #f ()    0    boolean extended)

("##bignum.adigit-ones?"              (2)   #f ()    0    boolean extended)
("##bignum.adigit-zero?"              (2)   #f ()    0    boolean extended)
("##bignum.adigit-negative?"          (2)   #f ()    0    boolean extended)
("##bignum.adigit-="                  (3)   #f ()    0    boolean extended)
("##bignum.adigit-<"                  (3)   #f ()    0    boolean extended)
("##bignum.->fixnum"                  (1)   #f ()    0    integer extended)
("##bignum.<-fixnum"                  (1)   #f ()    0    integer extended)
("##bignum.adigit-shrink!"            (2)   #t ()    0    #f      extended)
("##bignum.adigit-copy!"              (4)   #t ()    0    #f      extended)
("##bignum.adigit-cat!"               (7)   #t ()    0    #f      extended)
("##bignum.adigit-bitwise-and!"       (4)   #t ()    0    #f      extended)
("##bignum.adigit-bitwise-ior!"       (4)   #t ()    0    #f      extended)
("##bignum.adigit-bitwise-xor!"       (4)   #t ()    0    #f      extended)
("##bignum.adigit-bitwise-not!"       (2)   #t ()    0    #f      extended)

("##bignum.fdigit-length"             (1)   #f ()    0    integer extended)
("##bignum.fdigit-ref"                (2)   #f ()    0    integer extended)
("##bignum.fdigit-set!"               (3)   #t ()    0    #f      extended)

)
)

;;;============================================================================
