// -*- Mode: C++ -*-
//
//          GiSTdb.cpp

#include "GiSTdb.h"
#include "GiSTpath.h"

REGISTER(GiSTtable);

GiSTdb::GiSTdb(dbDatabase& aDB) : GiSTstore(), db(aDB) 
{
    query = "name=",&tableName;
    rootPageId = 0;
}


void 
GiSTdb::Create(const char *tableName)
{
    if (IsOpen()) { 
	return;
    }
    dbCursor<GiSTtable> cursor;
    this->tableName = tableName;
    SetOpen(1);
    if (cursor.select(query) == 0) { 
	GiSTtable table;
	table.name = tableName;
	rootPageId = Allocate();
	table.rootPageId = rootPageId;
	insert(table);
    } else { 
	rootPageId = cursor->rootPageId;
    }
}


void 
GiSTdb::Open(const char *tableName)
{
    dbCursor<GiSTtable> cursor;
    this->tableName = tableName;
    if (cursor.select(query) != 0) { 
	rootPageId = cursor->rootPageId;
	SetOpen(1);
    }
}

void 
GiSTdb::Close()
{
    if (!IsOpen()) { 
	return;
    }
    SetOpen(0);
}

void 
GiSTdb::Read(GiSTpage page, char *buf)
{
    if (IsOpen()) {
	if (page == GiSTRootPage) { 
	    page = rootPageId;
	}
	byte* pg = db.get(page);
	memcpy(buf, pg, dbPageSize);
	db.pool.unfix(pg);
    }
}

void 
GiSTdb::Write(GiSTpage page, const char *buf)
{
    if (IsOpen()) {
	if (page == GiSTRootPage) { 
	    page = rootPageId;
	}
	byte* pg = db.put(page);
	memcpy(pg, buf, dbPageSize);
	db.pool.unfix(pg);
    }
}

GiSTpage 
GiSTdb::Allocate()
{
    if (!IsOpen()) { 
	return 0;
    }
    
    oid_t page = db.allocatePage();
    byte* pg = db.get(page);
    memset(pg, 0, dbPageSize);
    db.pool.unfix(pg);

    return page;
}

void 
GiSTdb::Deallocate(GiSTpage page)
{
    db.freePage(page);
}








