# $Id: Gbcli.pm,v 1.1 2008/04/04 11:02:30 knizhnik Exp $
package Gbcli;
require Exporter;
use vars qw($VERSION @ISA @EXPORT);
@ISA=qw(Exporter);
$VERSION=1.0;
use strict;
@EXPORT=
qw(
    cli_cmd_close_session
    cli_cmd_prepare_and_execute
    cli_cmd_execute
    cli_cmd_get_first
    cli_cmd_get_last
    cli_cmd_get_next
    cli_cmd_get_prev
    cli_cmd_free_statement
    cli_cmd_abort
    cli_cmd_commit
    cli_cmd_precommit
    cli_cmd_update
    cli_cmd_remove
    cli_cmd_insert
    cli_cmd_prepare_and_insert
    cli_cmd_describe_table
    cli_cmd_show_tables
    cli_cmd_login
    cli_ok
    cli_bad_address
    cli_connection_refused
    cli_database_not_found
    cli_bad_statement
    cli_parameter_not_found
    cli_unbound_parameter
    cli_column_not_found
    cli_incompatible_type
    cli_network_error
    cli_runtime_error
    cli_closed_statement
    cli_unsupported_type
    cli_not_found
    cli_not_update_mode
    cli_table_not_found
    cli_not_all_columns_specified
    cli_not_fetched
    cli_already_updated
    cli_login_failed
    cli_empty_parameter
    cli_closed_connection
    cli_oid
    cli_bool
    cli_int1
    cli_int2
    cli_int4
    cli_int8
    cli_real4
    cli_real8
    cli_decimal
    cli_asciiz
    cli_pasciiz
    cli_cstring
    cli_array_of_oid
    cli_array_of_bool
    cli_array_of_int1
    cli_array_of_int2
    cli_array_of_int4
    cli_array_of_int8
    cli_array_of_real4 
    cli_array_of_real8
    cli_array_of_decimal
    cli_array_of_string
    cli_any 
    cli_datetime 
    cli_undefined
    cli_tuple_mode 
    cli_object_mode 
    cli_array_mode 
    cli_hash_mode 
    pack_int
    pack_short
    pack_byte
    unpack_int
    unpack_short
    unpack_byte
);

# packing 
sub pack_int($){
 my $val=shift;
 if (! defined $val ) { $val=0;}
 return pack ("N",unpack("i",pack "I",$val));
}
sub unpack_int($) {
 return unpack("i",pack ("I",unpack "N",$_[0]));
}
sub pack_short($){
 my $val=shift;
 if (! defined $val ) { $val=0;}
 return pack ("n",unpack("s",pack "S",$val));
}
sub unpack_short($){
 return unpack ("s",pack ("S",unpack ("n",$_[0])));
}
sub pack_byte($){
 my $val=shift;
 if (! defined $val ) { $val=0;}
 return pack "c",$val;
}
sub unpack_byte($){
 return unpack "c",$_[0];
}


# command codes 
sub cli_cmd_close_session { 0; }
sub cli_cmd_prepare_and_execute { 1; }
sub cli_cmd_execute { 2; }
sub cli_cmd_get_first { 3; }
sub cli_cmd_get_last { 4; }
sub cli_cmd_get_next { 5; }
sub cli_cmd_get_prev { 6; }
sub cli_cmd_free_statement { 7; }
sub cli_cmd_abort { 8; }
sub cli_cmd_commit { 9; }
sub cli_cmd_update { 10; }
sub cli_cmd_remove { 11; }
sub cli_cmd_insert { 12; }
sub cli_cmd_prepare_and_insert { 13; }
sub cli_cmd_describe_table { 14; }
sub cli_cmd_show_tables { 15; }
sub cli_cmd_login { 16; }
sub cli_cmd_precommit { 17; }

# status codes 
sub cli_ok { 0; }
sub cli_bad_address { -1; }
sub cli_connection_refused { -2; }
sub cli_database_not_found { -3; }
sub cli_bad_statement { -4; }
sub cli_parameter_not_found { -5; }
sub cli_unbound_parameter { -6; }
sub cli_column_not_found { -7; }
sub cli_incompatible_type { -8; }
sub cli_network_error { -9; }
sub cli_runtime_error { -10; }
sub cli_closed_statement { -11; }
sub cli_unsupported_type { -12; }
sub cli_not_found { -13; }
sub cli_not_update_mode { -14; }
sub cli_table_not_found { -15; }
sub cli_not_all_columns_specified { -16; }
sub cli_not_fetched { -17; }
sub cli_already_updated { -18; }
sub cli_table_already_exists { -19; }
sub cli_not_implemented { -20; }
sub cli_login_failed { -21; }
sub cli_empty_parameter { -22; }
sub cli_closed_connection { -23; }

# CLI types 
sub cli_oid { 0; }
sub cli_bool { 1; }
sub cli_int1 { 2; }
sub cli_int2 { 3; }
sub cli_int4 { 4; }
sub cli_int8 { 5; }
sub cli_real4 { 6; }
sub cli_real8 { 7; }
sub cli_decimal { 8; }
sub cli_asciiz { 9; }
sub cli_pasciiz { 10; }
sub cli_cstring { 11; }
sub cli_array_of_oid { 12; }
sub cli_array_of_bool { 13; }
sub cli_array_of_int1 { 14; }
sub cli_array_of_int2 { 15; }
sub cli_array_of_int4 { 16; }
sub cli_array_of_int8 { 17; }
sub cli_array_of_real4 { 18; }
sub cli_array_of_real8 { 19; }
sub cli_array_of_decimal { 20; }
sub cli_array_of_string { 21; }
sub cli_any { 22; }
sub cli_datetime { 23; }
sub cli_undefined { 24; }

# Binding mode 
sub cli_tuple_mode { 0; }
sub cli_object_mode { 1; }
sub cli_array_mode { 2; }
sub cli_hash_mode { 2; }

1;
